/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorlogacoes;

import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorlogacoes.model.DetalheLog;
import com.touchcomp.basementorlogacoes.model.Log;
import com.touchcomp.basementorlogacoes.model.LogAcoesUsuario;
import com.touchcomp.basementorlogacoes.model.LogError;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.LinkedList;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.orm.hibernate5.HibernateTransactionManager;
import org.springframework.orm.hibernate5.LocalSessionFactoryBean;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
public class ConfHibernateLogAcoes {
    private static final TLogger logger = TLogger.get(ConfHibernateLogAcoes.class);
    @Autowired
    private Environment environment;
    private static String urlConexaoLocal;
    private static String dbUserLocal;
    private static String dbPassLocal;
    private static String dbDriverLocal;
    private static String showSQLLocal;

    @Bean
    public LocalSessionFactoryBean sessionFactoryLogAcoes() throws ExceptionReflection {
        LocalSessionFactoryBean sessionFactory = new LocalSessionFactoryBean();
        sessionFactory.setDataSource(this.dataSourceLogAcoes());
        sessionFactory.setAnnotatedClasses(this.getAllClasses());
        sessionFactory.setHibernateProperties(this.getHibernateProps());
        return sessionFactory;
    }

    private Class[] getAllClasses() throws ExceptionReflection {
        LinkedList<Class> all = new LinkedList<Class>();
        all.add(DetalheLog.class);
        all.add(Log.class);
        all.add(LogError.class);
        all.add(LogAcoesUsuario.class);
        return all.toArray(new Class[0]);
    }

    private Properties getHibernateProps() {
        Properties properties = new Properties();
        properties.put("hibernate.dialect", this.environment.getRequiredProperty("hibernate.dialect"));
        if (TMethods.isStrWithData((String)showSQLLocal)) {
            properties.put("hibernate.show_sql", showSQLLocal);
        }
        properties.put("hibernate.hbm2ddl.auto", this.environment.getRequiredProperty("hibernate.hbm2ddl.auto"));
        properties.put("hibernate.enable_lazy_load_no_trans", "true");
        properties.put("hibernate.id.new_generator_mappings", "false");
        properties.put("hibernate.event.merge.entity_copy_observer", "allow");
        return properties;
    }

    @Bean
    public DataSource dataSourceLogAcoes() {
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setDriverClassName(dbDriverLocal);
        dataSource.setUrl(urlConexaoLocal);
        dataSource.setUsername(dbUserLocal);
        dataSource.setPassword(dbPassLocal);
        dataSource.setInitialSize(1);
        dataSource.setMinIdle(1);
        dataSource.setMaxTotal(15);
        dataSource.setMaxIdle(1);
        dataSource.setMaxOpenPreparedStatements(50);
        return dataSource;
    }

    @Bean(name={"transactionManagerLogAcoes"})
    @Autowired
    public HibernateTransactionManager transactionManager(@Qualifier(value="sessionFactoryLogAcoes") SessionFactory sessionFactoryLogAcoes) {
        HibernateTransactionManager txManager = new HibernateTransactionManager();
        txManager.setSessionFactory(sessionFactoryLogAcoes);
        return txManager;
    }

    public static void setConfig(String dbDriver, String urlConexao, String dbUser, String dbPass, String showSQL) {
        urlConexaoLocal = urlConexao;
        dbUserLocal = dbUser;
        dbPassLocal = dbPass;
        dbDriverLocal = dbDriver;
        showSQLLocal = showSQL;
    }
}

