/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorlogacoes.dao.impl;

import com.touchcomp.basementorlogacoes.dao.DaoLogGenericEntityImpl;
import com.touchcomp.basementorlogacoes.model.LogError;
import java.util.Date;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaDelete;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import org.hibernate.Criteria;
import org.springframework.stereotype.Repository;

@Repository
public class DaoLogErrosImpl
extends DaoLogGenericEntityImpl<LogError, Long> {
    public List<LogError> getLogs(Date dataInicial, Date dataFinal, boolean filtrarUsuario, Long idUsuario, boolean filtrarRecurso, Long idRecurso) {
        Criteria crit = this.criteria();
        crit.add(this.between("dataEvento", dataInicial, dataFinal));
        if (filtrarUsuario) {
            crit.add(this.eq("idUsuario", idUsuario));
        }
        if (filtrarRecurso) {
            crit.add(this.eq("recurso", idRecurso));
        }
        this.orderDesc(crit, "dataEvento");
        return this.toList(crit);
    }

    public void deleteLogBeforeThan(Date dataLimite) {
        CriteriaBuilder cb = this.getSession().getEntityManagerFactory().getCriteriaBuilder();
        CriteriaDelete delete = cb.createCriteriaDelete(LogError.class);
        Root e = delete.from(LogError.class);
        delete.where((Expression)cb.lessThanOrEqualTo((Expression)e.get("dataEvento"), (Comparable)dataLimite));
        this.getSession().createQuery(delete).executeUpdate();
    }
}

