/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorlogacoes.model;

import com.touchcomp.basementorlogacoes.model.DetalheLog;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

@Entity
@Table(name="log")
public class Log
implements Serializable {
    private Long identificador;
    private Long idUsuario;
    private String nomeUsuario;
    private Date dataCadastro;
    private String descricao;
    private String idRegistro;
    private String recurso;
    private String pathClass;
    private List<DetalheLog> detalheLogs = new ArrayList<DetalheLog>();

    @Id
    @Column(name="ID_LOG")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_log")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="nome_usuario")
    public String getNomeUsuario() {
        return this.nomeUsuario;
    }

    public void setNomeUsuario(String nomeUsuario) {
        this.nomeUsuario = nomeUsuario;
    }

    @Column(name="data_cadastro")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Column(name="descricao")
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Column(name="recurso")
    public String getRecurso() {
        return this.recurso;
    }

    public void setRecurso(String recurso) {
        this.recurso = recurso;
    }

    @OneToMany(fetch=FetchType.EAGER)
    @JoinColumn(name="id_log")
    @Fetch(value=FetchMode.SELECT)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<DetalheLog> getDetalheLogs() {
        return this.detalheLogs;
    }

    public void setDetalheLogs(List<DetalheLog> detalheLogs) {
        this.detalheLogs = detalheLogs;
    }

    @Column(name="id_usuario")
    public Long getIdUsuario() {
        return this.idUsuario;
    }

    public void setIdUsuario(Long idUsuario) {
        this.idUsuario = idUsuario;
    }

    @Column(name="id_registro")
    public String getIdRegistro() {
        return this.idRegistro;
    }

    public void setIdRegistro(String idRegistro) {
        this.idRegistro = idRegistro;
    }

    @Column(name="path_class")
    public String getPathClass() {
        return this.pathClass;
    }

    public void setPathClass(String pathClass) {
        this.pathClass = pathClass;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"Recurso: {0} Usuario: {1} Data: {2}", (Object[])new Object[]{this.getRecurso(), this.getNomeUsuario(), ToolDate.dateToStr((Date)this.getDataCadastro())});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

