/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorrules.impostos.icms.impl;

import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstNFeIncidenciaIcms;
import com.touchcomp.basementorexceptions.exceptions.impl.impostoicms.ExceptionImpostoIcms;
import com.touchcomp.basementorrules.impostos.icms.impl.BaseIcmsST;
import com.touchcomp.basementorrules.impostos.icms.impl.InterfaceIcmsCalculo;
import com.touchcomp.basementorrules.impostos.icms.model.IcmsCalculado;
import com.touchcomp.basementorrules.impostos.icms.model.IcmsParams;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import java.util.Arrays;
import java.util.List;

public class Icms61
extends BaseIcmsST
implements InterfaceIcmsCalculo {
    @Override
    public IcmsCalculado calcular(IcmsParams params) throws ExceptionImpostoIcms {
        IcmsCalculado calc = new IcmsCalculado(params);
        double baseCalculo = this.getBC(params);
        calc.setBaseCalculoIcms(baseCalculo);
        calc.setValorIcmsOutros(calc.getBaseCalculoIcms());
        calc.setAliquotaIcms(0.0);
        calc.setQtdeBCIcmsMonoRetAnt(params.getQuantidadeTotal());
        calc.setAliquotaAdRemIcmsRetAnt(params.getParamsCalcIcms().getAliquotaIcmsInformada());
        calc.setValorIcmsMonoRetAnt(ToolFormatter.arrredondarNumero((Double)(calc.getQtdeBCIcmsMonoRetAnt() * calc.getAliquotaAdRemIcmsRetAnt()), (int)2));
        return calc;
    }

    @Override
    public List<EnumConstNFeIncidenciaIcms> getIncidencia() {
        return Arrays.asList(EnumConstNFeIncidenciaIcms.TRIBUTACAO_MONOFASICA_COMBUSTIVEIS_COBRADO_ANTERIORMENTE);
    }

    @Override
    public boolean validCalcEntrada() {
        return true;
    }

    @Override
    public boolean validCalcSaida() {
        return true;
    }
}

