/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorrules.messages;

import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;

public class Messages {
    private static ResourceBundle resourceBundleError;
    private static String DATE_FORMAT;

    private Messages() {
    }

    public static String getErrorMsg(String codeMessage, Object ... adicional) {
        ResourceBundle msg = Messages.getResourceBundleErrors();
        if (codeMessage == null) {
            return "codemessage can't be null";
        }
        if (msg.containsKey(codeMessage)) {
            String ret = msg.getString(codeMessage);
            Object[] data = Messages.processFormattData(adicional);
            ret = MessageFormat.format(ret, data);
            return ret;
        }
        return codeMessage;
    }

    private static Object[] processFormattData(Object[] adicional) {
        if (adicional == null) {
            return null;
        }
        Object[] ret = new Object[adicional.length];
        for (int i = 0; i < adicional.length; ++i) {
            Object temp = adicional[i];
            if (temp instanceof Double || temp instanceof Float) {
                temp = Messages.formatNumber((Number)temp, 2);
            } else if (temp instanceof Date) {
                temp = Messages.formatDate((Date)temp);
            }
            ret[i] = temp == null ? "null" : temp;
        }
        return ret;
    }

    private static Object formatDate(Date temp) {
        SimpleDateFormat s = new SimpleDateFormat(DATE_FORMAT);
        return s.format(temp);
    }

    private static Object formatNumber(Number temp, int i) {
        return String.format("%." + i + "f", temp.doubleValue());
    }

    public static ResourceBundle getResourceBundleErrors() {
        if (resourceBundleError == null) {
            resourceBundleError = ResourceBundle.getBundle("com/touchcomp/basementorrules/messages/rules_errors", Locale.getDefault());
        }
        return resourceBundleError;
    }

    static {
        DATE_FORMAT = "dd/MM/yyyy hh:mm:ss";
    }
}

