/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorrules.opcoesdinamicas;

import com.touchcomp.basementor.interfaces.EnumOpDinamicasInterface;
import com.touchcomp.basementor.interfaces.EnumOpDinamicasOptionsInterface;
import com.touchcomp.basementor.interfaces.EnumOpSectionDinamicasInterface;
import com.touchcomp.basementorrules.opcoesdinamicas.interfaces.ModelOpDinamicasInterface;
import com.touchcomp.basementorrules.opcoesdinamicas.model.DTOOpcoesDinamicas;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public class CompOpcoes {
    public static <T> boolean isAffirmative(List<ModelOpDinamicasInterface> opcoes, EnumOpDinamicasInterface values) {
        Long value = CompOpcoes.getOption(opcoes, values, Long.class);
        return TMethods.isAffirmative((Number)value);
    }

    public static <T> T getOption(List<ModelOpDinamicasInterface> opcoes, EnumOpDinamicasInterface op, Class<T> clazz) {
        if (opcoes == null) {
            return null;
        }
        Optional<ModelOpDinamicasInterface> found = opcoes.stream().filter(i -> TMethods.isEquals((Object)op.getCodigo(), (Object)i.getChave())).findFirst();
        String value = op.getDefValue();
        if (found.isPresent()) {
            value = found.get().getValor();
        }
        return CompOpcoes.convertValue(value, clazz);
    }

    private static <T> T convertValue(String value, Class<T> clazz) {
        if (Short.class.isAssignableFrom(clazz) && value != null && !TMethods.isEquals((Object)"null", (Object)value)) {
            return (T)Short.valueOf(value);
        }
        if (Integer.class.isAssignableFrom(clazz) && value != null && !TMethods.isEquals((Object)"null", (Object)value)) {
            return (T)Integer.valueOf(value);
        }
        if (Long.class.isAssignableFrom(clazz) && value != null && !TMethods.isEquals((Object)"null", (Object)value)) {
            return (T)Long.valueOf(value);
        }
        if (Float.class.isAssignableFrom(clazz) && value != null && !TMethods.isEquals((Object)"null", (Object)value)) {
            return (T)Float.valueOf(value);
        }
        if (Double.class.isAssignableFrom(clazz) && value != null && !TMethods.isEquals((Object)"null", (Object)value)) {
            return (T)Double.valueOf(value);
        }
        value = value != null && !TMethods.isEquals((Object)"null", (Object)value) ? String.valueOf(value) : null;
        return (T)value;
    }

    public static DTOOpcoesDinamicas getAllOptions(List<ModelOpDinamicasInterface> options, EnumOpSectionDinamicasInterface[] sections, EnumOpDinamicasInterface[] enums) {
        DTOOpcoesDinamicas op = new DTOOpcoesDinamicas();
        for (EnumOpSectionDinamicasInterface v : sections) {
            DTOOpcoesDinamicas.DTOOpcoesSecoes sec = new DTOOpcoesDinamicas.DTOOpcoesSecoes();
            sec.setCodigo(v.getChave());
            sec.setDescricao(v.getDescricao());
            op.getOpcoesSecoes().add(sec);
        }
        LinkedList<DTOOpcoesDinamicas.DTOOpcoes> all = new LinkedList<DTOOpcoesDinamicas.DTOOpcoes>();
        for (EnumOpDinamicasInterface option : enums) {
            Optional<DTOOpcoesDinamicas.DTOOpcoesSecoes> sec = op.getOpcoesSecoes().stream().filter(i -> option.getCodigo().startsWith(i.getCodigo())).findFirst();
            if (!sec.isPresent()) continue;
            DTOOpcoesDinamicas.DTOOpcoes o = new DTOOpcoesDinamicas.DTOOpcoes();
            o.setCodigo(option.getCodigo());
            o.setDescricao(option.getDescricao());
            o.setValor(option.getDefValue());
            sec.get().getOpcoes().add(o);
            all.add(o);
            if (option.getChoices() == null) continue;
            for (EnumOpDinamicasOptionsInterface choice : option.getChoices()) {
                DTOOpcoesDinamicas.DTOValores val = new DTOOpcoesDinamicas.DTOValores();
                val.setDescricao(choice.getDescricao());
                val.setValor(choice.getValor());
                o.getOpcoes().add(val);
            }
        }
        for (ModelOpDinamicasInterface option : options) {
            Optional<DTOOpcoesDinamicas.DTOOpcoes> found = all.stream().filter(i -> TMethods.isEquals((Object)i.getCodigo(), (Object)option.getChave())).findFirst();
            if (!found.isPresent()) continue;
            found.get().setIdentificador(option.getIdentificador());
            found.get().setValor(option.getValor());
            found.get().setObservacao(option.getObservacao());
        }
        return op;
    }
}

