/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorStatus;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorlogacoes.model.LogError;
import com.touchcomp.basementorlogacoes.service.impl.logerror.ServiceLogErrosImpl;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorlogger.model.TempLogError;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.exception.ToolException;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.touchvomodel.web.WebDTOResult;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.lang.exception.ExceptionUtils;

public abstract class BaseMethods {
    public <T> T getBean(Class<T> clazz) {
        return (T)ConfApplicationContext.getBean(clazz);
    }

    public TLogger getLogger() {
        return TLogger.get(this.getClass());
    }

    public void logInfo(String message) {
        this.getLogger().info(message);
    }

    public void logDebug(String message) {
        this.getLogger().debug(message);
    }

    private LogError saveLog(TempLogError temp, Usuario user, Long nodo) {
        LogError log = new LogError();
        log.setDataEvento(new Timestamp(new Date().getTime()));
        log.setMessage(ToolString.cut((String)temp.getMessage(), (int)10000));
        log.setCodigo(ToolString.cut((String)temp.getCodigo(), (int)15));
        if (this.isNotNull(temp.getException()).booleanValue()) {
            log.setStackTrace(ToolString.cut((String)ExceptionUtils.getStackTrace((Throwable)temp.getException()), (int)32700));
        }
        log.setUid(ToolString.cut((String)temp.getUid(), (int)100));
        if (this.isNotNull(user).booleanValue()) {
            log.setIdUsuario(user.getIdentificador());
            log.setNomeUsuario(ToolString.cut((String)user.getUsuarioBasico().getPessoa().getNome(), (int)150));
        }
        log.setRecurso(nodo);
        ServiceLogErrosImpl service = this.getBean(ServiceLogErrosImpl.class);
        return (LogError)service.saveOrUpdate((Object)log);
    }

    public void logError(String message, Long nodo) {
        this.getLogger().error(message, nodo);
    }

    public void logError(String message) {
        this.getLogger().error(message);
    }

    public void logError(String message, Throwable t, Long nodo) {
        this.getLogger().error(message, t, nodo);
    }

    public void logError(String message, Throwable t) {
        this.getLogger().error(message, t);
    }

    public void logError(Throwable ex, Long idNodo) {
        this.getLogger().error(ex.getMessage(), ex, idNodo);
    }

    public void logError(Throwable ex) {
        this.getLogger().error(ex.getMessage(), ex);
    }

    public void logError(Throwable ex, WebDTOResult result, Long idNodo) {
        this.logError(ex, idNodo);
        result.setStatus(EnumConstantsMentorStatus.ERRO);
        if (ex instanceof ExceptionBase) {
            result.setMessage(((ExceptionBase)ex).getFormattedMessage());
        } else if (ex instanceof ExceptionRuntimeBase) {
            result.setMessage(((ExceptionRuntimeBase)ex).getFormattedMessage());
        } else {
            result.setMessage(ex.getMessage());
        }
        result.setDetailMessage(ToolException.getFullPrintStrack((Throwable)ex));
    }

    public void logError(Throwable ex, WebDTOResult result) {
        this.logError(ex, result, null);
    }

    public String getMessage(String key, Object ... details) {
        return MessagesBaseMentor.getMsg((String)key, (Object[])details);
    }

    public String getMessageTasks(String key, Object ... details) {
        return MessagesBaseMentor.getDefTasks((String)key, (Object[])details);
    }

    public String getMessage(Class key, Object ... details) {
        return MessagesBaseMentor.getMsg((String)key.getName(), (Object[])details);
    }

    public String getErrorMessage(String key, Object ... details) {
        return MessagesBaseMentor.getErrorMsg((String)key, (Object[])details);
    }

    public String getErrorMessage(Class key, Object ... details) {
        return MessagesBaseMentor.getErrorMsg((String)key.getName(), (Object[])details);
    }

    public boolean isAffimative(Number valor) {
        return ToolMethods.isAffirmative((Number)valor);
    }

    public boolean isEquals(Object ob1, Object ob2) {
        return ToolMethods.isEquals((Object)ob1, (Object)ob2);
    }

    public boolean isStrWithData(String text) {
        return ToolMethods.isStrWithData((String)text);
    }

    public Double arredondaNumero(Double numero, Integer casasDecimais) {
        return ToolFormatter.arrredondarNumero((Double)numero, (int)casasDecimais);
    }

    public Boolean isNull(Object object) {
        return ToolMethods.isNull((Object)object);
    }

    public Boolean isNotNull(Object object) {
        return ToolMethods.isNotNull((Object)object);
    }

    public static boolean isWithData(Collection lista) {
        return lista != null && lista.size() > 0;
    }

    public static boolean isWithData(Number numero) {
        return ToolMethods.isWithData((Number)numero);
    }
}

