/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.cache;

import com.touchcomp.basementorservice.cache.CacheKeyGenerator;
import com.touchcomp.basementorservice.cache.CacheUtil;
import java.util.Collections;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.DiskStoreConfiguration;
import org.joda.time.Duration;
import org.springframework.cache.ehcache.EhCacheCacheManager;
import org.springframework.cache.support.CompositeCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;

public class CacheConfigBase {
    @Primary
    @Bean(value={"cacheManager"})
    public CompositeCacheManager cacheManager() {
        CompositeCacheManager compositeCacheManager = new CompositeCacheManager();
        compositeCacheManager.setFallbackToNoOpCache(true);
        compositeCacheManager.setCacheManagers(Collections.singleton(this.ehCacheManager()));
        return compositeCacheManager;
    }

    @Bean(value={"customKeyGenerator"})
    public CacheKeyGenerator cacheKeyGenerator() {
        return new CacheKeyGenerator();
    }

    @Bean(value={"ehCacheManager"})
    public EhCacheCacheManager ehCacheManager() {
        EhCacheCacheManager ehCacheCacheManager = new EhCacheCacheManager();
        ehCacheCacheManager.setCacheManager(this.getCustomCacheManager());
        return ehCacheCacheManager;
    }

    private CacheManager getCustomCacheManager() {
        CacheManager cacheManager = CacheManager.create((Configuration)this.getEhCacheConfiguration());
        cacheManager.addCache(CacheUtil.createCache("1550_ITENS_BI_PAINEL_DASHBOARD", Duration.standardHours((long)4L)));
        cacheManager.addCache(CacheUtil.createCache("SEARCH_PARAMS", Duration.standardMinutes((long)10L)));
        cacheManager.addCache(CacheUtil.createCache("SEARCH_PARAMS_USER", Duration.standardMinutes((long)10L)));
        cacheManager.addCache(CacheUtil.createCache("ParamLancGerencial_1", Duration.standardHours((long)4L)));
        cacheManager.addCache(CacheUtil.createCache("OpcoesContabeisBaixaTitulos_1", Duration.standardHours((long)4L)));
        cacheManager.addCache(CacheUtil.createCache("buscaDadosEnderecoViaCep", Duration.standardHours((long)8L)));
        cacheManager.addCache(CacheUtil.createCache("buscaDadosEnderecoCep", Duration.standardMinutes((long)30L)));
        return cacheManager;
    }

    private Configuration getEhCacheConfiguration() {
        Configuration configuration = new Configuration();
        DiskStoreConfiguration diskStoreConfiguration = new DiskStoreConfiguration();
        diskStoreConfiguration.setPath("java.io.tmpdir");
        configuration.addDiskStore(diskStoreConfiguration);
        configuration.setName("custom_eh_cache");
        return configuration;
    }
}

