/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.cache;

import com.touchcomp.basementorservice.cache.CacheUtil;
import java.io.Serializable;
import org.joda.time.Duration;
import org.springframework.cache.Cache;
import org.springframework.cache.ehcache.EhCacheCacheManager;
import org.springframework.stereotype.Component;

@Component
public class CacheEntityManager {
    private final EhCacheCacheManager cacheManager;
    private static final int DEFAULT_CACHE_DURATION_HOURS = 1;
    private static final String CACHE_NAME = "entities.cache";

    public CacheEntityManager(EhCacheCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void createCache(String name) {
        if (this.cacheManager == null || this.cacheManager.getCacheManager() == null) {
            return;
        }
        if (this.cacheManager.getCache(name) != null) {
            return;
        }
        this.cacheManager.getCacheManager().addCache(CacheUtil.createCache(name, Duration.standardHours((long)1L)));
    }

    public Cache getOrCreateCache(String name) {
        Cache cache = this.cacheManager.getCache(name);
        if (cache == null) {
            this.createCache(name);
        }
        return this.cacheManager.getCache(name);
    }

    public <T> T getObject(Serializable name, Class<T> type) {
        Cache cache = this.getOrCreateCache(CACHE_NAME);
        Object value = cache.get((Object)name, type);
        return (T)value;
    }

    public void putObject(Serializable name, Object value) {
        Cache cache = this.getOrCreateCache(CACHE_NAME);
        cache.put((Object)name, value);
    }
}

