/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.cache;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.spi.CachingProvider;
import org.springframework.stereotype.Component;

@Component
public class CacheManagerUtil {
    private CacheManager getCacheManager() {
        CachingProvider provider = Caching.getCachingProvider();
        CacheManager cacheManager = provider.getCacheManager();
        return cacheManager;
    }

    public <Z, T> Cache<Z, T> getCache(String cacheName) {
        return this.getCacheManager().getCache(cacheName);
    }

    public List<String> getCachesNames() {
        List<String> actualList = StreamSupport.stream(this.getCacheManager().getCacheNames().spliterator(), false).collect(Collectors.toList());
        return actualList;
    }

    public List<Object> getCacheSize(String cacheName) {
        ArrayList actualList = Lists.newArrayList((Iterator)this.getCache(cacheName).iterator());
        return actualList;
    }

    public void reloadCache(String nome) {
        this.getCache(nome).clear();
    }

    public void reloadCache() {
        for (String cachesName : this.getCachesNames()) {
            this.reloadCache(cachesName);
        }
    }
}

