/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.acuracidadeestoque;

import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstDisponibilidade;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstTipoPropTerc;
import com.touchcomp.basementor.constants.enums.opcoesestoque.EnumConstOpEstoqueOp;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoCarregQtdeVlr;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoSaldo;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoSaldoQtde;
import com.touchcomp.basementor.interfaces.EnumOpDinamicasInterface;
import com.touchcomp.basementor.model.impl.SaldoEstoqueGeral;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.ContagemProdCentroEstoque;
import com.touchcomp.basementor.model.vo.ContagemProdGrade;
import com.touchcomp.basementor.model.vo.ContagemProdProduto;
import com.touchcomp.basementor.model.vo.ContagemProdutos;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.ItemApuracidadeEstoque;
import com.touchcomp.basementor.model.vo.Localizacao;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.OpcoesEstoque;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorrules.opcoesdinamicas.CompOpcoes;
import com.touchcomp.basementorservice.components.estoque.CompEstoque;
import com.touchcomp.basementorservice.helpers.impl.opcoes.opcoesestoque.HelperOpcoesEstoque;
import com.touchcomp.basementorservice.service.impl.lotefabricacao.ServiceLoteFabricacaoImpl;
import com.touchcomp.basementorservice.service.impl.naturezarequisicao.ServiceNaturezaRequisicaoImpl;
import com.touchcomp.basementorservice.service.impl.saldoestoque.ServiceSaldoEstoqueImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class CompAcuracidadeEstoque {
    final ServiceNaturezaRequisicaoImpl serviceNaturezaRequisicaoImpl;
    final ServiceLoteFabricacaoImpl serviceLoteFabricacaoImpl;
    final ServiceSaldoEstoqueImpl serviceSaldoEstoqueImpl;
    final CompEstoque compEstoque;
    final HelperOpcoesEstoque helperOpEstoque;

    public CompAcuracidadeEstoque(ServiceNaturezaRequisicaoImpl serviceNaturezaRequisicaoImpl, ServiceLoteFabricacaoImpl serviceLoteFabricacaoImpl, ServiceSaldoEstoqueImpl serviceSaldoEstoqueImpl, CompEstoque compEstoque, HelperOpcoesEstoque helperOpEstoque) {
        this.serviceNaturezaRequisicaoImpl = serviceNaturezaRequisicaoImpl;
        this.serviceLoteFabricacaoImpl = serviceLoteFabricacaoImpl;
        this.serviceSaldoEstoqueImpl = serviceSaldoEstoqueImpl;
        this.compEstoque = compEstoque;
        this.helperOpEstoque = helperOpEstoque;
    }

    public void vincularContagemProdutos(ContagemProdutos contagemProdutos, CentroEstoque centroEstoque, List<ItemApuracidadeEstoque> itens, OpcoesEstoque opEstoque, Short filtrarLocalizacao, Localizacao localizacao) throws ExceptionInvalidData {
        if (contagemProdutos == null) {
            return;
        }
        if (!TMethods.isWithData((Collection)contagemProdutos.getCentrosEstoqueContagem()) && contagemProdutos.getCentrosEstoqueContagem().size() > 1) {
            throw new ExceptionInvalidData("E.ERP.0944.001", new Object[]{contagemProdutos});
        }
        if (contagemProdutos.getAcuracidadeEstContProdutos() != null) {
            throw new ExceptionInvalidData("E.ERP.0944.002", new Object[]{contagemProdutos.getAcuracidadeEstContProdutos()});
        }
        ContagemProdCentroEstoque cc = (ContagemProdCentroEstoque)contagemProdutos.getCentrosEstoqueContagem().get(0);
        if (!TMethods.isEquals((Object)cc.getCentroEstoque(), (Object)centroEstoque)) {
            throw new ExceptionInvalidData("E.ERP.0944.003", new Object[]{cc.getCentroEstoque()});
        }
        for (ContagemProdProduto cp : cc.getProdutosContagem()) {
            if (ToolMethods.isAffirmative((Number)filtrarLocalizacao) && (!ToolMethods.isAffirmative((Number)filtrarLocalizacao) || !ToolMethods.isEquals((Object)cp.getProduto().getLocalizacao(), (Object)localizacao))) continue;
            for (ContagemProdGrade cg : cp.getGradesLotesContados()) {
                this.newItemApuracidadeEstoque(itens, cg.getGradeCor(), cg.getQuantidadeContada(), cg.getLotefabricacao(), cc.getCentroEstoque(), contagemProdutos.getEmpresa(), contagemProdutos.getDataContagem(), opEstoque);
            }
        }
    }

    public void newItemApuracidadeEstoque(List<ItemApuracidadeEstoque> itens, GradeCor gradeCor, Double quantidade, LoteFabricacao loteFabricacao, CentroEstoque centro, Empresa empresa, Date dataAcuracidade, OpcoesEstoque opEstoque) {
        Optional<ItemApuracidadeEstoque> found = itens.stream().filter(i -> TMethods.isEquals((Object)i.getGradeCor(), (Object)gradeCor) && TMethods.isEquals((Object)i.getLoteFabricacao(), (Object)loteFabricacao)).findFirst();
        if (found.isPresent()) {
            ItemApuracidadeEstoque item = found.get();
            if (CompOpcoes.isAffirmative(this.helperOpEstoque.build(opEstoque).getItens(), (EnumOpDinamicasInterface)EnumConstOpEstoqueOp.SUBSTITUIR_QTD_FINAL_POR_ULT_CONT_ADICIONADA)) {
                item.setQuantidadeFinal(quantidade);
            } else {
                item.setQuantidadeFinal(Double.valueOf(item.getQuantidadeFinal() + quantidade));
            }
            return;
        }
        ItemApuracidadeEstoque item = this.newItemApuracidadeEstoque(gradeCor, quantidade, loteFabricacao, centro, empresa, dataAcuracidade);
        itens.add(item);
    }

    public ItemApuracidadeEstoque newItemApuracidadeEstoque(GradeCor gradeCor, Double quantidade, LoteFabricacao loteFabricacao, CentroEstoque centro, Empresa empresa, Date dataAcuracidade) {
        if (loteFabricacao == null && TMethods.isEqualsNumber((Number)gradeCor.getProdutoGrade().getProduto().getLoteUnico(), (Number)1)) {
            loteFabricacao = this.serviceLoteFabricacaoImpl.findLoteUnico(gradeCor);
        }
        Produto produto = gradeCor != null ? gradeCor.getProdutoGrade().getProduto() : null;
        ItemApuracidadeEstoque found = new ItemApuracidadeEstoque();
        found.setGradeCor(gradeCor);
        found.setLoteFabricacao(loteFabricacao);
        found.setQuantidadeFinal(quantidade);
        found.setNaturezaRequisicao(this.serviceNaturezaRequisicaoImpl.getFirst(produto, empresa.getEmpresaDados().getGrupoEmpresa()));
        SaldoEstoqueGeral s = this.serviceSaldoEstoqueImpl.findSaldoGradeCentroEstoqueLote(produto, gradeCor, dataAcuracidade, empresa, loteFabricacao, centro, EnumConstSaldoEstTipoSaldo.TIPO_SALDO_PRODUTO, EnumConstSaldoEstTipoSaldoQtde.TIPO_SALDO_QTQ_TUDO, EnumConstSaldoEstTipoCarregQtdeVlr.TIPO_SALDO_QTQ_VLR_TUDO, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_TODOS, EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO, null);
        if (s != null) {
            found.setQuantidadeInicial(s.getQuantidade());
            found.setPrecoMedioInicial(s.getValorMedio());
            found.setPrecoMedioFinal(s.getValorMedio());
        }
        if (!TMethods.isWithData((Number)found.getPrecoMedioFinal())) {
            Double vlr = this.compEstoque.getUltimoCusto(produto, empresa);
            found.setPrecoMedioFinal(vlr);
            found.setPrecoMedioInicial(vlr);
        }
        return found;
    }
}

