/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.analisecredito;

import com.touchcomp.basementor.constants.enums.opcoesfaturamento.EnumConstOpFatVendaComDebito;
import com.touchcomp.basementor.constants.enums.saldotitulos.EnumConstSaldoTitPagRec;
import com.touchcomp.basementor.constants.enums.saldotitulos.EnumConstSaldoTitPessoaGrupoPessoa;
import com.touchcomp.basementor.model.impl.SaldoFinanceiroPessoa;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.ClienteFinanceiro;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementorservice.BaseMethods;
import com.touchcomp.basementorservice.service.impl.saldotitulo.ServiceSaldoTituloImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceChequeTerceiros;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.touchvomodel.web.WebDTOResult;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompAnaliseCreditoCliente
extends BaseMethods {
    @Autowired
    private ServiceSaldoTituloImpl serviceSaldoTitulo;
    @Autowired
    private ServiceChequeTerceiros serviceChequeTerceiros;

    public WebDTOResult validarClienteFinanceiro(UnidadeFatCliente un, Double valorAdicional, OpcoesFinanceiras opFin) {
        WebDTOResult result = new WebDTOResult();
        if (un == null) {
            return result;
        }
        Cliente cliente = un.getCliente();
        if (this.isAffimative(cliente.getFinanceiro().getNaoAvaliarFinanceiro())) {
            return result;
        }
        if (this.isAffimative(opFin.getVerificaLimitePedido())) {
            ClienteFinanceiro v = cliente.getFinanceiro();
            if (v.getDataLiberacaoCredito() != null && v.getDiasVigorLimiteCred() != null && v.getDiasVigorLimiteCred() > 0) {
                Date next = ToolDate.nextDays((Date)v.getDataLiberacaoCredito(), (int)v.getDiasVigorLimiteCred());
                Object msg = " A an\u00e1lise do limite de cr\u00e9dito deste cliente ser\u00e1 liberado \u00e0 partir da data " + ToolDate.dateToStr((Date)v.getDataLiberacaoCredito(), (String)"dd-MM-yyyy");
                if (v.getDataLiberacaoCredito().after(ToolDate.getCurrentDate())) {
                    if (this.isEquals(opFin.getPermitirVendaComDebito(), EnumConstOpFatVendaComDebito.PERMITIR_VENDA_SO_AVISAR.getValue()) || this.isEquals(opFin.getPermitirVendaComDebito(), EnumConstOpFatVendaComDebito.NAO_PERMITIR_VENDA_DEB_BLOQ_PED.getValue())) {
                        result.addWarning((String)msg);
                    } else {
                        result.addErroMessage("", (String)msg);
                    }
                    return result;
                }
                msg = "A an\u00e1lise do limite de cr\u00e9dito deste cliente expirou. Refa\u00e7a a an\u00e1lise de Cr\u00e9dito.";
                if (next.before(ToolDate.getCurrentDate())) {
                    if (this.isEquals(opFin.getPermitirVendaComDebito(), EnumConstOpFatVendaComDebito.PERMITIR_VENDA_SO_AVISAR.getValue()) || this.isEquals(opFin.getPermitirVendaComDebito(), EnumConstOpFatVendaComDebito.NAO_PERMITIR_VENDA_DEB_BLOQ_PED.getValue())) {
                        result.addWarning((String)msg);
                    } else {
                        result.addErroMessage("", (String)msg);
                    }
                    return result;
                }
            }
            String msg = "Cliente inabilitado para compras!";
            if (cliente.getFinanceiro().getHabilParaCompra() == null || !this.isAffimative(cliente.getFinanceiro().getHabilParaCompra())) {
                if (this.isEquals(opFin.getPermitirVendaComDebito(), EnumConstOpFatVendaComDebito.PERMITIR_VENDA_SO_AVISAR.getValue()) || this.isEquals(opFin.getPermitirVendaComDebito(), EnumConstOpFatVendaComDebito.NAO_PERMITIR_VENDA_DEB_BLOQ_PED.getValue())) {
                    result.addWarning(msg);
                } else {
                    result.addErroMessage("", msg);
                }
                return result;
            }
            this.validarTitulosEmAberto(result, cliente.getPessoa(), valorAdicional, opFin, v.getLimiteCredito());
            this.validarTituloVencidoEmAberto(result, cliente.getPessoa(), opFin);
        }
        return result;
    }

    private void validarTitulosEmAberto(WebDTOResult result, Pessoa pessoa, Double valorAdicional, OpcoesFinanceiras opcoesFinanceiras, Double limiteCreditoCliente) {
        if (this.getSaldoDevedorCliente(pessoa, opcoesFinanceiras) + valorAdicional > limiteCreditoCliente) {
            if (this.isEquals(opcoesFinanceiras.getPermitirVendaComDebito(), EnumConstOpFatVendaComDebito.NAO_PERMITIR_VENDA_DEB.getValue())) {
                result.addErroMessage("", "Cliente possui t\u00edtulos em atraso ou seu limite de cr\u00e9dito foi ultrapassado.");
            }
            if (this.isEquals(opcoesFinanceiras.getPermitirVendaComDebito(), EnumConstOpFatVendaComDebito.PERMITIR_VENDA_SO_AVISAR.getValue()) || this.isEquals(opcoesFinanceiras.getPermitirVendaComDebito(), EnumConstOpFatVendaComDebito.NAO_PERMITIR_VENDA_DEB_BLOQ_PED.getValue())) {
                result.addWarning("Cliente possui t\u00edtulos em atraso ou seu limite de cr\u00e9dito foi ultrapassado.");
            }
        }
    }

    private void validarTituloVencidoEmAberto(WebDTOResult result, Pessoa pessoa, OpcoesFinanceiras opcoesFinanceiras) {
        Double saldoDevedor;
        if (this.isEquals(opcoesFinanceiras.getPermitirVendaComDebito(), EnumConstOpFatVendaComDebito.PERMITIR_VENDA_NAO_AVISAR.getValue()) && (saldoDevedor = this.verificarTituloVencidoEmAberto(pessoa, opcoesFinanceiras.getDiasToleranciaAnaliseCredito())) > 0.0) {
            if (this.isEquals(opcoesFinanceiras.getPermitirVendaComDebito(), EnumConstOpFatVendaComDebito.NAO_PERMITIR_VENDA_DEB.getValue())) {
                result.addErroMessage("", "Cliente Possui Titulos em Atraso");
            }
            if (this.isEquals(opcoesFinanceiras.getPermitirVendaComDebito(), EnumConstOpFatVendaComDebito.PERMITIR_VENDA_SO_AVISAR.getValue()) || this.isEquals(opcoesFinanceiras.getPermitirVendaComDebito(), EnumConstOpFatVendaComDebito.NAO_PERMITIR_VENDA_DEB_BLOQ_PED.getValue())) {
                result.addWarning("Cliente Possui Titulos em Atraso");
            }
        }
    }

    private Double verificarTituloVencidoEmAberto(Pessoa pessoa, Integer diasTolerancia) {
        Double saldo = this.serviceSaldoTitulo.getSaldoVencidoPessoa(pessoa.getIdentificador(), EnumConstSaldoTitPagRec.TIPO_TITULO_REC, EnumConstSaldoTitPessoaGrupoPessoa.TIPO_PESSOA, null);
        return saldo != null ? saldo : 0.0;
    }

    private Double getSaldoDevedorCliente(Pessoa pessoa, OpcoesFinanceiras opcoesFinanceiras) {
        Double valor = this.getSaldoDevedorTitulosCliente(pessoa);
        if (valor == null) {
            valor = 0.0;
        }
        if (opcoesFinanceiras != null && this.isAffimative(opcoesFinanceiras.getIncluirChequeAnCred())) {
            valor = valor + this.getSaldoDevedorChequesAbertoCliente(pessoa);
        }
        return valor;
    }

    private Double getSaldoDevedorTitulosCliente(Pessoa pessoa) {
        SaldoFinanceiroPessoa saldo = this.serviceSaldoTitulo.getSaldoAbertoPessoa(null, null, pessoa.getIdentificador(), null, null, null, null, null, null, null, EnumConstSaldoTitPagRec.TIPO_TITULO_REC, EnumConstSaldoTitPessoaGrupoPessoa.TIPO_PESSOA);
        if (saldo != null) {
            return saldo.getValorSaldo();
        }
        return 0.0;
    }

    private Double getSaldoDevedorChequesAbertoCliente(Pessoa pessoa) {
        if (pessoa == null) {
            return 0.0;
        }
        Double valorChequesAberto = this.getSaldoDevedorChequesDevolvidosCliente(pessoa);
        valorChequesAberto = valorChequesAberto + this.getSaldoDevedorChequesNaoCompCliente(pessoa);
        return valorChequesAberto;
    }

    private Double getSaldoDevedorChequesDevolvidosCliente(Pessoa pessoa) {
        Double valorChequesAberto = this.serviceChequeTerceiros.valorChequesDevolvidos(pessoa.getIdentificador());
        return valorChequesAberto == null ? 0.0 : valorChequesAberto;
    }

    private Double getSaldoDevedorChequesNaoCompCliente(Pessoa pessoa) {
        Double valorChequesAberto = this.serviceChequeTerceiros.valorChequesNaoCompensados(pessoa.getIdentificador());
        return valorChequesAberto == null ? 0.0 : valorChequesAberto;
    }
}

