/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.analisecredito;

import com.touchcomp.basementor.constants.enums.opcoesfaturamento.EnumConstOpFatVendaComDebito;
import com.touchcomp.basementor.constants.enums.saldotitulos.EnumConstSaldoTitPagRec;
import com.touchcomp.basementor.constants.enums.saldotitulos.EnumConstSaldoTitPessoaGrupoPessoa;
import com.touchcomp.basementor.model.vo.GrupoPessoas;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementorservice.BaseMethods;
import com.touchcomp.basementorservice.service.impl.saldotitulo.ServiceSaldoTituloImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceChequeTerceiros;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.touchvomodel.web.WebDTOResult;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompAnaliseCreditoGrupoPessoas
extends BaseMethods {
    @Autowired
    private ServiceSaldoTituloImpl serviceSaldoTitulo;
    @Autowired
    private ServiceChequeTerceiros serviceChequeTerceiros;

    public WebDTOResult validarClienteFinanceiro(GrupoPessoas grupoPessoas, Double valorAdicional, OpcoesFinanceiras opFin) {
        WebDTOResult result = new WebDTOResult();
        if (grupoPessoas == null) {
            return result;
        }
        if (this.isAffimative(grupoPessoas.getNaoAvaliarFinanceiro())) {
            return result;
        }
        if (this.isAffimative(opFin.getVerificaLimitePedido())) {
            if (grupoPessoas.getDataLiberacaoCredito() != null && grupoPessoas.getDiasVigorLimiteCred() != null && grupoPessoas.getDiasVigorLimiteCred() > 0) {
                Date next = ToolDate.nextDays((Date)grupoPessoas.getDataLiberacaoCredito(), (int)grupoPessoas.getDiasVigorLimiteCred());
                Object msg = " A an\u00e1lise do limite de cr\u00e9dito do grupo de pessoas deste cliente ser\u00e1 liberado \u00e0 partir da data " + ToolDate.dateToStr((Date)grupoPessoas.getDataLiberacaoCredito(), (String)"dd-MM-yyyy");
                if (grupoPessoas.getDataLiberacaoCredito().after(ToolDate.getCurrentDate())) {
                    if (this.isEquals(opFin.getPermitirVendaComDebito(), EnumConstOpFatVendaComDebito.PERMITIR_VENDA_SO_AVISAR.getValue()) || this.isEquals(opFin.getPermitirVendaComDebito(), EnumConstOpFatVendaComDebito.NAO_PERMITIR_VENDA_DEB_BLOQ_PED.getValue())) {
                        result.addWarning((String)msg);
                    } else {
                        result.addErroMessage("", (String)msg);
                    }
                    return result;
                }
                msg = "A an\u00e1lise do limite de cr\u00e9dito do grupo de pessoas deste cliente expirou. Refa\u00e7a a an\u00e1lise de Cr\u00e9dito.";
                if (next.before(ToolDate.getCurrentDate())) {
                    if (this.isEquals(opFin.getPermitirVendaComDebito(), EnumConstOpFatVendaComDebito.PERMITIR_VENDA_SO_AVISAR.getValue()) || this.isEquals(opFin.getPermitirVendaComDebito(), EnumConstOpFatVendaComDebito.NAO_PERMITIR_VENDA_DEB_BLOQ_PED.getValue())) {
                        result.addWarning((String)msg);
                    } else {
                        result.addErroMessage("", (String)msg);
                    }
                    return result;
                }
            }
            String msg = "Cliente inabilitado para compras!";
            if (grupoPessoas.getHabilParaCompra() == null || !this.isAffimative(grupoPessoas.getHabilParaCompra())) {
                if (this.isEquals(opFin.getPermitirVendaComDebito(), EnumConstOpFatVendaComDebito.PERMITIR_VENDA_SO_AVISAR.getValue()) || this.isEquals(opFin.getPermitirVendaComDebito(), EnumConstOpFatVendaComDebito.NAO_PERMITIR_VENDA_DEB_BLOQ_PED.getValue())) {
                    result.addWarning(msg);
                } else {
                    result.addErroMessage("", msg);
                }
                return result;
            }
            this.validarTitulosEmAberto(result, valorAdicional, opFin, grupoPessoas.getLimiteCredito(), grupoPessoas);
            this.validarTituloVencidoEmAberto(result, opFin, grupoPessoas);
        }
        return result;
    }

    private void validarTituloVencidoEmAberto(WebDTOResult result, OpcoesFinanceiras opcoesFinanceiras, GrupoPessoas grupoPessoas) {
        Double saldoDevedor;
        if (opcoesFinanceiras.getPermitirVendaComDebito() != null && this.isEquals(opcoesFinanceiras.getPermitirVendaComDebito(), EnumConstOpFatVendaComDebito.PERMITIR_VENDA_NAO_AVISAR.getValue()) && (saldoDevedor = this.verificarTituloVencidoEmAberto(grupoPessoas)) > 0.0) {
            if (this.isEquals(opcoesFinanceiras.getPermitirVendaComDebito(), EnumConstOpFatVendaComDebito.NAO_PERMITIR_VENDA_DEB.getValue())) {
                result.addErroMessage("", "Grupo de Pessoas deste cliente possui t\u00edtulos em atraso.");
            }
            if (this.isEquals(opcoesFinanceiras.getPermitirVendaComDebito(), EnumConstOpFatVendaComDebito.PERMITIR_VENDA_SO_AVISAR.getValue()) || this.isEquals(opcoesFinanceiras.getPermitirVendaComDebito(), EnumConstOpFatVendaComDebito.NAO_PERMITIR_VENDA_DEB_BLOQ_PED.getValue())) {
                result.addWarning("Grupo de Pessoas deste cliente possui t\u00edtulos em atraso.");
            }
        }
    }

    private Double verificarTituloVencidoEmAberto(GrupoPessoas grupoPessoas) {
        Double saldo = this.serviceSaldoTitulo.getSaldoVencidoGrupoPessoa(grupoPessoas.getIdentificador(), EnumConstSaldoTitPagRec.TIPO_TITULO_REC, EnumConstSaldoTitPessoaGrupoPessoa.TIPO_GRUPO_PESSOA, null);
        return saldo;
    }

    private void validarTitulosEmAberto(WebDTOResult result, Double valorAdicional, OpcoesFinanceiras opcoesFinanceiras, Double limiteCreditoCliente, GrupoPessoas grupoPessoas) {
        Double saldoDevedor = 0.0;
        if ((saldoDevedor = Double.valueOf(saldoDevedor + this.getSaldoDevedorCliente(grupoPessoas, opcoesFinanceiras))) + valorAdicional > limiteCreditoCliente) {
            if (this.isEquals(opcoesFinanceiras.getPermitirVendaComDebito(), EnumConstOpFatVendaComDebito.NAO_PERMITIR_VENDA_DEB.getValue())) {
                result.addErroMessage("", "O grupo de pessoas deste cliente possui t\u00edtulos em atraso ou seu limite de cr\u00e9dito foi ultrapassado.");
            }
            if (this.isEquals(opcoesFinanceiras.getPermitirVendaComDebito(), EnumConstOpFatVendaComDebito.PERMITIR_VENDA_SO_AVISAR.getValue()) || this.isEquals(opcoesFinanceiras.getPermitirVendaComDebito(), EnumConstOpFatVendaComDebito.NAO_PERMITIR_VENDA_DEB_BLOQ_PED.getValue())) {
                result.addWarning("O grupo de pessoas deste cliente possui t\u00edtulos em atraso ou seu limite de cr\u00e9dito foi ultrapassado.");
            }
        }
    }

    private Double getSaldoDevedorCliente(GrupoPessoas grupoPessoas, OpcoesFinanceiras opcoesFinanceiras) {
        Double valor = this.getSaldoDevedorTitulosCliente(grupoPessoas);
        if (valor == null) {
            valor = 0.0;
        }
        if (opcoesFinanceiras != null && opcoesFinanceiras.getIncluirChequeAnCred() != null && opcoesFinanceiras.getIncluirChequeAnCred() == 1) {
            valor = valor + this.getSaldoDevedorChequesAbertoCliente(grupoPessoas);
        }
        return valor;
    }

    private Double getSaldoDevedorTitulosCliente(GrupoPessoas grupoPessoas) {
        Double saldo = this.serviceSaldoTitulo.getSaldoDevedorGrupoPessoa(grupoPessoas.getIdentificador(), EnumConstSaldoTitPagRec.TIPO_TITULO_REC, EnumConstSaldoTitPessoaGrupoPessoa.TIPO_GRUPO_PESSOA, null);
        return saldo;
    }

    private Double getSaldoDevedorChequesAbertoCliente(GrupoPessoas grupoPessoas) {
        Double valorChequesAberto = this.getSaldoDevedorChequesDevolvidosCliente(grupoPessoas);
        valorChequesAberto = valorChequesAberto + this.getSaldoDevedorChequesNaoCompCliente(grupoPessoas);
        return valorChequesAberto;
    }

    private Double getSaldoDevedorChequesDevolvidosCliente(GrupoPessoas grupoPessoas) {
        Double valorChequesAberto = this.serviceChequeTerceiros.valorChequesDevolvidosGrupoPessoas(grupoPessoas.getIdentificador());
        valorChequesAberto = valorChequesAberto == null ? 0.0 : valorChequesAberto;
        return valorChequesAberto;
    }

    private Double getSaldoDevedorChequesNaoCompCliente(GrupoPessoas grupoPessoas) {
        Double valorChequesAberto = this.serviceChequeTerceiros.valorChequesNaoCompensadosGrupoPessoa(grupoPessoas.getIdentificador());
        valorChequesAberto = valorChequesAberto == null ? 0.0 : valorChequesAberto;
        return valorChequesAberto;
    }
}

