/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.bderrors;

import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.components.bderrors.AuxProcessaForeignKey;
import com.touchcomp.basementortools.model.string.StringToken;
import com.touchcomp.basementortools.tools.exception.ToolException;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.hibernate.JDBCException;
import org.hibernate.exception.ConstraintViolationException;

public class CompBDErrors {
    public static String getProcessedMessage(Throwable ex) throws ExceptionRuntimeBase {
        try {
            if (ex == null) {
                throw new ExceptionRuntimeBase("E.GEN.000028");
            }
            if (ToolException.findException((Throwable)ex, ConstraintViolationException.class).booleanValue()) {
                return CompBDErrors.processViolationException(ex);
            }
            if (ToolException.findException((Throwable)ex, JDBCException.class).booleanValue()) {
                return CompBDErrors.processViolationException(ex);
            }
            if (ToolException.findException((Throwable)ex, ExceptionBase.class).booleanValue()) {
                ExceptionBase e = (ExceptionBase)ToolException.getException((Throwable)ex, ExceptionBase.class);
                return e != null ? e.getFormattedMessage() : ex.getMessage();
            }
            if (ToolException.findException((Throwable)ex, ExceptionRuntimeBase.class).booleanValue()) {
                ExceptionRuntimeBase e = (ExceptionRuntimeBase)ToolException.getException((Throwable)ex, ExceptionRuntimeBase.class);
                return e != null ? e.getFormattedMessage() : ex.getMessage();
            }
            TLogger.get(CompBDErrors.class).error(ex);
            throw new ExceptionRuntimeBase(MessagesBaseMentor.getErrorMsg((String)"E.GEN.000028", (Object[])new Object[]{ex.getMessage()}));
        }
        catch (IOException e) {
            TLogger.get(CompBDErrors.class).error(ex);
            throw new ExceptionRuntimeBase("E.GEN.000028");
        }
    }

    private static String processaMensagem(Throwable ex, String msg) {
        List tokens = ToolString.getReplaceTokens((String)CompBDErrors.getFullException(ex), (char)'|', (char)'|');
        if (!tokens.isEmpty()) {
            return (String)tokens.get(0);
        }
        StringToken[] tokensArray = ToolString.getReplaceTokensInArray((String)CompBDErrors.getFullException(ex));
        Object ret = msg;
        StringToken[] tokensToReplace = ToolString.getReplaceTokensInArray((String)msg);
        if (tokensToReplace.length > 0) {
            HashMap<String, StringToken> h = new HashMap<String, StringToken>();
            for (int i = 0; i < tokensArray.length; ++i) {
                try {
                    StringToken token = tokensArray[i];
                    StringToken token1 = tokensToReplace[i];
                    h.put(token1.getChave(), token);
                    continue;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            ret = ToolString.build((String)msg, h);
        } else {
            for (StringToken object : tokensArray) {
                ret = (String)ret + "\n" + String.valueOf(object);
            }
        }
        return ret;
    }

    private static String processMessageErro(Throwable ex) {
        String st = null;
        if (ex != null) {
            try {
                st = AuxProcessaForeignKey.getInstance().toStringErrorViolation(ex);
                if (st == null || st.trim().length() == 0) {
                    st = null;
                }
            }
            catch (Exception ex1) {
                TLogger.get(CompBDErrors.class).error(ex);
            }
        }
        if (st == null) {
            return null;
        }
        return MessagesBaseMentor.getTextDetailsMsg((String)"M.ERP.0000001", (Object[])new Object[]{st});
    }

    private static String getFullException(Throwable ex) {
        Object st = "";
        while (ex != null) {
            st = (String)st + ex.getMessage();
            ex = ex.getCause();
        }
        return st;
    }

    public static String getProcessedMessageViolationFK(Throwable ex) {
        return AuxProcessaForeignKey.getInstance().toStringErrorViolation(ex);
    }

    private static String getMessage(InputStream in, Throwable ex) throws IOException {
        Properties props = new Properties();
        if (in == null) {
            return null;
        }
        props.load(in);
        Enumeration<Object> e = props.keys();
        String full = ToolException.getFullPrintStrack((Throwable)ex);
        while (e.hasMoreElements()) {
            String aux = (String)e.nextElement();
            if (!ToolException.findMessage((String)full, (String)aux).booleanValue()) continue;
            String msg = props.getProperty(aux);
            return CompBDErrors.processaMensagem(ex, msg);
        }
        return null;
    }

    private static String processViolationException(Throwable ex) throws IOException {
        if (ToolException.findMessage((Throwable)ex, (String)"FOREIGNKEY", (boolean)true).booleanValue()) {
            String st = CompBDErrors.processMessageErro(ex);
            return st;
        }
        InputStream inBdErrors = CompBDErrors.class.getResourceAsStream("/messages/bd_errors.properties");
        InputStream inUniques = CompBDErrors.class.getResourceAsStream("/messages/unique_keys.properties");
        String ret = CompBDErrors.getMessage(inUniques, ex);
        if (ret != null) {
            return ret;
        }
        ret = CompBDErrors.getMessage(inBdErrors, ex);
        if (ret != null) {
            return ret;
        }
        String full = ToolException.getFullPrintStrack((Throwable)((Exception)ex));
        List tokens = ToolString.getReplaceTokens((String)full);
        if (tokens.size() > 0) {
            Object temp = "";
            for (StringToken token : tokens) {
                temp = (String)temp + token.getChave();
            }
            return temp;
        }
        if (ex != null) {
            return ex.getMessage();
        }
        throw new ExceptionRuntimeBase(MessagesBaseMentor.getErrorMsg((String)"E.GEN.000065", (Object[])new Object[]{ex.getMessage()}));
    }
}

