/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.borderocobranca;

import com.touchcomp.basementor.model.vo.BorderoTitulos;
import com.touchcomp.basementor.model.vo.CarteiraCobranca;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemBorderoCobranca;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidDataRuntime;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class CompBorderoTitulos {
    public BorderoTitulos criarBordero(CarteiraCobranca carteiraOrigem, CarteiraCobranca carteiraDestino, Empresa empresa, List<Titulo> listTitulos) {
        this.validaDadosCreateBordero(carteiraOrigem, carteiraDestino, empresa, listTitulos);
        BorderoTitulos b = new BorderoTitulos();
        b.setCarteiraCobranca(carteiraDestino);
        b.setCarteiraOrigem(carteiraOrigem);
        b.setDataBordero(new Date());
        b.setDataCadastro(new Date());
        b.setEmpresa(empresa);
        b.setItemBorderoCobranca(this.createItensBordero(listTitulos, b));
        return b;
    }

    private List<ItemBorderoCobranca> createItensBordero(List<Titulo> listTitulos, BorderoTitulos borderoTitulos) {
        ArrayList<ItemBorderoCobranca> listItens = new ArrayList<ItemBorderoCobranca>();
        for (Titulo t : listTitulos) {
            ItemBorderoCobranca item = new ItemBorderoCobranca();
            t.setCarteiraCobranca(borderoTitulos.getCarteiraCobranca());
            item.setTitulo(t);
            item.setBorderoCobranca(borderoTitulos);
            listItens.add(item);
        }
        return listItens;
    }

    public List<Titulo> atualizarCartTituloBeforeDeleteBordero(List<Titulo> listTitulos, CarteiraCobranca carteira) {
        this.validaDadosDeleteBordero(listTitulos, carteira);
        listTitulos.forEach(t -> t.setCarteiraCobranca(carteira));
        return listTitulos;
    }

    public BorderoTitulos atualizarCartTituloBeforeDeleteBordero(BorderoTitulos bordero, CarteiraCobranca carteira) {
        this.validaDadosDeleteBordero(bordero, carteira);
        bordero.getItemBorderoCobranca().forEach(item -> item.getTitulo().setCarteiraCobranca(carteira));
        return bordero;
    }

    private void validaDadosCreateBordero(CarteiraCobranca carteiraOrigem, CarteiraCobranca carteiraDestino, Empresa empresa, List<Titulo> listTitulos) {
        if (ToolMethods.isEquals((Object)carteiraOrigem, null)) {
            throw new ExceptionInvalidDataRuntime(new ExcepCodeDetail("V.ERP.1212.001"));
        }
        if (ToolMethods.isEquals((Object)carteiraDestino, null)) {
            throw new ExceptionInvalidDataRuntime(new ExcepCodeDetail("V.ERP.1212.002"));
        }
        if (ToolMethods.isEquals((Object)empresa, null)) {
            throw new ExceptionInvalidDataRuntime(new ExcepCodeDetail("V.ERP.1212.003"));
        }
        if (!ToolMethods.isWithData(listTitulos)) {
            throw new ExceptionInvalidDataRuntime(new ExcepCodeDetail("V.ERP.1212.004"));
        }
    }

    private void validaDadosDeleteBordero(List<Titulo> listTitulos, CarteiraCobranca carteira) {
        if (ToolMethods.isEquals((Object)carteira, null)) {
            throw new ExceptionInvalidDataRuntime(new ExcepCodeDetail("V.ERP.1212.005"));
        }
        if (!ToolMethods.isWithData(listTitulos)) {
            throw new ExceptionInvalidDataRuntime(new ExcepCodeDetail("V.ERP.1212.004"));
        }
    }

    private void validaDadosDeleteBordero(BorderoTitulos borderoTitulos, CarteiraCobranca carteira) {
        if (ToolMethods.isEquals((Object)borderoTitulos, null)) {
            throw new ExceptionInvalidDataRuntime(new ExcepCodeDetail("V.ERP.1212.006"));
        }
        if (ToolMethods.isEquals((Object)carteira, null)) {
            throw new ExceptionInvalidDataRuntime(new ExcepCodeDetail("V.ERP.1212.005"));
        }
    }
}

