/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.businessintelligence;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.touchcomp.basementor.model.vo.BusinessIntelligence;
import com.touchcomp.basementor.model.vo.BusinessIntelligencePref;
import com.touchcomp.basementor.model.vo.ClasseModeloBI;
import com.touchcomp.basementor.model.vo.DadoAdicionalBI;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Grupo;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementor.model.vo.WhereNodeBI;
import com.touchcomp.basementorexceptions.exceptions.impl.builbusinessintelligence.ExceptionBuildBI;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorservice.components.businessintelligence.CompDynamicParams;
import com.touchcomp.basementorservice.components.businessintelligence.model.DefaultBIParamsMap;
import com.touchcomp.basementorservice.model.bi.BIParamPrefUser;
import com.touchcomp.basementorservice.model.bi.BIPrefUser;
import com.touchcomp.basementortools.tools.converter.CompRestrictionsFactory;
import com.touchcomp.basementortools.tools.converter.impl.OpFinder;
import com.touchcomp.basementortools.tools.json.ToolJson;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.reflections.ToolReflections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class CompBIDefaultParams {
    private final CompDynamicParams compDynamic;

    public CompBIDefaultParams(CompDynamicParams compDynamic) {
        this.compDynamic = compDynamic;
    }

    public void buildDefValuesParams(BusinessIntelligence bi) throws ExceptionBuildBI {
        this.buildDefValuesParams(bi, null);
    }

    public void buildDefValuesParams(BusinessIntelligence bi, DefaultBIParamsMap<String, Object> defParams) throws ExceptionBuildBI {
        this.buildDefValuesParams(bi, defParams, null);
    }

    public void buildDefValuesParams(BusinessIntelligence bi, DefaultBIParamsMap<String, Object> defParams, Object obj) throws ExceptionBuildBI {
        if (defParams == null) {
            defParams = new DefaultBIParamsMap();
        }
        this.putDadosAdicionais(bi.getDadosAdicionalBI(), bi, defParams, obj);
        this.putDadosObjetos(bi, defParams);
    }

    private void putDadosAdicionais(List<DadoAdicionalBI> dadosAdicionalBI, BusinessIntelligence bi, DefaultBIParamsMap<String, Object> defParams, Object obj) throws ExceptionBuildBI {
        for (DadoAdicionalBI d : dadosAdicionalBI) {
            d.setValorParametro(this.buildValorParametro(d.getTipoInfValor(), d.getValorParametro(), d.getValorExpressao(), d.getChaveParametro(), d.getClasseParametro(), d.getClassePesquisa(), d.getMetodoPesquisa(), defParams));
            this.putDadosAdicionais(d.getDadoAdicionalBIFilhos(), bi, defParams, obj);
        }
    }

    private void putDadosObjetos(BusinessIntelligence bi, DefaultBIParamsMap<String, Object> defParams) throws ExceptionBuildBI {
        if (bi.getBusinessIntelligenceObjetos() == null) {
            return;
        }
        if (bi.getBusinessIntelligenceObjetos().getClasseModeloBI() == null) {
            return;
        }
        this.putDadosObjetos(bi.getBusinessIntelligenceObjetos().getClasseModeloBI().getNodosCondicao(), defParams, bi.getBusinessIntelligenceObjetos().getClasseModeloBI());
    }

    public void putDadosObjetos(List<WhereNodeBI> whereNodes) throws ExceptionBuildBI {
        this.putDadosObjetos(whereNodes, new DefaultBIParamsMap<String, Object>(), null);
    }

    public void putDadosObjetos(List<WhereNodeBI> whereNodes, DefaultBIParamsMap<String, Object> defParams, ClasseModeloBI classeMod) throws ExceptionBuildBI {
        for (WhereNodeBI d : whereNodes) {
            if (d.getCheckNodeBI() != null && classeMod == null) {
                classeMod = d.getClasseModelo();
            }
            Object metodo = d.getAtributo();
            String classe = d.getClasse();
            if (ToolMethods.isStrWithData((String)d.getFullPathAtributo())) {
                metodo = d.getFullPathAtributo() + (String)metodo;
            }
            try {
                if (ToolMethods.isStrWithData((String)classe) && ToolReflections.isPrimitive(Class.forName(classe)) && classeMod != null) {
                    classe = classeMod.getClasse();
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            d.setParametro1(this.buildValorParametro(d.getTipoInfValor(), d.getParametro1(), d.getValorExpressao1(), d.getChave(), d.getClasse(), classe, (String)metodo, defParams));
            d.setParametro2(this.buildValorParametro(d.getTipoInfValor(), d.getParametro2(), d.getValorExpressao2(), d.getChave(), d.getClasse(), classe, (String)metodo, defParams));
            this.putDadosObjetos(d.getFilhos(), defParams, classeMod);
        }
    }

    public static void buildPrefParams(BusinessIntelligence businessIntelligence, BusinessIntelligencePref currentPerfil) throws ExceptionIO {
        if (currentPerfil == null || currentPerfil.getDadosUtilizados() == null || currentPerfil.getDadosUtilizados().isEmpty()) {
            return;
        }
        Map options = ToolMethods.toMap((ToolMethods.Pair[])new ToolMethods.Pair[]{ToolMethods.pair((Object)DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, (Object)false)});
        BIPrefUser prefs = (BIPrefUser)ToolJson.readJson((String)currentPerfil.getDadosUtilizados(), BIPrefUser.class, (Map)options);
        for (BIParamPrefUser pref : prefs.getParams()) {
            DadoAdicionalBI found;
            if (pref.getTipo().equals((short)0) && (found = CompBIDefaultParams.findIt(pref.getChave(), businessIntelligence.getDadosAdicionalBI())) != null) {
                found.setValorParametro(pref.getValor1());
            }
            if (!pref.getTipo().equals((short)1) || (found = CompBIDefaultParams.findItWhere(pref.getChave(), businessIntelligence.getBusinessIntelligenceObjetos().getClasseModeloBI().getNodosCondicao())) == null) continue;
            found.setOperacao(pref.getOpcao());
            found.setParametro1(pref.getValor1());
            found.setParametro2(pref.getValor2());
        }
    }

    private static DadoAdicionalBI findIt(String key, List<DadoAdicionalBI> dados) {
        for (DadoAdicionalBI dado : dados) {
            if (dado.getChaveParametro() != null && dado.getChaveParametro().equalsIgnoreCase(key)) {
                return dado;
            }
            DadoAdicionalBI found = CompBIDefaultParams.findIt(key, dado.getDadoAdicionalBIFilhos());
            if (found == null) continue;
            return found;
        }
        return null;
    }

    private static WhereNodeBI findItWhere(String key, List<WhereNodeBI> dados) {
        for (WhereNodeBI dado : dados) {
            if ((dado.getFullPathAtributo() + dado.getAtributo()).equalsIgnoreCase(key)) {
                return dado;
            }
            WhereNodeBI found = CompBIDefaultParams.findItWhere(key, dado.getFilhos());
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public static DefaultBIParamsMap getDefParamsMap(HashMap<String, Object> params) {
        DefaultBIParamsMap h = new DefaultBIParamsMap();
        h.putAll(params);
        return h;
    }

    public static DefaultBIParamsMap<String, Object> getDefParamsMap(Empresa empresa, Usuario usuario, Grupo grupoUsuario, Object ... others) {
        DefaultBIParamsMap<String, Object> h = new DefaultBIParamsMap<String, Object>();
        h.putItAll(empresa, usuario, grupoUsuario);
        h.putItAllObj(others);
        return h;
    }

    public String buildValorParametro(Short tipoInfValor, String valorParametro, String expressaoParametro, String chaveParametro, String classeParametro, String classePesquisa, String metodoPesquisa, DefaultBIParamsMap<String, Object> defParams) throws ExceptionBuildBI {
        String value;
        block8: {
            value = valorParametro;
            if (defParams.get(chaveParametro) != null) {
                Object temp = defParams.get(chaveParametro);
                OpFinder o = CompRestrictionsFactory.getRestrictions(temp.getClass());
                value = o.convertValueToStringNative(temp);
            } else if (this.compDynamic.isDynamicParam(expressaoParametro)) {
                try {
                    Object found = this.compDynamic.getValueFromObj(expressaoParametro, classeParametro, defParams);
                    if (found != null) {
                        OpFinder o = CompRestrictionsFactory.getRestrictions(found.getClass());
                        value = o.convertValueToStringNative(found);
                        break block8;
                    }
                    value = CompRestrictionsFactory.getRestrictions((String)classeParametro).getDefaultValueStr();
                }
                catch (ClassCastException found) {}
            } else {
                Object found = this.compDynamic.getValueFromObj(metodoPesquisa, classePesquisa, defParams);
                if (found != null) {
                    OpFinder o = CompRestrictionsFactory.getRestrictions(found.getClass());
                    value = o.convertValueToStringNative(found);
                }
            }
        }
        return value;
    }
}

