/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.businessintelligence;

import com.touchcomp.basementortools.constants.EnumConstantsCriteria;
import com.touchcomp.basementortools.tools.converter.CompRestrictionsFactory;
import com.touchcomp.basementortools.tools.converter.impl.OpFinder;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchvomodel.vo.businessintelligence.DTOBusinessIntelligenceDet;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class CompBIParams {
    public StringBuilder toStringParams(List<DTOBusinessIntelligenceDet.DTODadoAdicional> params) {
        StringBuilder ret = new StringBuilder();
        this.toStringParams(params, 0, ret);
        return ret;
    }

    private void toStringParams(List<DTOBusinessIntelligenceDet.DTODadoAdicional> dadosAdicionais, int countTabs, StringBuilder param) {
        Object tab = "";
        for (int i = 0; i < countTabs; ++i) {
            tab = (String)tab + "&emsp;";
        }
        for (DTOBusinessIntelligenceDet.DTODadoAdicional dd : dadosAdicionais) {
            OpFinder op = CompRestrictionsFactory.getRestrictions((String)dd.getTipoCampo());
            param.append((String)tab);
            param.append("<b>");
            param.append(dd.getDescricao());
            if (dd.getTipo() == DTOBusinessIntelligenceDet.DTODadoAdicionalTipo.DADO_FILTRO_OBJETOS) {
                param.append(" (");
                param.append(this.getDescOperacao(dd.getOperacao(), dd.getOperacoes()));
                param.append(")");
            }
            param.append(": ");
            param.append("</b>");
            param.append(this.getValorInf(op, dd));
            if (dd.getOperacao() != null && dd.getValorInformado1() != null && dd.getOperacao().shortValue() == EnumConstantsCriteria.BETWEEN.getValue()) {
                param.append(" / ");
                param.append(this.convertValue(op, dd.getValorInformado1()));
            }
            param.append("<br>");
            this.toStringParams(dd.getDadosAdicionais(), countTabs + 1, param);
        }
    }

    private String getDescOperacao(Short operacao, List<DTOBusinessIntelligenceDet.DTODadoOperacoes> operacoes) {
        for (DTOBusinessIntelligenceDet.DTODadoOperacoes op : operacoes) {
            if (!ToolMethods.isEquals((Object)op.getOperacao(), (Object)operacao)) continue;
            return op.getDescricao();
        }
        return "NI";
    }

    private String getValorInf(OpFinder op, DTOBusinessIntelligenceDet.DTODadoAdicional dd) {
        Optional<DTOBusinessIntelligenceDet.DTODadoAdicionalFixo> found;
        if (dd.getValorInformado() == null) {
            return "";
        }
        if (!dd.getDadosFixos().isEmpty() && (found = dd.getDadosFixos().stream().filter(i -> ToolMethods.isEquals((Object)i.getValorInformado(), (Object)dd.getValorInformado())).findFirst()).isPresent()) {
            return found.get().getDescricao();
        }
        if (dd.getValorInformado().contains(";")) {
            return dd.getValorInformado();
        }
        return this.convertValue(op, dd.getValorInformado());
    }

    private String convertValue(OpFinder op, String valorInformado1) {
        return op.convertValueToString(op.convertStrNativeValue(valorInformado1));
    }
}

