/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.businessintelligence;

import com.touchcomp.basementor.constants.enums.ConstEnumFormImprBI;
import com.touchcomp.basementor.constants.enums.bi.EnumConstTipoRepositorioBI;
import com.touchcomp.basementor.constants.enums.tiposistemastouch.EnumConstTipoSistema;
import com.touchcomp.basementor.model.vo.BusinessIntelligence;
import com.touchcomp.basementor.model.vo.BusinessIntelligencePref;
import com.touchcomp.basementorexceptions.exceptions.impl.builbusinessintelligence.ExceptionBuildBI;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorservice.components.businessintelligence.CompBIDefaultParams;
import com.touchcomp.basementorservice.components.businessintelligence.model.DefaultBIParamsMap;
import com.touchcomp.basementorservice.helpers.impl.businessintelligence.HelperBusinessIntelligence;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.ServiceBuildBusinessIntelligenceImpl;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.model.DataOutputBI;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.model.DataResultBI;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.touchvomodel.vo.businessintelligence.DTOBusinessIntelligenceDet;
import com.touchcomp.touchvomodel.vo.importacaobi.repositorio.DTOImportacaoBIImportacao;
import java.io.File;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompBusinessIntelligence {
    @Autowired
    CompBIDefaultParams compBIDefaultParams;
    @Autowired
    ServiceBuildBusinessIntelligenceImpl serviceBuildBI;
    @Autowired
    HelperBusinessIntelligence helper;

    public String generateSerialBI(String cpfPessoa, String cnpjEmpresa, Long identificador, Short tipo, EnumConstTipoRepositorioBI tipoRepo) {
        Object serial = "";
        if (tipoRepo.equals((Object)EnumConstTipoRepositorioBI.SMART_COMPONENT)) {
            serial = (String)serial + String.valueOf(tipoRepo.getValue());
        }
        serial = (String)serial + ToolString.completaZeros((String)ToolString.refina((String)cpfPessoa), (int)14, (boolean)true);
        serial = (String)serial + ToolString.completaZeros((String)ToolString.refina((String)cnpjEmpresa), (int)14, (boolean)true);
        serial = (String)serial + ToolString.completaZeros((String)String.valueOf(identificador), (int)5, (boolean)true);
        serial = (String)serial + String.valueOf(tipo);
        return serial;
    }

    public String generateSerialBI(DTOImportacaoBIImportacao dto, EnumConstTipoRepositorioBI tipoRepo) {
        return this.generateSerialBI(dto.getCpfPessoaReponsavel(), dto.getCnpjEmpresaReponsavel(), dto.getIdentificadorReg(), dto.getTipo(), tipoRepo);
    }

    public String generateSerialBI(BusinessIntelligence bi) {
        return this.generateSerialBI(bi.getPessoaResponsavel().getComplemento().getCnpj(), bi.getEmpresa().getPessoa().getComplemento().getCnpj(), bi.getIdentificador(), bi.getTipoBI(), EnumConstTipoRepositorioBI.BI);
    }

    public DataResultBI buildBIData(BusinessIntelligence bi, BusinessIntelligencePref preferences, DefaultBIParamsMap<String, Object> params) throws ExceptionBuildBI, ExceptionIO {
        if (preferences != null) {
            CompBIDefaultParams.buildPrefParams(bi, preferences);
        }
        DataResultBI out = this.serviceBuildBI.gerarBI(bi, EnumConstTipoSistema.WEB, params);
        return out;
    }

    public File prepareGenerateBIFile(BusinessIntelligence bi, String defFileName, ConstEnumFormImprBI formato, DefaultBIParamsMap<String, Object> otherParams) throws ExceptionIO, ExceptionBuildBI {
        return this.prepareGenerateBIFile(bi, null, defFileName, formato, otherParams);
    }

    public File prepareGenerateBIFile(BusinessIntelligence bi, BusinessIntelligencePref preferences, String defFileName, ConstEnumFormImprBI formato, DefaultBIParamsMap<String, Object> params) throws ExceptionIO, ExceptionBuildBI {
        if (preferences != null) {
            CompBIDefaultParams.buildPrefParams(bi, preferences);
        }
        if (params != null) {
            this.compBIDefaultParams.buildDefValuesParams(bi, params);
        }
        if (formato == null) {
            formato = ConstEnumFormImprBI.EXCEL_DIRETO;
        }
        this.compBIDefaultParams.buildDefValuesParams(bi);
        DTOBusinessIntelligenceDet res = this.helper.build(bi).buildToDTO(EnumConstTipoSistema.WEB, params);
        ServiceBuildBusinessIntelligenceImpl service = this.serviceBuildBI;
        DataOutputBI dataResult = service.gerarConverterFormatoImpBI(res, formato, preferences, params);
        File ger = dataResult.getFile();
        if (ToolMethods.isStrWithData((String)defFileName)) {
            ger = ToolFile.renameFileName((File)ger, (String)defFileName, (boolean)true);
        }
        System.out.println("Arquivo gerado com sucesso: " + ger.getAbsolutePath());
        return ger;
    }
}

