/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.businessintelligence;

import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.parser.CronParser;
import com.touchcomp.basementor.constants.enums.EnumBaseInterface;
import com.touchcomp.basementorexceptions.exceptions.impl.builbusinessintelligence.ExceptionBuildBI;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.reflections.ToolReflections;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.hibernate.proxy.HibernateProxy;
import org.springframework.stereotype.Component;

@Component
public class CompDynamicParams {
    private final String MASK_EXPRESSION_REV = "expressionRev:(${cronExpression})";
    private final String MASK_EXPRESSION = "expression:(${cronExpression})";
    private final String MASK_REFLECTION = "reflection:(${class}:${fieldPath})";

    public Object getValueFromObj(String expressao, String classType, Object obj) throws ExceptionBuildBI {
        Map<String, Object> defValues = new HashMap<String, Object>();
        if (obj != null && obj instanceof Map) {
            defValues = (Map)obj;
        }
        return this.getValueFromObj(expressao, classType, defValues);
    }

    public Object getValueFromObj(String expressao, String classType, Map<String, Object> defValues) throws ExceptionBuildBI {
        if (defValues == null) {
            defValues = new HashMap<String, Object>();
        }
        try {
            if (this.isReflection(expressao)) {
                return this.getValueAsReflection(expressao, defValues);
            }
            if (this.isDateExpressionRev(expressao)) {
                return this.getValueAsExpressionRev(expressao);
            }
            if (this.isDateExpression(expressao)) {
                return this.getValueAsExpression(expressao);
            }
        }
        catch (Throwable t) {
            TLogger.get(this.getClass()).error(t);
        }
        return this.convertStringToObject(classType, expressao, defValues);
    }

    private Object convertStringToObject(String classe, String fieldExpression, Map<String, Object> defValues) throws ExceptionBuildBI {
        if (!TMethods.isStrWithData((String)classe) || defValues == null || !TMethods.isStrWithData((String)fieldExpression)) {
            return null;
        }
        if (classe.lastIndexOf(".") > 0) {
            classe = classe.substring(classe.lastIndexOf(".") + 1);
        }
        String key = classe;
        Optional<String> found = defValues.keySet().stream().filter(i -> TMethods.isEquals((Object)i, (Object)key)).findFirst();
        if (!found.isPresent()) {
            return null;
        }
        Object value = defValues.get(found.get());
        if (value == null) {
            return null;
        }
        value = this.getValueFromObj(value, fieldExpression);
        return value;
    }

    private boolean isReflection(String temp) {
        if (!TMethods.isStrWithData((String)temp)) {
            return false;
        }
        return temp.startsWith(DynamicParamType.VALOR_REFLECTION.getPrefixo());
    }

    private boolean isDateExpression(String temp) {
        if (!TMethods.isStrWithData((String)temp)) {
            return false;
        }
        return temp.startsWith(DynamicParamType.VALOR_EXPRESSAO.getPrefixo());
    }

    private boolean isDateExpressionRev(String temp) {
        if (!TMethods.isStrWithData((String)temp)) {
            return false;
        }
        return temp.startsWith(DynamicParamType.VALOR_EXPRESSAO_REVERSA.getPrefixo());
    }

    private Object getValueFromObj(Object obj, String path) throws ExceptionBuildBI {
        try {
            return ToolReflections.getFieldValueFromGetMethod((String)path, (Object)obj);
        }
        catch (ExceptionReflection ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw new ExceptionBuildBI(ex.getFormattedMessage(), (Throwable)ex, new Object[0]);
        }
    }

    private Date getValueAsExpression(String data) throws ExceptionBuildBI {
        data = data.substring(DynamicParamType.VALOR_EXPRESSAO.getPrefixo().length());
        data = data.replaceAll("\\(", "");
        data = data.replaceAll("\\)", "");
        CronDefinition cronDefinition = CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ);
        CronParser parser = new CronParser(cronDefinition);
        ExecutionTime executionTime = ExecutionTime.forCron((Cron)parser.parse(data));
        Optional found = executionTime.nextExecution(ZonedDateTime.now());
        return found.isPresent() ? ToolDate.asDate((ZonedDateTime)((ZonedDateTime)found.get())) : new Date();
    }

    private Date getValueAsExpressionRev(String data) throws ExceptionBuildBI {
        data = data.substring(DynamicParamType.VALOR_EXPRESSAO_REVERSA.getPrefixo().length());
        data = data.replaceAll("\\(", "");
        data = data.replaceAll("\\)", "");
        CronDefinition cronDefinition = CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ);
        CronParser parser = new CronParser(cronDefinition);
        ExecutionTime executionTime = ExecutionTime.forCron((Cron)parser.parse(data));
        Optional found = executionTime.lastExecution(ZonedDateTime.now());
        return found.isPresent() ? ToolDate.asDate((ZonedDateTime)((ZonedDateTime)found.get())) : new Date();
    }

    private Object getValueAsReflection(String data, Map<String, Object> defValues) throws ExceptionBuildBI {
        String field;
        data = data.substring(DynamicParamType.VALOR_REFLECTION.getPrefixo().length());
        data = data.replaceAll("\\(", "");
        data = data.replaceAll("\\)", "");
        Object obj = null;
        if (data.startsWith("[")) {
            String key = data.substring(0, data.indexOf("]") + 1);
            obj = defValues.get(key);
            field = data.substring(data.indexOf("]") + 2);
        } else {
            int index;
            Set<String> keys = defValues.keySet();
            for (String key : keys) {
                Object temp = defValues.get(key);
                if ((temp == null || !(temp instanceof HibernateProxy) || !TMethods.isEquals((Object)key, (Object)((HibernateProxy)temp).getHibernateLazyInitializer().getPersistentClass().getSimpleName())) && (temp == null || !TMethods.isEquals((Object)key, (Object)temp.getClass().getSimpleName()))) continue;
                obj = temp;
                break;
            }
            field = (index = data.lastIndexOf(":")) >= 0 ? data.substring(index + 1) : data;
        }
        return this.getValueFromObj(obj, field);
    }

    public boolean isDynamicParam(String valorParametro) {
        if (!TMethods.isStrWithData((String)valorParametro)) {
            return false;
        }
        if (valorParametro.startsWith(DynamicParamType.VALOR_EXPRESSAO.getPrefixo())) {
            return true;
        }
        if (valorParametro.startsWith(DynamicParamType.VALOR_EXPRESSAO_REVERSA.getPrefixo())) {
            return true;
        }
        return valorParametro.startsWith(DynamicParamType.VALOR_REFLECTION.getPrefixo());
    }

    public Expression getExpression(String expression) throws ExceptionInvalidData {
        Expression ex = new Expression();
        ex.setType(DynamicParamType.VALOR_INFORMADO);
        if (!this.isDynamicParam(expression)) {
            return ex;
        }
        if (this.isReflection(expression)) {
            ex.setType(DynamicParamType.VALOR_REFLECTION);
        }
        if (this.isDateExpression(expression)) {
            ex.setType(DynamicParamType.VALOR_EXPRESSAO);
            ex.setCronExpression(this.getCronExpression(expression));
        }
        return ex;
    }

    private String getCronExpression(String data) {
        data = data.substring(DynamicParamType.VALOR_EXPRESSAO.getPrefixo().length());
        return data;
    }

    public String getExpression(Expression currentExpression) {
        if (currentExpression == null) {
            return null;
        }
        if (currentExpression.getType() == null || currentExpression.getType().equals((Object)DynamicParamType.VALOR_INFORMADO)) {
            return null;
        }
        if (currentExpression.getType() == DynamicParamType.VALOR_REFLECTION) {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("class", currentExpression.entidade);
            data.put("fieldPath", currentExpression.field);
            return ToolString.build((String)"reflection:(${class}:${fieldPath})", data);
        }
        if (currentExpression.getType() == DynamicParamType.VALOR_EXPRESSAO_REVERSA) {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("cronExpression", currentExpression.cronExpression);
            return ToolString.build((String)"expressionRev:(${cronExpression})", data);
        }
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("cronExpression", currentExpression.cronExpression);
        return ToolString.build((String)"expression:(${cronExpression})", data);
    }

    public static enum DynamicParamType implements EnumBaseInterface<Integer, String>
    {
        VALOR_INFORMADO(1, "Valor Informado", ""),
        VALOR_EXPRESSAO(5, "Expressao", "expression:"),
        VALOR_EXPRESSAO_REVERSA(6, "Expressao Reversa(Data Anterior)", "expressionRev:"),
        VALOR_REFLECTION(10, "Dinamico(Reflection)", "reflection:");

        private final int value;
        private final String descricao;
        private final String prefixo;

        private DynamicParamType(Integer option, String descricao, String prefixo) {
            this.value = option;
            this.descricao = descricao;
            this.prefixo = prefixo;
        }

        public int getValue() {
            return this.value;
        }

        public String getDescricao() {
            return this.descricao;
        }

        public String getPrefixo() {
            return this.prefixo;
        }

        public String toString() {
            return this.descricao;
        }

        public Integer getEnumId() {
            return this.getValue();
        }

        public String getEnumDesc() {
            return this.getDescricao();
        }
    }

    public static class Expression {
        private DynamicParamType type;
        private String entidade;
        private String field;
        private String cronExpression;

        public DynamicParamType getType() {
            return this.type;
        }

        public void setType(DynamicParamType type) {
            this.type = type;
        }

        public String getEntidade() {
            return this.entidade;
        }

        public void setEntidade(String entidade) {
            this.entidade = entidade;
        }

        public String getField() {
            return this.field;
        }

        public void setField(String field) {
            this.field = field;
        }

        public String getCronExpression() {
            return this.cronExpression;
        }

        public void setCronExpression(String cronExpression) {
            this.cronExpression = cronExpression;
        }
    }
}

