/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.businessintelligence.atualizador;

import com.fasterxml.jackson.core.type.TypeReference;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorStatus;
import com.touchcomp.basementor.constants.enums.bi.EnumConstTipoRepositorioBI;
import com.touchcomp.basementor.constants.enums.tiposistemastouch.EnumConstTipoSistemasTouch;
import com.touchcomp.basementor.model.vo.BusinessIntelligence;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.decoder.ExceptionDecodeHexString;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorexceptions.exceptions.impl.webservice.ExceptionWebService;
import com.touchcomp.basementorproperties.api.PropertiesApi;
import com.touchcomp.basementorservice.components.businessintelligence.repositorio.AuxImportBI;
import com.touchcomp.basementorservice.model.genericmap.GenericMapValues;
import com.touchcomp.basementorservice.service.impl.businessintelligence.DadosBILocais;
import com.touchcomp.basementorservice.service.impl.businessintelligence.ServiceBusinessIntelligenceImpl;
import com.touchcomp.basementorservice.service.impl.formatogeracaobi.ServiceFormatoGeracaoBIImpl;
import com.touchcomp.basementorservice.service.impl.nodo.ServiceNodoImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.webserviceclient.ToolRESTWebServiceClient;
import com.touchcomp.basementorversao.model.temp.DTOInfoVersao;
import com.touchcomp.basementorversao.service.impl.versoes.ServiceVersaoVersoesImpl;
import com.touchcomp.touchvomodel.vo.importacaobi.repositorio.DTOImportacaoBIRes;
import com.touchcomp.touchvomodel.vo.importacaobi.repositorio.DTOVersaoBICompleto;
import com.touchcomp.touchvomodel.web.WebDTOResult;
import java.util.Date;
import java.util.List;

public class AuxAtualizadorBI {
    private final ServiceBusinessIntelligenceImpl serviceBusinessIntelligence;
    private final ServiceVersaoVersoesImpl serviceVersaoVersoes;
    private final ServiceFormatoGeracaoBIImpl serviceFormatoGeracaoBI;
    private final ServiceNodoImpl serviceNodo;

    public AuxAtualizadorBI(ServiceBusinessIntelligenceImpl serviceBusinessIntelligence, ServiceVersaoVersoesImpl serviceVersaoVersoes, ServiceFormatoGeracaoBIImpl serviceFormatoGeracaoBI, ServiceNodoImpl serviceNodo) {
        this.serviceBusinessIntelligence = serviceBusinessIntelligence;
        this.serviceVersaoVersoes = serviceVersaoVersoes;
        this.serviceFormatoGeracaoBI = serviceFormatoGeracaoBI;
        this.serviceNodo = serviceNodo;
    }

    public void atualizarBIs(Empresa empresa) throws ExceptionIO, ExceptionWebService, ExceptionDecodeHexString, ClassNotFoundException, ExceptionReflection {
        String servidor = this.getServidor();
        StringBuilder url = new StringBuilder();
        url.append("/touch-erp/noauth/internal-services/repositorio-bi/consultar-bis-repositorio/");
        url.append(empresa.getPessoa().getComplemento().getCnpj());
        url.append("/");
        url.append(EnumConstTipoRepositorioBI.BI.getValue());
        WebDTOResult w = (WebDTOResult)ToolRESTWebServiceClient.createServiceGet((String)servidor, (String)url.toString(), (TypeReference)new TypeReference<WebDTOResult<List<DTOImportacaoBIRes>>>(this){});
        if (!TMethods.isEquals((Object)w.getStatus(), (Object)EnumConstantsMentorStatus.SUCESSO) || w.getResult() == null) {
            throw new ExceptionRuntimeBase(w.getMessage());
        }
        List itens = (List)w.getResult();
        List<GenericMapValues<DadosBILocais>> bisLocais = this.serviceBusinessIntelligence.getBILocais();
        for (DTOImportacaoBIRes i : itens) {
            for (DTOImportacaoBIRes.ImportacaoBIRes imp : i.getImportacoesBI()) {
                for (DTOImportacaoBIRes.RepositorioBIRes repositorio : imp.getRepositoriosBI()) {
                    this.process(imp, repositorio, empresa, bisLocais);
                }
            }
        }
    }

    private void process(DTOImportacaoBIRes.ImportacaoBIRes item, DTOImportacaoBIRes.RepositorioBIRes repositorio, Empresa empresa, List<GenericMapValues<DadosBILocais>> bisLocais) throws ExceptionIO, ExceptionWebService, ExceptionDecodeHexString, ClassNotFoundException, ExceptionReflection {
        Long numeroVer;
        Long numeroVerRepo;
        Long versaoSistema = this.getCodigoVersao();
        DTOImportacaoBIRes.RepositorioVersaoRes ultimaVersao = this.getUltimaVersaoPassivelAtualizacao(versaoSistema, repositorio);
        if (ultimaVersao == null) {
            return;
        }
        Long numeroBI = item.getNumeroBI();
        GenericMapValues<DadosBILocais> toUpdate = this.getBIToUpdate(numeroBI, numeroVerRepo = repositorio.getNumeroVersao(), numeroVer = ultimaVersao.getNumeroVersao(), bisLocais);
        if (toUpdate == null) {
            return;
        }
        BusinessIntelligence bi = this.serviceBusinessIntelligence.getBI(toUpdate.getLong(DadosBILocais.NUMERO_BI), toUpdate.getLong(DadosBILocais.VERSAO_REP), toUpdate.getLong(DadosBILocais.VERSAO));
        if (bi == null) {
            return;
        }
        this.atualizarBIVersao(bi, item, repositorio, ultimaVersao, versaoSistema, empresa);
    }

    private void atualizarBIVersao(BusinessIntelligence bi, DTOImportacaoBIRes.ImportacaoBIRes item, DTOImportacaoBIRes.RepositorioBIRes itemRep, DTOImportacaoBIRes.RepositorioVersaoRes itemV, Long versaoSistema, Empresa empresa) throws ExceptionIO, ExceptionWebService, ExceptionDecodeHexString, ClassNotFoundException, ExceptionReflection {
        String servidor = this.getServidor();
        StringBuilder url = new StringBuilder();
        url.append("/touch-erp/noauth/internal-services/repositorio-bi/get-bi-completo");
        url.append("/").append(empresa.getPessoa().getComplemento().getCnpj());
        url.append("/").append(item.getSerialLocalBI());
        url.append("/").append(itemRep.getNumeroVersao());
        url.append("/").append(itemV.getNumeroVersao());
        url.append("/").append(versaoSistema);
        url.append("/").append(EnumConstTipoRepositorioBI.BI.getValue());
        WebDTOResult w = (WebDTOResult)ToolRESTWebServiceClient.createServiceGet((String)servidor, (String)url.toString(), (TypeReference)new TypeReference<WebDTOResult<DTOVersaoBICompleto>>(this){});
        if (!TMethods.isEquals((Object)w.getStatus(), (Object)EnumConstantsMentorStatus.SUCESSO) || w.getResult() == null) {
            throw new ExceptionRuntimeBase(w.getMessage());
        }
        this.salvarNovaVersaoBI(bi, (DTOVersaoBICompleto)w.getResult(), versaoSistema, empresa);
    }

    private void salvarNovaVersaoBI(BusinessIntelligence old, DTOVersaoBICompleto novoBI, Long versaoSistema, Empresa empresa) throws ExceptionDecodeHexString, ExceptionIO, ClassNotFoundException, ExceptionReflection {
        BusinessIntelligence newBI = new AuxImportBI(this.serviceNodo, this.serviceFormatoGeracaoBI).importarDataBI(novoBI, versaoSistema, empresa);
        this.serviceBusinessIntelligence.arquivarBI(old.getIdentificador(), versaoSistema);
        newBI.setIdentificador(old.getIdentificador());
        newBI.setDataAtualizacao(old.getDataAtualizacao());
        newBI.setDataCadastro(new Date());
        newBI.setBusinessIntelligenceInf(old.getBusinessIntelligenceInf());
        newBI.setFormatosGeracao(old.getFormatosGeracao());
        this.serviceBusinessIntelligence.resave(newBI, old);
    }

    private String getServidor() throws ExceptionIO {
        PropertiesApi propertiesApi = PropertiesApi.get();
        return propertiesApi.getServidorTouch();
    }

    private Long getCodigoVersao() {
        DTOInfoVersao versao = this.serviceVersaoVersoes.getVersaoSistema(EnumConstTipoSistemasTouch.MENTOR_BD);
        return versao.getCodigo();
    }

    private DTOImportacaoBIRes.RepositorioVersaoRes getUltimaVersaoPassivelAtualizacao(Long versaoSistema, DTOImportacaoBIRes.RepositorioBIRes repositorio) {
        DTOImportacaoBIRes.RepositorioVersaoRes found = null;
        for (DTOImportacaoBIRes.RepositorioVersaoRes versao : repositorio.getVersaosRepositorioBI()) {
            Long codVersao = 0L;
            if (TMethods.isWithData((Number)versao.getCodigoVersaoMinSistema())) {
                codVersao = versao.getCodigoVersaoMinSistema();
            }
            if (codVersao > versaoSistema || found != null && (versao.getNumeroVersao() == null || found.getNumeroVersao() >= versao.getNumeroVersao())) continue;
            found = versao;
        }
        return found;
    }

    private GenericMapValues<DadosBILocais> getBIToUpdate(Long numeroBI, Long numeroVerRepo, Long numeroVer, List<GenericMapValues<DadosBILocais>> bisLocais) {
        for (GenericMapValues<DadosBILocais> bi : bisLocais) {
            if (!TMethods.isEqualsNumber((Number)numeroBI, (Number)bi.getLong(DadosBILocais.NUMERO_BI)) || !TMethods.isEqualsNumber((Number)numeroVerRepo, (Number)bi.getLong(DadosBILocais.VERSAO_REP)) || numeroVer == null || bi.getLong(DadosBILocais.VERSAO) == null || numeroVer <= bi.getLong(DadosBILocais.VERSAO)) continue;
            return bi;
        }
        return null;
    }
}

