/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.businessintelligence.atualizador;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorStatus;
import com.touchcomp.basementor.constants.enums.bi.EnumConstTipoRepositorioBI;
import com.touchcomp.basementor.constants.enums.tiposistemastouch.EnumConstTipoSistemasTouch;
import com.touchcomp.basementor.model.vo.BusinessIntelligence;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.SmartComponent;
import com.touchcomp.basementorexceptions.exceptions.impl.decoder.ExceptionDecodeHexString;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorexceptions.exceptions.impl.webservice.ExceptionWebService;
import com.touchcomp.basementorservice.BaseMethods;
import com.touchcomp.basementorservice.components.businessintelligence.atualizador.auxiliar.AtualizadorBI;
import com.touchcomp.basementorservice.components.businessintelligence.atualizador.auxiliar.AtualizadorSmartComponent;
import com.touchcomp.basementorservice.service.impl.businessintelligence.ServiceBusinessIntelligenceImpl;
import com.touchcomp.basementorservice.service.impl.formatogeracaobi.ServiceFormatoGeracaoBIImpl;
import com.touchcomp.basementorservice.service.impl.nodo.ServiceNodoImpl;
import com.touchcomp.basementorservice.service.impl.smartcomponente.ServiceSmartComponentImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementorversao.model.temp.DTOInfoVersao;
import com.touchcomp.basementorversao.service.impl.versoes.ServiceVersaoVersoesImpl;
import com.touchcomp.touchvomodel.vo.businessintelligence.DTOBusinessIntelligenceUpdates;
import com.touchcomp.touchvomodel.vo.importacaobi.repositorio.DTOImportacaoBIRes;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class CompAtualizacaoBusinessIntelligence
extends BaseMethods {
    @Autowired
    private ServiceBusinessIntelligenceImpl serviceBusinessIntelligence;
    @Autowired
    private ServiceSmartComponentImpl serviceSmartComponent;
    @Autowired
    private ServiceVersaoVersoesImpl serviceVersaoVersoes;
    @Autowired
    private ServiceNodoImpl serviceNodo;
    @Autowired
    private ServiceFormatoGeracaoBIImpl serviceFormatoGeracao;

    public void atualizarDocumentos(EnumConstantsMentorSimNao atualizarBIs, EnumConstantsMentorSimNao atualizarSMs, Empresa empresa) throws ExceptionIO, ExceptionWebService, ExceptionDecodeHexString, ClassNotFoundException, ExceptionReflection {
        if (TMethods.isNotNull((Object)atualizarBIs).booleanValue() && TMethods.isAffirmative((Number)atualizarBIs.getValue())) {
            new AtualizadorBI(this.serviceVersaoVersoes, this.serviceBusinessIntelligence, this.serviceNodo, this.serviceFormatoGeracao).atualizar(empresa);
        }
        if (TMethods.isNotNull((Object)atualizarSMs).booleanValue() && TMethods.isAffirmative((Number)atualizarSMs.getValue())) {
            new AtualizadorSmartComponent(this.serviceVersaoVersoes, this.serviceSmartComponent).atualizar(empresa);
        }
    }

    @Async
    public CompletableFuture atualizarDocumentosAsync(EnumConstTipoRepositorioBI tipo, Empresa empresa) throws ExceptionIO, ExceptionWebService, ExceptionDecodeHexString, ClassNotFoundException, ExceptionReflection {
        if (TMethods.isNotNull((Object)tipo).booleanValue() && TMethods.isEquals((Object)tipo, (Object)EnumConstTipoRepositorioBI.BI)) {
            new AtualizadorBI(this.serviceVersaoVersoes, this.serviceBusinessIntelligence, this.serviceNodo, this.serviceFormatoGeracao).atualizar(empresa);
        } else if (TMethods.isNotNull((Object)tipo).booleanValue() && TMethods.isEquals((Object)tipo, (Object)EnumConstTipoRepositorioBI.SMART_COMPONENT)) {
            new AtualizadorSmartComponent(this.serviceVersaoVersoes, this.serviceSmartComponent).atualizar(empresa);
        }
        return CompletableFuture.completedFuture(EnumConstantsMentorStatus.SUCESSO);
    }

    public List<DTOBusinessIntelligenceUpdates> listartDocumentosComAtualizacao(EnumConstTipoRepositorioBI tipo, Empresa empresa) throws ExceptionIO, ExceptionWebService, ExceptionDecodeHexString, ClassNotFoundException, ExceptionReflection {
        if (TMethods.isNotNull((Object)tipo).booleanValue() && TMethods.isEquals((Object)tipo, (Object)EnumConstTipoRepositorioBI.BI)) {
            return new AtualizadorBI(this.serviceVersaoVersoes, this.serviceBusinessIntelligence, this.serviceNodo, this.serviceFormatoGeracao).listUpdates(empresa);
        }
        if (TMethods.isNotNull((Object)tipo).booleanValue() && TMethods.isEquals((Object)tipo, (Object)EnumConstTipoRepositorioBI.SMART_COMPONENT)) {
            return new AtualizadorSmartComponent(this.serviceVersaoVersoes, this.serviceSmartComponent).listUpdates(empresa);
        }
        return null;
    }

    public void atualizarDocumento(EnumConstTipoRepositorioBI tipo, DTOBusinessIntelligenceUpdates bi, Empresa empresa) throws ExceptionObjNotFound, ExceptionInvalidData, ExceptionIO, ExceptionWebService, ExceptionDecodeHexString, ClassNotFoundException, ExceptionReflection {
        if (!CompAtualizacaoBusinessIntelligence.isWithData(bi.getRepositorios()) || bi.getRepositorios().size() > 1) {
            throw new ExceptionInvalidData("E.ERP.2002.003", new Object[0]);
        }
        DTOImportacaoBIRes.RepositorioBIRes repositorio = (DTOImportacaoBIRes.RepositorioBIRes)bi.getRepositorios().getFirst();
        if (!CompAtualizacaoBusinessIntelligence.isWithData(repositorio.getVersaosRepositorioBI()) || repositorio.getVersaosRepositorioBI().size() > 1) {
            throw new ExceptionInvalidData("E.ERP.2002.004", new Object[0]);
        }
        DTOImportacaoBIRes.RepositorioVersaoRes versao = (DTOImportacaoBIRes.RepositorioVersaoRes)repositorio.getVersaosRepositorioBI().getFirst();
        if (this.isNotNull(bi).booleanValue() && this.isNotNull(repositorio).booleanValue() && this.isNotNull(versao).booleanValue()) {
            BusinessIntelligence vo;
            if (TMethods.isNotNull((Object)tipo).booleanValue() && TMethods.isEquals((Object)tipo, (Object)EnumConstTipoRepositorioBI.BI)) {
                vo = (BusinessIntelligence)this.serviceBusinessIntelligence.getOrThrow(bi.getIdentificador());
                new AtualizadorBI(this.serviceVersaoVersoes, this.serviceBusinessIntelligence, this.serviceNodo, this.serviceFormatoGeracao).atualizarDoc(vo, bi, repositorio, versao, empresa);
            }
            if (TMethods.isNotNull((Object)tipo).booleanValue() && TMethods.isEquals((Object)tipo, (Object)EnumConstTipoRepositorioBI.SMART_COMPONENT)) {
                vo = (SmartComponent)this.serviceSmartComponent.getOrThrow(bi.getIdentificador());
                new AtualizadorSmartComponent(this.serviceVersaoVersoes, this.serviceSmartComponent).atualizarDoc(vo, bi, repositorio, versao, empresa);
            }
        } else {
            throw new ExceptionInvalidData("E.ERP.2002.001", new Object[0]);
        }
    }

    public void arquivar(EnumConstTipoRepositorioBI tipo, Long identificador) throws ExceptionIO, ExceptionObjNotFound {
        if (TMethods.isNotNull((Object)tipo).booleanValue() && TMethods.isEquals((Object)tipo, (Object)EnumConstTipoRepositorioBI.BI)) {
            this.serviceBusinessIntelligence.arquivarBI(identificador, this.getCodigoVersao());
        }
        if (TMethods.isNotNull((Object)tipo).booleanValue() && TMethods.isEquals((Object)tipo, (Object)EnumConstTipoRepositorioBI.SMART_COMPONENT)) {
            this.serviceSmartComponent.arquivar(identificador, this.getCodigoVersao());
        }
    }

    public void desarquivar(EnumConstTipoRepositorioBI tipo, Long identificador) throws ExceptionIO, ExceptionObjNotFound {
        if (TMethods.isNotNull((Object)tipo).booleanValue() && TMethods.isEquals((Object)tipo, (Object)EnumConstTipoRepositorioBI.BI)) {
            this.serviceBusinessIntelligence.desarquivarBI(identificador, this.getCodigoVersao());
        }
        if (TMethods.isNotNull((Object)tipo).booleanValue() && TMethods.isEquals((Object)tipo, (Object)EnumConstTipoRepositorioBI.SMART_COMPONENT)) {
            this.serviceSmartComponent.desarquivar(identificador, this.getCodigoVersao());
        }
    }

    protected Long getCodigoVersao() {
        DTOInfoVersao versao = this.serviceVersaoVersoes.getVersaoSistema(EnumConstTipoSistemasTouch.MENTOR_BD);
        return versao.getCodigo();
    }
}

