/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.businessintelligence.atualizador.auxiliar;

import com.touchcomp.basementor.constants.enums.bi.EnumConstTipoRepositorioBI;
import com.touchcomp.basementor.model.vo.BusinessIntelligence;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementorexceptions.exceptions.impl.decoder.ExceptionDecodeHexString;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorservice.components.businessintelligence.atualizador.auxiliar.BaseAtualizador;
import com.touchcomp.basementorservice.components.businessintelligence.repositorio.AuxImportBI;
import com.touchcomp.basementorservice.service.impl.businessintelligence.ServiceBusinessIntelligenceImpl;
import com.touchcomp.basementorservice.service.impl.formatogeracaobi.ServiceFormatoGeracaoBIImpl;
import com.touchcomp.basementorservice.service.impl.nodo.ServiceNodoImpl;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementorversao.service.impl.versoes.ServiceVersaoVersoesImpl;
import com.touchcomp.touchvomodel.vo.importacaobi.repositorio.DTOVersaoBICompleto;
import java.util.List;

public class AtualizadorBI
extends BaseAtualizador<BusinessIntelligence> {
    ServiceBusinessIntelligenceImpl serviceBusinessIntelligence;
    ServiceNodoImpl serviceNodo;
    ServiceFormatoGeracaoBIImpl serviceFormatoGeracaoBI;

    public AtualizadorBI(ServiceVersaoVersoesImpl serviceVersaoVersoes, ServiceBusinessIntelligenceImpl serviceBusinessIntelligence, ServiceNodoImpl serviceNodo, ServiceFormatoGeracaoBIImpl serviceFormatoGeracaoBI) {
        super(serviceVersaoVersoes);
        this.serviceBusinessIntelligence = serviceBusinessIntelligence;
        this.serviceNodo = serviceNodo;
        this.serviceFormatoGeracaoBI = serviceFormatoGeracaoBI;
    }

    @Override
    protected List findAll() {
        return this.serviceBusinessIntelligence.getBILocais();
    }

    @Override
    protected BusinessIntelligence get(String numero, Long numeroVersaoRep, Long versao) {
        if (ToolString.isALongNumber((String)numero)) {
            return this.serviceBusinessIntelligence.getBI(Long.valueOf(numero), numeroVersaoRep, versao);
        }
        return null;
    }

    @Override
    protected EnumConstTipoRepositorioBI tipo() {
        return EnumConstTipoRepositorioBI.BI;
    }

    @Override
    protected void save(BusinessIntelligence vo, DTOVersaoBICompleto result, Empresa empresa, Long versaoSistema) throws ExceptionIO, ClassNotFoundException, ExceptionReflection, ExceptionDecodeHexString {
        BusinessIntelligence newBI = new AuxImportBI(this.serviceNodo, this.serviceFormatoGeracaoBI).importarDataBI(result, versaoSistema, empresa);
        this.serviceBusinessIntelligence.arquivarBI(vo.getIdentificador(), versaoSistema);
        this.serviceBusinessIntelligence.reimportBI(newBI, vo);
    }
}

