/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.businessintelligence.atualizador.auxiliar;

import com.fasterxml.jackson.core.type.TypeReference;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorStatus;
import com.touchcomp.basementor.constants.enums.bi.EnumConstTipoRepositorioBI;
import com.touchcomp.basementor.constants.enums.tiposistemastouch.EnumConstTipoSistemasTouch;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.decoder.ExceptionDecodeHexString;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorexceptions.exceptions.impl.webservice.ExceptionWebService;
import com.touchcomp.basementorproperties.api.PropertiesApi;
import com.touchcomp.basementorservice.BaseMethods;
import com.touchcomp.basementorservice.model.genericmap.GenericMapValues;
import com.touchcomp.basementorservice.service.impl.businessintelligence.DadosBILocais;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.webserviceclient.ToolRESTWebServiceClient;
import com.touchcomp.basementorversao.model.temp.DTOInfoVersao;
import com.touchcomp.basementorversao.service.impl.versoes.ServiceVersaoVersoesImpl;
import com.touchcomp.touchvomodel.vo.businessintelligence.DTOBusinessIntelligenceUpdates;
import com.touchcomp.touchvomodel.vo.importacaobi.repositorio.DTOImportacaoBIRes;
import com.touchcomp.touchvomodel.vo.importacaobi.repositorio.DTOVersaoBICompleto;
import com.touchcomp.touchvomodel.web.WebDTOResult;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public abstract class BaseAtualizador<T>
extends BaseMethods {
    private ServiceVersaoVersoesImpl serviceVersaoVersoes;

    BaseAtualizador(ServiceVersaoVersoesImpl serviceVersaoVersoes) {
        this.serviceVersaoVersoes = serviceVersaoVersoes;
    }

    public void atualizar(Empresa empresa) throws ExceptionIO, ExceptionWebService, ExceptionDecodeHexString, ClassNotFoundException, ExceptionReflection {
        List<DTOImportacaoBIRes> itens = this.listDocsServer(empresa);
        List<GenericMapValues<DadosBILocais>> bisLocais = this.findAll();
        for (DTOImportacaoBIRes i : itens) {
            for (DTOImportacaoBIRes.ImportacaoBIRes imp : i.getImportacoesBI()) {
                for (DTOImportacaoBIRes.RepositorioBIRes repositorio : imp.getRepositoriosBI()) {
                    this.process(imp, repositorio, empresa, bisLocais);
                }
            }
        }
    }

    public List<DTOBusinessIntelligenceUpdates> listUpdates(Empresa empresa) throws ExceptionIO, ExceptionWebService, ExceptionDecodeHexString, ClassNotFoundException, ExceptionReflection {
        List<DTOImportacaoBIRes> itens = this.listDocsServer(empresa);
        List<GenericMapValues<DadosBILocais>> bisLocais = this.findAll();
        Long versaoSistema = this.getCodigoVersao();
        LinkedList<DTOBusinessIntelligenceUpdates> docsAndUpdates = new LinkedList<DTOBusinessIntelligenceUpdates>();
        for (GenericMapValues<DadosBILocais> dadosBI : bisLocais) {
            block1: for (DTOImportacaoBIRes i : itens) {
                for (DTOImportacaoBIRes.ImportacaoBIRes imp : i.getImportacoesBI()) {
                    if (!this.isEquals(imp.getNumeroBI(), Long.valueOf(dadosBI.getString(DadosBILocais.NUMERO_BI)))) continue;
                    LinkedList<DTOImportacaoBIRes.RepositorioBIRes> repositorios = new LinkedList<DTOImportacaoBIRes.RepositorioBIRes>();
                    for (DTOImportacaoBIRes.RepositorioBIRes repositorio : imp.getRepositoriosBI()) {
                        if (repositorio.getNumeroVersao() < dadosBI.getLong(DadosBILocais.VERSAO_REP) || this.isAffimative(repositorio.getInativo())) continue;
                        DTOImportacaoBIRes.RepositorioBIRes repository = this.newRepositoryToUpdate(repositorio);
                        for (DTOImportacaoBIRes.RepositorioVersaoRes versao : repositorio.getVersaosRepositorioBI()) {
                            Long codVersao = 0L;
                            if (TMethods.isWithData((Number)versao.getCodigoVersaoMinSistema())) {
                                codVersao = versao.getCodigoVersaoMinSistema();
                            }
                            if (codVersao > versaoSistema || versao.getNumeroVersao() <= dadosBI.getLong(DadosBILocais.VERSAO) || this.isAffimative(versao.getInativo()) || !this.isNotNull(versao.getDataLiberacao()).booleanValue() || !versao.getDataLiberacao().before(new Date())) continue;
                            repository.getVersaosRepositorioBI().add(versao);
                        }
                        if (!BaseAtualizador.isWithData(repository.getVersaosRepositorioBI())) continue;
                        repositorios.add(repository);
                    }
                    if (!BaseAtualizador.isWithData(repositorios)) continue block1;
                    DTOBusinessIntelligenceUpdates vo = new DTOBusinessIntelligenceUpdates();
                    vo.setNumeroBI(dadosBI.getString(DadosBILocais.NUMERO_BI));
                    vo.setSerial(dadosBI.getString(DadosBILocais.SERIAL_BI));
                    vo.setDescricao(dadosBI.getString(DadosBILocais.DESCRICAO));
                    vo.setObservacao(dadosBI.getString(DadosBILocais.OBSERVACAO));
                    vo.setIdentificador(dadosBI.getLong(DadosBILocais.IDENTIFICADOR));
                    vo.setVersao(dadosBI.getLong(DadosBILocais.VERSAO));
                    vo.setVersaoRepositorio(dadosBI.getLong(DadosBILocais.VERSAO_REP));
                    vo.setRepositorios(repositorios);
                    docsAndUpdates.add(vo);
                    continue block1;
                }
            }
        }
        return docsAndUpdates;
    }

    private DTOImportacaoBIRes.RepositorioBIRes newRepositoryToUpdate(DTOImportacaoBIRes.RepositorioBIRes repServer) {
        DTOImportacaoBIRes.RepositorioBIRes aux = new DTOImportacaoBIRes.RepositorioBIRes();
        aux.setDescricao(repServer.getDescricao());
        aux.setIdentificador(repServer.getIdentificador());
        aux.setInativo(repServer.getInativo());
        aux.setNomeBi(repServer.getNomeBi());
        aux.setNumeroVersao(repServer.getNumeroVersao());
        aux.setVersaosRepositorioBI(new LinkedList());
        return aux;
    }

    protected List<DTOImportacaoBIRes> listDocsServer(Empresa empresa) throws ExceptionWebService, ExceptionIO {
        EnumConstTipoRepositorioBI tipo = this.tipo();
        if (this.isNull(tipo).booleanValue()) {
            return new LinkedList<DTOImportacaoBIRes>();
        }
        String servidor = this.getServidor();
        StringBuilder url = new StringBuilder();
        url.append("/touch-erp/noauth/internal-services/repositorio-bi/consultar-bis-repositorio/");
        url.append(empresa.getPessoa().getComplemento().getCnpj());
        url.append("/");
        url.append(tipo.getValue());
        WebDTOResult w = (WebDTOResult)ToolRESTWebServiceClient.createServiceGet((String)servidor, (String)url.toString(), (TypeReference)new TypeReference<WebDTOResult<List<DTOImportacaoBIRes>>>(this){});
        if (!TMethods.isEquals((Object)w.getStatus(), (Object)EnumConstantsMentorStatus.SUCESSO) || w.getResult() == null) {
            throw new ExceptionRuntimeBase(w.getMessage());
        }
        return (List)w.getResult();
    }

    protected abstract List<GenericMapValues<DadosBILocais>> findAll();

    protected abstract T get(String var1, Long var2, Long var3);

    protected abstract EnumConstTipoRepositorioBI tipo();

    protected abstract void save(T var1, DTOVersaoBICompleto var2, Empresa var3, Long var4) throws ExceptionIO, ClassNotFoundException, ExceptionReflection, ExceptionDecodeHexString;

    private void process(DTOImportacaoBIRes.ImportacaoBIRes item, DTOImportacaoBIRes.RepositorioBIRes repositorio, Empresa empresa, List<GenericMapValues<DadosBILocais>> bisLocais) throws ExceptionIO, ExceptionWebService, ExceptionDecodeHexString, ClassNotFoundException, ExceptionReflection {
        Long numeroVer;
        Long numeroVerRepo;
        Long versaoSistema = this.getCodigoVersao();
        DTOImportacaoBIRes.RepositorioVersaoRes ultimaVersao = this.getUltimaVersaoPassivelAtualizacao(versaoSistema, repositorio);
        if (ultimaVersao == null) {
            return;
        }
        Long numeroBI = item.getNumeroBI();
        GenericMapValues<DadosBILocais> toUpdate = this.getDocToUpdate(numeroBI, numeroVerRepo = repositorio.getNumeroVersao(), numeroVer = ultimaVersao.getNumeroVersao(), bisLocais);
        if (toUpdate == null) {
            return;
        }
        T vo = this.get(toUpdate.getString(DadosBILocais.NUMERO_BI), toUpdate.getLong(DadosBILocais.VERSAO_REP), toUpdate.getLong(DadosBILocais.VERSAO));
        if (vo == null) {
            return;
        }
        this.atualizarDoc(vo, item, repositorio, ultimaVersao, versaoSistema, empresa);
    }

    public void atualizarDoc(T vo, DTOImportacaoBIRes.ImportacaoBIRes item, DTOImportacaoBIRes.RepositorioBIRes itemRep, DTOImportacaoBIRes.RepositorioVersaoRes itemV, Long versaoSistema, Empresa empresa) throws ExceptionIO, ExceptionWebService, ExceptionDecodeHexString, ClassNotFoundException, ExceptionReflection {
        this.atualizarDoc(vo, item.getSerialLocalBI(), itemRep.getNumeroVersao(), itemV.getNumeroVersao(), versaoSistema, empresa);
    }

    public void atualizarDoc(T vo, DTOBusinessIntelligenceUpdates item, DTOImportacaoBIRes.RepositorioBIRes itemRep, DTOImportacaoBIRes.RepositorioVersaoRes itemV, Empresa empresa) throws ExceptionIO, ExceptionWebService, ExceptionDecodeHexString, ClassNotFoundException, ExceptionReflection {
        this.atualizarDoc(vo, item.getSerial(), itemRep.getNumeroVersao(), itemV.getNumeroVersao(), null, empresa);
    }

    private void atualizarDoc(T vo, String serial, Long numeroVersaoRep, Long numeroVersao, Long versaoSistema, Empresa empresa) throws ExceptionIO, ExceptionWebService, ExceptionDecodeHexString, ClassNotFoundException, ExceptionReflection {
        if (this.isNull(versaoSistema).booleanValue()) {
            versaoSistema = this.getCodigoVersao();
        }
        String servidor = this.getServidor();
        StringBuilder url = new StringBuilder();
        url.append("/touch-erp/noauth/internal-services/repositorio-bi/get-bi-completo");
        url.append("/").append(empresa.getPessoa().getComplemento().getCnpj());
        url.append("/").append(serial);
        url.append("/").append(numeroVersaoRep);
        url.append("/").append(numeroVersao);
        url.append("/").append(versaoSistema);
        url.append("/").append(this.tipo().getValue());
        WebDTOResult w = (WebDTOResult)ToolRESTWebServiceClient.createServiceGet((String)servidor, (String)url.toString(), (TypeReference)new TypeReference<WebDTOResult<DTOVersaoBICompleto>>(this){});
        if (TMethods.isEquals((Object)w.getStatus(), (Object)EnumConstantsMentorStatus.SUCESSO) && w.getResult() != null) {
            this.save(vo, (DTOVersaoBICompleto)w.getResult(), empresa, versaoSistema);
        }
    }

    protected String getServidor() throws ExceptionIO {
        PropertiesApi propertiesApi = PropertiesApi.get();
        return propertiesApi.getServidorTouch();
    }

    protected Long getCodigoVersao() {
        DTOInfoVersao versao = this.serviceVersaoVersoes.getVersaoSistema(EnumConstTipoSistemasTouch.MENTOR_BD);
        return versao.getCodigo();
    }

    protected DTOImportacaoBIRes.RepositorioVersaoRes getUltimaVersaoPassivelAtualizacao(Long versaoSistema, DTOImportacaoBIRes.RepositorioBIRes repositorio) {
        DTOImportacaoBIRes.RepositorioVersaoRes found = null;
        for (DTOImportacaoBIRes.RepositorioVersaoRes versao : repositorio.getVersaosRepositorioBI()) {
            Long codVersao = 0L;
            if (TMethods.isWithData((Number)versao.getCodigoVersaoMinSistema())) {
                codVersao = versao.getCodigoVersaoMinSistema();
            }
            if (codVersao > versaoSistema || found != null && (versao.getNumeroVersao() == null || found.getNumeroVersao() >= versao.getNumeroVersao())) continue;
            found = versao;
        }
        return found;
    }

    protected GenericMapValues<DadosBILocais> getDocToUpdate(Long numeroBI, Long numeroVerRepo, Long numeroVer, List<GenericMapValues<DadosBILocais>> bisLocais) {
        for (GenericMapValues<DadosBILocais> bi : bisLocais) {
            String numeroSM = bi.getString(DadosBILocais.NUMERO_BI);
            if (!TMethods.isNotNull((Object)numeroSM).booleanValue() || !TMethods.isEqualsNumber((Number)numeroBI, (Number)Long.valueOf(numeroSM)) || !TMethods.isEqualsNumber((Number)numeroVerRepo, (Number)bi.getLong(DadosBILocais.VERSAO_REP)) || numeroVer == null || bi.getLong(DadosBILocais.VERSAO) == null || numeroVer <= bi.getLong(DadosBILocais.VERSAO)) continue;
            return bi;
        }
        return null;
    }
}

