/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.businessintelligence.repositorio;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.statusobjeto.EnumConstStatusObjeto;
import com.touchcomp.basementor.model.vo.BusinessIntelligence;
import com.touchcomp.basementor.model.vo.BusinessIntelligenceFormGer;
import com.touchcomp.basementor.model.vo.BusinessIntelligenceInf;
import com.touchcomp.basementor.model.vo.BusinessIntelligenceNodo;
import com.touchcomp.basementor.model.vo.DadoAdicionalBI;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FormatoGeracaoBI;
import com.touchcomp.basementor.model.vo.Nodo;
import com.touchcomp.basementor.model.vo.ValorFixoDadoAdicional;
import com.touchcomp.basementorexceptions.exceptions.impl.decoder.ExceptionDecodeHexString;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorservice.components.entityxml.CompExpImpEntityXML;
import com.touchcomp.basementorservice.service.impl.formatogeracaobi.ServiceFormatoGeracaoBIImpl;
import com.touchcomp.basementorservice.service.impl.nodo.ServiceNodoImpl;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.clone.ToolClone;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.hexadecimal.ToolHexString;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.reflections.ToolReflections;
import com.touchcomp.touchvomodel.vo.importacaobi.repositorio.DTOVersaoBICompleto;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class AuxImportBI {
    private ServiceNodoImpl serviceNodo;
    private ServiceFormatoGeracaoBIImpl serviceFormatoGeracaoBI;

    public AuxImportBI(ServiceNodoImpl serviceNodo, ServiceFormatoGeracaoBIImpl serviceFormatoGeracaoBI) {
        this.serviceNodo = serviceNodo;
        this.serviceFormatoGeracaoBI = serviceFormatoGeracaoBI;
    }

    public BusinessIntelligence importarDataBI(DTOVersaoBICompleto h, Long versao, Empresa emp) throws ClassNotFoundException, ExceptionReflection, ExceptionDecodeHexString, ExceptionIO {
        String content = ToolHexString.decodeToStr((String)h.getArquivoBI());
        BusinessIntelligence b = this.importarDataBI(content, versao);
        b.setTipoClassificacaoBI(Short.valueOf(h.getTipoClassificacaoBI()));
        b.setNumeroBI(h.getNumeroBI());
        b.setAtivo(Short.valueOf(EnumConstStatusObjeto.ATIVO.getValue()));
        b.setNumeroVersao(h.getNumeroVersao());
        b.setNumeroVersaoRep(h.getNumeroVersaoRep());
        b.setSerialLocalBI(h.getSerialBI());
        b.setNumeroControle(h.getNumeroControle());
        if (TMethods.isNull((Object)b.getBusinessIntelligenceInf()).booleanValue()) {
            b.setBusinessIntelligenceInf(new BusinessIntelligenceInf());
        }
        this.setNodos(b, h);
        if (b.getBusinessIntelligenceObjetos() != null && b.getBusinessIntelligenceObjetos().getClasseModeloBI() != null) {
            String oldClass = b.getBusinessIntelligenceObjetos().getClasseModeloBI().getClasse();
            b.getBusinessIntelligenceObjetos().getClasseModeloBI().setClasse(ToolReflections.toModelVOClass((String)oldClass).getCanonicalName());
            Iterator iterator = b.getDadosAdicionalBI().iterator();
            while (iterator.hasNext()) {
                DadoAdicionalBI d;
                oldClass = (d = (DadoAdicionalBI)iterator.next()).getClassePesquisa();
                d.setClassePesquisa(oldClass != null ? ToolReflections.toModelVOClass((String)oldClass).getCanonicalName() : null);
            }
        }
        ToolClone.nullIds((Object)b);
        return this.doAfterImport(b, emp);
    }

    public BusinessIntelligence importarDataBI(byte[] data, Long versao) throws ExceptionIO, ExceptionDecodeHexString {
        String conteudoBI = ToolHexString.decodeToStr((String)new String(data));
        return this.importarDataBI(conteudoBI, versao);
    }

    public BusinessIntelligence importarDataBI(String conteudoBI, Long versao) throws ExceptionIO {
        return (BusinessIntelligence)((CompExpImpEntityXML)Context.get(CompExpImpEntityXML.class)).fileToEntity(new ByteArrayInputStream(conteudoBI.getBytes(Charset.forName("UTF-8"))), versao, false, "com.touchcomp.basementor.model.vo");
    }

    public BusinessIntelligence importarDataBI(File file, Empresa emp, Long versao) throws FileNotFoundException, ExceptionIO, ExceptionReflection {
        return this.importarDataBI(ToolFile.getConteudoArquivo((InputStream)new FileInputStream(file), (String)"UTF-8"), versao, emp);
    }

    public BusinessIntelligence importarDataBI(byte[] data, Empresa emp, Long versao) throws ExceptionIO, ExceptionDecodeHexString, ExceptionReflection {
        String conteudoBI = ToolHexString.decodeToStr((String)new String(data));
        return this.importarDataBI(conteudoBI, versao, emp);
    }

    public BusinessIntelligence importarDataBI(String content, Long versao, Empresa emp) throws ExceptionIO, ExceptionReflection {
        BusinessIntelligence b = (BusinessIntelligence)((CompExpImpEntityXML)Context.get(CompExpImpEntityXML.class)).fileToEntity(content, versao, false, "com.touchcomp.basementor.model.vo");
        return this.doAfterImport(b, emp);
    }

    private BusinessIntelligence doAfterImport(BusinessIntelligence b, Empresa emp) throws ExceptionReflection {
        ToolClone.nullIds((Object)b);
        b.setEmpresa(emp);
        b.setFormatosGeracao(this.getAllFormatos());
        b.setAtivo(Short.valueOf(EnumConstStatusObjeto.ATIVO.getValue()));
        this.atualizarValorFixoBi(b.getDadosAdicionalBI());
        if (b.getNrVersaoEstruturaBI() == null) {
            b.setNrVersaoEstruturaBI(Integer.valueOf(1));
        }
        return b;
    }

    private void atualizarValorFixoBi(List<DadoAdicionalBI> dados) {
        for (DadoAdicionalBI dadosAdicionais : dados) {
            for (ValorFixoDadoAdicional valorFixo : dadosAdicionais.getValorFixo()) {
                valorFixo.setDadoAdicional(dadosAdicionais);
            }
            this.atualizarValorFixoBi(dadosAdicionais.getDadoAdicionalBIFilhos());
        }
    }

    private List<BusinessIntelligenceFormGer> getAllFormatos() {
        List formatosDisp = this.serviceFormatoGeracaoBI.findAll();
        LinkedList<BusinessIntelligenceFormGer> toAdd = new LinkedList<BusinessIntelligenceFormGer>();
        for (FormatoGeracaoBI formatoGeracaoBI : formatosDisp) {
            BusinessIntelligenceFormGer baux = new BusinessIntelligenceFormGer();
            baux.setFormatoGeracaoBI(formatoGeracaoBI);
            baux.setLiberar(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
            toAdd.add(baux);
        }
        return toAdd;
    }

    private void setNodos(BusinessIntelligence b, DTOVersaoBICompleto h) {
        if (h.getNodos() == null) {
            return;
        }
        for (Long nd : h.getNodos()) {
            Nodo nodo = (Nodo)this.serviceNodo.get(nd);
            if (nodo == null) continue;
            BusinessIntelligenceNodo bn = new BusinessIntelligenceNodo();
            bn.setBusinessIntelligenceInf(b.getBusinessIntelligenceInf());
            bn.setNodo(nodo);
            b.getBusinessIntelligenceInf().getNodos().add(bn);
        }
    }
}

