/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.businessintelligence.repositorio;

import com.fasterxml.jackson.core.type.TypeReference;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorStatus;
import com.touchcomp.basementor.constants.enums.bi.EnumConstAlteracaoBI;
import com.touchcomp.basementor.constants.enums.bi.EnumConstTipoRepositorioBI;
import com.touchcomp.basementor.model.vo.BusinessIntelligence;
import com.touchcomp.basementor.model.vo.BusinessIntelligenceNodo;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.SmartComponent;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.invalidstate.ExceptionInvalidState;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.components.entityxml.CompExpImpEntityXML;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.base64.ToolBase64;
import com.touchcomp.basementortools.tools.hexadecimal.ToolHexString;
import com.touchcomp.basementortools.tools.json.ToolJson;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.webserviceclient.ToolRESTWebServiceClient;
import com.touchcomp.basementortools.tools.zip.ToolZipUtils;
import com.touchcomp.touchvomodel.vo.importacaobi.repositorio.DTOImportacaoBIImportacao;
import com.touchcomp.touchvomodel.web.WebDTOResult;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class CompEnvioRepositorioBI {
    private static final TLogger logger = TLogger.get(CompEnvioRepositorioBI.class);

    public void enviarBIRepositorio(BusinessIntelligence bi, String alteracoes, String servidor, String codigoVersaoSistema, EnumConstAlteracaoBI tipoAlteracao) throws ExceptionInvalidState {
        try {
            DTOImportacaoBIImportacao d = new DTOImportacaoBIImportacao();
            d.setAlteracao(alteracoes);
            d.setArquivoBI(this.getArquivoBI(bi, codigoVersaoSistema));
            d.setDescricao(bi.getObservacao());
            d.setNodos(this.getNodos(bi));
            d.setNomeBI(bi.getDescricao());
            d.setNumeroControle(bi.getNumeroControle());
            d.setNumeroEstrutura(bi.getNrVersaoEstruturaBI());
            d.setNumeroVersao(bi.getNumeroVersao());
            d.setNumeroVersaoRep(bi.getNumeroVersaoRep());
            d.setCpfPessoaReponsavel(bi.getPessoaResponsavel().getComplemento().getCnpj());
            d.setSerialLocalBI(bi.getSerialLocalBI());
            d.setTipoAlteracao(Short.valueOf(tipoAlteracao.getValue()));
            d.setTipoBI(bi.getTipoBI());
            d.setCnpjEmpresaReponsavel(bi.getEmpresa().getPessoa().getComplemento().getCnpj());
            d.setIdentificadorReg(bi.getIdentificador());
            d.setTipo(Short.valueOf(EnumConstTipoRepositorioBI.BI.getValue()));
            String temp = ToolJson.toJson((Object)d);
            byte[] data = ToolZipUtils.compress((String)temp);
            temp = ToolBase64.encodeBase64((byte[])data);
            WebDTOResult w = (WebDTOResult)ToolRESTWebServiceClient.createServicePost((String)servidor, (String)("/noauth/internal-services/repositorio-bi/importar-bi-zip/" + EnumConstTipoRepositorioBI.BI.getValue()), (String)temp, WebDTOResult.class);
            if (!ToolMethods.isEquals((Object)w.getStatus(), (Object)EnumConstantsMentorStatus.SUCESSO)) {
                throw new ExceptionInvalidState("", new Object[]{w.getMessage()});
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new ExceptionInvalidState("E.ERP.0747.021", new Object[]{ex.getMessage()});
        }
    }

    public SmartComponent enviarSmartRepositorio(SmartComponent smart, Usuario user, Empresa empresa, String alteracoes, String servidor, String codigoVersaoSistema, EnumConstAlteracaoBI tipoAlteracao) throws ExceptionInvalidState {
        Pessoa pessoaRes = smart.getPessoaResponsavel();
        if (pessoaRes == null) {
            pessoaRes = user.getUsuarioBasico().getPessoa();
        }
        try {
            DTOImportacaoBIImportacao imp;
            DTOImportacaoBIImportacao d = new DTOImportacaoBIImportacao();
            d.setAlteracao(alteracoes);
            d.setArquivoBI(this.getArquivoBI(smart, codigoVersaoSistema));
            d.setDescricao(smart.getObservacao());
            d.setNomeBI(smart.getDescricao());
            d.setNumeroControle(smart.getNumeroControle());
            d.setNumeroEstrutura(smart.getNrVersaoEstrutura());
            d.setNumeroVersao(smart.getNumeroVersaoRep());
            d.setNumeroVersaoRep(smart.getNumeroVersaoRep());
            d.setCpfPessoaReponsavel(pessoaRes.getComplemento().getCnpj());
            d.setSerialLocalBI(smart.getSerialLocal());
            d.setTipoAlteracao(Short.valueOf(tipoAlteracao.getValue()));
            d.setCnpjEmpresaReponsavel(empresa.getPessoa().getComplemento().getCnpj());
            d.setIdentificadorReg(smart.getIdentificador());
            d.setTipo(Short.valueOf(EnumConstTipoRepositorioBI.BI.getValue()));
            TypeReference<WebDTOResult<DTOImportacaoBIImportacao>> type = new TypeReference<WebDTOResult<DTOImportacaoBIImportacao>>(this){};
            String temp = ToolJson.toJson((Object)d);
            byte[] data = ToolZipUtils.compress((String)temp);
            temp = ToolHexString.encodeToHex((byte[])data);
            WebDTOResult w = (WebDTOResult)ToolRESTWebServiceClient.createServicePost((String)servidor, (String)("/noauth/internal-services/repositorio-bi/importar-bi-zip/" + EnumConstTipoRepositorioBI.SMART_COMPONENT.getValue()), (String)temp, (TypeReference)type);
            if (!ToolMethods.isEquals((Object)w.getStatus(), (Object)EnumConstantsMentorStatus.SUCESSO)) {
                throw new ExceptionInvalidState("E.ERP.0747.021", new Object[]{w.getMessage()});
            }
            if (w.getResult() != null && (imp = (DTOImportacaoBIImportacao)w.getResult()) != null) {
                smart.setNumeroControle(imp.getNumeroControle());
                smart.setSerialLocal(imp.getSerialLocalBI());
                smart.setNrVersaoEstrutura(imp.getNumeroEstrutura());
                smart.setNumeroVersaoRep(imp.getNumeroVersaoRep());
            }
            return smart;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new ExceptionInvalidState("E.ERP.0747.021", new Object[]{ex.getMessage()});
        }
    }

    private List<Long> getNodos(BusinessIntelligence bi) {
        LinkedList<Long> nodos = new LinkedList<Long>();
        if (ToolMethods.isWithData((Collection)bi.getBusinessIntelligenceInf().getNodos())) {
            for (BusinessIntelligenceNodo nodo : bi.getBusinessIntelligenceInf().getNodos()) {
                nodos.add(nodo.getNodo().getIdentificador());
            }
        }
        bi.getBusinessIntelligenceInf().getNodos().forEach(i -> nodos.add(i.getNodo().getIdentificador()));
        return nodos;
    }

    private String getArquivoBI(Object bi, String codigoVersaoSistema) throws ExceptionIO {
        byte[] dados = ((CompExpImpEntityXML)Context.get(CompExpImpEntityXML.class)).entityToByte(bi, Long.valueOf(codigoVersaoSistema));
        String str = ToolHexString.encodeToHex((byte[])dados);
        return str;
    }
}

