/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.businessintelligence.repositorio;

import com.fasterxml.jackson.core.type.TypeReference;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorStatus;
import com.touchcomp.basementor.constants.enums.bi.EnumConstTipoRepositorioBI;
import com.touchcomp.basementor.constants.enums.tiposistemastouch.EnumConstTipoSistemasTouch;
import com.touchcomp.basementor.model.vo.BusinessIntelligence;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.SmartComponent;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.impl.decoder.ExceptionDecodeHexString;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorexceptions.exceptions.impl.webservice.ExceptionWebService;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorproperties.api.PropertiesApi;
import com.touchcomp.basementorservice.components.businessintelligence.repositorio.AuxImportBI;
import com.touchcomp.basementorservice.components.businessintelligence.repositorio.AuxImportSM;
import com.touchcomp.basementorservice.components.entityxml.CompExpImpEntityXML;
import com.touchcomp.basementorservice.service.impl.businessintelligence.ServiceBusinessIntelligenceImpl;
import com.touchcomp.basementorservice.service.impl.formatogeracaobi.ServiceFormatoGeracaoBIImpl;
import com.touchcomp.basementorservice.service.impl.nodo.ServiceNodoImpl;
import com.touchcomp.basementorservice.service.impl.smartcomponente.ServiceSmartComponentImpl;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.hexadecimal.ToolHexString;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementortools.tools.webserviceclient.ToolRESTWebServiceClient;
import com.touchcomp.basementortools.tools.webserviceclient.ToolRESTWebServiceClient2;
import com.touchcomp.basementorversao.model.temp.DTOInfoVersao;
import com.touchcomp.basementorversao.service.impl.versoes.ServiceVersaoVersoesImpl;
import com.touchcomp.touchvomodel.vo.importacaobi.repositorio.DTOImportacaoBIConsulta;
import com.touchcomp.touchvomodel.vo.importacaobi.repositorio.DTOImportacaoBIImportacao;
import com.touchcomp.touchvomodel.vo.importacaobi.repositorio.DTOImportacaoBIRes;
import com.touchcomp.touchvomodel.vo.importacaobi.repositorio.DTOVersaoBICompleto;
import com.touchcomp.touchvomodel.web.WebDTOResult;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompRepositorioBI {
    @Autowired
    private ServiceVersaoVersoesImpl serviceVersaoVersoes;
    @Autowired
    private ServiceBusinessIntelligenceImpl serviceBusinessIntelligence;
    @Autowired
    private ServiceSmartComponentImpl serviceSmartComponent;
    @Autowired
    private ServiceNodoImpl serviceNodo;
    @Autowired
    private ServiceFormatoGeracaoBIImpl serviceFormatoGeracaoBI;

    public WebDTOResult getDocumentosNodo(Long nodo, EnumConstTipoRepositorioBI tipo, Empresa empresa) throws ExceptionIO, ExceptionWebService {
        String cnpj = ToolString.onlyNumbers((String)empresa.getPessoa().getComplemento().getCnpj());
        WebDTOResult w = (WebDTOResult)ToolRESTWebServiceClient.createServiceGet((String)this.getServidorTouch(), (String)("/touch-erp/noauth/internal-services/repositorio-bi/consultar-bi-nodo/" + nodo + "/" + cnpj + "/" + tipo.getValue()), (TypeReference)new TypeReference<WebDTOResult<List<DTOImportacaoBIConsulta>>>(this){});
        return w;
    }

    public WebDTOResult downloadBI(String serial, Long numeroVersaoRep, Long numeroVersao, EnumConstTipoRepositorioBI tipo, String token, Empresa empresa) throws ExceptionIO, ExceptionWebService, ExceptionDecodeHexString, ClassNotFoundException, ExceptionReflection, ExceptionInvalidData, ExceptionBase {
        if (TMethods.isNull((Object)empresa).booleanValue()) {
            return new WebDTOResult(EnumConstantsMentorStatus.ERRO_PROCESSO);
        }
        String cnpj = ToolString.onlyNumbers((String)empresa.getPessoa().getComplemento().getCnpj());
        ToolRESTWebServiceClient2.Config config = new ToolRESTWebServiceClient2.Config();
        config.setUrl(PropertiesApi.get().getServidorTouch() + "/touch-erp/auth/basic-user/business-intelligence/repositorio/get-bi-completo/" + cnpj + "/" + serial + "/" + numeroVersaoRep + "/" + numeroVersao + "/" + tipo.getValue());
        config.getRequestProperties().put("Authorization", "Bearer " + token);
        WebDTOResult w = (WebDTOResult)ToolRESTWebServiceClient2.downloadEntityFrom((ToolRESTWebServiceClient2.Config)config, (TypeReference)new TypeReference<WebDTOResult<DTOVersaoBICompleto>>(this){});
        if (TMethods.isEquals((Object)w.getStatus(), (Object)EnumConstantsMentorStatus.SUCESSO) && w.getResult() != null) {
            if (TMethods.isEquals((Object)tipo, (Object)EnumConstTipoRepositorioBI.BI)) {
                BusinessIntelligence bi = new AuxImportBI(this.serviceNodo, this.serviceFormatoGeracaoBI).importarDataBI((DTOVersaoBICompleto)w.getResult(), this.getCodigoVersao(), empresa);
                this.serviceBusinessIntelligence.saveOrUpdate(bi);
            } else if (TMethods.isEquals((Object)tipo, (Object)EnumConstTipoRepositorioBI.SMART_COMPONENT)) {
                new AuxImportSM().importarDataBI((DTOVersaoBICompleto)w.getResult(), this.getCodigoVersao());
            } else {
                throw new ExceptionInvalidData("E.ERP.000010", new Object[0]);
            }
        }
        return w;
    }

    public WebDTOResult getDocumentosRepositorio(EnumConstTipoRepositorioBI tipo, Empresa empresa) throws ExceptionIO, ExceptionWebService {
        String cnpj = ToolString.onlyNumbers((String)empresa.getPessoa().getComplemento().getCnpj());
        WebDTOResult w = (WebDTOResult)ToolRESTWebServiceClient.createServiceGet((String)this.getServidorTouch(), (String)("/touch-erp/noauth/internal-services/repositorio-bi/consultar-bis-repositorio/" + cnpj + "/" + tipo.getValue()), (TypeReference)new TypeReference<WebDTOResult<List<DTOImportacaoBIRes>>>(this){});
        return w;
    }

    public WebDTOResult getDocumentoNumero(String numero, EnumConstTipoRepositorioBI tipo, Empresa empresa) throws ExceptionIO, ExceptionWebService {
        String cnpj = ToolString.onlyNumbers((String)empresa.getPessoa().getComplemento().getCnpj());
        WebDTOResult w = (WebDTOResult)ToolRESTWebServiceClient.createServiceGet((String)this.getServidorTouch(), (String)("/touch-erp/noauth/internal-services/repositorio-bi/consultar-bi-numero-bi/" + numero + "/" + cnpj + "/" + tipo.getValue()), (TypeReference)new TypeReference<WebDTOResult<List<DTOImportacaoBIConsulta>>>(this){});
        return w;
    }

    public WebDTOResult enviarDocumento(DTOImportacaoBIImportacao dto, EnumConstTipoRepositorioBI tipo, Long identificador) throws ExceptionObjNotFound, ExceptionIO, ExceptionWebService, ExceptionInvalidData {
        if (TMethods.isEquals((Object)tipo, (Object)EnumConstTipoRepositorioBI.BI)) {
            BusinessIntelligence bi = (BusinessIntelligence)this.serviceBusinessIntelligence.getOrThrow(identificador);
            dto = this.getDTODocToSend(dto, bi);
            WebDTOResult w = (WebDTOResult)ToolRESTWebServiceClient.createServicePost((String)this.getServidorTouch(), (String)"/touch-erp/noauth/internal-services/repositorio-bi/importar-bi", (Object)dto, WebDTOResult.class);
            w.setMessage(MessagesBaseMentor.getMsg((String)"msg.documento.importado", (Object[])new Object[0]));
            return w;
        }
        if (TMethods.isEquals((Object)tipo, (Object)EnumConstTipoRepositorioBI.SMART_COMPONENT)) {
            SmartComponent sm = (SmartComponent)this.serviceSmartComponent.getOrThrow(identificador);
            dto = this.getDTODocToSend(dto, sm);
            WebDTOResult w = (WebDTOResult)ToolRESTWebServiceClient.createServicePost((String)this.getServidorTouch(), (String)"/touch-erp/noauth/internal-services/repositorio-bi/importar-bi", (Object)dto, WebDTOResult.class);
            w.setMessage(MessagesBaseMentor.getMsg((String)"msg.documento.importado", (Object[])new Object[0]));
            return w;
        }
        throw new ExceptionInvalidData("E.ERP.000010", new Object[0]);
    }

    private DTOImportacaoBIImportacao getDTODocToSend(DTOImportacaoBIImportacao dto, BusinessIntelligence bi) throws ExceptionIO {
        dto.setArquivoBI(this.getArquivoBI(bi));
        dto.setDescricao(bi.getObservacao());
        dto.setNomeBI(bi.getDescricao());
        dto.setNumeroControle(bi.getNumeroControle());
        dto.setNumeroEstrutura(bi.getNrVersaoEstruturaBI());
        dto.setNumeroVersao(bi.getNumeroVersao());
        dto.setNumeroVersaoRep(bi.getNumeroVersaoRep());
        dto.setCpfPessoaReponsavel(bi.getPessoaResponsavel().getComplemento().getCnpj());
        dto.setSerialLocalBI(bi.getSerialLocalBI());
        dto.setTipoBI(bi.getTipoBI());
        dto.setTipo(Short.valueOf(EnumConstTipoRepositorioBI.BI.getValue()));
        return dto;
    }

    private DTOImportacaoBIImportacao getDTODocToSend(DTOImportacaoBIImportacao dto, SmartComponent sm) throws ExceptionIO {
        dto.setArquivoBI(this.getArquivoSM(sm));
        dto.setDescricao(sm.getObservacao());
        dto.setNomeBI(sm.getDescricao());
        dto.setNumeroControle(sm.getNumeroControle());
        dto.setNumeroEstrutura(sm.getNrVersaoEstrutura());
        dto.setNumeroVersao(sm.getCodigoVersao());
        dto.setNumeroVersaoRep(sm.getNumeroVersaoRep());
        if (sm.getPessoaResponsavel() != null) {
            dto.setCpfPessoaReponsavel(sm.getPessoaResponsavel().getComplemento().getCnpj());
        }
        dto.setSerialLocalBI(sm.getSerialLocal());
        dto.setTipo(Short.valueOf(EnumConstTipoRepositorioBI.SMART_COMPONENT.getValue()));
        return dto;
    }

    private String getArquivoBI(BusinessIntelligence bi) throws ExceptionIO {
        byte[] dados = ((CompExpImpEntityXML)Context.get(CompExpImpEntityXML.class)).entityToByte(bi, this.getCodigoVersao());
        String str = ToolHexString.encodeToHex((byte[])dados);
        return str;
    }

    private String getArquivoSM(SmartComponent sm) throws ExceptionIO {
        byte[] dados = ((CompExpImpEntityXML)Context.get(CompExpImpEntityXML.class)).entityToByte(sm, this.getCodigoVersao());
        String str = ToolHexString.encodeToHex((byte[])dados);
        return str;
    }

    private String getServidorTouch() throws ExceptionIO {
        PropertiesApi propertiesApi = PropertiesApi.get();
        return propertiesApi.getServidorTouch();
    }

    private Long getCodigoVersao() {
        DTOInfoVersao versao = this.serviceVersaoVersoes.getVersaoSistema(EnumConstTipoSistemasTouch.MENTOR_BD);
        return versao.getCodigo();
    }
}

