/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.calculoimpostos;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.IncidenciaIcms;
import com.touchcomp.basementor.model.vo.ModalidadeIcmsSt;
import com.touchcomp.basementor.model.vo.ModeloFiscalIcms;
import com.touchcomp.basementor.model.vo.ModeloFiscalIpi;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.ProdutoAliquotaUF;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementor.model.vo.UnidadeFederativaOrigDest;
import com.touchcomp.basementorservice.service.impl.unidadefederativaorigdest.ServiceUnidadeFederativaOrigDestImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.HashMap;

public class CalculoICMSEntUtilities {
    public static final String ALIQUOTA_ICMS = "aliquotaIPI";
    public static final String VALOR_ICMS = "valorIcms";
    public static final String ICMS_ISENTO = "icmsIsento";
    public static final String ICMS_SEM_APROV = "icmsSemAprov";
    public static final String INDICE_ALTERACAO_ST = "indiceAlteracaoST";
    public static final String ALIQUOTA_ICMS_ST = "aliquotaSt";
    public static final String DESCONTO_PADRAO_ST = "descontoPadraoST";
    public static final String VALOR_BC_NAO_TRIB_ICMS = "valorReducaoIcms";
    public static final String ICMS_OUTROS = "icmsOutros";
    public static final String ICMS_TRIBUTADO = "icmsTributado";
    public static final String BASE_CALCULO_ICMS = "bcIcms";
    public static final String BASE_CALCULO_ICMS_ST = "bcIcmsST";
    public static final String VALOR_ICMS_ST = "valorIcmsST";
    public static final String VALOR_DIFERENCA_ALIQUOTA = "valorDifAliquota";
    public static final String VALOR_ICMS_DESONERADO = "valorIcmsDesonerado";
    private final EnumConstantsMentorSimNao incluirSeguroBC;
    private final EnumConstantsMentorSimNao incluirFreteBC;
    private final EnumConstantsMentorSimNao incluirDespAcessBC;
    private final EnumConstantsMentorSimNao incluirDescontoBC;
    private final EnumConstantsMentorSimNao incluirSeguroBCST;
    private final EnumConstantsMentorSimNao incluirFreteBCST;
    private final EnumConstantsMentorSimNao incluirDespAcessBCST;
    private final EnumConstantsMentorSimNao incluirDescontoBCST;
    private final EnumConstantsMentorSimNao incluirIPIBCST;
    private final EnumConstantsMentorSimNao incluirIcmsDesonerado;
    private ServiceUnidadeFederativaOrigDestImpl serviceUnidadeFederativaOrigemDest = (ServiceUnidadeFederativaOrigDestImpl)ConfApplicationContext.getBean(ServiceUnidadeFederativaOrigDestImpl.class);

    public CalculoICMSEntUtilities(EnumConstantsMentorSimNao incluirSeguroBC, EnumConstantsMentorSimNao incluirFreteBC, EnumConstantsMentorSimNao incluirDespAcessBC, EnumConstantsMentorSimNao incluirDescontoBC, EnumConstantsMentorSimNao incluirSeguroBCST, EnumConstantsMentorSimNao incluirFreteBCST, EnumConstantsMentorSimNao incluirDespAcessBCST, EnumConstantsMentorSimNao incluirDescontoBCST, EnumConstantsMentorSimNao incluirIPIBCST, EnumConstantsMentorSimNao incluirIcmsDesonerado) {
        this.incluirSeguroBC = incluirSeguroBC;
        this.incluirFreteBC = incluirFreteBC;
        this.incluirDespAcessBC = incluirDespAcessBC;
        this.incluirDescontoBC = incluirDescontoBC;
        this.incluirSeguroBCST = incluirSeguroBC;
        this.incluirFreteBCST = incluirFreteBCST;
        this.incluirDespAcessBCST = incluirDespAcessBCST;
        this.incluirDescontoBCST = incluirDescontoBCST;
        this.incluirIPIBCST = incluirIPIBCST;
        this.incluirIcmsDesonerado = incluirIcmsDesonerado;
    }

    public HashMap valoresIcms(ModeloFiscalIcms modeloFiscalIcms, ModeloFiscalIpi modeloFiscalIpi, Double valorIpiIndustria, Double valorIpiObservacao, Double aliquotaICMS, Double percRedICMS, Produto produto, short modoArredondamento, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, EmpresaContabilidade empresaContabilidade, double vrIcmsDesonerado) throws Exception {
        String codigo;
        IncidenciaIcms icms = modeloFiscalIcms.getIncidenciaIcms();
        HashMap<String, Double> h = new HashMap<String, Double>();
        h.put(ALIQUOTA_ICMS, 0.0);
        h.put(VALOR_ICMS, 0.0);
        h.put(ICMS_ISENTO, 0.0);
        h.put(ICMS_SEM_APROV, 0.0);
        h.put(INDICE_ALTERACAO_ST, 0.0);
        h.put(ALIQUOTA_ICMS_ST, 0.0);
        h.put(DESCONTO_PADRAO_ST, 0.0);
        h.put(ICMS_OUTROS, 0.0);
        h.put(ICMS_TRIBUTADO, 0.0);
        h.put(BASE_CALCULO_ICMS, 0.0);
        h.put(VALOR_BC_NAO_TRIB_ICMS, 0.0);
        h.put(VALOR_ICMS_DESONERADO, 0.0);
        h.put(VALOR_ICMS_ST, 0.0);
        percRedICMS = percRedICMS == null ? 0.0 : percRedICMS;
        if (modeloFiscalIpi.getIpiCompoeBcIcms() == 1) {
            vrProdServ += valorIpiIndustria + valorIpiObservacao;
        }
        if ((codigo = icms.getCodigo().substring(1)).equalsIgnoreCase("00")) {
            this.calcularICMS00(modeloFiscalIcms, produto, h, aliquotaICMS, percRedICMS, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, vrIcmsDesonerado);
        } else if (codigo.equalsIgnoreCase("10")) {
            this.calcularICMS10(modeloFiscalIcms, produto, h, aliquotaICMS, percRedICMS, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, vrIcmsDesonerado);
        } else if (codigo.equalsIgnoreCase("20")) {
            this.calcularICMS20(modeloFiscalIcms, produto, h, aliquotaICMS, percRedICMS, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, vrIcmsDesonerado);
        } else if (codigo.equalsIgnoreCase("30")) {
            this.calcularICMS30(modeloFiscalIcms, produto, h, aliquotaICMS, percRedICMS, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, vrIcmsDesonerado);
        } else if (codigo.equalsIgnoreCase("40")) {
            this.calcularICMS40(modeloFiscalIcms, produto, h, aliquotaICMS, percRedICMS, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, vrIcmsDesonerado);
        } else if (codigo.equalsIgnoreCase("41")) {
            this.calcularICMS41(modeloFiscalIcms, produto, h, aliquotaICMS, percRedICMS, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, vrIcmsDesonerado);
        } else if (codigo.equalsIgnoreCase("50")) {
            this.calcularICMS50(modeloFiscalIcms, produto, h, aliquotaICMS, percRedICMS, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, vrIcmsDesonerado);
        } else if (codigo.equalsIgnoreCase("51")) {
            this.calcularICMS51(modeloFiscalIcms, produto, h, aliquotaICMS, percRedICMS, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, vrIcmsDesonerado);
        } else if (codigo.equalsIgnoreCase("60")) {
            this.calcularICMS60(modeloFiscalIcms, produto, h, aliquotaICMS, percRedICMS, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, vrIcmsDesonerado);
        } else if (codigo.equalsIgnoreCase("61")) {
            this.calcularICMS61(modeloFiscalIcms, produto, h, aliquotaICMS, percRedICMS, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, vrIcmsDesonerado);
        } else if (codigo.equalsIgnoreCase("70")) {
            this.calcularICMS70(modeloFiscalIcms, produto, h, aliquotaICMS, percRedICMS, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, vrIcmsDesonerado);
        } else if (codigo.equalsIgnoreCase("90")) {
            this.calcularICMS90(modeloFiscalIcms, produto, h, aliquotaICMS, percRedICMS, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, vrIcmsDesonerado);
        } else {
            throw new Exception("O sistema n\u00c3\u00a3o contempla este tipo de ICMS na entrada.");
        }
        if (empresaContabilidade != null) {
            if (empresaContabilidade.getEmbutirIpiIcmsOutros().equals((short)1) && modeloFiscalIpi.getIpiCompoeBcIcms().equals((short)0)) {
                h.put(ICMS_OUTROS, ToolFormatter.arrredondarNumero((Double)((Double)h.get(ICMS_OUTROS) + valorIpiIndustria + valorIpiObservacao), (int)2));
            }
            if (empresaContabilidade.getEmbutirIcmsStIcmsOutros().equals((short)1)) {
                h.put(ICMS_OUTROS, (Double)h.get(ICMS_OUTROS) + (Double)h.get(VALOR_ICMS_ST));
            }
        }
        h.put(VALOR_ICMS, ToolFormatter.arrredondarNumero((Double)((Double)h.get(VALOR_ICMS)), (int)2, (int)modoArredondamento));
        h.put(ALIQUOTA_ICMS, ToolFormatter.arrredondarNumero((Double)((Double)h.get(ALIQUOTA_ICMS)), (int)2, (int)modoArredondamento));
        h.put(ICMS_ISENTO, ToolFormatter.arrredondarNumero((Double)((Double)h.get(ICMS_ISENTO)), (int)2, (int)modoArredondamento));
        h.put(ICMS_SEM_APROV, ToolFormatter.arrredondarNumero((Double)((Double)h.get(ICMS_SEM_APROV)), (int)2, (int)modoArredondamento));
        h.put(BASE_CALCULO_ICMS_ST, ToolFormatter.arrredondarNumero((Double)((Double)h.get(BASE_CALCULO_ICMS_ST)), (int)2, (int)modoArredondamento));
        h.put(VALOR_ICMS_ST, ToolFormatter.arrredondarNumero((Double)((Double)h.get(VALOR_ICMS_ST)), (int)2, (int)modoArredondamento));
        h.put(ICMS_OUTROS, ToolFormatter.arrredondarNumero((Double)((Double)h.get(ICMS_OUTROS)), (int)2, (int)modoArredondamento));
        h.put(ICMS_TRIBUTADO, ToolFormatter.arrredondarNumero((Double)((Double)h.get(ICMS_TRIBUTADO)), (int)2, (int)modoArredondamento));
        h.put(BASE_CALCULO_ICMS, ToolFormatter.arrredondarNumero((Double)((Double)h.get(BASE_CALCULO_ICMS)), (int)2, (int)modoArredondamento));
        h.put(VALOR_BC_NAO_TRIB_ICMS, ToolFormatter.arrredondarNumero((Double)((Double)h.get(VALOR_BC_NAO_TRIB_ICMS)), (int)2, (int)modoArredondamento));
        return h;
    }

    private double getBCTotal(double vrProdServ, double valorDesconto, double valorDespAcess, double valorFrete, double valorSeguro, double valorIcmsDesonerado) {
        double bc = vrProdServ;
        bc -= valorDesconto;
        bc += valorDespAcess;
        bc += valorFrete;
        bc += valorSeguro;
        return ToolFormatter.arrredondarNumero((Double)(bc -= valorIcmsDesonerado), (int)2);
    }

    private void ajustarBCOutros(HashMap h, double baseCalculo, double bcTot) {
        Double bcOutros = (Double)h.get(ICMS_OUTROS);
        if (bcTot - baseCalculo > 0.0) {
            bcOutros = bcOutros == null ? 0.0 : bcOutros;
            h.put(ICMS_OUTROS, ToolFormatter.arrredondarNumero((Double)(bcTot - baseCalculo), (int)2) + bcOutros);
        }
    }

    private void calcularICMS00(ModeloFiscalIcms modeloFiscalIcms, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double vrIcmsDesonerado) {
        boolean recTributos;
        double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, vrIcmsDesonerado);
        double baseCalculoTot = this.getBCTotal(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, vrIcmsDesonerado);
        boolean bl = recTributos = modeloFiscalIcms.getRecuperarTributosIcms() != null && modeloFiscalIcms.getRecuperarTributosIcms() == 1;
        if (recTributos) {
            h.put(ICMS_TRIBUTADO, baseCalculo);
            h.put(VALOR_ICMS, baseCalculo * (aliquotaICMS / 100.0));
            h.put(ALIQUOTA_ICMS, aliquotaICMS);
        } else {
            h.put(ICMS_OUTROS, baseCalculo);
            h.put(ICMS_SEM_APROV, baseCalculo * (aliquotaICMS / 100.0));
            h.put(ALIQUOTA_ICMS, aliquotaICMS);
        }
        h.put(BASE_CALCULO_ICMS, baseCalculo);
        this.ajustarBCOutros(h, baseCalculo, baseCalculoTot);
    }

    private void calcularICMS10(ModeloFiscalIcms modeloFiscalIcms, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double vrIcmsDesonerado) {
        boolean recTributos;
        double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, vrIcmsDesonerado);
        double baseCalculoTot = this.getBCTotal(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, vrIcmsDesonerado);
        boolean bl = recTributos = modeloFiscalIcms.getRecuperarTributosIcms() != null && modeloFiscalIcms.getRecuperarTributosIcms() == 1;
        if (recTributos) {
            h.put(ICMS_TRIBUTADO, baseCalculo);
            h.put(VALOR_ICMS, baseCalculo * (aliquotaICMS / 100.0));
            h.put(ALIQUOTA_ICMS, aliquotaICMS);
        } else {
            h.put(ICMS_OUTROS, baseCalculo);
            h.put(ICMS_SEM_APROV, baseCalculo * (aliquotaICMS / 100.0));
            h.put(ALIQUOTA_ICMS, aliquotaICMS);
        }
        h.put(BASE_CALCULO_ICMS, baseCalculo);
        this.ajustarBCOutros(h, baseCalculo, baseCalculoTot);
    }

    private void calcularICMS20(ModeloFiscalIcms modeloFiscalIcms, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double vrIcmsDesonerado) {
        double baseCalculo = vrProdServ;
        if (this.incluirDescontoBC == null || this.incluirDescontoBC == EnumConstantsMentorSimNao.SIM) {
            baseCalculo -= valorDesconto;
        }
        if (this.incluirIcmsDesonerado == null || this.incluirIcmsDesonerado == EnumConstantsMentorSimNao.SIM) {
            baseCalculo -= vrIcmsDesonerado;
        }
        double bcAcess = 0.0;
        if (this.incluirDespAcessBC == null || this.incluirDespAcessBC == EnumConstantsMentorSimNao.SIM) {
            bcAcess += valorDespAcess;
        }
        if (this.incluirFreteBC == null || this.incluirFreteBC == EnumConstantsMentorSimNao.SIM) {
            bcAcess += valorFrete;
        }
        if (this.incluirSeguroBC == null || this.incluirSeguroBC == EnumConstantsMentorSimNao.SIM) {
            bcAcess += valorSeguro;
        }
        if (ToolMethods.isEquals((Object)modeloFiscalIcms.getTipoAliquotaIcms(), (Object)0)) {
            h.put(ICMS_OUTROS, baseCalculo + bcAcess);
            h.put(ALIQUOTA_ICMS, 0.0);
            h.put(BASE_CALCULO_ICMS, baseCalculo + bcAcess);
        } else if (ToolMethods.isEquals((Object)modeloFiscalIcms.getIncluiDespAcessCalcRed(), (Object)1)) {
            boolean recTributos;
            double vrReduz = (baseCalculo += bcAcess) * (percRedICMS / 100.0);
            boolean bl = recTributos = modeloFiscalIcms.getRecuperarTributosIcms() != null && modeloFiscalIcms.getRecuperarTributosIcms() == 1;
            if (recTributos) {
                h.put(ICMS_TRIBUTADO, baseCalculo - vrReduz);
                h.put(ICMS_ISENTO, vrReduz);
                h.put(VALOR_ICMS, (baseCalculo - vrReduz) * (aliquotaICMS / 100.0));
                if (modeloFiscalIcms.getIcmsDispensadoDesconto() != null && (modeloFiscalIcms.getIcmsDispensadoDesconto().equals((short)1) || modeloFiscalIcms.getIcmsDispensadoDesconto().equals((short)2))) {
                    Double valorIcmsDesonerado = ToolFormatter.arrredondarNumero((Double)(vrReduz * (aliquotaICMS / 100.0)), (int)2);
                    Double valorIcmsIsento = ToolFormatter.arrredondarNumero((Double)(vrReduz - valorIcmsDesonerado), (int)2);
                    h.put(VALOR_ICMS_DESONERADO, valorIcmsDesonerado);
                    h.put(ICMS_ISENTO, valorIcmsIsento);
                }
                h.put(VALOR_BC_NAO_TRIB_ICMS, vrReduz);
                h.put(ALIQUOTA_ICMS, aliquotaICMS);
            } else {
                h.put(ICMS_OUTROS, baseCalculo - vrReduz);
                h.put(ICMS_ISENTO, vrReduz);
                h.put(ICMS_SEM_APROV, (baseCalculo - vrReduz) * (aliquotaICMS / 100.0));
                if (modeloFiscalIcms.getIcmsDispensadoDesconto() != null && (modeloFiscalIcms.getIcmsDispensadoDesconto().equals((short)1) || modeloFiscalIcms.getIcmsDispensadoDesconto().equals((short)2))) {
                    Double valorIcmsDesonerado = ToolFormatter.arrredondarNumero((Double)(vrReduz * (aliquotaICMS / 100.0)), (int)2);
                    Double valorIcmsIsento = ToolFormatter.arrredondarNumero((Double)(vrReduz - valorIcmsDesonerado), (int)2);
                    h.put(VALOR_ICMS_DESONERADO, valorIcmsDesonerado);
                    h.put(ICMS_ISENTO, valorIcmsIsento);
                }
                h.put(VALOR_BC_NAO_TRIB_ICMS, vrReduz);
                h.put(ALIQUOTA_ICMS, aliquotaICMS);
            }
            h.put(BASE_CALCULO_ICMS, baseCalculo);
        } else {
            boolean recTributos;
            double vrReduz = baseCalculo * (percRedICMS / 100.0);
            boolean bl = recTributos = modeloFiscalIcms.getRecuperarTributosIcms() != null && modeloFiscalIcms.getRecuperarTributosIcms() == 1;
            if (recTributos) {
                h.put(ICMS_TRIBUTADO, baseCalculo + bcAcess - vrReduz);
                h.put(ICMS_ISENTO, vrReduz);
                h.put(VALOR_ICMS, (baseCalculo - vrReduz) * (aliquotaICMS / 100.0) + bcAcess * (aliquotaICMS / 100.0));
                if (modeloFiscalIcms.getIcmsDispensadoDesconto() != null && (modeloFiscalIcms.getIcmsDispensadoDesconto().equals((short)1) || modeloFiscalIcms.getIcmsDispensadoDesconto().equals((short)2))) {
                    Double valorIcmsDesonerado = ToolFormatter.arrredondarNumero((Double)(vrReduz * (aliquotaICMS / 100.0)), (int)2);
                    Double valorIcmsIsento = ToolFormatter.arrredondarNumero((Double)(vrReduz - valorIcmsDesonerado), (int)2);
                    h.put(VALOR_ICMS_DESONERADO, valorIcmsDesonerado);
                    h.put(ICMS_ISENTO, valorIcmsIsento);
                }
                h.put(VALOR_BC_NAO_TRIB_ICMS, vrReduz);
                h.put(ALIQUOTA_ICMS, aliquotaICMS);
            } else {
                h.put(ICMS_OUTROS, baseCalculo + bcAcess - vrReduz);
                h.put(ICMS_ISENTO, vrReduz);
                h.put(ICMS_SEM_APROV, (baseCalculo - vrReduz) * (aliquotaICMS / 100.0) + bcAcess * (aliquotaICMS / 100.0));
                if (modeloFiscalIcms.getIcmsDispensadoDesconto() != null && (modeloFiscalIcms.getIcmsDispensadoDesconto().equals((short)1) || modeloFiscalIcms.getIcmsDispensadoDesconto().equals((short)2))) {
                    Double valorIcmsDesonerado = ToolFormatter.arrredondarNumero((Double)(vrReduz * (aliquotaICMS / 100.0)), (int)2);
                    Double valorIcmsIsento = ToolFormatter.arrredondarNumero((Double)(vrReduz - valorIcmsDesonerado), (int)2);
                    h.put(VALOR_ICMS_DESONERADO, valorIcmsDesonerado);
                    h.put(ICMS_ISENTO, valorIcmsIsento);
                }
                h.put(VALOR_BC_NAO_TRIB_ICMS, vrReduz);
                h.put(ALIQUOTA_ICMS, aliquotaICMS);
            }
            h.put(BASE_CALCULO_ICMS, baseCalculo + bcAcess);
        }
    }

    private void calcReducao(ModeloFiscalIcms modeloFiscalIcms, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double vrIcmsDesonerado) {
        double baseCalculo = vrProdServ;
        if (this.incluirDescontoBC == null || this.incluirDescontoBC == EnumConstantsMentorSimNao.SIM) {
            baseCalculo -= valorDesconto;
        }
        if (this.incluirIcmsDesonerado == null || this.incluirIcmsDesonerado == EnumConstantsMentorSimNao.SIM) {
            baseCalculo -= vrIcmsDesonerado;
        }
        double bcAcess = 0.0;
        if (this.incluirDespAcessBC == null || this.incluirDespAcessBC == EnumConstantsMentorSimNao.SIM) {
            bcAcess += valorDespAcess;
        }
        if (this.incluirFreteBC == null || this.incluirFreteBC == EnumConstantsMentorSimNao.SIM) {
            bcAcess += valorFrete;
        }
        if (this.incluirSeguroBC == null || this.incluirSeguroBC == EnumConstantsMentorSimNao.SIM) {
            bcAcess += valorSeguro;
        }
        double baseCalculoTot = this.getBCTotal(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, vrIcmsDesonerado);
        if (ToolMethods.isEquals((Object)modeloFiscalIcms.getIncluiDespAcessCalcRed(), (Object)1)) {
            boolean recTributos;
            double vrReduz = (baseCalculo += bcAcess) * (percRedICMS / 100.0);
            boolean bl = recTributos = modeloFiscalIcms.getRecuperarTributosIcms() != null && modeloFiscalIcms.getRecuperarTributosIcms() == 1;
            if (recTributos) {
                h.put(ICMS_TRIBUTADO, baseCalculo - vrReduz);
                h.put(ICMS_ISENTO, vrReduz);
                h.put(VALOR_ICMS, baseCalculo * (aliquotaICMS / 100.0));
                if (modeloFiscalIcms.getIcmsDispensadoDesconto() != null && (modeloFiscalIcms.getIcmsDispensadoDesconto().equals((short)1) || modeloFiscalIcms.getIcmsDispensadoDesconto().equals((short)2))) {
                    Double valorIcmsDesonerado = ToolFormatter.arrredondarNumero((Double)(vrReduz * (aliquotaICMS / 100.0)), (int)2);
                    Double valorIcmsIsento = ToolFormatter.arrredondarNumero((Double)(vrReduz - valorIcmsDesonerado), (int)2);
                    h.put(VALOR_ICMS_DESONERADO, valorIcmsDesonerado);
                    h.put(ICMS_ISENTO, valorIcmsIsento);
                }
                h.put(VALOR_BC_NAO_TRIB_ICMS, vrReduz);
                h.put(ALIQUOTA_ICMS, aliquotaICMS);
                this.ajustarBCOutros(h, baseCalculo, baseCalculoTot);
            } else {
                h.put(ICMS_OUTROS, baseCalculo - vrReduz);
                h.put(ICMS_ISENTO, vrReduz);
                h.put(ICMS_SEM_APROV, (baseCalculo - vrReduz) * (aliquotaICMS / 100.0));
                if (modeloFiscalIcms.getIcmsDispensadoDesconto() != null && (modeloFiscalIcms.getIcmsDispensadoDesconto().equals((short)1) || modeloFiscalIcms.getIcmsDispensadoDesconto().equals((short)2))) {
                    Double valorIcmsDesonerado = ToolFormatter.arrredondarNumero((Double)(vrReduz * (aliquotaICMS / 100.0)), (int)2);
                    Double valorIcmsIsento = ToolFormatter.arrredondarNumero((Double)(vrReduz - valorIcmsDesonerado), (int)2);
                    h.put(VALOR_ICMS_DESONERADO, valorIcmsDesonerado);
                    h.put(ICMS_ISENTO, valorIcmsIsento);
                }
                h.put(VALOR_BC_NAO_TRIB_ICMS, vrReduz);
                h.put(ALIQUOTA_ICMS, aliquotaICMS);
            }
            h.put(BASE_CALCULO_ICMS, baseCalculo);
        } else {
            boolean recTributos;
            double vrReduz = baseCalculo * (percRedICMS / 100.0);
            boolean bl = recTributos = modeloFiscalIcms.getRecuperarTributosIcms() != null && modeloFiscalIcms.getRecuperarTributosIcms() == 1;
            if (recTributos) {
                h.put(ICMS_TRIBUTADO, baseCalculo + bcAcess - vrReduz);
                h.put(ICMS_ISENTO, vrReduz);
                h.put(VALOR_ICMS, (baseCalculo - vrReduz) * (aliquotaICMS / 100.0) + bcAcess * (aliquotaICMS / 100.0));
                if (modeloFiscalIcms.getIcmsDispensadoDesconto() != null && (modeloFiscalIcms.getIcmsDispensadoDesconto().equals((short)1) || modeloFiscalIcms.getIcmsDispensadoDesconto().equals((short)2))) {
                    Double valorIcmsDesonerado = ToolFormatter.arrredondarNumero((Double)(vrReduz * (aliquotaICMS / 100.0)), (int)2);
                    Double valorIcmsIsento = ToolFormatter.arrredondarNumero((Double)(vrReduz - valorIcmsDesonerado), (int)2);
                    h.put(VALOR_ICMS_DESONERADO, valorIcmsDesonerado);
                    h.put(ICMS_ISENTO, valorIcmsIsento);
                }
                h.put(VALOR_BC_NAO_TRIB_ICMS, vrReduz);
                h.put(ALIQUOTA_ICMS, aliquotaICMS);
                this.ajustarBCOutros(h, baseCalculo, baseCalculoTot);
            } else {
                h.put(ICMS_OUTROS, baseCalculo + bcAcess - vrReduz);
                h.put(ICMS_ISENTO, vrReduz);
                h.put(ICMS_SEM_APROV, (baseCalculo - vrReduz) * (aliquotaICMS / 100.0) + bcAcess * (aliquotaICMS / 100.0));
                if (modeloFiscalIcms.getIcmsDispensadoDesconto() != null && (modeloFiscalIcms.getIcmsDispensadoDesconto().equals((short)1) || modeloFiscalIcms.getIcmsDispensadoDesconto().equals((short)2))) {
                    Double valorIcmsDesonerado = ToolFormatter.arrredondarNumero((Double)(vrReduz * (aliquotaICMS / 100.0)), (int)2);
                    Double valorIcmsIsento = ToolFormatter.arrredondarNumero((Double)(vrReduz - valorIcmsDesonerado), (int)2);
                    h.put(VALOR_ICMS_DESONERADO, valorIcmsDesonerado);
                    h.put(ICMS_ISENTO, valorIcmsIsento);
                }
                h.put(VALOR_BC_NAO_TRIB_ICMS, vrReduz);
                h.put(ALIQUOTA_ICMS, aliquotaICMS);
            }
            h.put(BASE_CALCULO_ICMS, baseCalculo + bcAcess);
        }
    }

    private void calcularICMS30(ModeloFiscalIcms modeloFiscalIcms, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double vrIcmsDesonerado) {
        double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, vrIcmsDesonerado);
        double baseCalculoTot = this.getBCTotal(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, vrIcmsDesonerado);
        h.put(ICMS_ISENTO, baseCalculo);
        h.put(ALIQUOTA_ICMS, 0.0);
        h.put(BASE_CALCULO_ICMS, baseCalculo);
        this.ajustarBCOutros(h, baseCalculo, baseCalculoTot);
    }

    private void calcularICMS40(ModeloFiscalIcms modeloFiscalIcms, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double vrIcmsDesonerado) {
        double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, vrIcmsDesonerado);
        double baseCalculoTot = this.getBCTotal(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, vrIcmsDesonerado);
        h.put(ICMS_ISENTO, baseCalculo);
        h.put(ALIQUOTA_ICMS, 0.0);
        h.put(BASE_CALCULO_ICMS, baseCalculo);
        h.put(VALOR_ICMS_DESONERADO, vrIcmsDesonerado);
        this.ajustarBCOutros(h, baseCalculo, baseCalculoTot);
    }

    private void calcularICMS41(ModeloFiscalIcms modeloFiscalIcms, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double vrIcmsDesonerado) {
        double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, vrIcmsDesonerado);
        double baseCalculoTot = this.getBCTotal(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, vrIcmsDesonerado);
        h.put(ICMS_ISENTO, baseCalculo);
        h.put(ALIQUOTA_ICMS, 0.0);
        h.put(BASE_CALCULO_ICMS, baseCalculo);
        h.put(VALOR_ICMS_DESONERADO, vrIcmsDesonerado);
        this.ajustarBCOutros(h, baseCalculo, baseCalculoTot);
    }

    private void calcularICMS50(ModeloFiscalIcms modeloFiscalIcms, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double vrIcmsDesonerado) {
        double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, vrIcmsDesonerado);
        double baseCalculoTot = this.getBCTotal(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, vrIcmsDesonerado);
        h.put(ICMS_OUTROS, baseCalculo);
        h.put(ALIQUOTA_ICMS, 0.0);
        h.put(BASE_CALCULO_ICMS, baseCalculo);
        h.put(VALOR_ICMS_DESONERADO, vrIcmsDesonerado);
        this.ajustarBCOutros(h, baseCalculo, baseCalculoTot);
    }

    private void calcularICMS51(ModeloFiscalIcms modeloFiscalIcms, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double vrIcmsDesonerado) {
        double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, vrIcmsDesonerado);
        double baseCalculoTot = this.getBCTotal(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, vrIcmsDesonerado);
        h.put(ICMS_OUTROS, baseCalculo);
        h.put(ALIQUOTA_ICMS, 0.0);
        h.put(BASE_CALCULO_ICMS, baseCalculo);
        h.put(VALOR_ICMS_DESONERADO, vrIcmsDesonerado);
        this.ajustarBCOutros(h, baseCalculo, baseCalculoTot);
    }

    private void calcularICMS60(ModeloFiscalIcms modeloFiscalIcms, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double vrIcmsDesonerado) {
        double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, vrIcmsDesonerado);
        double baseCalculoTot = this.getBCTotal(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, vrIcmsDesonerado);
        h.put(ICMS_OUTROS, baseCalculo);
        h.put(ALIQUOTA_ICMS, 0.0);
        h.put(BASE_CALCULO_ICMS, baseCalculo);
        this.ajustarBCOutros(h, baseCalculo, baseCalculoTot);
    }

    private void calcularICMS61(ModeloFiscalIcms modeloFiscalIcms, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double vrIcmsDesonerado) {
        double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, vrIcmsDesonerado);
        double baseCalculoTot = this.getBCTotal(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, vrIcmsDesonerado);
        h.put(ICMS_OUTROS, baseCalculo);
        h.put(ALIQUOTA_ICMS, 0.0);
        h.put(BASE_CALCULO_ICMS, baseCalculo);
        this.ajustarBCOutros(h, baseCalculo, baseCalculoTot);
    }

    private void calcularICMS70(ModeloFiscalIcms modeloFiscalIcms, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double vrIcmsDesonerado) {
        boolean recTributos;
        double baseCalculo = vrProdServ;
        if (this.incluirDescontoBC == null || this.incluirDescontoBC == EnumConstantsMentorSimNao.SIM) {
            baseCalculo -= valorDesconto;
        }
        double bcAcess = 0.0;
        if (this.incluirDespAcessBC == null || this.incluirDespAcessBC == EnumConstantsMentorSimNao.SIM) {
            bcAcess += valorDespAcess;
        }
        if (this.incluirFreteBC == null || this.incluirFreteBC == EnumConstantsMentorSimNao.SIM) {
            bcAcess += valorFrete;
        }
        if (this.incluirSeguroBC == null || this.incluirSeguroBC == EnumConstantsMentorSimNao.SIM) {
            bcAcess += valorSeguro;
        }
        double vrReduz = baseCalculo * (percRedICMS / 100.0);
        boolean bl = recTributos = modeloFiscalIcms.getRecuperarTributosIcms() != null && modeloFiscalIcms.getRecuperarTributosIcms() == 1;
        if (recTributos) {
            h.put(ICMS_TRIBUTADO, baseCalculo + bcAcess - vrReduz);
            h.put(ICMS_ISENTO, vrReduz);
            h.put(VALOR_ICMS, (baseCalculo - vrReduz) * (aliquotaICMS / 100.0) + bcAcess * (aliquotaICMS / 100.0));
            if (modeloFiscalIcms.getIcmsDispensadoDesconto() != null && (modeloFiscalIcms.getIcmsDispensadoDesconto().equals((short)1) || modeloFiscalIcms.getIcmsDispensadoDesconto().equals((short)2))) {
                h.put(VALOR_ICMS_DESONERADO, ToolFormatter.arrredondarNumero((Double)(vrReduz * (aliquotaICMS / 100.0)), (int)2));
            }
            h.put(VALOR_BC_NAO_TRIB_ICMS, vrReduz);
            h.put(ALIQUOTA_ICMS, aliquotaICMS);
        } else {
            h.put(ICMS_OUTROS, baseCalculo + bcAcess - vrReduz);
            h.put(ICMS_ISENTO, vrReduz);
            h.put(ICMS_SEM_APROV, (baseCalculo - vrReduz) * (aliquotaICMS / 100.0) + bcAcess);
            if (modeloFiscalIcms.getIcmsDispensadoDesconto() != null && (modeloFiscalIcms.getIcmsDispensadoDesconto().equals((short)1) || modeloFiscalIcms.getIcmsDispensadoDesconto().equals((short)2))) {
                h.put(VALOR_ICMS_DESONERADO, ToolFormatter.arrredondarNumero((Double)(vrReduz * (aliquotaICMS / 100.0)), (int)2));
            }
            h.put(VALOR_BC_NAO_TRIB_ICMS, vrReduz);
            h.put(ALIQUOTA_ICMS, aliquotaICMS);
        }
        h.put(BASE_CALCULO_ICMS, baseCalculo + bcAcess);
    }

    private void calcularICMS90(ModeloFiscalIcms modeloFiscalIcms, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double vrIcmsDesonerado) {
        boolean recTributos;
        double baseCalculo = vrProdServ;
        if (this.incluirDescontoBC == null || this.incluirDescontoBC == EnumConstantsMentorSimNao.SIM) {
            baseCalculo -= valorDesconto;
        }
        double bcAcess = 0.0;
        if (this.incluirDespAcessBC == null || this.incluirDespAcessBC == EnumConstantsMentorSimNao.SIM) {
            bcAcess += valorDespAcess;
        }
        if (this.incluirFreteBC == null || this.incluirFreteBC == EnumConstantsMentorSimNao.SIM) {
            bcAcess += valorFrete;
        }
        if (this.incluirSeguroBC == null || this.incluirSeguroBC == EnumConstantsMentorSimNao.SIM) {
            bcAcess += valorSeguro;
        }
        double vrReduz = baseCalculo * (percRedICMS / 100.0);
        boolean bl = recTributos = modeloFiscalIcms.getRecuperarTributosIcms() != null && modeloFiscalIcms.getRecuperarTributosIcms() == 1;
        if (recTributos) {
            h.put(ICMS_TRIBUTADO, baseCalculo + bcAcess - vrReduz);
            h.put(ICMS_OUTROS, vrReduz);
            if (modeloFiscalIcms.getTipoAliquotaIcms() != 0) {
                h.put(VALOR_ICMS, (baseCalculo - vrReduz) * (aliquotaICMS / 100.0) + bcAcess * (aliquotaICMS / 100.0));
                h.put(ALIQUOTA_ICMS, aliquotaICMS);
            } else {
                h.put(ALIQUOTA_ICMS, 0.0);
            }
            h.put(VALOR_BC_NAO_TRIB_ICMS, vrReduz);
        } else {
            h.put(ICMS_OUTROS, baseCalculo + bcAcess);
            if (modeloFiscalIcms.getTipoAliquotaIcms() != 0) {
                h.put(ICMS_SEM_APROV, (baseCalculo - vrReduz) * (aliquotaICMS / 100.0) + bcAcess * (aliquotaICMS / 100.0));
                h.put(VALOR_BC_NAO_TRIB_ICMS, vrReduz);
                h.put(ALIQUOTA_ICMS, aliquotaICMS);
            } else {
                h.put(ALIQUOTA_ICMS, 0.0);
            }
        }
        h.put(BASE_CALCULO_ICMS, baseCalculo + bcAcess);
    }

    public HashMap calcularDiferencaAliquota(ModeloFiscalIcms modeloFiscalIcms, UnidadeFederativa ufFornecedor, UnidadeFederativa ufEmpresa, Produto produto, Double valorFrete, Double valorSeguro, Double valorDespAcessoria, Double valorDesconto, Double valorProdServ, Short ipiCompoeBC, Double valorIPI, Double aliqIcmsInfItem) throws Exception {
        HashMap<String, Double> h = new HashMap<String, Double>();
        double valorDif = 0.0;
        double aliquotaIcms = this.getAliquotaInternaProduto(produto, ufEmpresa);
        if (modeloFiscalIcms.getCalcularDiferencaAliquota() != null && modeloFiscalIcms.getCalcularDiferencaAliquota() == 1 && aliquotaIcms > 0.0) {
            Double bcDifAliq = this.getBCDifAliquota(valorProdServ, valorDesconto, valorDespAcessoria, valorFrete, valorSeguro, ipiCompoeBC, valorIPI);
            if (!ufEmpresa.equals((Object)ufFornecedor) && ufFornecedor.getPais().equals((Object)ufEmpresa.getPais())) {
                Double aliqModeloOrEstado = 0.0;
                aliqModeloOrEstado = modeloFiscalIcms.getTipoAliquotaIcms() == 2 ? aliqIcmsInfItem : this.getAliquotaICMS(ufFornecedor, ufEmpresa);
                if (aliqModeloOrEstado != null && aliqModeloOrEstado > 0.0) {
                    valorDif = this.calcularDiferencaAliquota(aliqModeloOrEstado, aliquotaIcms, ufFornecedor, ufEmpresa, bcDifAliq, modeloFiscalIcms);
                }
            }
        }
        if (valorDif < 0.0) {
            valorDif = 0.0;
        }
        h.put(VALOR_DIFERENCA_ALIQUOTA, valorDif);
        return h;
    }

    public HashMap calcularSt(Double valorIcms, Double indiceAlteracao, Double aliquotaICMSST, Double descontoPadrao, Double quantidadeTotal, Produto produto, ModalidadeIcmsSt modalidade, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double vrIpiIndustria, double vrIpiObservacao, double percReducaoBCST) {
        double valorIPI = vrIpiIndustria + vrIpiObservacao;
        double baseCalculo = this.getBCST(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, valorIPI, percReducaoBCST);
        valorIcms = valorIcms == null ? 0.0 : valorIcms;
        indiceAlteracao = indiceAlteracao == null ? 0.0 : indiceAlteracao;
        aliquotaICMSST = aliquotaICMSST == null ? 0.0 : aliquotaICMSST;
        descontoPadrao = descontoPadrao == null ? 0.0 : descontoPadrao;
        quantidadeTotal = quantidadeTotal == null ? 0.0 : quantidadeTotal;
        HashMap<String, Double> h = new HashMap<String, Double>();
        double bcIcmsst = baseCalculo;
        bcIcmsst = modalidade != null && modalidade.getCodigo().equalsIgnoreCase("0") ? produto.getValorTabICMSST() * quantidadeTotal : bcIcmsst * indiceAlteracao - bcIcmsst * (descontoPadrao / 100.0);
        bcIcmsst = ToolFormatter.arrredondarNumero((Double)bcIcmsst, (int)2);
        h.put(INDICE_ALTERACAO_ST, indiceAlteracao);
        h.put(ALIQUOTA_ICMS_ST, aliquotaICMSST);
        h.put(DESCONTO_PADRAO_ST, descontoPadrao);
        Double valorSt = bcIcmsst * (aliquotaICMSST / 100.0) - valorIcms;
        if (valorSt < 0.0) {
            valorSt = 0.0;
        }
        h.put(BASE_CALCULO_ICMS_ST, bcIcmsst);
        h.put(VALOR_ICMS_ST, valorSt);
        return h;
    }

    public Double getAliquotaICMS(UnidadeFederativa ufOrigem, UnidadeFederativa ufDestino, Produto prod) throws Exception {
        if (prod == null) {
            return 0.0;
        }
        if (ufDestino.equals((Object)ufOrigem)) {
            return prod.getAliquotaIcms();
        }
        return this.getAliquotaICMS(ufOrigem, ufDestino);
    }

    public Double getAliquotaICMS(UnidadeFederativa ufOrigem, UnidadeFederativa ufDestino) throws Exception {
        UnidadeFederativaOrigDest found = this.serviceUnidadeFederativaOrigemDest.get(ufOrigem, ufDestino);
        if (found != null) {
            return found.getAliquotaICMS();
        }
        return 0.0;
    }

    private double getBC(double vrProdServ, double valorDesconto, double valorDespAcess, double valorFrete, double valorSeguro, double valorIcmsDesonerado) {
        double bc = vrProdServ;
        if (this.incluirDescontoBC == null || this.incluirDescontoBC == EnumConstantsMentorSimNao.SIM) {
            bc -= valorDesconto;
        }
        if (this.incluirDespAcessBC == null || this.incluirDespAcessBC == EnumConstantsMentorSimNao.SIM) {
            bc += valorDespAcess;
        }
        if (this.incluirFreteBC == null || this.incluirFreteBC == EnumConstantsMentorSimNao.SIM) {
            bc += valorFrete;
        }
        if (this.incluirSeguroBC == null || this.incluirSeguroBC == EnumConstantsMentorSimNao.SIM) {
            bc += valorSeguro;
        }
        if (this.incluirIcmsDesonerado == null || this.incluirIcmsDesonerado == EnumConstantsMentorSimNao.SIM) {
            bc -= valorIcmsDesonerado;
        }
        return bc;
    }

    private double getBCST(double vrProdServ, double valorDesconto, double valorDespAcess, double valorFrete, double valorSeguro, double valorIPI, Double percRedBCST) {
        double bcIcmsst = vrProdServ;
        if (this.incluirDescontoBCST != null && this.incluirDescontoBCST == EnumConstantsMentorSimNao.SIM) {
            bcIcmsst -= valorDesconto;
        }
        if (this.incluirDespAcessBCST != null && this.incluirDespAcessBCST == EnumConstantsMentorSimNao.SIM) {
            bcIcmsst += valorDespAcess;
        }
        if (this.incluirFreteBCST != null && this.incluirFreteBCST == EnumConstantsMentorSimNao.SIM) {
            bcIcmsst += valorFrete;
        }
        if (this.incluirSeguroBCST != null && this.incluirSeguroBCST == EnumConstantsMentorSimNao.SIM) {
            bcIcmsst += valorSeguro;
        }
        if (this.incluirIPIBCST != null && this.incluirIPIBCST == EnumConstantsMentorSimNao.SIM) {
            bcIcmsst += valorIPI;
        }
        if (percRedBCST != null && percRedBCST > 0.0) {
            bcIcmsst -= bcIcmsst * percRedBCST / 100.0;
        }
        return bcIcmsst;
    }

    private double getBCDifAliquota(double vrProdServ, double valorDesconto, double valorDespAcess, double valorFrete, double valorSeguro, Short ipiIncluiBC, double valorIPI) {
        double bcDifAliq = vrProdServ;
        if (this.incluirDescontoBC != null && this.incluirDescontoBC == EnumConstantsMentorSimNao.SIM) {
            bcDifAliq -= valorDesconto;
        }
        if (this.incluirDespAcessBC != null && this.incluirDespAcessBC == EnumConstantsMentorSimNao.SIM) {
            bcDifAliq += valorDespAcess;
        }
        if (this.incluirFreteBC != null && this.incluirFreteBC == EnumConstantsMentorSimNao.SIM) {
            bcDifAliq += valorFrete;
        }
        if (this.incluirSeguroBC != null && this.incluirSeguroBC == EnumConstantsMentorSimNao.SIM) {
            bcDifAliq += valorSeguro;
        }
        if (ipiIncluiBC != null && ipiIncluiBC == 1) {
            bcDifAliq += valorIPI;
        }
        return bcDifAliq;
    }

    public static boolean isIncidenciaIsenta(String codigo) {
        if (codigo.equalsIgnoreCase("41")) {
            return true;
        }
        if (codigo.equalsIgnoreCase("40")) {
            return true;
        }
        return codigo.equalsIgnoreCase("30");
    }

    public static boolean isIncidenciaReducao(String codigo) {
        if (codigo.equalsIgnoreCase("20")) {
            return true;
        }
        return codigo.equalsIgnoreCase("70");
    }

    private double calcularDiferencaAliquota(Double aliqModeloOrEstado, double aliquotaIcms, UnidadeFederativa ufFornecedor, UnidadeFederativa ufEmpresa, Double valorTotalItem, ModeloFiscalIcms mod) {
        double valorDif = 0.0;
        if (mod.getModoDifAliquota() != null && mod.getModoDifAliquota() == 1) {
            double valorCompraSemIcms = valorTotalItem * (1.0 - aliqModeloOrEstado / 100.0);
            double novaBCIcms = valorCompraSemIcms / (1.0 - aliquotaIcms / 100.0);
            double novoVlrIcms = novaBCIcms * aliquotaIcms / 100.0;
            return novoVlrIcms - (valorTotalItem - valorCompraSemIcms);
        }
        valorDif = valorTotalItem * (aliquotaIcms / 100.0) - valorTotalItem * (aliqModeloOrEstado / 100.0);
        return valorDif;
    }

    private double getAliquotaInternaProduto(Produto produto, UnidadeFederativa ufEmpresa) {
        for (ProdutoAliquotaUF produtoAliquotaUF : produto.getAliquotasUF()) {
            if (!produtoAliquotaUF.getUf().equals((Object)ufEmpresa)) continue;
            return produtoAliquotaUF.getAliquotaIcms();
        }
        return produto.getAliquotaIcms();
    }
}

