/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.calculoimpostos;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstContrEstadoIcms;
import com.touchcomp.basementor.constants.enums.modalidadeicms.EnumConstModIcms;
import com.touchcomp.basementor.constants.enums.modelofiscalicms.EnumConstModFiscalDifal;
import com.touchcomp.basementor.constants.enums.modelofiscalicms.EnumConstModFiscalDifalST;
import com.touchcomp.basementor.model.vo.AliquotaSt;
import com.touchcomp.basementor.model.vo.CNAE;
import com.touchcomp.basementor.model.vo.CategoriaPessoa;
import com.touchcomp.basementor.model.vo.CategoriaSt;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.DadosFiscaisUF;
import com.touchcomp.basementor.model.vo.DadosFiscaisUFNcmFCP;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.IncidenciaIcms;
import com.touchcomp.basementor.model.vo.ModeloFiscalICMSSTItem;
import com.touchcomp.basementor.model.vo.ModeloFiscalIcms;
import com.touchcomp.basementor.model.vo.ModeloFiscalIpi;
import com.touchcomp.basementor.model.vo.NcmAliquotaUF;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.ProdutoAliquotaUF;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementor.model.vo.UnidadeFederativaOrigDest;
import com.touchcomp.basementor.model.vo.VersaoNFe;
import com.touchcomp.basementorservice.service.impl.aliquotast.ServiceAliquotaStImpl;
import com.touchcomp.basementorservice.service.impl.dadosfiscaisuf.ServiceDadosFiscaisUFImpl;
import com.touchcomp.basementorservice.service.impl.modelofiscalicmsstitem.ServiceModeloFiscalICMSSTItemImpl;
import com.touchcomp.basementorservice.service.impl.unidadefederativaorigdest.ServiceUnidadeFederativaOrigDestImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class CalculoICMSSaiUtilities {
    public static final String ALIQUOTA_ICMS = "aliquotaICMS";
    public static final String ALIQUOTA_ICMS_SIMPLES = "aliquotaICMSSimples";
    public static final String VALOR_ICMS = "valorIcms";
    public static final String VALOR_ICMS_SIMPLES = "valorIcmsSimples";
    public static final String VALOR_ICMS_ST = "valorIcmsSt";
    public static final String ICMS_ISENTO = "icmsIsento";
    public static final String ICMS_SEM_APROV = "icmsSemAprov";
    public static final String INDICE_ALTERACAO_ST = "indiceAlteracaoST";
    public static final String ALIQUOTA_ICMS_ST = "aliquotaSt";
    public static final String DESCONTO_PADRAO_ST = "descontoPadraoST";
    public static final String ICMS_OUTROS = "icmsOutros";
    public static final String ICMS_TRIBUTADO = "icmsTributado";
    public static final String BASE_CALCULO_ICMS = "bcIcms";
    public static final String BASE_CALCULO_ICMS_ST = "bcIcmsST";
    public static final String VALOR_BC_NAO_TRIB_ICMS = "valorNaoTribIcms";
    public static final String VALOR_ICMS_DESONERADO = "valorIcmsDesonerado";
    public static final String BC_ICMS_UF_DEST = "valorBcIcmsUfDest";
    public static final String VR_ICMS_UF_DEST = "valorIcmsPartilhaDest";
    public static final String VR_ICMS_UF_REM = "valorIcmsPartilhaRem";
    public static final String ALIQ_INTERNA_UF_DEST = "aliquotaInternaUFDest";
    public static final String ALIQ_INTERESTADUAL = "aliquotaInterestadual";
    public static final String PERC_PARTILHA_ICMS = "percPartilhaIcms";
    public static final String ALIQ_FUNDO_POBREZA = "aliquotaFundoPobreza";
    public static final String VALOR_FUNDO_POBREZA = "valorFundoPobreza";
    public static final String BASE_CALCULO_FCP = "valorBCFCP";
    public static final String VALOR_FCP = "valorFCP";
    public static final String ALIQUOTA_FCP = "aliquotaFCP";
    public static final String BASE_CALCULO_FCP_ST = "valorBCFCPSt";
    public static final String VALOR_FCP_ST = "valorFCPSt";
    public static final String ALIQUOTA_FCP_ST = "aliquotaFCPSt";
    public static final String BASE_CALCULO_FCP_ST_RETIDO = "valorBCFCPStRetido";
    public static final String VALOR_FCP_ST_RETIDO = "valorFCPStRetido";
    public static final String ALIQUOTA_FCP_ST_RETIDO = "aliquotaFCPStRetido";
    public static final String VALOR_ICMS_DIFERIMENTO = "valorIcmsDiferimento";
    public static final String PERC_DIFERIMENTO = "percentualDiferimento";
    private final EnumConstantsMentorSimNao incluirSeguroBC;
    private final EnumConstantsMentorSimNao incluirFreteBC;
    private final EnumConstantsMentorSimNao incluirDespAcessBC;
    private final EnumConstantsMentorSimNao incluirDescontoBC;
    private final Short tipoCalcST;
    private final EnumConstantsMentorSimNao incluirSeguroBCST;
    private final EnumConstantsMentorSimNao incluirFreteBCST;
    private final EnumConstantsMentorSimNao incluirDespAcessBCST;
    private final EnumConstantsMentorSimNao incluirDescontoBCST;
    private final EnumConstantsMentorSimNao incluirIPIBCST;
    private final EnumConstContrEstadoIcms contribuinteEstado;
    private final EnumConstantsMentorSimNao usarCategoriaST;
    private final Empresa empresa;
    private final CNAE cnae;
    private Date dataEmissao;
    private final VersaoNFe versaoNFe;
    private ServiceModeloFiscalICMSSTItemImpl serviceModeloFiscalICMSSTItem = (ServiceModeloFiscalICMSSTItemImpl)ConfApplicationContext.getBean(ServiceModeloFiscalICMSSTItemImpl.class);
    private ServiceUnidadeFederativaOrigDestImpl serviceUnidadeFederativaOrigemDest = (ServiceUnidadeFederativaOrigDestImpl)ConfApplicationContext.getBean(ServiceUnidadeFederativaOrigDestImpl.class);
    private ServiceAliquotaStImpl serviceAliquotaSt = (ServiceAliquotaStImpl)ConfApplicationContext.getBean(ServiceAliquotaStImpl.class);
    private ServiceDadosFiscaisUFImpl serviceDadosFiscaisUF = (ServiceDadosFiscaisUFImpl)ConfApplicationContext.getBean(ServiceDadosFiscaisUFImpl.class);

    public CalculoICMSSaiUtilities(EnumConstantsMentorSimNao incluirSeguroBC, EnumConstantsMentorSimNao incluirFreteBC, EnumConstantsMentorSimNao incluirDespAcessBC, EnumConstantsMentorSimNao incluirDescontoBC, Short tipoCalcST, Empresa empresa, CNAE cnae, EnumConstContrEstadoIcms contribuinteEstado, EnumConstantsMentorSimNao incluirSeguroBCST, EnumConstantsMentorSimNao incluirFreteBCST, EnumConstantsMentorSimNao incluirDespAcessBCST, EnumConstantsMentorSimNao incluirDescontoBCST, EnumConstantsMentorSimNao incluirIPIBCST, EnumConstantsMentorSimNao usarCategoriaST, Date dataEmissao, VersaoNFe versaoNFe) {
        this.incluirSeguroBC = incluirSeguroBC;
        this.incluirFreteBC = incluirFreteBC;
        this.incluirDespAcessBC = incluirDespAcessBC;
        this.incluirDescontoBC = incluirDescontoBC;
        this.tipoCalcST = tipoCalcST;
        this.contribuinteEstado = contribuinteEstado;
        this.empresa = empresa;
        this.cnae = cnae;
        this.incluirDescontoBCST = incluirDescontoBCST;
        this.incluirDespAcessBCST = incluirDespAcessBCST;
        this.incluirFreteBCST = incluirFreteBCST;
        this.incluirIPIBCST = incluirIPIBCST;
        this.incluirSeguroBCST = incluirSeguroBCST;
        this.usarCategoriaST = usarCategoriaST;
        this.dataEmissao = dataEmissao;
        this.versaoNFe = versaoNFe;
    }

    public HashMap valoresIcmsIcmsST(ModeloFiscalIcms modeloFiscalIcms, ModeloFiscalIpi modeloFiscalIpi, double valorImpImportacao, double valorPis, double valorCofins, Double valorIpiIndustria, Double valorIpiObservacao, Double aliquotaICMS, Double percRedICMS, Double indiceCalcBCImportacaoICMS, Produto produto, Double quantidadeTotal, UnidadeFederativa ufCliente, Double aliqICMSSimples, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, Short consumidorFinal, Short contribuinteEstado, EmpresaContabilidade empresaContabilidade, UnidadeFatCliente unidadeFatCliente, Short tipoCFOP, Double valorIpiDevolucao) throws Exception {
        IncidenciaIcms icms = modeloFiscalIcms.getIncidenciaIcms();
        double valorIPI = valorIpiIndustria + valorIpiObservacao + valorIpiDevolucao;
        HashMap<String, Object> h = new HashMap<String, Object>();
        h.put(ALIQUOTA_ICMS, aliquotaICMS);
        h.put(VALOR_ICMS, 0.0);
        h.put(ICMS_ISENTO, 0.0);
        h.put(ICMS_SEM_APROV, 0.0);
        h.put(INDICE_ALTERACAO_ST, 0.0);
        h.put(ALIQUOTA_ICMS_ST, 0.0);
        h.put(DESCONTO_PADRAO_ST, 0.0);
        h.put(BASE_CALCULO_ICMS_ST, 0.0);
        h.put(INDICE_ALTERACAO_ST, 0.0);
        h.put(VALOR_ICMS_ST, 0.0);
        h.put(ICMS_OUTROS, 0.0);
        h.put(ICMS_TRIBUTADO, 0.0);
        h.put(VALOR_BC_NAO_TRIB_ICMS, 0.0);
        h.put(ALIQUOTA_ICMS_SIMPLES, 0.0);
        h.put(VALOR_ICMS_SIMPLES, 0.0);
        h.put(VALOR_ICMS_DESONERADO, 0.0);
        h.put(BC_ICMS_UF_DEST, 0.0);
        h.put(VR_ICMS_UF_DEST, 0.0);
        h.put(VR_ICMS_UF_REM, 0.0);
        h.put(ALIQ_INTERNA_UF_DEST, 0.0);
        h.put(ALIQ_INTERESTADUAL, 0.0);
        h.put(PERC_PARTILHA_ICMS, 0.0);
        h.put(ALIQ_FUNDO_POBREZA, 0.0);
        h.put(VALOR_FUNDO_POBREZA, 0.0);
        h.put(ALIQUOTA_FCP, 0.0);
        h.put(ALIQUOTA_FCP_ST, 0.0);
        h.put(ALIQUOTA_FCP_ST_RETIDO, 0.0);
        h.put(VALOR_FCP, 0.0);
        h.put(VALOR_FCP_ST, 0.0);
        h.put(VALOR_FCP_ST_RETIDO, 0.0);
        h.put(BASE_CALCULO_FCP, 0.0);
        h.put(BASE_CALCULO_FCP_ST, 0.0);
        h.put(BASE_CALCULO_FCP_ST_RETIDO, 0.0);
        h.put(PERC_DIFERIMENTO, 0.0);
        h.put(VALOR_ICMS_DIFERIMENTO, 0.0);
        percRedICMS = percRedICMS == null ? 0.0 : percRedICMS;
        String cod = icms.getCodigo();
        cod = cod.substring(1);
        DadosFiscaisUF dadosFiscaisUF = this.getDAdosFiscaisUF(unidadeFatCliente, this.empresa);
        Double aliquotaFCP = 0.0;
        if (dadosFiscaisUF != null && dadosFiscaisUF.getCalcularFCP() != null && dadosFiscaisUF.getCalcularFCP().equals((short)1)) {
            aliquotaFCP = dadosFiscaisUF.getAliquotaFCP();
        } else if (dadosFiscaisUF != null && dadosFiscaisUF.getCalcularFCP() != null && dadosFiscaisUF.getCalcularFCP().equals((short)2)) {
            for (DadosFiscaisUFNcmFCP d : dadosFiscaisUF.getNcmsFCP()) {
                if (!d.getNcm().equals((Object)produto.getNcm())) continue;
                aliquotaFCP = d.getAliquotaFCP();
                break;
            }
        }
        if (cod.equalsIgnoreCase("00")) {
            this.calcularICMS00(modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, h, aliquotaICMS, percRedICMS, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, aliquotaFCP, quantidadeTotal);
        } else if (cod.equalsIgnoreCase("10")) {
            this.calcularICMS10(modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, h, aliquotaICMS, percRedICMS, quantidadeTotal, ufCliente, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, consumidorFinal, unidadeFatCliente, aliquotaFCP);
        } else if (cod.equalsIgnoreCase("20")) {
            this.calcularICMS20(modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, h, aliquotaICMS, percRedICMS, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, aliquotaFCP);
        } else if (cod.equalsIgnoreCase("30")) {
            this.calcularICMS30(modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, h, aliquotaICMS, percRedICMS, quantidadeTotal, ufCliente, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, consumidorFinal, unidadeFatCliente, aliquotaFCP);
        } else if (cod.equalsIgnoreCase("40")) {
            this.calcularICMS40(modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, h, aliquotaICMS, percRedICMS, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, quantidadeTotal);
        } else if (cod.equalsIgnoreCase("41")) {
            this.calcularICMS41(modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, h, aliquotaICMS, percRedICMS, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, quantidadeTotal);
        } else if (cod.equalsIgnoreCase("50")) {
            this.calcularICMS50(modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, h, aliquotaICMS, percRedICMS, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, quantidadeTotal);
        } else if (cod.equalsIgnoreCase("51")) {
            this.calcularICMS51(modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, h, aliquotaICMS, percRedICMS, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, aliquotaFCP, quantidadeTotal);
        } else if (cod.equalsIgnoreCase("60")) {
            this.calcularICMS60(modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, h, aliquotaICMS, percRedICMS, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, quantidadeTotal);
        } else if (cod.equalsIgnoreCase("61")) {
            this.calcularICMS61(modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, h, aliquotaICMS, percRedICMS, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, quantidadeTotal);
        } else if (cod.equalsIgnoreCase("70")) {
            this.calcularICMS70(modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, h, aliquotaICMS, percRedICMS, quantidadeTotal, ufCliente, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, consumidorFinal, unidadeFatCliente, aliquotaFCP);
        } else if (cod.equalsIgnoreCase("90")) {
            this.calcularICMS90(modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, h, aliquotaICMS, percRedICMS, quantidadeTotal, ufCliente, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, consumidorFinal, unidadeFatCliente, aliquotaFCP);
        } else if (cod.equalsIgnoreCase("101")) {
            this.calcularICMS101(modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, h, aliquotaICMS, percRedICMS, aliqICMSSimples, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, quantidadeTotal);
        } else if (cod.equalsIgnoreCase("102")) {
            this.calcularICMS102(modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, h, aliquotaICMS, percRedICMS, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI);
        } else if (cod.equalsIgnoreCase("103")) {
            this.calcularICMS103(modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, h, aliquotaICMS, percRedICMS, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, quantidadeTotal);
        } else if (cod.equalsIgnoreCase("201")) {
            this.calcularICMS201(modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, h, aliquotaICMS, percRedICMS, quantidadeTotal, ufCliente, aliqICMSSimples, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, consumidorFinal, unidadeFatCliente, aliquotaFCP);
        } else if (cod.equalsIgnoreCase("202")) {
            this.calcularICMS202(modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, h, aliquotaICMS, percRedICMS, quantidadeTotal, ufCliente, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, consumidorFinal, unidadeFatCliente, aliquotaFCP);
        } else if (cod.equalsIgnoreCase("203")) {
            this.calcularICMS203(modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, h, aliquotaICMS, percRedICMS, quantidadeTotal, ufCliente, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, consumidorFinal, unidadeFatCliente, aliquotaFCP);
        } else if (cod.equalsIgnoreCase("300")) {
            this.calcularICMS300(modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, h, aliquotaICMS, percRedICMS, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, quantidadeTotal);
        } else if (cod.equalsIgnoreCase("400")) {
            this.calcularICMS400(modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, h, aliquotaICMS, percRedICMS, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, quantidadeTotal);
        } else if (cod.equalsIgnoreCase("500")) {
            this.calcularICMS500(modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, h, aliquotaICMS, percRedICMS, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, quantidadeTotal);
        } else if (cod.equalsIgnoreCase("900")) {
            this.calcularICMS900(modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, h, aliquotaICMS, percRedICMS, aliqICMSSimples, quantidadeTotal, ufCliente, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, consumidorFinal, unidadeFatCliente, aliquotaFCP);
        } else {
            throw new Exception("O sistema n\u00c3\u00a3o contempla este tipo de ICMS no faturamento.");
        }
        if (empresaContabilidade != null) {
            Double valorIcmsNaoTrib;
            if (empresaContabilidade.getEmbutirIpiIcmsOutros().equals((short)1) && modeloFiscalIpi.getIpiCompoeBcIcms().equals((short)0)) {
                h.put(ICMS_OUTROS, (Double)h.get(ICMS_OUTROS) + valorIPI);
            }
            if (ToolMethods.isEquals((Object)this.incluirDespAcessBC, (Object)0) && valorDespAcess > 0.0) {
                valorIcmsNaoTrib = (Double)h.get(ICMS_OUTROS);
                h.put(ICMS_OUTROS, valorIcmsNaoTrib + valorDespAcess);
            }
            if (ToolMethods.isEquals((Object)this.incluirFreteBC, (Object)0) && valorFrete > 0.0) {
                valorIcmsNaoTrib = (Double)h.get(ICMS_OUTROS);
                h.put(ICMS_OUTROS, valorIcmsNaoTrib + valorFrete);
            }
            if (ToolMethods.isEquals((Object)this.incluirSeguroBC, (Object)0) && valorSeguro > 0.0) {
                valorIcmsNaoTrib = (Double)h.get(ICMS_OUTROS);
                h.put(ICMS_OUTROS, valorIcmsNaoTrib + valorSeguro);
            }
        }
        Double percentualPartilha = this.getPercentualPartilhaIcms();
        if (dadosFiscaisUF != null && dadosFiscaisUF.getCalcularFCP() != null && dadosFiscaisUF.getCalcularFCP().equals((short)3)) {
            aliquotaFCP = dadosFiscaisUF.getAliquotaFCP();
        }
        this.calcularIcmsPartilha(produto, this.empresa.getPessoa().getEndereco().getCidade().getUf(), ufCliente, percentualPartilha, consumidorFinal, h, contribuinteEstado, aliquotaICMS, cod, aliquotaFCP, EnumConstModFiscalDifal.get((Object)modeloFiscalIcms.getTipoCalculoDifal()), modeloFiscalIcms.getEntradaSaida());
        this.calcularIcmsDesoneradoSuframa(modeloFiscalIcms, modeloFiscalIpi, unidadeFatCliente, vrProdServ, h, produto.getNaoAplicaSuframa(), valorFrete, valorSeguro, valorDespAcess, valorDesconto, valorIPI, tipoCFOP, produto, quantidadeTotal);
        return h;
    }

    private void calcularICMS00(ModeloFiscalIcms modeloFiscalIcms, ModeloFiscalIpi modeloFiscalIpi, Short tipoCFOP, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double valorIPI, double aliquotaFCP, double quantidadeTotal) {
        double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, valorIPI, modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, quantidadeTotal);
        double vlrIcms = ToolFormatter.arrredondarNumero((Double)(baseCalculo * (aliquotaICMS / 100.0)), (int)2);
        h.put(ICMS_TRIBUTADO, baseCalculo);
        h.put(VALOR_ICMS, vlrIcms);
        h.put(ALIQUOTA_ICMS, aliquotaICMS);
        h.put(BASE_CALCULO_ICMS, baseCalculo);
        this.calcularFCP(aliquotaFCP, vlrIcms, baseCalculo, h, modeloFiscalIcms.getNaoCalcularFCP());
    }

    private void calcularICMS10(ModeloFiscalIcms modeloFiscalIcms, ModeloFiscalIpi modeloFiscalIpi, Short tipoCFOP, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, Double quantidadeTotal, UnidadeFederativa ufCliente, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double valorIPI, Short consumidorFinal, UnidadeFatCliente unidadeFatCliente, double aliquotaFCP) throws Exception {
        double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, valorIPI, modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, quantidadeTotal);
        double vlrIcms = ToolFormatter.arrredondarNumero((Double)(baseCalculo * (aliquotaICMS / 100.0)), (int)2);
        h.put(ICMS_TRIBUTADO, baseCalculo);
        h.put(VALOR_ICMS, vlrIcms);
        h.put(ALIQUOTA_ICMS, aliquotaICMS);
        h.put(BASE_CALCULO_ICMS, baseCalculo);
        this.calcularFCP(aliquotaFCP, vlrIcms, baseCalculo, h, modeloFiscalIcms.getNaoCalcularFCP());
        this.calcularIcmsDifalST(baseCalculo + valorDesconto, vlrIcms, modeloFiscalIcms, produto, quantidadeTotal, ufCliente, h, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, consumidorFinal, modeloFiscalIcms.getReducaoBaseCalcIcmsST(), unidadeFatCliente, aliquotaFCP);
    }

    private void calcularICMS20(ModeloFiscalIcms modeloFiscalIcms, ModeloFiscalIpi modeloFiscalIpi, Short tipoCFOP, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double valorIPI, double aliquotaFCP) {
        double baseCalculo = vrProdServ;
        if (modeloFiscalIpi.getIpiCompoeBcIcms() != null && modeloFiscalIpi.getIpiCompoeBcIcms() == 1) {
            baseCalculo += valorIPI;
        }
        if (this.incluirDescontoBC == null || this.incluirDescontoBC == EnumConstantsMentorSimNao.SIM) {
            baseCalculo -= valorDesconto;
        }
        double bcAcess = 0.0;
        if (this.incluirDespAcessBC == null || this.incluirDespAcessBC == EnumConstantsMentorSimNao.SIM) {
            bcAcess += valorDespAcess;
        }
        if (this.incluirFreteBC == null || this.incluirFreteBC == EnumConstantsMentorSimNao.SIM) {
            bcAcess += valorFrete;
        }
        if (this.incluirSeguroBC == null || this.incluirSeguroBC == EnumConstantsMentorSimNao.SIM) {
            bcAcess += valorSeguro;
        }
        if (ToolMethods.isEquals((Object)modeloFiscalIcms.getIncluiDespAcessCalcRed(), (Object)1)) {
            baseCalculo += bcAcess;
            bcAcess = 0.0;
        }
        double vrReduz = ToolFormatter.arrredondarNumero((Double)(baseCalculo * (percRedICMS / 100.0)), (int)2);
        h.put(ICMS_TRIBUTADO, ToolFormatter.arrredondarNumero((Double)(baseCalculo + bcAcess - vrReduz), (int)2));
        h.put(ICMS_ISENTO, ToolFormatter.arrredondarNumero((Double)vrReduz, (int)2));
        if (modeloFiscalIcms.getIcmsDispensadoDesconto() != null && (modeloFiscalIcms.getIcmsDispensadoDesconto().equals((short)1) || modeloFiscalIcms.getIcmsDispensadoDesconto().equals((short)2))) {
            Double valorIcmsDesonerado = ToolFormatter.arrredondarNumero((Double)(vrReduz * (aliquotaICMS / 100.0)), (int)2);
            Double valorIcmsIsento = ToolFormatter.arrredondarNumero((Double)(vrReduz - valorIcmsDesonerado), (int)2);
            h.put(VALOR_ICMS_DESONERADO, valorIcmsDesonerado);
            h.put(ICMS_ISENTO, valorIcmsIsento);
        }
        Double vlrIcms = ToolFormatter.arrredondarNumero((Double)((baseCalculo - vrReduz) * (aliquotaICMS / 100.0)), (int)2) + ToolFormatter.arrredondarNumero((Double)(bcAcess * (aliquotaICMS / 100.0)), (int)2);
        h.put(VALOR_ICMS, vlrIcms);
        h.put(VALOR_BC_NAO_TRIB_ICMS, ToolFormatter.arrredondarNumero((Double)vrReduz, (int)2));
        h.put(ALIQUOTA_ICMS, aliquotaICMS);
        h.put(BASE_CALCULO_ICMS, baseCalculo + bcAcess);
        this.calcularFCP(aliquotaFCP, vlrIcms, baseCalculo + bcAcess - vrReduz, h, modeloFiscalIcms.getNaoCalcularFCP());
    }

    private void calcularICMS30(ModeloFiscalIcms modeloFiscalIcms, ModeloFiscalIpi modeloFiscalIpi, Short tipoCFOP, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, Double quantidadeTotal, UnidadeFederativa ufCliente, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double valorIPI, Short consumidorFinal, UnidadeFatCliente unidadeFatCliente, Double aliquotaFCP) throws Exception {
        double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, valorIPI, modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, quantidadeTotal);
        double vlrIcms = ToolFormatter.arrredondarNumero((Double)(baseCalculo * (aliquotaICMS / 100.0)), (int)2);
        h.put(ICMS_ISENTO, baseCalculo);
        h.put(ALIQUOTA_ICMS, 0.0);
        h.put(BASE_CALCULO_ICMS, baseCalculo);
        this.calcularIcmsDifalST(baseCalculo + valorDesconto, 0.0, modeloFiscalIcms, produto, quantidadeTotal, ufCliente, h, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, consumidorFinal, modeloFiscalIcms.getReducaoBaseCalcIcmsST(), unidadeFatCliente, aliquotaFCP);
    }

    private void calcularICMS40(ModeloFiscalIcms modeloFiscalIcms, ModeloFiscalIpi modeloFiscalIpi, Short tipoCFOP, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double valorIPI, double quantidadeTotal) {
        double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, valorIPI, modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, quantidadeTotal);
        h.put(BASE_CALCULO_ICMS, baseCalculo);
        h.put(ALIQUOTA_ICMS, 0.0);
        h.put(ICMS_ISENTO, baseCalculo);
    }

    private void calcularICMS41(ModeloFiscalIcms modeloFiscalIcms, ModeloFiscalIpi modeloFiscalIpi, Short tipoCFOP, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double valorIPI, double quantidadeTotal) {
        double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, valorIPI, modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, quantidadeTotal);
        h.put(BASE_CALCULO_ICMS, baseCalculo);
        h.put(ALIQUOTA_ICMS, 0.0);
        h.put(ICMS_ISENTO, baseCalculo);
    }

    private void calcularICMS50(ModeloFiscalIcms modeloFiscalIcms, ModeloFiscalIpi modeloFiscalIpi, Short tipoCFOP, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double valorIPI, double quantidadeTotal) {
        double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, valorIPI, modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, quantidadeTotal);
        h.put(BASE_CALCULO_ICMS, baseCalculo);
        h.put(ALIQUOTA_ICMS, 0.0);
        h.put(ICMS_OUTROS, baseCalculo);
    }

    private void calcularICMS51(ModeloFiscalIcms modeloFiscalIcms, ModeloFiscalIpi modeloFiscalIpi, Short tipoCFOP, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double valorIPI, double aliquotaFCP, double quantidadeTotal) {
        double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, valorIPI, modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, quantidadeTotal);
        Double percDiferimento = produto.getPercentualDiferimento();
        if (ToolMethods.isEquals((Object)modeloFiscalIcms.getTipoPercDiferimento(), (Object)2)) {
            percDiferimento = modeloFiscalIcms.getPercentualDiferimento();
        }
        if (percDiferimento == 0.0) {
            h.put(BASE_CALCULO_ICMS, baseCalculo);
            h.put(ALIQUOTA_ICMS, 0.0);
            h.put(ICMS_OUTROS, baseCalculo);
        } else {
            Double valorIcmsTotal = ToolFormatter.arrredondarNumero((Double)(baseCalculo * (aliquotaICMS / 100.0)), (int)2);
            Double valorIcms = ToolFormatter.arrredondarNumero((Double)(baseCalculo * (aliquotaICMS / 100.0)), (int)2);
            Double valorDiferimento = ToolFormatter.arrredondarNumero((Double)(valorIcms * (percDiferimento / 100.0)), (int)2);
            valorIcms = valorIcms - valorDiferimento;
            Double percBaseCalculoTrib = ToolFormatter.arrredondarNumero((Double)(valorIcms * 100.0 / valorIcmsTotal), (int)4);
            Double baseCalculoTrib = ToolFormatter.arrredondarNumero((Double)(baseCalculo * (percBaseCalculoTrib / 100.0)), (int)2);
            Double baseCalculoOutros = ToolFormatter.arrredondarNumero((Double)(baseCalculo - baseCalculoTrib), (int)2);
            h.put(BASE_CALCULO_ICMS, baseCalculo);
            h.put(ICMS_TRIBUTADO, baseCalculoTrib);
            h.put(ICMS_OUTROS, baseCalculoOutros);
            h.put(ALIQUOTA_ICMS, aliquotaICMS);
            h.put(VALOR_ICMS, valorIcms);
            h.put(PERC_DIFERIMENTO, percDiferimento);
            h.put(VALOR_ICMS_DIFERIMENTO, valorDiferimento);
            if (aliquotaFCP > 0.0) {
                h.put(VALOR_FCP, ToolFormatter.arrredondarNumero((Double)(baseCalculo * (aliquotaFCP / 100.0)), (int)2));
                h.put(ALIQUOTA_FCP, aliquotaFCP);
                h.put(BASE_CALCULO_FCP, baseCalculo);
            }
        }
    }

    private void calcularICMS60(ModeloFiscalIcms modeloFiscalIcms, ModeloFiscalIpi modeloFiscalIpi, Short tipoCFOP, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double valorIPI, double quantidadeTotal) {
        double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, valorIPI, modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, quantidadeTotal);
        h.put(BASE_CALCULO_ICMS, baseCalculo);
        h.put(ALIQUOTA_ICMS, 0.0);
        h.put(ICMS_OUTROS, baseCalculo);
    }

    private void calcularICMS70(ModeloFiscalIcms modeloFiscalIcms, ModeloFiscalIpi modeloFiscalIpi, Short tipoCFOP, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, Double quantidadeTotal, UnidadeFederativa ufCliente, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double valorIPI, Short consumidorFinal, UnidadeFatCliente unidadeFatCliente, double aliquotaFCP) throws Exception {
        double baseCalculo = vrProdServ;
        if (this.incluirDescontoBC == null || this.incluirDescontoBC == EnumConstantsMentorSimNao.SIM) {
            baseCalculo -= valorDesconto;
        }
        double bcAcess = 0.0;
        if (this.incluirDespAcessBC == null || this.incluirDespAcessBC == EnumConstantsMentorSimNao.SIM) {
            bcAcess += valorDespAcess;
        }
        if (this.incluirFreteBC == null || this.incluirFreteBC == EnumConstantsMentorSimNao.SIM) {
            bcAcess += valorFrete;
        }
        if (this.incluirSeguroBC == null || this.incluirSeguroBC == EnumConstantsMentorSimNao.SIM) {
            bcAcess += valorSeguro;
        }
        if (ToolMethods.isEquals((Object)modeloFiscalIcms.getIncluiDespAcessCalcRed(), (Object)1)) {
            baseCalculo += bcAcess;
            bcAcess = 0.0;
        }
        double vrReduz = ToolFormatter.arrredondarNumero((Double)(baseCalculo * (percRedICMS / 100.0)), (int)2);
        double vlrIcms = 0.0;
        h.put(ICMS_TRIBUTADO, ToolFormatter.arrredondarNumero((Double)(baseCalculo + bcAcess - vrReduz), (int)2));
        h.put(BASE_CALCULO_ICMS, baseCalculo + bcAcess);
        h.put(ICMS_ISENTO, ToolFormatter.arrredondarNumero((Double)vrReduz, (int)2));
        if (modeloFiscalIcms.getTipoAliquotaIcms() != 0) {
            vlrIcms = ToolFormatter.arrredondarNumero((Double)((baseCalculo - vrReduz) * (aliquotaICMS / 100.0)), (int)2) + ToolFormatter.arrredondarNumero((Double)(bcAcess * (aliquotaICMS / 100.0)), (int)2);
            h.put(VALOR_ICMS, vlrIcms);
            h.put(VALOR_BC_NAO_TRIB_ICMS, ToolFormatter.arrredondarNumero((Double)vrReduz, (int)2));
            if (modeloFiscalIcms.getIcmsDispensadoDesconto() != null && (modeloFiscalIcms.getIcmsDispensadoDesconto().equals((short)1) || modeloFiscalIcms.getIcmsDispensadoDesconto().equals((short)2))) {
                Double valorIcmsDesonerado = ToolFormatter.arrredondarNumero((Double)(vrReduz * (aliquotaICMS / 100.0)), (int)2);
                Double valorIcmsIsento = ToolFormatter.arrredondarNumero((Double)(vrReduz - valorIcmsDesonerado), (int)2);
                h.put(VALOR_ICMS_DESONERADO, valorIcmsDesonerado);
                h.put(ICMS_ISENTO, valorIcmsIsento);
            }
            h.put(ALIQUOTA_ICMS, aliquotaICMS);
        } else {
            h.put(ALIQUOTA_ICMS, 0.0);
        }
        this.calcularFCP(aliquotaFCP, vlrIcms, baseCalculo + bcAcess - vrReduz, h, modeloFiscalIcms.getNaoCalcularFCP());
        this.calcularIcmsDifalST(vrProdServ, vlrIcms, modeloFiscalIcms, produto, quantidadeTotal, ufCliente, h, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, consumidorFinal, modeloFiscalIcms.getReducaoBaseCalcIcmsST(), unidadeFatCliente, aliquotaFCP);
    }

    private void calcularICMS90(ModeloFiscalIcms modeloFiscalIcms, ModeloFiscalIpi modeloFiscalIpi, Short tipoCFOP, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, Double quantidadeTotal, UnidadeFederativa ufCliente, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double valorIPI, Short consumidorFinal, UnidadeFatCliente unidadeFatCliente, double aliquotaFCP) throws Exception {
        if (modeloFiscalIcms.getTipoAliquotaIcms() != 0) {
            if (percRedICMS > 0.0) {
                this.calcularICMS20(modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, h, aliquotaICMS, percRedICMS, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, aliquotaFCP);
            } else {
                this.calcularICMS00(modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, h, aliquotaICMS, percRedICMS, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, aliquotaFCP, quantidadeTotal);
            }
        } else {
            double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, valorIPI, modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, quantidadeTotal);
            double vlrIcms = baseCalculo * (aliquotaICMS / 100.0);
            h.put(BASE_CALCULO_ICMS, baseCalculo);
            h.put(ICMS_OUTROS, baseCalculo);
            if (modeloFiscalIcms.getIcmsDispensadoDesconto() != null && modeloFiscalIcms.getIcmsDispensadoDesconto().equals((short)1) && modeloFiscalIcms.getMotivoDesoneracaoIcms() != null) {
                Double valorIcmsDesonerado = ToolFormatter.arrredondarNumero((Double)vlrIcms, (int)2);
                Double valorIcmsOutros = ToolFormatter.arrredondarNumero((Double)(baseCalculo - valorIcmsDesonerado), (int)2);
                h.put(VALOR_ICMS_DESONERADO, valorIcmsDesonerado);
                h.put(ICMS_OUTROS, valorIcmsOutros);
                h.put(ALIQUOTA_ICMS, aliquotaICMS);
            } else {
                h.put(ALIQUOTA_ICMS, 0.0);
            }
        }
        Double baseCalculo = (Double)h.get(BASE_CALCULO_ICMS);
        Double vlrIcms = (Double)h.get(VALOR_ICMS);
        this.calcularIcmsDifalST(baseCalculo, vlrIcms, modeloFiscalIcms, produto, quantidadeTotal, ufCliente, h, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, consumidorFinal, modeloFiscalIcms.getReducaoBaseCalcIcmsST(), unidadeFatCliente, aliquotaFCP);
    }

    private void calcularIcmsDifalST(Double baseCalculo, Double valorIcms, ModeloFiscalIcms modeloFiscalIcms, Produto produto, Double quantidadeTotal, UnidadeFederativa ufCliente, HashMap h, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double valorIPI, Short consumidorFinal, Double percRedBCICMSSt, UnidadeFatCliente unidadeFatCliente, Double aliquotaFCP) throws Exception {
        EnumConstModFiscalDifalST tp = EnumConstModFiscalDifalST.get((Object)modeloFiscalIcms.getTipoTributacaoIcmsSt());
        if (tp == null || ToolMethods.isEquals((Object)tp, (Object)EnumConstModFiscalDifalST.TIPO_TRIB_ICMSST_NAO_INC_ICMSST)) {
            return;
        }
        if (ToolMethods.isEquals((Object)tp, (Object)EnumConstModFiscalDifalST.TIPO_TRIB_ICMSST_DIFAL_BASE_DUPLA)) {
            this.calcDifalSTBaseDupla(h, produto, ufCliente);
        } else if (ToolMethods.isEquals((Object)tp, (Object)EnumConstModFiscalDifalST.TIPO_TRIB_ICMSST_DIFAL_BASE_SIMPLES)) {
            this.calcDifalSTBaseSimples(h, produto, ufCliente);
        } else if (ToolMethods.isEquals((Object)tp, (Object)EnumConstModFiscalDifalST.TIPO_TRIB_ICMSST_CAT_INFORMADA) || ToolMethods.isEquals((Object)tp, (Object)EnumConstModFiscalDifalST.TIPO_TRIB_ICMSST_CAT_PRODUTO)) {
            this.calcularSt(tp, baseCalculo, valorIcms, modeloFiscalIcms, produto, quantidadeTotal, ufCliente, h, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, consumidorFinal, percRedBCICMSSt, unidadeFatCliente, aliquotaFCP);
        }
        Double bcST = (Double)h.get(BASE_CALCULO_ICMS_ST);
        this.calcularFCPSt(aliquotaFCP, bcST, h, modeloFiscalIcms.getNaoCalcularFCP());
    }

    private void calcularSt(EnumConstModFiscalDifalST tp, Double baseCalculo, Double valorIcms, ModeloFiscalIcms modeloFiscalIcms, Produto produto, Double quantidadeTotal, UnidadeFederativa ufCliente, HashMap h, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double valorIPI, Short consumidorFinal, Double percRedBCICMSSt, UnidadeFatCliente unidadeFatCliente, Double aliquotaFCP) throws Exception {
        double bcIcmsst = 0.0;
        bcIcmsst = modeloFiscalIcms.getCalcularIcmsPresumidoST() == null || modeloFiscalIcms.getCalcularIcmsPresumidoST().equals((short)0) || unidadeFatCliente == null ? this.getBCST(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, valorIPI, percRedBCICMSSt) : this.getBCSTPresumido(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, valorIPI, percRedBCICMSSt, unidadeFatCliente);
        if (modeloFiscalIcms.getModalidadeIcmsSt() != null && modeloFiscalIcms.getModalidadeIcmsSt().getCodigo().equalsIgnoreCase("0") && produto.getValorTabICMSST() <= 0.0) {
            throw new Exception("Foi selecionado no modelo fiscal valor tabelado para ICMS e/ou ICMS ST, porem o mesmo nao foi informado no cadastro do produto. Desta forma o valor calculado sera 0.");
        }
        if (this.tipoCalcST == null || this.tipoCalcST == 0) {
            this.putValoresSTAliquotaST(tp, h, produto, ufCliente, bcIcmsst, valorIcms, modeloFiscalIcms, vrProdServ, unidadeFatCliente);
        } else if (unidadeFatCliente != null) {
            this.putValoresSTModeloFiscalST(tp, h, produto, ufCliente, bcIcmsst, valorIcms, modeloFiscalIcms, consumidorFinal, unidadeFatCliente.getCategoriaPessoa());
        }
        Double bcST = (Double)h.get(BASE_CALCULO_ICMS_ST);
        this.calcularFCPSt(aliquotaFCP, bcST, h, modeloFiscalIcms.getNaoCalcularFCP());
    }

    private void putValoresSTModeloFiscalST(EnumConstModFiscalDifalST tp, HashMap h, Produto produto, UnidadeFederativa uf, double bcIcmsst, double valorIcms, ModeloFiscalIcms modeloFiscalIcms, Short consumidorFinal, CategoriaPessoa categoriaPessoa) throws Exception {
        Integer codigo;
        CategoriaSt cat = produto.getCategoriaSutr();
        if (ToolMethods.isEquals((Object)tp, (Object)EnumConstModFiscalDifalST.TIPO_TRIB_ICMSST_CAT_INFORMADA) && modeloFiscalIcms.getCategoriaST() != null) {
            cat = modeloFiscalIcms.getCategoriaST();
        }
        if (this.usarCategoriaST != null && this.usarCategoriaST == EnumConstantsMentorSimNao.SIM && cat == null) {
            throw new Exception("Foi informado que o ICMSST ser\u00c3\u00a1 calculado pela categoria de ST, mas a mesma n\u00c3\u00a3o foi informado no modelo fiscal ou no produto.");
        }
        ModeloFiscalICMSSTItem mod = this.getModeloFiscalItem(produto, uf, modeloFiscalIcms.getIncidenciaIcms(), cat, EnumConstantsMentorSimNao.get((Object)consumidorFinal));
        if (mod == null && (codigo = Integer.valueOf(Integer.parseInt(modeloFiscalIcms.getIncidenciaIcms().getCodigo()))) != 90 && codigo != 190 && codigo != 290 && codigo != 900) {
            StringBuilder sb = new StringBuilder();
            sb.append("Modelo Fiscal ICMS ST n\u00c3\u00a3o encontrado para:\n");
            if (this.cnae != null) {
                sb.append("CNAE:").append(this.cnae.getCodigo()).append("\n");
            } else {
                sb.append("CNAE:").append("N\u00c3\u00a3o informado no cadastro do cliente").append("\n");
            }
            if (cat != null) {
                sb.append("Categoria ST:").append(cat.getNome()).append("\n");
            } else {
                sb.append("Categoria ST:").append("N\u00c3\u00a3o informado no cadastro do modelo fiscal/produto").append("\n");
            }
            if (produto != null && produto.getNcm() != null) {
                sb.append("NCM:").append(produto.getNcm().getCodigo()).append("\n");
            } else {
                sb.append("NCM:").append("N\u00c3\u00a3o informado no cadastro do produto").append("\n");
            }
            sb.append("UF:").append(uf.getSigla()).append("\n");
            sb.append("Empresa:").append(this.empresa.getPessoa().getNome()).append("\n");
            sb.append("Incidencia ICMS:").append(modeloFiscalIcms.getIncidenciaIcms().getCodigo()).append("\n");
            sb.append("ConsumidorFinal:").append(this.getSimOrNao(consumidorFinal)).append("\n");
            throw new Exception(sb.toString());
        }
        h.put(INDICE_ALTERACAO_ST, mod.getIndiceAlteracao());
        h.put(ALIQUOTA_ICMS_ST, mod.getAliquotaIcms());
        h.put(DESCONTO_PADRAO_ST, mod.getDescontoPadrao());
        if (this.empresa.getEmpresaDados().getRegimeTributario().getCodigo() == 1 || this.empresa.getEmpresaDados().getRegimeTributario().getCodigo() == 2) {
            valorIcms = modeloFiscalIcms.getAliquotaIcms() > 0.0 ? bcIcmsst * modeloFiscalIcms.getAliquotaIcms() / 100.0 : bcIcmsst * produto.getAliquotaIcms() / 100.0;
        }
        if (mod.getIndiceAlteracao() > 0.0) {
            bcIcmsst = ToolFormatter.arrredondarNumero((Double)(bcIcmsst * mod.getIndiceAlteracao()), (int)2);
        }
        Double bcSt = ToolFormatter.arrredondarNumero((Double)(bcIcmsst - bcIcmsst * (mod.getDescontoPadrao() / 100.0)), (int)2);
        Double valorSt = bcSt * (mod.getAliquotaIcms() / 100.0) - valorIcms;
        if (modeloFiscalIcms.getCalcularIcmsPresumidoST().equals((short)1)) {
            Double aliquotaIcms = this.getAliquotaICMS(this.empresa.getPessoa().getEndereco().getCidade().getUf(), uf);
            valorSt = valorSt - (bcIcmsst - bcIcmsst * (aliquotaIcms / 100.0));
        }
        if (valorSt < 0.0) {
            valorSt = 0.0;
        }
        h.put(BASE_CALCULO_ICMS_ST, ToolFormatter.arrredondarNumero((Double)bcSt, (int)2));
        h.put(VALOR_ICMS_ST, ToolFormatter.arrredondarNumero((Double)valorSt, (int)2));
        h.put(ICMS_OUTROS, ToolFormatter.arrredondarNumero((Double)valorSt, (int)2));
    }

    private void putValoresSTAliquotaST(EnumConstModFiscalDifalST tp, HashMap<String, Object> h, Produto produto, UnidadeFederativa ufCliente, Double bcIcmsst, Double valorIcms, ModeloFiscalIcms modeloFiscalIcms, Double vrProdServ, UnidadeFatCliente unidadeFatCliente) throws Exception {
        block6: {
            try {
                CategoriaSt cat = produto.getCategoriaSutr();
                if (ToolMethods.isEquals((Object)tp, (Object)EnumConstModFiscalDifalST.TIPO_TRIB_ICMSST_CAT_INFORMADA)) {
                    cat = modeloFiscalIcms.getCategoriaST();
                }
                if (cat == null) {
                    throw new Exception("N\u00ef\u00bf\u00bdo foi encontrado nenhuma Categoria de Substiui\u00ef\u00bf\u00bd\u00ef\u00bf\u00bdo Tribut\u00ef\u00bf\u00bdria para o produto:  " + produto.getNome() + ". Verifique seu cadastro.");
                }
                AliquotaSt al = this.procurarAliquotaSt(cat, ufCliente);
                h.put(INDICE_ALTERACAO_ST, al.getIndiceAlteracao());
                h.put(ALIQUOTA_ICMS_ST, al.getAliquotaIcms());
                h.put(DESCONTO_PADRAO_ST, al.getDescontoPadrao());
                Double bcSt = ToolFormatter.arrredondarNumero((Double)(bcIcmsst * al.getIndiceAlteracao() - bcIcmsst * (al.getDescontoPadrao() / 100.0)), (int)2);
                Double valorSt = bcSt * (al.getAliquotaIcms() / 100.0) - valorIcms;
                if (modeloFiscalIcms.getCalcularIcmsPresumidoST().equals((short)1)) {
                    Double aliquotaIcms = this.getAliquotaICMS(this.empresa.getPessoa().getEndereco().getCidade().getUf(), ufCliente);
                    Double bc = this.getBCAbatendoSomentePisCofins(vrProdServ, unidadeFatCliente);
                    valorSt = valorSt - ToolFormatter.arrredondarNumero((Double)(bc * (aliquotaIcms / 100.0)), (int)2);
                }
                if (valorSt < 0.0) {
                    valorSt = 0.0;
                }
                h.put(BASE_CALCULO_ICMS_ST, ToolFormatter.arrredondarNumero((Double)bcSt, (int)2));
                h.put(VALOR_ICMS_ST, ToolFormatter.arrredondarNumero((Double)valorSt, (int)2));
                h.put(ICMS_OUTROS, ToolFormatter.arrredondarNumero((Double)valorSt, (int)2));
            }
            catch (Exception ex) {
                Integer codigo = Integer.parseInt(modeloFiscalIcms.getIncidenciaIcms().getCodigo());
                if (codigo == 90 || codigo == 190 || codigo == 290 || codigo == 900) break block6;
                throw ex;
            }
        }
    }

    private ModeloFiscalICMSSTItem getModeloFiscalItem(Produto produto, UnidadeFederativa uf, IncidenciaIcms inc, CategoriaSt cat, EnumConstantsMentorSimNao consumidorFinal) throws Exception {
        return this.serviceModeloFiscalICMSSTItem.get(produto.getNcm(), uf, this.empresa, this.cnae, inc, this.contribuinteEstado, this.usarCategoriaST, cat, consumidorFinal);
    }

    private void calcularICMS101(ModeloFiscalIcms modeloFiscalIcms, ModeloFiscalIpi modeloFiscalIpi, Short tipoCFOP, Produto produto, HashMap<String, Object> h, Double aliquotaICMS, Double percRedICMS, Double aliqICMSSimples, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double valorIPI, double quantidadeTotal) {
        double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, valorIPI, modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, quantidadeTotal);
        h.put(BASE_CALCULO_ICMS, baseCalculo);
        h.put(ICMS_OUTROS, baseCalculo);
        h.put(ALIQUOTA_ICMS_SIMPLES, aliqICMSSimples);
        h.put(VALOR_ICMS_SIMPLES, baseCalculo * (aliqICMSSimples / 100.0));
        h.put(ALIQUOTA_ICMS, 0.0);
    }

    private void calcularICMS102(ModeloFiscalIcms modeloFiscalIcms, ModeloFiscalIpi modeloFiscalIpi, Short tipoCFOP, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double baseCalculo) {
        h.put(BASE_CALCULO_ICMS, baseCalculo);
        h.put(ICMS_OUTROS, baseCalculo);
        h.put(ALIQUOTA_ICMS_SIMPLES, 0.0);
        h.put(VALOR_ICMS_SIMPLES, 0.0);
        h.put(ALIQUOTA_ICMS, 0.0);
    }

    private void calcularICMS103(ModeloFiscalIcms modeloFiscalIcms, ModeloFiscalIpi modeloFiscalIpi, Short tipoCFOP, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double valorIPI, double quantidadeTotal) {
        double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, valorIPI, modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, quantidadeTotal);
        h.put(BASE_CALCULO_ICMS, baseCalculo);
        h.put(ICMS_OUTROS, baseCalculo);
        h.put(ALIQUOTA_ICMS_SIMPLES, 0.0);
        h.put(VALOR_ICMS_SIMPLES, 0.0);
        h.put(ALIQUOTA_ICMS, 0.0);
    }

    private void calcularICMS201(ModeloFiscalIcms modeloFiscalIcms, ModeloFiscalIpi modeloFiscalIpi, Short tipoCFOP, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, Double quantidadeTotal, UnidadeFederativa ufCliente, Double aliqICMSSimples, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double valorIPI, Short consumidorFinal, UnidadeFatCliente unidadeFatCliente, Double aliquotaFCP) throws Exception {
        double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, valorIPI, modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, quantidadeTotal);
        h.put(BASE_CALCULO_ICMS, baseCalculo);
        h.put(ICMS_OUTROS, baseCalculo);
        h.put(ALIQUOTA_ICMS, 0.0);
        UnidadeFederativa ufOrigem = this.empresa.getPessoa().getEndereco().getCidade().getUf();
        UnidadeFederativa ufDestino = ufCliente;
        aliquotaICMS = !ufOrigem.equals((Object)ufDestino) ? this.getAliquotaICMS(ufOrigem, ufDestino, produto) : produto.getAliquotaIcms();
        Double valorIcms = baseCalculo * (aliquotaICMS / 100.0);
        this.calcularIcmsDifalST(baseCalculo + valorDesconto, valorIcms, modeloFiscalIcms, produto, quantidadeTotal, ufCliente, h, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, consumidorFinal, modeloFiscalIcms.getReducaoBaseCalcIcmsST(), unidadeFatCliente, aliquotaFCP);
    }

    private void calcularICMS202(ModeloFiscalIcms modeloFiscalIcms, ModeloFiscalIpi modeloFiscalIpi, Short tipoCFOP, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, Double quantidadeTotal, UnidadeFederativa ufCliente, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double valorIPI, Short consumidorFinal, UnidadeFatCliente unidadeFatCliente, Double aliquotaFCP) throws Exception {
        double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, valorIPI, modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, quantidadeTotal);
        h.put(BASE_CALCULO_ICMS, baseCalculo);
        h.put(ICMS_OUTROS, baseCalculo);
        h.put(ALIQUOTA_ICMS_SIMPLES, 0.0);
        h.put(VALOR_ICMS_SIMPLES, 0.0);
        h.put(ALIQUOTA_ICMS, 0.0);
        UnidadeFederativa ufOrigem = this.empresa.getPessoa().getEndereco().getCidade().getUf();
        UnidadeFederativa ufDestino = ufCliente;
        aliquotaICMS = !ufOrigem.equals((Object)ufDestino) ? this.getAliquotaICMS(ufOrigem, ufDestino, produto) : produto.getAliquotaIcms();
        Double valorIcms = baseCalculo * (aliquotaICMS / 100.0);
        this.calcularIcmsDifalST(baseCalculo + valorDesconto, valorIcms, modeloFiscalIcms, produto, quantidadeTotal, ufCliente, h, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, consumidorFinal, modeloFiscalIcms.getReducaoBaseCalcIcmsST(), unidadeFatCliente, aliquotaFCP);
    }

    private void calcularICMS203(ModeloFiscalIcms modeloFiscalIcms, ModeloFiscalIpi modeloFiscalIpi, Short tipoCFOP, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, Double quantidadeTotal, UnidadeFederativa ufCliente, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double valorIPI, Short consumidorFinal, UnidadeFatCliente unidadeFatCliente, Double aliquotaFCP) throws Exception {
        double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, valorIPI, modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, quantidadeTotal);
        h.put(BASE_CALCULO_ICMS, baseCalculo);
        h.put(ICMS_OUTROS, baseCalculo);
        h.put(ALIQUOTA_ICMS_SIMPLES, 0.0);
        h.put(VALOR_ICMS_SIMPLES, 0.0);
        h.put(ALIQUOTA_ICMS, 0.0);
        UnidadeFederativa ufOrigem = this.empresa.getPessoa().getEndereco().getCidade().getUf();
        UnidadeFederativa ufDestino = ufCliente;
        aliquotaICMS = !ufOrigem.equals((Object)ufDestino) ? this.getAliquotaICMS(ufOrigem, ufDestino, produto) : produto.getAliquotaIcms();
        Double valorIcms = baseCalculo * (aliquotaICMS / 100.0);
        this.calcularIcmsDifalST(baseCalculo + valorDesconto, valorIcms, modeloFiscalIcms, produto, quantidadeTotal, ufCliente, h, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, consumidorFinal, modeloFiscalIcms.getReducaoBaseCalcIcmsST(), unidadeFatCliente, aliquotaFCP);
    }

    private void calcularICMS300(ModeloFiscalIcms modeloFiscalIcms, ModeloFiscalIpi modeloFiscalIpi, Short tipoCFOP, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double valorIPI, double quantidadeTotal) {
        double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, valorIPI, modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, quantidadeTotal);
        h.put(BASE_CALCULO_ICMS, baseCalculo);
        h.put(ICMS_ISENTO, baseCalculo);
        h.put(ALIQUOTA_ICMS_SIMPLES, 0.0);
        h.put(VALOR_ICMS_SIMPLES, 0.0);
        h.put(ALIQUOTA_ICMS, 0.0);
    }

    private void calcularICMS400(ModeloFiscalIcms modeloFiscalIcms, ModeloFiscalIpi modeloFiscalIpi, Short tipoCFOP, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double valorIPI, double quantidadeTotal) {
        double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, valorIPI, modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, quantidadeTotal);
        h.put(BASE_CALCULO_ICMS, baseCalculo);
        h.put(ICMS_ISENTO, baseCalculo);
        h.put(ALIQUOTA_ICMS_SIMPLES, 0.0);
        h.put(VALOR_ICMS_SIMPLES, 0.0);
        h.put(ALIQUOTA_ICMS, 0.0);
    }

    private void calcularICMS500(ModeloFiscalIcms modeloFiscalIcms, ModeloFiscalIpi modeloFiscalIpi, Short tipoCFOP, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double valorIPI, double quantidadeTotal) {
        double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, valorIPI, modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, quantidadeTotal);
        h.put(BASE_CALCULO_ICMS, baseCalculo);
        h.put(ICMS_OUTROS, baseCalculo);
        h.put(ALIQUOTA_ICMS_SIMPLES, 0.0);
        h.put(VALOR_ICMS_SIMPLES, 0.0);
        h.put(ALIQUOTA_ICMS, 0.0);
    }

    private void calcularICMS900(ModeloFiscalIcms modeloFiscalIcms, ModeloFiscalIpi modeloFiscalIpi, Short tipoCFOP, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, Double aliqICMSSimples, Double quantidadeTotal, UnidadeFederativa ufCliente, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double valorIPI, Short consumidorFinal, UnidadeFatCliente unidadeFatCliente, Double aliquotaFCP) throws Exception {
        double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, valorIPI, modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, quantidadeTotal);
        h.put(BASE_CALCULO_ICMS, baseCalculo);
        h.put(ICMS_OUTROS, baseCalculo);
        if (modeloFiscalIcms.getCalcularIcmsSimples() != null && modeloFiscalIcms.getCalcularIcmsSimples() == 1) {
            h.put(ALIQUOTA_ICMS_SIMPLES, aliqICMSSimples);
            h.put(VALOR_ICMS_SIMPLES, baseCalculo * (aliqICMSSimples / 100.0));
        } else {
            h.put(ALIQUOTA_ICMS_SIMPLES, 0.0);
            h.put(VALOR_ICMS_SIMPLES, 0.0);
        }
        h.put(ALIQUOTA_ICMS, 0.0);
        if (this.incluirDescontoBC == null || this.incluirDescontoBC == EnumConstantsMentorSimNao.SIM) {
            baseCalculo -= valorDesconto;
        }
        double bcAcess = 0.0;
        if (this.incluirDespAcessBC == null || this.incluirDespAcessBC == EnumConstantsMentorSimNao.SIM) {
            bcAcess += valorDespAcess;
        }
        if (this.incluirFreteBC == null || this.incluirFreteBC == EnumConstantsMentorSimNao.SIM) {
            bcAcess += valorFrete;
        }
        if (this.incluirSeguroBC == null || this.incluirSeguroBC == EnumConstantsMentorSimNao.SIM) {
            bcAcess += valorSeguro;
        }
        if (ToolMethods.isEquals((Object)modeloFiscalIcms.getIncluiDespAcessCalcRed(), (Object)1)) {
            baseCalculo += bcAcess;
            bcAcess = 0.0;
        }
        double vlrIcms = 0.0;
        if (modeloFiscalIcms.getTipoAliquotaIcms() != 0) {
            if (percRedICMS > 0.0) {
                double vrReduz = ToolFormatter.arrredondarNumero((Double)(baseCalculo * (percRedICMS / 100.0)), (int)2);
                h.put(ICMS_OUTROS, baseCalculo + bcAcess);
                h.put(BASE_CALCULO_ICMS, baseCalculo + bcAcess);
                if (modeloFiscalIcms.getTipoAliquotaIcms() != 0) {
                    vlrIcms = ToolFormatter.arrredondarNumero((Double)((baseCalculo - vrReduz) * (aliquotaICMS / 100.0)), (int)2) + ToolFormatter.arrredondarNumero((Double)(bcAcess * (aliquotaICMS / 100.0)), (int)2);
                    h.put(VALOR_ICMS, vlrIcms);
                    h.put(VALOR_BC_NAO_TRIB_ICMS, ToolFormatter.arrredondarNumero((Double)vrReduz, (int)2));
                    if (modeloFiscalIcms.getIcmsDispensadoDesconto() != null && (modeloFiscalIcms.getIcmsDispensadoDesconto().equals((short)1) || modeloFiscalIcms.getIcmsDispensadoDesconto().equals((short)2))) {
                        Double valorIcmsDesonerado = ToolFormatter.arrredondarNumero((Double)(vrReduz * (aliquotaICMS / 100.0)), (int)2);
                        Double valorIcmsNaoTrib = ToolFormatter.arrredondarNumero((Double)(vrReduz - valorIcmsDesonerado), (int)2);
                        h.put(VALOR_ICMS_DESONERADO, valorIcmsDesonerado);
                        h.put(VALOR_BC_NAO_TRIB_ICMS, valorIcmsNaoTrib);
                    }
                    h.put(ALIQUOTA_ICMS, aliquotaICMS);
                } else {
                    h.put(ALIQUOTA_ICMS, 0.0);
                }
            } else {
                vlrIcms = baseCalculo * (aliquotaICMS / 100.0);
                h.put(ICMS_OUTROS, baseCalculo);
                h.put(BASE_CALCULO_ICMS, baseCalculo);
                h.put(VALOR_ICMS, vlrIcms);
                h.put(ALIQUOTA_ICMS, aliquotaICMS);
            }
        } else {
            h.put(BASE_CALCULO_ICMS, baseCalculo);
            h.put(ICMS_OUTROS, baseCalculo);
            h.put(ALIQUOTA_ICMS, 0.0);
            h.put(VALOR_ICMS, 0.0);
            h.put(percRedICMS, 0.0);
        }
        UnidadeFederativa ufOrigem = this.empresa.getPessoa().getEndereco().getCidade().getUf();
        UnidadeFederativa ufDestino = ufCliente;
        aliquotaICMS = !ufOrigem.equals((Object)ufDestino) ? this.getAliquotaICMS(ufOrigem, ufDestino, produto) : produto.getAliquotaIcms();
        Double valorIcms = ToolFormatter.arrredondarNumero((Double)(baseCalculo * (aliquotaICMS / 100.0)), (int)2);
        this.calcularIcmsDifalST(baseCalculo + valorDesconto, valorIcms, modeloFiscalIcms, produto, quantidadeTotal, ufCliente, h, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, consumidorFinal, modeloFiscalIcms.getReducaoBaseCalcIcmsST(), unidadeFatCliente, aliquotaFCP);
    }

    public Double getAliquotaICMS(UnidadeFederativa ufOrigem, UnidadeFederativa ufDestino, Produto prod) throws Exception {
        if (prod == null) {
            return 0.0;
        }
        if (ufDestino.equals((Object)ufOrigem)) {
            return prod.getAliquotaIcms();
        }
        return this.getAliquotaICMS(ufOrigem, ufDestino);
    }

    public Double getAliquotaICMS(UnidadeFederativa ufOrigem, UnidadeFederativa ufDestino) throws Exception {
        UnidadeFederativaOrigDest found = this.serviceUnidadeFederativaOrigemDest.get(ufOrigem, ufDestino);
        if (found != null) {
            return found.getAliquotaICMS();
        }
        return 0.0;
    }

    private AliquotaSt procurarAliquotaSt(CategoriaSt cat, UnidadeFederativa ufCliente) throws Exception {
        AliquotaSt al = this.serviceAliquotaSt.get(cat, ufCliente);
        if (al == null) {
            throw new Exception("Al\u00c3\u00adquota de Substitui\u00c3\u00a7\u00c3\u00a3o Tribut\u00c3\u00a1ria n\u00c3\u00a3o encontrada para a Categoria " + (cat != null ? cat.getNome() : "") + " e UF " + ufCliente.getSigla());
        }
        return al;
    }

    private double getBC(double vrProdServ, double valorDesconto, double valorDespAcess, double valorFrete, double valorSeguro, double valorIPI, ModeloFiscalIcms modeloFiscalIcms, ModeloFiscalIpi modeloFiscalIpi, Short tipoCfop, Produto produto, Double quantidadeTotal) {
        double bc = vrProdServ;
        if (modeloFiscalIpi.getIpiCompoeBcIcms() == 1) {
            bc += valorIPI;
        }
        if (this.incluirDescontoBC == null || this.incluirDescontoBC == EnumConstantsMentorSimNao.SIM) {
            bc -= valorDesconto;
        }
        if (this.incluirDespAcessBC == null || this.incluirDespAcessBC == EnumConstantsMentorSimNao.SIM) {
            bc += valorDespAcess;
        }
        if (this.incluirFreteBC == null || this.incluirFreteBC == EnumConstantsMentorSimNao.SIM) {
            bc += valorFrete;
        }
        if (this.incluirSeguroBC == null || this.incluirSeguroBC == EnumConstantsMentorSimNao.SIM) {
            bc += valorSeguro;
        }
        if (tipoCfop == 2) {
            Double indice = modeloFiscalIcms.getIndiceCalcImportacao();
            if (indice == null || indice <= 0.0) {
                indice = 1.0;
            }
            bc /= indice.doubleValue();
        }
        if (modeloFiscalIcms.getModalidadeIcms() != null && ToolMethods.isEquals((Object)modeloFiscalIcms.getModalidadeIcms().getCodigo(), (Object)EnumConstModIcms.PAUTA.getValue())) {
            bc = produto.getValorTabICMS() * quantidadeTotal;
        }
        return bc;
    }

    private double getBCST(double vrProdServ, double valorDesconto, double valorDespAcess, double valorFrete, double valorSeguro, double valorIPI, Double percRedBCST) {
        double bcIcmsst = vrProdServ;
        if (this.incluirDescontoBCST != null && this.incluirDescontoBCST == EnumConstantsMentorSimNao.SIM) {
            bcIcmsst -= valorDesconto;
        }
        if (this.incluirDespAcessBCST != null && this.incluirDespAcessBCST == EnumConstantsMentorSimNao.SIM) {
            bcIcmsst += valorDespAcess;
        }
        if (this.incluirFreteBCST != null && this.incluirFreteBCST == EnumConstantsMentorSimNao.SIM) {
            bcIcmsst += valorFrete;
        }
        if (this.incluirSeguroBCST != null && this.incluirSeguroBCST == EnumConstantsMentorSimNao.SIM) {
            bcIcmsst += valorSeguro;
        }
        if (this.incluirIPIBCST != null && this.incluirIPIBCST == EnumConstantsMentorSimNao.SIM) {
            bcIcmsst += valorIPI;
        }
        if (percRedBCST != null && percRedBCST > 0.0) {
            bcIcmsst -= bcIcmsst * percRedBCST / 100.0;
        }
        return bcIcmsst;
    }

    private void calcularIcmsPartilha(Produto produto, UnidadeFederativa ufEmpresa, UnidadeFederativa ufCliente, Double percentualPartilha, Short consumidorFinal, HashMap h, Short contribuinteEstado, Double aliquotaIcms, String codigoIncidenciaIcms, Double aliquotaFCP, EnumConstModFiscalDifal tipoDifal, Short entradaSaida) throws Exception {
        if (ToolMethods.isEquals((Object)EnumConstModFiscalDifal.TIPO_DIFAL_NAO_CALCULAR.getValue(), (Object)tipoDifal.getValue())) {
            return;
        }
        if (consumidorFinal != null && consumidorFinal == 1 && !ufEmpresa.equals((Object)ufCliente) && !ufCliente.getSigla().equals("EX") && contribuinteEstado.equals(EnumConstContrEstadoIcms.NAO_CONTRIBUINTE.getEnumId())) {
            Double baseCalculo = (Double)h.get(ICMS_TRIBUTADO);
            Double vrIcms = (Double)h.get(VALOR_ICMS);
            if (vrIcms != null && vrIcms > 0.0) {
                Double aliqInternaDest = this.getAliquotaInternaUFDestinatario(produto, ufCliente);
                Double aliqInterestadual = aliquotaIcms;
                Double diferenca = Math.abs(aliqInternaDest - aliqInterestadual);
                if (diferenca >= 0.0 && ToolMethods.isEquals((Object)EnumConstModFiscalDifal.TIPO_DIFAL_CALCULAR.getValue(), (Object)tipoDifal.getValue())) {
                    Double valorIcmsACalcular = ToolFormatter.arrredondarNumero((Double)(baseCalculo * diferenca / 100.0), (int)2);
                    Double vrIcmsUFDest = ToolFormatter.arrredondarNumero((Double)(valorIcmsACalcular * percentualPartilha / 100.0), (int)2);
                    if (ToolMethods.isEquals((Object)entradaSaida, (Object)1)) {
                        h.put(VR_ICMS_UF_DEST, vrIcmsUFDest);
                        h.put(VR_ICMS_UF_REM, valorIcmsACalcular - vrIcmsUFDest);
                    } else {
                        h.put(VR_ICMS_UF_REM, vrIcmsUFDest);
                        h.put(VR_ICMS_UF_DEST, valorIcmsACalcular - vrIcmsUFDest);
                    }
                    h.put(BC_ICMS_UF_DEST, baseCalculo);
                    h.put(ALIQ_INTERNA_UF_DEST, aliqInternaDest);
                    h.put(ALIQ_INTERESTADUAL, aliqInterestadual);
                    h.put(PERC_PARTILHA_ICMS, percentualPartilha);
                    if (aliquotaFCP != null && aliquotaFCP > 0.0) {
                        h.put(ALIQ_FUNDO_POBREZA, aliquotaFCP);
                        h.put(VALOR_FUNDO_POBREZA, baseCalculo * (aliquotaFCP / 100.0));
                    }
                } else {
                    h.put(ALIQ_INTERESTADUAL, aliqInterestadual);
                    h.put(PERC_PARTILHA_ICMS, percentualPartilha);
                }
            } else if (codigoIncidenciaIcms.equals("101") || codigoIncidenciaIcms.equals("102") || codigoIncidenciaIcms.equals("103") || codigoIncidenciaIcms.equals("300") || codigoIncidenciaIcms.equals("400") || codigoIncidenciaIcms.equals("500")) {
                Double aliqInterestadual = this.getAliquotaICMS(ufEmpresa, ufCliente);
                h.put(BC_ICMS_UF_DEST, 0.0);
                h.put(ALIQ_INTERNA_UF_DEST, 0.0);
                h.put(ALIQ_INTERESTADUAL, aliqInterestadual);
                h.put(PERC_PARTILHA_ICMS, percentualPartilha);
                h.put(VR_ICMS_UF_DEST, 0.0);
                h.put(VR_ICMS_UF_REM, 0.0);
                if (aliquotaFCP != null && aliquotaFCP > 0.0) {
                    h.put(ALIQ_FUNDO_POBREZA, aliquotaFCP);
                    h.put(VALOR_FUNDO_POBREZA, baseCalculo * (aliquotaFCP / 100.0));
                }
            }
            h.put(ALIQUOTA_FCP, 0.0);
            h.put(ALIQUOTA_FCP_ST, 0.0);
            h.put(ALIQUOTA_FCP_ST_RETIDO, 0.0);
            h.put(VALOR_FCP, 0.0);
            h.put(VALOR_FCP_ST, 0.0);
            h.put(VALOR_FCP_ST_RETIDO, 0.0);
            h.put(BASE_CALCULO_FCP, 0.0);
            h.put(BASE_CALCULO_FCP_ST, 0.0);
            h.put(BASE_CALCULO_FCP_ST_RETIDO, 0.0);
        }
    }

    private Double getAliquotaInternaUFDestinatario(Produto produto, UnidadeFederativa ufCliente) throws Exception {
        List aliquotasUFNcm;
        List aliquotasUFProd = produto.getAliquotasUF();
        if (aliquotasUFProd != null) {
            for (ProdutoAliquotaUF aliqUF : aliquotasUFProd) {
                if (!aliqUF.getUf().equals((Object)ufCliente)) continue;
                return aliqUF.getAliquotaIcms();
            }
        }
        if ((aliquotasUFNcm = produto.getNcm().getAliquotasUF()) != null) {
            for (NcmAliquotaUF aliqUF : aliquotasUFNcm) {
                if (!aliqUF.getUf().equals((Object)ufCliente)) continue;
                return aliqUF.getAliquotaIcms();
            }
        }
        throw new Exception("Primeiro, cadastre a al\u00c3\u00adquota interestadual para o produto: " + produto.getIdentificador() + "-" + produto.getNome() + "  ou para o NCM: " + produto.getNcm().getCodigo());
    }

    private Double getPercentualPartilhaIcms() {
        int ano;
        if (this.dataEmissao == null) {
            this.dataEmissao = new Date();
        }
        if ((ano = ToolDate.yearFromDate((Object)this.dataEmissao).intValue()) < 2017) {
            return 40.0;
        }
        if (ano == 2017) {
            return 60.0;
        }
        if (ano == 2018) {
            return 80.0;
        }
        return 100.0;
    }

    private String getSimOrNao(Short consumidorFinal) {
        if (consumidorFinal.equals((short)1)) {
            return "Sim";
        }
        return "N\u00c3\u00a3o";
    }

    private double getBCSTPresumido(double vrProdServ, double valorDesconto, double valorDespAcess, double valorFrete, double valorSeguro, double valorIPI, Double percRedBCST, UnidadeFatCliente unidadeFatCliente) {
        double bcIcmsst = vrProdServ;
        if (unidadeFatCliente != null) {
            Double aliqPisSuf = unidadeFatCliente.getCliente().getFaturamento().getPercentualPisSufr();
            Double aliqCofinsSuf = unidadeFatCliente.getCliente().getFaturamento().getPercentualCofinsSufr();
            Double aliqIcmsSuf = unidadeFatCliente.getCliente().getFaturamento().getPercentualIcmsSufr();
            Double aliqIpiSuf = unidadeFatCliente.getCliente().getFaturamento().getPercentualIpiSufr();
            bcIcmsst = ToolFormatter.arrredondarNumero((Double)(bcIcmsst - bcIcmsst * ((aliqPisSuf + aliqCofinsSuf) / 100.0)), (int)2);
            bcIcmsst = ToolFormatter.arrredondarNumero((Double)(bcIcmsst - bcIcmsst * (aliqIcmsSuf / 100.0)), (int)2);
            bcIcmsst = ToolFormatter.arrredondarNumero((Double)(bcIcmsst + bcIcmsst * (aliqIpiSuf / 100.0)), (int)2);
        }
        if (this.incluirDescontoBCST != null && this.incluirDescontoBCST == EnumConstantsMentorSimNao.SIM) {
            bcIcmsst -= valorDesconto;
        }
        if (this.incluirDespAcessBCST != null && this.incluirDespAcessBCST == EnumConstantsMentorSimNao.SIM) {
            bcIcmsst += valorDespAcess;
        }
        if (this.incluirFreteBCST != null && this.incluirFreteBCST == EnumConstantsMentorSimNao.SIM) {
            bcIcmsst += valorFrete;
        }
        if (this.incluirSeguroBCST != null && this.incluirSeguroBCST == EnumConstantsMentorSimNao.SIM) {
            bcIcmsst += valorSeguro;
        }
        if (this.incluirIPIBCST != null && this.incluirIPIBCST == EnumConstantsMentorSimNao.SIM) {
            bcIcmsst += valorIPI;
        }
        if (percRedBCST != null && percRedBCST > 0.0) {
            bcIcmsst -= bcIcmsst * percRedBCST / 100.0;
        }
        return bcIcmsst;
    }

    private Double getBCAbatendoSomentePisCofins(Double vrProdServ, UnidadeFatCliente unidadeFatCliente) {
        double bcIcmsst = vrProdServ;
        Double aliqPisSuf = unidadeFatCliente.getCliente().getFaturamento().getPercentualPisSufr();
        Double aliqCofinsSuf = unidadeFatCliente.getCliente().getFaturamento().getPercentualCofinsSufr();
        bcIcmsst = ToolFormatter.arrredondarNumero((Double)(bcIcmsst - bcIcmsst * ((aliqPisSuf + aliqCofinsSuf) / 100.0)), (int)2);
        return bcIcmsst;
    }

    private DadosFiscaisUF getDAdosFiscaisUF(UnidadeFatCliente unidadeFatCliente, Empresa empresa) throws Exception {
        if (unidadeFatCliente != null) {
            return this.serviceDadosFiscaisUF.get(unidadeFatCliente.getPessoa().getEndereco().getCidade().getUf(), empresa);
        }
        return null;
    }

    private void calcularFCP(double aliquotaFCP, double vlrIcms, double baseCalculo, HashMap h, Short naoCalcularFCP) {
        if (this.versaoNFe.getCodigo().equals("4.00") && (naoCalcularFCP == null || naoCalcularFCP.equals((short)0)) && aliquotaFCP > 0.0 && vlrIcms > 0.0) {
            h.put(VALOR_FCP, ToolFormatter.arrredondarNumero((Double)(baseCalculo * (aliquotaFCP / 100.0)), (int)2));
            h.put(ALIQUOTA_FCP, aliquotaFCP);
            h.put(BASE_CALCULO_FCP, baseCalculo);
        }
    }

    private void calcularFCPSt(Double aliquotaFCP, Double bcST, HashMap h, Short naoCalcularFCP) {
        if (this.versaoNFe.getCodigo().equals("4.00") && (naoCalcularFCP == null || naoCalcularFCP.equals((short)0)) && bcST != null && bcST > 0.0 && aliquotaFCP > 0.0) {
            h.put(VALOR_FCP_ST, ToolFormatter.arrredondarNumero((Double)(bcST * (aliquotaFCP / 100.0)), (int)2));
            h.put(ALIQUOTA_FCP_ST, aliquotaFCP);
            h.put(BASE_CALCULO_FCP_ST, bcST);
            h.put(VALOR_FCP, 0.0);
            h.put(ALIQUOTA_FCP, 0.0);
            h.put(BASE_CALCULO_FCP, 0.0);
            h.put(VALOR_FCP_ST_RETIDO, 0.0);
            h.put(ALIQUOTA_FCP_ST_RETIDO, 0.0);
            h.put(BASE_CALCULO_FCP_ST_RETIDO, 0.0);
        }
    }

    private void calcDifalSTBaseSimples(HashMap values, Produto produto, UnidadeFederativa ufCliente) throws Exception {
        Double bcIcms = (Double)values.get(BASE_CALCULO_ICMS);
        Double aliqIcms = (Double)values.get(ALIQUOTA_ICMS);
        Double vlrIcms = (Double)values.get(VALOR_ICMS);
        Double aliqInternaDest = this.getAliquotaInternaUFDestinatario(produto, ufCliente);
        Double bcDifalST = bcIcms;
        Double vrDifalST = bcIcms * (aliqInternaDest - aliqIcms) / 100.0;
        values.put(VALOR_ICMS_ST, vrDifalST);
        values.put(BASE_CALCULO_ICMS_ST, bcDifalST);
    }

    private void calcDifalSTBaseDupla(HashMap values, Produto produto, UnidadeFederativa ufCliente) throws Exception {
        Double bcIcms = (Double)values.get(BASE_CALCULO_ICMS);
        Double aliqIcms = (Double)values.get(ALIQUOTA_ICMS);
        Double vlrIcms = (Double)values.get(VALOR_ICMS);
        Double aliqInternaDest = this.getAliquotaInternaUFDestinatario(produto, ufCliente);
        Double bcDifalST = (bcIcms - vlrIcms) / (1.0 - aliqIcms / 100.0);
        Double vrDifalST = bcDifalST * aliqInternaDest / 100.0 - vlrIcms;
        values.put(VALOR_ICMS_ST, vrDifalST);
        values.put(BASE_CALCULO_ICMS_ST, bcDifalST);
    }

    private void calcularIcmsDesoneradoSuframa(ModeloFiscalIcms modeloFiscalIcms, ModeloFiscalIpi modeloFiscalIpi, UnidadeFatCliente unidadeFatCliente, double vrProdServ, HashMap h, Short naoAplicaSuframaProduto, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double valorIPI, Short tipoCFOP, Produto produto, double quantidadeTotal) {
        Cliente vo = unidadeFatCliente.getCliente();
        double perc = 0.0;
        double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, valorIPI, modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, quantidadeTotal);
        if (vo != null && vo.getPessoa().getComplemento().getHabilitarSuframa() != null && vo.getPessoa().getComplemento().getHabilitarSuframa() == 1 && modeloFiscalIcms.getMotivoDesoneracaoIcms() != null && modeloFiscalIcms.getMotivoDesoneracaoIcms().getCodigo().equals("7") && (naoAplicaSuframaProduto == null || naoAplicaSuframaProduto.equals((short)0)) && vo.getFaturamento().getPercentualIcmsSufr() > 0.0) {
            perc = vo.getFaturamento().getPercentualIcmsSufr();
            h.put(VALOR_ICMS_DESONERADO, ToolFormatter.arrredondarNumero((Double)(perc / 100.0 * baseCalculo), (int)2));
        }
    }

    private void calcularICMS61(ModeloFiscalIcms modeloFiscalIcms, ModeloFiscalIpi modeloFiscalIpi, Short tipoCFOP, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, Double valorFrete, Double valorSeguro, Double valorDespAcess, Double valorDesconto, Double vrProdServ, Double valorIPI, Double quantidadeTotal) {
        double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, valorIPI, modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, quantidadeTotal);
        h.put(BASE_CALCULO_ICMS, baseCalculo);
        h.put(ALIQUOTA_ICMS, aliquotaICMS);
        h.put(ICMS_OUTROS, baseCalculo);
        h.put(VALOR_ICMS, 0.0);
    }
}

