/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.calculoimpostos;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import java.util.HashMap;

public class CalculoIPISaiUtilities {
    public static final String ALIQUOTA_IPI = "aliquotaIPI";
    public static final String IPI_INDUSTRIA = "ipiIndustria";
    public static final String IPI_ISENTO = "ipiIsento";
    public static final String IPI_OBSERVACAO = "ipiObservacao";
    public static final String IPI_COMERCIO = "ipiComercio";
    public static final String IPI_OUTROS = "ipiOutros";
    public static final String IPI_TRIBUTADO = "ipiTributado";
    private final Short incluirSeguroBC;
    private final Short incluirFreteBC;
    private final Short incluirDespAcessBC;
    private final Short incluirDescontoBC;

    public CalculoIPISaiUtilities(short incluirSeguroBC, short incluirFreteBC, short incluirDespAcessBC, short incluirDescontoBC) {
        this.incluirSeguroBC = incluirSeguroBC;
        this.incluirFreteBC = incluirFreteBC;
        this.incluirDespAcessBC = incluirDespAcessBC;
        this.incluirDescontoBC = incluirDescontoBC;
    }

    public HashMap calcularIpi(String codigoIPI, Produto produto, Double aliquotaIpi, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double qtdeTotal, Empresa emp) throws Exception {
        double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro);
        HashMap<String, Double> h = new HashMap<String, Double>();
        h.put(ALIQUOTA_IPI, 0.0);
        h.put(IPI_COMERCIO, 0.0);
        h.put(IPI_INDUSTRIA, 0.0);
        h.put(IPI_ISENTO, 0.0);
        h.put(IPI_OBSERVACAO, 0.0);
        h.put(IPI_OUTROS, 0.0);
        h.put(IPI_TRIBUTADO, 0.0);
        h.put(ALIQUOTA_IPI, aliquotaIpi);
        switch (Integer.valueOf(codigoIPI)) {
            case 0: {
                this.calcularIpi00(baseCalculo, produto, h, aliquotaIpi, vrProdServ, qtdeTotal, emp);
                break;
            }
            case 1: {
                this.calcularIpi01(baseCalculo, produto, h, aliquotaIpi, qtdeTotal);
                break;
            }
            case 2: {
                this.calcularIpi02(baseCalculo, produto, h, aliquotaIpi, qtdeTotal);
                break;
            }
            case 3: {
                this.calcularIpi03(baseCalculo, produto, h, aliquotaIpi, qtdeTotal);
                break;
            }
            case 4: {
                this.calcularIpi04(baseCalculo, produto, h, aliquotaIpi, qtdeTotal);
                break;
            }
            case 5: {
                this.calcularIpi05(baseCalculo, produto, h, aliquotaIpi, qtdeTotal);
                break;
            }
            case 49: {
                this.calcularIpi49(baseCalculo, produto, h, aliquotaIpi, qtdeTotal);
                break;
            }
            case 50: {
                this.calcularIpi50(baseCalculo, produto, h, aliquotaIpi, qtdeTotal);
                break;
            }
            case 51: {
                this.calcularIpi51(baseCalculo, produto, h, aliquotaIpi, qtdeTotal);
                break;
            }
            case 52: {
                this.calcularIpi52(baseCalculo, produto, h, aliquotaIpi, qtdeTotal);
                break;
            }
            case 53: {
                this.calcularIpi53(baseCalculo, produto, h, aliquotaIpi, qtdeTotal);
                break;
            }
            case 54: {
                this.calcularIpi54(baseCalculo, produto, h, aliquotaIpi, qtdeTotal);
                break;
            }
            case 55: {
                this.calcularIpi55(baseCalculo, produto, h, aliquotaIpi, qtdeTotal);
                break;
            }
            case 99: {
                this.calcularIpi99(baseCalculo, produto, h, aliquotaIpi, qtdeTotal);
            }
        }
        h.put(ALIQUOTA_IPI, ToolFormatter.arrredondarNumero((Double)((Double)h.get(ALIQUOTA_IPI)), (int)2));
        h.put(IPI_COMERCIO, ToolFormatter.arrredondarNumero((Double)((Double)h.get(IPI_COMERCIO)), (int)2));
        h.put(IPI_INDUSTRIA, ToolFormatter.arrredondarNumero((Double)((Double)h.get(IPI_INDUSTRIA)), (int)2));
        h.put(IPI_ISENTO, ToolFormatter.arrredondarNumero((Double)((Double)h.get(IPI_ISENTO)), (int)2));
        h.put(IPI_OBSERVACAO, ToolFormatter.arrredondarNumero((Double)((Double)h.get(IPI_OBSERVACAO)), (int)2));
        h.put(IPI_OUTROS, ToolFormatter.arrredondarNumero((Double)((Double)h.get(IPI_OUTROS)), (int)2));
        h.put(IPI_TRIBUTADO, ToolFormatter.arrredondarNumero((Double)((Double)h.get(IPI_TRIBUTADO)), (int)2));
        h.put(ALIQUOTA_IPI, aliquotaIpi);
        return h;
    }

    private void calcularIpi50(double baseCalculo, Produto produto, HashMap h, double aliquotaIpi, double qtdeTotal) {
        if (produto.getIpiTributadoQuantidade() == 0) {
            h.put(IPI_TRIBUTADO, baseCalculo);
            h.put(IPI_INDUSTRIA, baseCalculo * (aliquotaIpi / 100.0));
            h.put(ALIQUOTA_IPI, aliquotaIpi);
        } else {
            h.put(IPI_TRIBUTADO, baseCalculo);
            h.put(IPI_INDUSTRIA, baseCalculo * qtdeTotal);
            h.put(ALIQUOTA_IPI, 0.0);
        }
    }

    private void calcularIpi51(double baseCalculo, Produto produto, HashMap h, double aliquotaIpi, double qtdeTotal) {
        if (produto.getIpiTributadoQuantidade() == 0) {
            h.put(IPI_OUTROS, baseCalculo);
            h.put(ALIQUOTA_IPI, 0.0);
        } else {
            h.put(IPI_OUTROS, baseCalculo * qtdeTotal);
            h.put(ALIQUOTA_IPI, 0.0);
        }
    }

    private void calcularIpi52(double baseCalculo, Produto produto, HashMap h, double aliquotaIpi, double qtdeTotal) {
        if (produto.getIpiTributadoQuantidade() == 0) {
            h.put(IPI_ISENTO, baseCalculo);
            h.put(ALIQUOTA_IPI, 0.0);
        } else {
            h.put(IPI_ISENTO, baseCalculo * qtdeTotal);
            h.put(ALIQUOTA_IPI, 0.0);
        }
    }

    private void calcularIpi53(double baseCalculo, Produto produto, HashMap h, double aliquotaIpi, double qtdeTotal) {
        if (produto.getIpiTributadoQuantidade() == 0) {
            h.put(IPI_OUTROS, baseCalculo);
            h.put(ALIQUOTA_IPI, 0.0);
        } else {
            h.put(IPI_OUTROS, baseCalculo * qtdeTotal);
            h.put(ALIQUOTA_IPI, 0.0);
        }
    }

    private void calcularIpi54(double baseCalculo, Produto produto, HashMap h, double aliquotaIpi, double qtdeTotal) {
        if (produto.getIpiTributadoQuantidade() == 0) {
            h.put(IPI_OUTROS, baseCalculo);
            h.put(ALIQUOTA_IPI, 0.0);
        } else {
            h.put(IPI_OUTROS, baseCalculo * qtdeTotal);
            h.put(ALIQUOTA_IPI, 0.0);
        }
    }

    private void calcularIpi55(double baseCalculo, Produto produto, HashMap h, double aliquotaIpi, double qtdeTotal) {
        if (produto.getIpiTributadoQuantidade() == 0) {
            h.put(IPI_OUTROS, baseCalculo);
            h.put(ALIQUOTA_IPI, 0.0);
        } else {
            h.put(IPI_OUTROS, baseCalculo * qtdeTotal);
            h.put(ALIQUOTA_IPI, 0.0);
        }
    }

    private void calcularIpi99(double baseCalculo, Produto produto, HashMap h, double aliquotaIpi, double qtdeTotal) {
        if (produto.getIpiTributadoQuantidade() == 0) {
            h.put(IPI_OUTROS, baseCalculo);
            h.put(ALIQUOTA_IPI, 0.0);
        } else {
            h.put(IPI_OUTROS, baseCalculo * qtdeTotal);
            h.put(ALIQUOTA_IPI, 0.0);
        }
    }

    private void calcularIpi00(double baseCalculo, Produto produto, HashMap h, double aliquotaIpi, double valorProdServ, double qtdeTotal, Empresa emp) {
        if (produto.getIpiTributadoQuantidade() == 0) {
            h.put(IPI_TRIBUTADO, baseCalculo);
            h.put(IPI_INDUSTRIA, baseCalculo * (aliquotaIpi / 100.0));
            h.put(ALIQUOTA_IPI, aliquotaIpi);
        } else {
            h.put(IPI_TRIBUTADO, baseCalculo);
            h.put(IPI_INDUSTRIA, valorProdServ * qtdeTotal);
        }
    }

    private void calcularIpi01(double baseCalculo, Produto produto, HashMap h, double aliquotaIpi, double qtdeTotal) {
        if (produto.getIpiTributadoQuantidade() == 0) {
            h.put(IPI_OUTROS, baseCalculo);
            h.put(ALIQUOTA_IPI, 0.0);
        } else {
            h.put(IPI_OUTROS, qtdeTotal * baseCalculo);
            h.put(ALIQUOTA_IPI, 0.0);
        }
    }

    private void calcularIpi02(double baseCalculo, Produto produto, HashMap h, double aliquotaIpi, double qtdeTotal) {
        if (produto.getIpiTributadoQuantidade() == 0) {
            h.put(IPI_ISENTO, baseCalculo);
            h.put(ALIQUOTA_IPI, 0.0);
        } else {
            h.put(IPI_ISENTO, qtdeTotal * baseCalculo);
            h.put(ALIQUOTA_IPI, 0.0);
        }
    }

    private void calcularIpi03(double baseCalculo, Produto produto, HashMap h, double aliquotaIpi, double qtdeTotal) {
        if (produto.getIpiTributadoQuantidade() == 0) {
            h.put(IPI_OUTROS, baseCalculo);
            h.put(ALIQUOTA_IPI, 0.0);
        } else {
            h.put(IPI_OUTROS, qtdeTotal * baseCalculo);
            h.put(ALIQUOTA_IPI, 0.0);
        }
    }

    private void calcularIpi04(double baseCalculo, Produto produto, HashMap h, double aliquotaIpi, double qtdeTotal) {
        if (produto.getIpiTributadoQuantidade() == 0) {
            h.put(IPI_OUTROS, baseCalculo);
            h.put(ALIQUOTA_IPI, 0.0);
        } else {
            h.put(IPI_OUTROS, qtdeTotal * baseCalculo);
            h.put(ALIQUOTA_IPI, 0.0);
        }
    }

    private void calcularIpi05(double baseCalculo, Produto produto, HashMap h, double aliquotaIpi, double qtdeTotal) {
        if (produto.getIpiTributadoQuantidade() == 0) {
            h.put(IPI_OUTROS, baseCalculo);
            h.put(ALIQUOTA_IPI, 0.0);
        } else {
            h.put(IPI_OUTROS, qtdeTotal * baseCalculo);
            h.put(ALIQUOTA_IPI, 0.0);
        }
    }

    private void calcularIpi49(double baseCalculo, Produto produto, HashMap h, double aliquotaIpi, double qtdeTotal) {
        if (produto.getIpiTributadoQuantidade() == 0) {
            h.put(IPI_OUTROS, baseCalculo);
            h.put(ALIQUOTA_IPI, 0.0);
        } else {
            h.put(IPI_OUTROS, qtdeTotal * baseCalculo);
            h.put(ALIQUOTA_IPI, 0.0);
        }
    }

    private double getBC(double vrProdServ, double valorDesconto, double valorDespAcess, double valorFrete, double valorSeguro) {
        double bc = vrProdServ;
        if (this.incluirDescontoBC == null || this.incluirDescontoBC == 1) {
            bc -= valorDesconto;
        }
        if (this.incluirDespAcessBC == null || this.incluirDespAcessBC == 1) {
            bc += valorDespAcess;
        }
        if (this.incluirFreteBC == null || this.incluirFreteBC == 1) {
            bc += valorFrete;
        }
        if (this.incluirSeguroBC == null || this.incluirSeguroBC == 1) {
            bc += valorSeguro;
        }
        return bc;
    }
}

