/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.calculoimpostos;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstTipoPropTerc;
import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstContrEstadoIcms;
import com.touchcomp.basementor.constants.enums.impostos.rat.EnumConstTipoCalcRat;
import com.touchcomp.basementor.constants.enums.impostos.senar.EnumConstTipoCalcSenar;
import com.touchcomp.basementor.constants.enums.impostos.taxasanidanimal.EnumConstCalcTipoTaxaSanidAnimal;
import com.touchcomp.basementor.constants.enums.number.EnumConstTipoArredondamento;
import com.touchcomp.basementor.model.vo.CNAE;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.GradeItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ItemNotaLivroFiscal;
import com.touchcomp.basementor.model.vo.ModeloFiscal;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.OpcoesImpostos;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.SituacaoDocumento;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.jepparser.ExceptionJEPParser;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorrules.impostos.rat.CompImpostoRat;
import com.touchcomp.basementorrules.impostos.rat.model.RatCalculado;
import com.touchcomp.basementorrules.impostos.rat.model.RatParams;
import com.touchcomp.basementorrules.impostos.senar.CompImpostoSenar;
import com.touchcomp.basementorrules.impostos.senar.model.SenarCalculado;
import com.touchcomp.basementorrules.impostos.senar.model.SenarParams;
import com.touchcomp.basementorrules.impostos.taxasanidadeanimal.CompImpostoTaxaSanidadeAnimal;
import com.touchcomp.basementorrules.impostos.taxasanidadeanimal.model.TaxaSanidAnimalCalculado;
import com.touchcomp.basementorrules.impostos.taxasanidadeanimal.model.TaxaSanidAnimalParams;
import com.touchcomp.basementorservice.components.calculoimpostos.CalculoICMSSaiUtilities;
import com.touchcomp.basementorservice.components.calculoimpostos.CalculoIPISaiUtilities;
import com.touchcomp.basementorservice.components.calculoimpostos.CalculoOutrosImpostos;
import com.touchcomp.basementorservice.components.calculoimpostos.CalculoPisCofins;
import com.touchcomp.basementorservice.components.calculoimpostos.CalculosImpFiscaisNotaTerceiros;
import com.touchcomp.basementorservice.components.obsdinamica.CompOBSDinamica;
import com.touchcomp.basementorservice.service.impl.saldoestoque.ServiceSaldoEstoqueImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.jep.ToolJepExpressionParser;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class CalculosImpFiscaisNotaPropria {
    ServiceSaldoEstoqueImpl serviceSaldoEstoque = (ServiceSaldoEstoqueImpl)ConfApplicationContext.getBean(ServiceSaldoEstoqueImpl.class);

    public List calcularImpostosFiscaisItNotaPropria(List itensNota, UnidadeFederativa ufEmpresa, UnidadeFatCliente cliente, SituacaoDocumento sitDoc, Empresa empresa, Short consumidorFinal, OpcoesFaturamento opcoes, Date dataPartilhaIcms, EmpresaContabilidade empresaContabilidade, OpcoesImpostos opImpostsos) throws Exception {
        for (Object o : itensNota) {
            ItemNotaFiscalPropria item = (ItemNotaFiscalPropria)o;
            this.calcularImpostosFiscaisItNotaPropria(item, ufEmpresa, cliente, sitDoc, empresa, consumidorFinal, opcoes, dataPartilhaIcms, empresaContabilidade, opImpostsos);
        }
        return itensNota;
    }

    public void calcularImpostosFiscaisItNotaPropria(ItemNotaFiscalPropria item, UnidadeFederativa ufEmpresa, UnidadeFatCliente cliente, SituacaoDocumento sitDoc, Empresa empresa, Short consumidorFinal, OpcoesFaturamento opcoes, Date dataPartilhaIcms, EmpresaContabilidade empresaContabilidade, OpcoesImpostos opImpostos) throws Exception {
        double vlrProduto = item.getQuantidadeTotal() * item.getValorUnitario();
        vlrProduto = ToolFormatter.arrredondarNumero((Double)vlrProduto, (int)2);
        this.calcularImpostosNormalmente(item, vlrProduto, cliente, ufEmpresa, empresa, consumidorFinal, opcoes, dataPartilhaIcms, empresaContabilidade);
        this.setarValorCustoDev(item, empresa);
        this.atualizarValorCompra(item);
        try {
            CalculosImpFiscaisNotaPropria.atualizarValorTransf(item, opImpostos);
        }
        catch (Exception ex) {
            TLogger.get(CalculosImpFiscaisNotaTerceiros.class).error((Throwable)ex);
            throw new Exception(ex);
        }
    }

    private void calculoOutrosImpostos(ItemNotaLivroFiscal itLF, ItemNotaFiscalPropria item) throws Exception {
        this.valoresPisCofinsItemNotaPropria(itLF, item);
        this.valoresContSocItemNotaPropria(itLF, item);
        this.valoresFunruralItemNotaPropria(itLF, item);
        this.valoresLei10833ItemNotaPropria(itLF, item);
        this.valoresCIDEItemNotaPropria(itLF, item);
        this.valoresINSSItemNotaPropria(itLF, item);
        this.valoresIRFFItemNotaPropria(itLF, item);
        this.valoresIssItemNotaPropria(itLF, item);
        this.valoresOutrosItemNotaPropria(itLF, item);
        this.valoresSestSenatItemNotaPropria(itLF, item);
        this.valoresImpPrevistosItemNotaPropria(itLF, item);
        this.valoresSenartemNotaPropria(itLF, item);
        this.valoresRattemNotaPropria(itLF, item);
        this.valoresTaxaSanidAnimalItemNotaPropria(itLF, item);
    }

    private void valoresSenartemNotaPropria(ItemNotaLivroFiscal itLF, ItemNotaFiscalPropria item) {
        EnumConstTipoCalcSenar tp = ToolMethods.isEquals((Object)item.getModeloFiscal().getTipoSenar(), (Object)1) ? EnumConstTipoCalcSenar.CALCULAR_NORMAL : EnumConstTipoCalcSenar.NAO_CALCULAR;
        SenarParams params = new SenarParams(itLF.getAliquotaSenar(), itLF.getValorSenar(), Double.valueOf(this.getValorFreteItem(item)), Double.valueOf(this.getValorSeguroItem(item)), Double.valueOf(this.getValorDespAcssItem(item)), Double.valueOf(this.getValorDescontoItem(item)), Double.valueOf(item.getVrProduto() + item.getVrServico()), EnumConstTipoArredondamento.ROUND_DOWN, tp);
        SenarCalculado calc = CompImpostoSenar.calcularSenar((SenarParams)params);
        itLF.setAliquotaSenar(calc.getAliquotaSenar());
        itLF.setValorSenar(calc.getValorSenar());
    }

    private void valoresRattemNotaPropria(ItemNotaLivroFiscal itLF, ItemNotaFiscalPropria item) {
        EnumConstTipoCalcRat tp = ToolMethods.isEquals((Object)item.getModeloFiscal().getTipoSenar(), (Object)1) ? EnumConstTipoCalcRat.CALCULAR_NORMAL : EnumConstTipoCalcRat.NAO_CALCULAR;
        RatParams params = new RatParams(itLF.getAliquotaRat(), itLF.getValorRat(), Double.valueOf(this.getValorFreteItem(item)), Double.valueOf(this.getValorSeguroItem(item)), Double.valueOf(this.getValorDespAcssItem(item)), Double.valueOf(this.getValorDescontoItem(item)), Double.valueOf(item.getVrProduto() + item.getVrServico()), EnumConstTipoArredondamento.ROUND_DOWN, tp);
        RatCalculado calc = CompImpostoRat.calcularRat((RatParams)params);
        itLF.setAliquotaRat(calc.getAliquotaRat());
        itLF.setValorRat(calc.getValorRat());
    }

    private void valoresTaxaSanidAnimalItemNotaPropria(ItemNotaLivroFiscal itLF, ItemNotaFiscalPropria item) {
        TaxaSanidAnimalParams params = new TaxaSanidAnimalParams(itLF.getTaxaSanidadeAnimal(), itLF.getFatorTaxaSanidadeAnimal(), itLF.getValorTaxaSanidadeAnimal(), item.getQuantidadeTotal(), EnumConstTipoArredondamento.ROUND_DOWN, EnumConstCalcTipoTaxaSanidAnimal.CALCULAR_NORMAL);
        TaxaSanidAnimalCalculado calc = CompImpostoTaxaSanidadeAnimal.calcularTaxaSanidadeAnimal((TaxaSanidAnimalParams)params);
        itLF.setTaxaSanidadeAnimal(calc.getTaxaSanidAnimal());
        itLF.setValorTaxaSanidadeAnimal(calc.getValorSanidAnimal());
        itLF.setFatorTaxaSanidadeAnimal(calc.getFatorTaxaSanidAnimal());
        itLF.setBcTaxaSanidadeAnimal(calc.getBaseCalculoTaxaSanidAnimal());
    }

    private void valoresIpiItemNotaPropria(ModeloFiscal modeloFiscal, ItemNotaLivroFiscal itLF, Produto produto, UnidadeFatCliente cliente, ItemNotaFiscalPropria item, Empresa empresa) throws Exception {
        if (item.getNaoCalcularIpi() == null || item.getNaoCalcularIpi() != 1) {
            HashMap h = new CalculoIPISaiUtilities(item.getModeloFiscal().getModeloFiscalIpi().getIncluiSeguro(), item.getModeloFiscal().getModeloFiscalIpi().getIncluiFrete(), item.getModeloFiscal().getModeloFiscalIpi().getIncluiDespAcess(), item.getModeloFiscal().getModeloFiscalIpi().getIncluiDesconto()).calcularIpi(item.getModeloFiscal().getModeloFiscalIpi().getIncidenciaIpi().getCodigo(), produto, itLF.getAliquotaIpi(), this.getValorFreteItem(item), this.getValorSeguroItem(item), this.getValorDespAcssItem(item), this.getValorDescontoItem(item), item.getVrProduto() + item.getVrServico(), item.getQuantidadeTotal(), empresa);
            itLF.setAliquotaIpi((Double)h.get("aliquotaIPI"));
            itLF.setVrIpiComercio((Double)h.get("ipiComercio"));
            itLF.setVrIpiIndustria((Double)h.get("ipiIndustria"));
            itLF.setVrIpiIsento((Double)h.get("ipiIsento"));
            itLF.setVrIpiObservacao((Double)h.get("ipiObservacao"));
            itLF.setVrIpiOutros((Double)h.get("ipiOutros"));
            itLF.setVrIpiTributado((Double)h.get("ipiTributado"));
        }
    }

    private void valoresIcmsIcmsSTItemNotaPropria(ModeloFiscal modeloFiscal, ItemNotaFiscalPropria item, Produto produto, UnidadeFederativa ufEmpresa, UnidadeFederativa ufCliente, CNAE cnaeCliente, Empresa empresa, Short contribuinteEstado, Short consumidorFinal, OpcoesFaturamento opcoes, Date dataPartilhaIcms, EmpresaContabilidade empresaContabilidade, UnidadeFatCliente unidadeFatCliente) throws Exception {
        if (item.getNaoCalcularIcms() == null || item.getNaoCalcularIcms() != 1) {
            Date dataEmissao = dataPartilhaIcms != null ? dataPartilhaIcms : new Date();
            HashMap h = new CalculoICMSSaiUtilities(EnumConstantsMentorSimNao.get((Object)modeloFiscal.getModeloFiscalIcms().getIncluiSeguro()), EnumConstantsMentorSimNao.get((Object)modeloFiscal.getModeloFiscalIcms().getIncluiFrete()), EnumConstantsMentorSimNao.get((Object)modeloFiscal.getModeloFiscalIcms().getIncluiDespAcess()), EnumConstantsMentorSimNao.get((Object)modeloFiscal.getModeloFiscalIcms().getIncluiDesconto()), opcoes.getTipoCalculoST(), empresa, cnaeCliente, EnumConstContrEstadoIcms.get((Object)consumidorFinal), EnumConstantsMentorSimNao.get((Object)item.getModeloFiscal().getModeloFiscalIcms().getIncluiSeguroST()), EnumConstantsMentorSimNao.get((Object)item.getModeloFiscal().getModeloFiscalIcms().getIncluiFreteST()), EnumConstantsMentorSimNao.get((Object)item.getModeloFiscal().getModeloFiscalIcms().getIncluiDespAcessST()), EnumConstantsMentorSimNao.get((Object)item.getModeloFiscal().getModeloFiscalIcms().getIncluiDescontoST()), EnumConstantsMentorSimNao.get((Object)item.getModeloFiscal().getModeloFiscalIcms().getIncluiIPIST()), EnumConstantsMentorSimNao.get((Object)opcoes.getUsarCategoriaST()), dataEmissao, opcoes.getVersaoNFe()).valoresIcmsIcmsST(modeloFiscal.getModeloFiscalIcms(), modeloFiscal.getModeloFiscalIpi(), item.getItemNotaLivroFiscal().getVrImpostoImportacao(), item.getItemNotaLivroFiscal().getVrPis(), item.getItemNotaLivroFiscal().getVrCofins(), item.getItemNotaLivroFiscal().getVrIpiIndustria(), item.getItemNotaLivroFiscal().getVrIpiObservacao(), item.getItemNotaLivroFiscal().getAliquotaIcms(), item.getItemNotaLivroFiscal().getPercReducaoBCIcms(), item.getItemNotaLivroFiscal().getIndiceICMSCalcImportacao(), produto, item.getQuantidadeTotal(), ufCliente, item.getItemNotaLivroFiscal().getAliquotaICMSSimples(), this.getValorFreteItem(item), this.getValorSeguroItem(item), this.getValorDespAcssItem(item), this.getValorDescontoItem(item), item.getVrProduto() + item.getVrServico(), consumidorFinal, contribuinteEstado, empresaContabilidade, unidadeFatCliente, modeloFiscal.getTipoCfop(), item.getItemNotaLivroFiscal().getValorIpiDevolucao());
            if (h.get("aliquotaICMS") instanceof Double) {
                item.getItemNotaLivroFiscal().setAliquotaIcms((Double)h.get("aliquotaICMS"));
            } else {
                item.getItemNotaLivroFiscal().setAliquotaIcms(Double.valueOf((Double)h.get("aliquotaICMS")));
            }
            item.getItemNotaLivroFiscal().setAliquotaIcmsST((Double)h.get("aliquotaSt"));
            item.getItemNotaLivroFiscal().setVrBcCalculoIcms((Double)h.get("bcIcms"));
            h.get("descontoPadraoST");
            item.getItemNotaLivroFiscal().setVrIcmsIsento(ToolFormatter.arrredondarNumero((Double)((Double)h.get("icmsIsento")), (int)2));
            item.getItemNotaLivroFiscal().setVrIcmsOutros(ToolFormatter.arrredondarNumero((Double)((Double)h.get("icmsOutros")), (int)2));
            item.getItemNotaLivroFiscal().setVrIcmsSemAprov(ToolFormatter.arrredondarNumero((Double)((Double)h.get("icmsSemAprov")), (int)2));
            item.getItemNotaLivroFiscal().setVrIcmsTributado(ToolFormatter.arrredondarNumero((Double)((Double)h.get("icmsTributado")), (int)2));
            item.getItemNotaLivroFiscal().setIndiceAlteracaoIcmsST((Double)h.get("indiceAlteracaoST"));
            item.getItemNotaLivroFiscal().setVrBcCalculoIcmsSt((Double)h.get("bcIcmsST"));
            item.getItemNotaLivroFiscal().setVrIcmsSt(ToolFormatter.arrredondarNumero((Double)((Double)h.get("valorIcmsSt")), (int)2));
            item.getItemNotaLivroFiscal().setVrIcms(ToolFormatter.arrredondarNumero((Double)((Double)h.get("valorIcms")), (int)2));
            item.getItemNotaLivroFiscal().setVrIcmsDesonerado(ToolFormatter.arrredondarNumero((Double)((Double)h.get("valorIcmsDesonerado")), (int)2));
            item.getItemNotaLivroFiscal().setVrNaoTribICMS(ToolFormatter.arrredondarNumero((Double)((Double)h.get("valorNaoTribIcms")), (int)2));
            item.getItemNotaLivroFiscal().setAliquotaICMSSimples((Double)h.get("aliquotaICMSSimples"));
            item.getItemNotaLivroFiscal().setValorICMSSimples(ToolFormatter.arrredondarNumero((Double)((Double)h.get("valorIcmsSimples")), (int)2));
            if (h.get("valorBcIcmsUfDest") != null) {
                item.getItemNotaLivroFiscal().setValorBcIcmsUfDest((Double)h.get("valorBcIcmsUfDest"));
            } else {
                item.getItemNotaLivroFiscal().setValorBcIcmsUfDest(Double.valueOf(0.0));
            }
            if (h.get("valorIcmsPartilhaRem") != null) {
                item.getItemNotaLivroFiscal().setValorIcmsPartilhaRem(ToolFormatter.arrredondarNumero((Double)((Double)h.get("valorIcmsPartilhaRem")), (int)2));
            } else {
                item.getItemNotaLivroFiscal().setValorIcmsPartilhaRem(Double.valueOf(0.0));
            }
            if (h.get("valorIcmsPartilhaDest") != null) {
                item.getItemNotaLivroFiscal().setValorIcmsPartilhaDest(ToolFormatter.arrredondarNumero((Double)((Double)h.get("valorIcmsPartilhaDest")), (int)2));
            } else {
                item.getItemNotaLivroFiscal().setValorIcmsPartilhaDest(Double.valueOf(0.0));
            }
            if (h.get("aliquotaInternaUFDest") != null) {
                item.getItemNotaLivroFiscal().setAliquotaInternaUFDest((Double)h.get("aliquotaInternaUFDest"));
            } else {
                item.getItemNotaLivroFiscal().setAliquotaInternaUFDest(Double.valueOf(0.0));
            }
            if (h.get("aliquotaInterestadual") != null) {
                item.getItemNotaLivroFiscal().setAliquotaInterestadual((Double)h.get("aliquotaInterestadual"));
            } else {
                item.getItemNotaLivroFiscal().setAliquotaInterestadual(Double.valueOf(0.0));
            }
            if (h.get("percPartilhaIcms") != null) {
                item.getItemNotaLivroFiscal().setPercPartilhaIcms((Double)h.get("percPartilhaIcms"));
            } else {
                item.getItemNotaLivroFiscal().setPercPartilhaIcms(Double.valueOf(0.0));
            }
            if (h.get("aliquotaFundoPobreza") != null) {
                item.getItemNotaLivroFiscal().setAliquotaFundoPobreza((Double)h.get("aliquotaFundoPobreza"));
            } else {
                item.getItemNotaLivroFiscal().setAliquotaFundoPobreza(Double.valueOf(0.0));
            }
            if (h.get("valorFundoPobreza") != null) {
                item.getItemNotaLivroFiscal().setValorFundoPobreza(ToolFormatter.arrredondarNumero((Double)((Double)h.get("valorFundoPobreza")), (int)2));
            } else {
                item.getItemNotaLivroFiscal().setValorFundoPobreza(Double.valueOf(0.0));
            }
            if (h.get("valorBCFCP") != null) {
                item.getItemNotaLivroFiscal().setValorBCFCP(ToolFormatter.arrredondarNumero((Double)((Double)h.get("valorBCFCP")), (int)2));
            } else {
                item.getItemNotaLivroFiscal().setValorBCFCP(Double.valueOf(0.0));
            }
            if (h.get("aliquotaFCP") != null) {
                item.getItemNotaLivroFiscal().setAliquotaFCP(ToolFormatter.arrredondarNumero((Double)((Double)h.get("aliquotaFCP")), (int)2));
            } else {
                item.getItemNotaLivroFiscal().setAliquotaFCP(Double.valueOf(0.0));
            }
            if (h.get("valorFCP") != null) {
                item.getItemNotaLivroFiscal().setValorFCP(ToolFormatter.arrredondarNumero((Double)((Double)h.get("valorFCP")), (int)2));
            } else {
                item.getItemNotaLivroFiscal().setValorFCP(Double.valueOf(0.0));
            }
            if (h.get("valorBCFCPSt") != null) {
                item.getItemNotaLivroFiscal().setValorBCFCPSt(ToolFormatter.arrredondarNumero((Double)((Double)h.get("valorBCFCPSt")), (int)2));
            } else {
                item.getItemNotaLivroFiscal().setValorBCFCPSt(Double.valueOf(0.0));
            }
            if (h.get("aliquotaFCPSt") != null) {
                item.getItemNotaLivroFiscal().setAliquotaFCPSt(ToolFormatter.arrredondarNumero((Double)((Double)h.get("aliquotaFCPSt")), (int)2));
            } else {
                item.getItemNotaLivroFiscal().setAliquotaFCPSt(Double.valueOf(0.0));
            }
            if (h.get("valorFCPSt") != null) {
                item.getItemNotaLivroFiscal().setValorFCPSt(ToolFormatter.arrredondarNumero((Double)((Double)h.get("valorFCPSt")), (int)2));
            } else {
                item.getItemNotaLivroFiscal().setValorFCPSt(Double.valueOf(0.0));
            }
            if (h.get("valorBCFCPStRetido") != null) {
                item.getItemNotaLivroFiscal().setValorBCFCPStRetido(ToolFormatter.arrredondarNumero((Double)((Double)h.get("valorBCFCPStRetido")), (int)2));
            } else {
                item.getItemNotaLivroFiscal().setValorBCFCPStRetido(Double.valueOf(0.0));
            }
            if (h.get("aliquotaFCPStRetido") != null) {
                item.getItemNotaLivroFiscal().setAliquotaFCPStRetido(ToolFormatter.arrredondarNumero((Double)((Double)h.get("aliquotaFCPStRetido")), (int)2));
            } else {
                item.getItemNotaLivroFiscal().setAliquotaFCPStRetido(Double.valueOf(0.0));
            }
            if (h.get("valorFCPStRetido") != null) {
                item.getItemNotaLivroFiscal().setValorFCPStRetido(ToolFormatter.arrredondarNumero((Double)((Double)h.get("valorFCPStRetido")), (int)2));
            } else {
                item.getItemNotaLivroFiscal().setValorFCPStRetido(Double.valueOf(0.0));
            }
            if (h.get("valorIcmsDiferimento") != null) {
                item.getItemNotaLivroFiscal().setValorIcmsDiferimento(ToolFormatter.arrredondarNumero((Double)((Double)h.get("valorIcmsDiferimento")), (int)2));
            } else {
                item.getItemNotaLivroFiscal().setValorIcmsDiferimento(Double.valueOf(0.0));
            }
            if (h.get("percentualDiferimento") != null) {
                item.getItemNotaLivroFiscal().setPercentualDiferimento(ToolFormatter.arrredondarNumero((Double)((Double)h.get("percentualDiferimento")), (int)2));
            } else {
                item.getItemNotaLivroFiscal().setPercentualDiferimento(Double.valueOf(0.0));
            }
        }
    }

    private void calcularImpostosNormalmente(ItemNotaFiscalPropria item, double vlrProduto, UnidadeFatCliente unidadeFatCliente, UnidadeFederativa ufEmpresa, Empresa empresa, Short consumidorFinal, OpcoesFaturamento opcoes, Date dataPartilhaIcms, EmpresaContabilidade empresaContabilidade) throws Exception {
        Produto produto = item.getProduto();
        if (item.getItemNotaLivroFiscal() == null) {
            item.setItemNotaLivroFiscal(new ItemNotaLivroFiscal());
        }
        ItemNotaLivroFiscal itLF = item.getItemNotaLivroFiscal();
        ModeloFiscal modeloFiscal = item.getModeloFiscal();
        if (produto.getTipoProduto() == 1) {
            itLF.setAliquotaIcms(Double.valueOf(0.0));
            itLF.setAliquotaIpi(Double.valueOf(0.0));
            itLF.setVrBcCalculoIcmsSt(Double.valueOf(0.0));
            itLF.setVrDifAliquota(Double.valueOf(0.0));
            itLF.setVrIcms(Double.valueOf(0.0));
            itLF.setVrIcmsIsento(Double.valueOf(0.0));
            itLF.setVrIcmsOutros(Double.valueOf(0.0));
            itLF.setVrIcmsSemAprov(Double.valueOf(0.0));
            itLF.setVrIcmsSt(Double.valueOf(0.0));
            itLF.setVrIcmsTributado(Double.valueOf(0.0));
            item.setVrServico(Double.valueOf(vlrProduto));
            item.setVrProduto(Double.valueOf(0.0));
        } else {
            item.setVrServico(Double.valueOf(0.0));
            item.setVrProduto(Double.valueOf(vlrProduto));
        }
        if (item.getTipoDesconto() == 0) {
            if (item.getPercDesconto() > 0.0) {
                item.setValorDesconto(ToolFormatter.arrredondarNumero((Double)(item.getPercDesconto() / 100.0 * vlrProduto), (int)2));
            }
        } else {
            item.setValorDesconto(ToolFormatter.arrredondarNumero((Double)item.getValorDesconto(), (int)2));
            if (item.getValorDesconto() > 0.0 && vlrProduto > 0.0) {
                item.setPercDesconto(ToolFormatter.arrredondarNumero((Double)(item.getValorDesconto() * 100.0 / vlrProduto), (int)2));
            }
        }
        if (item.getTipoDespAcessoria() == 0) {
            if (item.getPercDespAcessoria() > 0.0) {
                item.setValorDespAcessoria(ToolFormatter.arrredondarNumero((Double)(item.getPercDespAcessoria() / 100.0 * vlrProduto), (int)2));
            }
        } else {
            item.setValorDespAcessoria(ToolFormatter.arrredondarNumero((Double)item.getValorDespAcessoria(), (int)2));
            if (item.getValorDespAcessoria() > 0.0 && vlrProduto > 0.0) {
                item.setPercDespAcessoria(ToolFormatter.arrredondarNumero((Double)(item.getValorDespAcessoria() * 100.0 / vlrProduto), (int)2));
            }
        }
        if (item.getTipoFrete() == 0) {
            if (item.getPercFrete() > 0.0) {
                item.setValorFrete(ToolFormatter.arrredondarNumero((Double)(item.getPercFrete() / 100.0 * vlrProduto), (int)2));
            }
        } else {
            item.setValorFrete(ToolFormatter.arrredondarNumero((Double)item.getValorFrete(), (int)2));
            if (item.getValorFrete() > 0.0 && vlrProduto > 0.0) {
                item.setPercFrete(ToolFormatter.arrredondarNumero((Double)(item.getValorFrete() * 100.0 / vlrProduto), (int)2));
            }
        }
        if (item.getTipoSeguro() == 0) {
            if (item.getPercSeguro() > 0.0) {
                item.setVrSeguro(ToolFormatter.arrredondarNumero((Double)(item.getPercSeguro() / 100.0 * vlrProduto), (int)2));
            }
        } else {
            item.setVrSeguro(ToolFormatter.arrredondarNumero((Double)item.getVrSeguro(), (int)2));
            if (item.getVrSeguro() > 0.0 && vlrProduto > 0.0) {
                item.setPercSeguro(ToolFormatter.arrredondarNumero((Double)(item.getVrSeguro() * 100.0 / vlrProduto), (int)2));
            }
        }
        if (produto.getTipoProduto() == 0) {
            this.valoresImpImportacao(itLF, item);
            this.valoresIpiItemNotaPropria(modeloFiscal, itLF, produto, unidadeFatCliente, item, empresa);
            this.valoresIcmsIcmsSTItemNotaPropria(modeloFiscal, item, produto, ufEmpresa, unidadeFatCliente.getPessoa().getEndereco().getCidade().getUf(), unidadeFatCliente.getCliente().getPessoa().getComplemento().getCnae(), empresa, unidadeFatCliente.getCliente().getPessoa().getComplemento().getContribuinteEstado(), consumidorFinal, opcoes, dataPartilhaIcms, empresaContabilidade, unidadeFatCliente);
        }
        this.calculoOutrosImpostos(itLF, item);
        Double valorTotal = item.getVrProduto() + item.getVrServico() - item.getValorDesconto() + item.getValorFrete() + item.getVrSeguro() + item.getValorDespAcessoria() + itLF.getVrIpiIndustria() + itLF.getVrIcmsSt() + itLF.getVrOutros() + itLF.getVrDevICMSST() + itLF.getValorFCPSt() + itLF.getValorIpiDevolucao();
        if (item.getModeloFiscal().getModeloFiscalIcms().getIcmsDispensadoDesconto() != null && item.getModeloFiscal().getModeloFiscalIcms().getIcmsDispensadoDesconto().equals((short)1)) {
            valorTotal = valorTotal - itLF.getVrIcmsDesonerado();
        }
        itLF.setValorTotal(ToolFormatter.arrredondarNumero((Double)valorTotal, (int)2));
        if (item.getProduto().getClassificacaoProdutoANP() != null && item.getProduto().getPesoUnitario() > 0.0 && item.getQuantidadeTotal() > 0.0) {
            itLF.setValorPartida(Double.valueOf((itLF.getValorTotal() - itLF.getVrIcms()) / (item.getQuantidadeTotal() * item.getProduto().getPesoUnitario())));
        }
    }

    private void setarValorCustoDev(ItemNotaFiscalPropria item, Empresa emp) throws Exception {
        if (ToolMethods.isEquals((Object)item.getInfVrCustoManual(), (Object)0) && (item.getItemNotaLivroFiscal().getCfop() != null && item.getItemNotaLivroFiscal().getCfop() != null && item.getItemNotaLivroFiscal().getCfop().getCfopDevolucaoVenda() != null && item.getItemNotaLivroFiscal().getCfop().getCfopDevolucaoVenda() == 1 && item.getInfVrCustoManual() != 1 || item.getNotaFiscalPropria() != null && item.getNotaFiscalPropria().getNaturezaOperacao() != null && ToolMethods.isEquals((Object)item.getNotaFiscalPropria().getNaturezaOperacao().getEntradaSaida(), (Object)2))) {
            double vlr;
            Date d = new Date();
            if (item.getNotaFiscalPropria() != null && item.getNotaFiscalPropria().getDataEmissaoNota() != null) {
                d = item.getNotaFiscalPropria().getDataEmissaoNota();
            }
            if (item.getGradesNotaFiscalPropria() != null && !item.getGradesNotaFiscalPropria().isEmpty() && ((GradeItemNotaFiscalPropria)item.getGradesNotaFiscalPropria().get(0)).getValorCusto() > 0.0) {
                for (GradeItemNotaFiscalPropria g : item.getGradesNotaFiscalPropria()) {
                    g.setValorCusto(((GradeItemNotaFiscalPropria)item.getGradesNotaFiscalPropria().get(0)).getValorCusto());
                }
            } else if (item.getGradesNotaFiscalPropria() != null && !item.getGradesNotaFiscalPropria().isEmpty() && ((GradeItemNotaFiscalPropria)item.getGradesNotaFiscalPropria().get(0)).getValorCusto() == 0.0 && (vlr = this.findPrecoMedio(d, item.getProduto(), emp, EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO.getValue()).doubleValue()) > 0.0) {
                for (GradeItemNotaFiscalPropria g : item.getGradesNotaFiscalPropria()) {
                    g.setValorCusto(Double.valueOf(vlr));
                }
            }
            for (GradeItemNotaFiscalPropria g : item.getGradesNotaFiscalPropria()) {
                Double valorFreteCte = item.getValorFreteCTe() != null ? item.getValorFreteCTe() : 0.0;
                g.setValorCusto(Double.valueOf(g.getValorCusto() + valorFreteCte));
            }
        }
    }

    public Double findPrecoMedio(Date data, Produto produto, Empresa empresa, Short tipoCentroEstoque) throws Exception {
        return this.serviceSaldoEstoque.findPrecoMedioProduto(produto, empresa, data, EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO, null);
    }

    private void valoresPisCofinsItemNotaPropria(ItemNotaLivroFiscal itLF, ItemNotaFiscalPropria item) throws Exception {
        if (item.getNaoCalcularPisCofins() == null || item.getNaoCalcularPisCofins() == 0) {
            HashMap h = new CalculoPisCofins(EnumConstantsMentorSimNao.get((Object)item.getModeloFiscal().getModeloFiscalPisCofins().getIncluiSeguro()), EnumConstantsMentorSimNao.get((Object)item.getModeloFiscal().getModeloFiscalPisCofins().getIncluiFrete()), EnumConstantsMentorSimNao.get((Object)item.getModeloFiscal().getModeloFiscalPisCofins().getIncluiDespAcess()), EnumConstantsMentorSimNao.get((Object)item.getModeloFiscal().getModeloFiscalPisCofins().getIncluiDesconto()), item.getModeloFiscal().getModeloFiscalPisCofins().getValorMinimoCofins(), item.getModeloFiscal().getModeloFiscalPisCofins().getValorMinimoPis(), EnumConstantsMentorSimNao.get((Object)item.getModeloFiscal().getModeloFiscalPisCofins().getAbaterValorIcms()), EnumConstantsMentorSimNao.get((Object)item.getModeloFiscal().getModeloFiscalPisCofins().getIncluirIcmsDesonerado()), EnumConstantsMentorSimNao.get((Object)item.getModeloFiscal().getModeloFiscalPisCofins().getIncluirIcmsSemAproveitamento()), EnumConstantsMentorSimNao.get((Object)item.getModeloFiscal().getModeloFiscalPisCofins().getIncluirIpiObservacao())).calculoPisCofins(EnumConstantsMentorSimNao.get((Object)item.getModeloFiscal().getModeloFiscalPisCofins().getCalcularPisNormal()), EnumConstantsMentorSimNao.get((Object)item.getModeloFiscal().getModeloFiscalPisCofins().getCalcularPisSt()), EnumConstantsMentorSimNao.get((Object)item.getModeloFiscal().getModeloFiscalPisCofins().getCalcularCofinsNormal()), EnumConstantsMentorSimNao.get((Object)item.getModeloFiscal().getModeloFiscalPisCofins().getCalcularCofinsSt()), item.getModeloFiscal().getModeloFiscalPisCofins().getIncidenciaPisCofins(), itLF.getAliquotaPis(), itLF.getAliquotaPisSt(), itLF.getAliquotaCofins(), itLF.getAliquotaCofinsSt(), this.getValorFreteItem(item), this.getValorSeguroItem(item), this.getValorDespAcssItem(item), this.getValorDescontoItem(item), item.getVrProduto() + item.getVrServico(), 4, item.getProduto().getPisCofinsTributadoQuantidade(), item.getQuantidadeTotal(), item.getProduto().getAliquotaPisQtde(), item.getProduto().getAliquotaCofinsQtde(), item.getItemNotaLivroFiscal().getVrIcms(), item.getItemNotaLivroFiscal().getVrIcmsDesonerado(), item.getItemNotaLivroFiscal().getVrIcmsSemAprov(), item.getItemNotaLivroFiscal().getVrIpiObservacao());
            itLF.setAliquotaPis((Double)h.get("aliquotaPis"));
            itLF.setAliquotaPisSt((Double)h.get("aliquotaPisSt"));
            itLF.setAliquotaCofins((Double)h.get("aliquotaCofins"));
            itLF.setAliquotaCofinsSt((Double)h.get("aliquotaCofinsSt"));
            itLF.setVrPis((Double)h.get("valorPis"));
            itLF.setVrPisSt((Double)h.get("valorPisSt"));
            itLF.setVrCofins((Double)h.get("valorCofins"));
            itLF.setVrCofinsSt((Double)h.get("valorCofinsSt"));
            itLF.setVrBCCofins((Double)h.get("valorBCCofins"));
            itLF.setVrBCCofinsSt((Double)h.get("valorBCCofinsSt"));
            itLF.setVrBCPis((Double)h.get("valorBCPis"));
            itLF.setVrBCPisSt((Double)h.get("valorBCPisSt"));
            itLF.setAliquotaPisQtde((Double)h.get("aliquotaPisQtde"));
            itLF.setAliquotaCofinsQtde((Double)h.get("aliquotaCofinsQtde"));
        }
    }

    private void valoresContSocItemNotaPropria(ItemNotaLivroFiscal itLF, ItemNotaFiscalPropria item) {
        HashMap h = CalculoOutrosImpostos.calculoContSoc(item.getModeloFiscal().getTipoContSoc(), itLF.getAliquotaContSoc(), itLF.getPercRedContSoc(), item.getModeloFiscal().getValorMinimoCSLL(), itLF.getVrContSoc(), this.getValorFreteItem(item), this.getValorSeguroItem(item), this.getValorDespAcssItem(item), this.getValorDescontoItem(item), item.getVrProduto() + item.getVrServico(), (short)4);
        itLF.setAliquotaContSoc((Double)h.get("aliquotaContSoc"));
        itLF.setVrContSoc((Double)h.get("valorContSoc"));
        itLF.setPercRedContSoc((Double)h.get("percRedContSoc"));
    }

    private void valoresFunruralItemNotaPropria(ItemNotaLivroFiscal itLF, ItemNotaFiscalPropria item) {
        HashMap h = CalculoOutrosImpostos.calculoFunrural(item.getModeloFiscal(), itLF.getAliquotaFunrural(), itLF.getPercRedFunrural(), itLF.getVrFunrural(), this.getValorFreteItem(item), this.getValorSeguroItem(item), this.getValorDespAcssItem(item), this.getValorDescontoItem(item), item.getVrProduto() + item.getVrServico(), (short)4);
        itLF.setAliquotaFunrural((Double)h.get("aliquotaFunrural"));
        itLF.setVrFunrural((Double)h.get("valorFunrural"));
        itLF.setPercRedFunrural((Double)h.get("percRedFunrural"));
    }

    private void valoresLei10833ItemNotaPropria(ItemNotaLivroFiscal itLF, ItemNotaFiscalPropria item) {
        HashMap h = CalculoOutrosImpostos.calculoLei10833(item.getModeloFiscal(), itLF.getAliquotaLei10833(), itLF.getPercRedLei10833(), itLF.getVrLei10833(), this.getValorFreteItem(item), this.getValorSeguroItem(item), this.getValorDespAcssItem(item), this.getValorDescontoItem(item), item.getVrProduto() + item.getVrServico(), (short)4);
        itLF.setAliquotaLei10833((Double)h.get("aliquotaLei10833"));
        itLF.setVrLei10833((Double)h.get("valorLei10833"));
        itLF.setPercRedLei10833((Double)h.get("percRedLei10833"));
    }

    private void valoresCIDEItemNotaPropria(ItemNotaLivroFiscal itLF, ItemNotaFiscalPropria item) {
        HashMap h = CalculoOutrosImpostos.calculoCIDE(item.getModeloFiscal(), itLF.getAliquotaCIDE(), itLF.getValorCIDE(), item.getQuantidadeTotal());
        itLF.setAliquotaCIDE((Double)h.get("aliquotaCIDE"));
        itLF.setValorCIDE((Double)h.get("valorCIDE"));
        itLF.setQuantidadeBCCIDE((Double)h.get("bcCIDE"));
    }

    private void valoresINSSItemNotaPropria(ItemNotaLivroFiscal itLF, ItemNotaFiscalPropria item) {
        HashMap h = CalculoOutrosImpostos.calculoINSS(item.getModeloFiscal().getTipoINSS(), itLF.getAliquotaInss(), itLF.getPercRedBcInss(), itLF.getVrInss(), item.getModeloFiscal().getValorMinimoInss(), this.getValorFreteItem(item), this.getValorSeguroItem(item), this.getValorDespAcssItem(item), this.getValorDescontoItem(item), item.getVrProduto() + item.getVrServico(), (short)4);
        itLF.setAliquotaInss((Double)h.get("aliquotaInss"));
        itLF.setVrInss((Double)h.get("valorInss"));
        itLF.setPercRedBcInss((Double)h.get("percRedInss"));
    }

    private void valoresIRFFItemNotaPropria(ItemNotaLivroFiscal itLF, ItemNotaFiscalPropria item) {
        HashMap h = CalculoOutrosImpostos.calculoIRRF(item.getModeloFiscal().getTipoIRRF(), itLF.getAliquotaIrrf(), itLF.getPercRedIrrf(), itLF.getVrIrrf(), item.getModeloFiscal().getValorMinimoIR(), this.getValorFreteItem(item), this.getValorSeguroItem(item), this.getValorDespAcssItem(item), this.getValorDescontoItem(item), item.getVrProduto() + item.getVrServico(), (short)4);
        itLF.setAliquotaIrrf((Double)h.get("aliquotaIrrf"));
        itLF.setVrIrrf((Double)h.get("valorIrrf"));
        itLF.setPercRedIrrf((Double)h.get("percRedIRRF"));
    }

    private void valoresIssItemNotaPropria(ItemNotaLivroFiscal itLF, ItemNotaFiscalPropria item) {
        HashMap h = CalculoOutrosImpostos.calculoISS(item.getModeloFiscal().getIssRetido(), itLF.getAliquotaIss(), 0.0, itLF.getVrIss(), item.getModeloFiscal().getValorMinimoISS(), this.getValorFreteItem(item), this.getValorSeguroItem(item), this.getValorDespAcssItem(item), this.getValorDescontoItem(item), item.getVrProduto() + item.getVrServico(), (short)4);
        itLF.setAliquotaIss((Double)h.get("aliquotaIss"));
        itLF.setVrIss((Double)h.get("valorIss"));
    }

    private void valoresOutrosItemNotaPropria(ItemNotaLivroFiscal itLF, ItemNotaFiscalPropria item) {
        HashMap h = CalculoOutrosImpostos.calculoOutros(item.getModeloFiscal().getTipoOutros(), itLF.getAliquotaOutros(), itLF.getPercRedOutros(), itLF.getVrOutros(), item.getModeloFiscal().getValorMinimoOutros(), this.getValorFreteItem(item), this.getValorSeguroItem(item), this.getValorDespAcssItem(item), this.getValorDescontoItem(item), item.getVrProduto() + item.getVrServico(), (short)4);
        itLF.setAliquotaOutros((Double)h.get("aliquotaOutros"));
        itLF.setVrOutros((Double)h.get("valorOutros"));
        itLF.setPercRedOutros((Double)h.get("percRedOutros"));
    }

    private void valoresSestSenatItemNotaPropria(ItemNotaLivroFiscal itLF, ItemNotaFiscalPropria item) {
        HashMap h = CalculoOutrosImpostos.calculoSestSenat(item.getModeloFiscal(), itLF.getAliquotaSestSenat(), itLF.getPercRedSestSenat(), itLF.getValorSestSenat(), this.getValorFreteItem(item), this.getValorSeguroItem(item), this.getValorDespAcssItem(item), this.getValorDescontoItem(item), item.getVrProduto() + item.getVrServico(), (short)4);
        itLF.setAliquotaSestSenat((Double)h.get("aliquotaSestSenat"));
        itLF.setValorSestSenat((Double)h.get("valorSestSenat"));
        itLF.setPercRedSestSenat((Double)h.get("percRedSestSenat"));
    }

    private void valoresImpPrevistosItemNotaPropria(ItemNotaLivroFiscal itLF, ItemNotaFiscalPropria item) {
        HashMap h = CalculoOutrosImpostos.calcularValorImpostosPrevistos(item.getModeloFiscal(), itLF.getAliqImpostosEstimada(), itLF.getValorSestSenat(), this.getValorFreteItem(item), this.getValorSeguroItem(item), this.getValorDespAcssItem(item), this.getValorDescontoItem(item), item.getVrProduto() + item.getVrServico());
        itLF.setAliqImpostosEstimada((Double)h.get("aliqImpEstimado"));
        itLF.setVlrImpostosEstimado((Double)h.get("vlrImpEstimado"));
    }

    private void valoresImpImportacao(ItemNotaLivroFiscal itLF, ItemNotaFiscalPropria item) {
        if (item.getNaoCalcularII() == null || item.getNaoCalcularII().equals((short)0)) {
            HashMap h = CalculoOutrosImpostos.valoresImpImportacao(item.getModeloFiscal(), itLF.getAliquotaImpostoImportacao(), itLF.getVrBCImpostoImp(), this.getValorFreteItem(item), this.getValorSeguroItem(item), this.getValorDespAcssItem(item), this.getValorDescontoItem(item), item.getVrProduto() + item.getVrServico());
            itLF.setAliquotaImpostoImportacao((Double)h.get("aliquotaImpostoImportacao"));
            itLF.setVrImpostoImportacao((Double)h.get("valorImpostoImportacao"));
            itLF.setVrBCImpostoImp((Double)h.get("bcImpostoImportacao"));
        }
    }

    public HashMap getValorTotal(List itens) {
        HashMap<String, Double> h = new HashMap<String, Double>();
        Double valor = 0.0;
        Double valorDesconto = 0.0;
        Double valorIcmsSt = 0.0;
        Double valorIcmsStDev = 0.0;
        Double valorIcmsDisp = 0.0;
        for (Object o : itens) {
            ItemNotaFiscalPropria i = (ItemNotaFiscalPropria)o;
            if (i.getModeloFiscal().getGerarFinanceiro() != 1) continue;
            valor = valor + i.getItemNotaLivroFiscal().getValorTotal();
            valorDesconto = valorDesconto + i.getValorDesconto();
            if (i.getItemNotaLivroFiscal().getVrDevICMSST() != null) {
                valorIcmsStDev = valorIcmsStDev + i.getItemNotaLivroFiscal().getVrDevICMSST();
            }
            if (i.getModeloFiscal().getModeloFiscalIcms().getIcmsDispensadoDesconto() != null && i.getModeloFiscal().getModeloFiscalIcms().getIcmsDispensadoDesconto().equals((short)1)) {
                valorIcmsDisp = valorIcmsDisp + i.getItemNotaLivroFiscal().getVrIcmsDesonerado();
            }
            if (valor == 0.0) {
                valor = (double)i.getVrProduto();
            }
            if (i.getModeloFiscal().getModeloFiscalIcms().getCalcularIcmsStCliente() == null || i.getModeloFiscal().getModeloFiscalIcms().getCalcularIcmsStCliente() == 1) continue;
            valorIcmsSt = valorIcmsSt + i.getItemNotaLivroFiscal().getVrIcmsSt();
        }
        h.put("valorTotal", valor);
        h.put("valorDesconto", valorDesconto);
        h.put("valorICMSST", valorIcmsSt);
        h.put("valorICMSDispensado", valorIcmsDisp);
        h.put("valorIcmsStDev", valorIcmsStDev);
        return h;
    }

    public HashMap getValorTotalPreFaturamento(List itens) {
        HashMap<String, Double> h = new HashMap<String, Double>();
        Double valor = 0.0;
        Double valorDesconto = 0.0;
        Double valorIcmsSt = 0.0;
        Double valorIcmsStDev = 0.0;
        Double valorIcmsDisp = 0.0;
        for (Object o : itens) {
            ItemNotaFiscalPropria i = (ItemNotaFiscalPropria)o;
            if (i.getGerarFinanceiro() != 1) continue;
            valor = valor + i.getItemNotaLivroFiscal().getValorTotal();
            valorDesconto = valorDesconto + i.getValorDesconto();
            if (i.getItemNotaLivroFiscal().getVrDevICMSST() != null) {
                valorIcmsStDev = valorIcmsStDev + i.getItemNotaLivroFiscal().getVrDevICMSST();
            }
            if (i.getModeloFiscal().getModeloFiscalIcms().getIcmsDispensadoDesconto() != null && i.getModeloFiscal().getModeloFiscalIcms().getIcmsDispensadoDesconto().equals((short)1)) {
                valorIcmsDisp = valorIcmsDisp + i.getItemNotaLivroFiscal().getVrIcmsDesonerado();
            }
            if (valor == 0.0) {
                valor = (double)i.getVrProduto();
            }
            if (i.getModeloFiscal().getModeloFiscalIcms().getCalcularIcmsStCliente() == null || i.getModeloFiscal().getModeloFiscalIcms().getCalcularIcmsStCliente() == 1) continue;
            valorIcmsSt = valorIcmsSt + i.getItemNotaLivroFiscal().getVrIcmsSt();
        }
        h.put("valorTotal", valor);
        h.put("valorDesconto", valorDesconto);
        h.put("valorICMSST", valorIcmsSt);
        h.put("valorICMSDispensado", valorIcmsDisp);
        h.put("valorIcmsStDev", valorIcmsStDev);
        return h;
    }

    private static void ratearFreteCTe(List<ItemNotaFiscalPropria> itens, Double valorFreteCTe) {
        Double valorTotalProdutos = CalculosImpFiscaisNotaPropria.getValorRatFreteCTeAutonomo(itens);
        for (ItemNotaFiscalPropria item : itens) {
            valorFreteCTe = valorFreteCTe == null ? 0.0 : valorFreteCTe;
            double aux = 0.0;
            if (item.getVrProduto() > 0.0 && valorTotalProdutos > 0.0) {
                aux = item.getVrProduto() / valorTotalProdutos * valorFreteCTe;
            }
            item.setValorFreteCTe(Double.valueOf(aux));
        }
    }

    private static Double getValorRatFreteCTeAutonomo(List<ItemNotaFiscalPropria> itens) {
        double valorTotalProdutos = 0.0;
        for (ItemNotaFiscalPropria item : itens) {
            valorTotalProdutos += item.getVrProduto() + item.getVrServico();
        }
        return valorTotalProdutos;
    }

    private static void atualizarValorTransf(ItemNotaFiscalPropria item, OpcoesImpostos opImpostos) throws ExceptionJEPParser, ExceptionReflection, ExceptionInvalidData {
        if (!ToolMethods.isEquals((Object)item.getItemNotaLivroFiscal().getCfop().getCfopCompra(), (Object)1)) {
            return;
        }
        for (GradeItemNotaFiscalPropria gr : item.getGradesNotaFiscalPropria()) {
            gr.setValorTransfFiscal(gr.getValorCusto());
        }
        if (opImpostos == null) {
            return;
        }
        if (!ToolMethods.isStrWithData((String)opImpostos.getExpressaoAnaliseVrTransfNFP())) {
            return;
        }
        for (GradeItemNotaFiscalPropria gr : item.getGradesNotaFiscalPropria()) {
            String str = ((CompOBSDinamica)Context.get(CompOBSDinamica.class)).build(gr, opImpostos.getExpressaoAnaliseVrTransfNFP(), false);
            Double d = ToolJepExpressionParser.evaluate((String)str, new HashMap());
            gr.setValorTransfFiscal(d);
        }
    }

    private void atualizarValorCompra(ItemNotaFiscalPropria item) {
        if (!ToolMethods.isEquals((Object)item.getItemNotaLivroFiscal().getCfop().getCfopCompra(), (Object)1)) {
            return;
        }
        for (GradeItemNotaFiscalPropria gr : item.getGradesNotaFiscalPropria()) {
            Double d = (item.getVrProduto() + item.getVrServico() + item.getItemNotaLivroFiscal().getVrIpiComercio() + item.getItemNotaLivroFiscal().getVrIpiIndustria() + item.getItemNotaLivroFiscal().getVrIpiObservacao() + item.getItemNotaLivroFiscal().getVrIcmsSt()) / item.getQuantidadeTotal() * gr.getFatorConversao();
            gr.setValorUltPrecoCompra(d);
        }
    }

    private double getValorFreteItem(ItemNotaFiscalPropria item) {
        return ToolFormatter.arrredondarNumero((Double)(item.getValorFreteItemInf() + item.getValorFreteRateado()), (int)2);
    }

    private double getValorDescontoItem(ItemNotaFiscalPropria item) {
        return ToolFormatter.arrredondarNumero((Double)(item.getValorDescontoItemInf() + item.getValorDescontoRateado()), (int)2);
    }

    private double getValorDespAcssItem(ItemNotaFiscalPropria item) {
        return ToolFormatter.arrredondarNumero((Double)(item.getValorDespAcessItemInf() + item.getValorDespAcessRateado()), (int)2);
    }

    private double getValorSeguroItem(ItemNotaFiscalPropria item) {
        return ToolFormatter.arrredondarNumero((Double)(item.getValorSeguroItemInf() + item.getValorSeguroRateado()), (int)2);
    }
}

