/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.calculoimpostos.impostosxml;

import com.touchcomp.basementor.constants.ConstantsNotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.IncidenciaIcms;
import com.touchcomp.basementor.model.vo.ItemNotaLivroFiscal;
import com.touchcomp.basementor.model.vo.ItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.MotivoDesoneracaoIcms;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.dao.impl.DaoMotivoDesoneracaoIcmsImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class AuxImportaNotaTerceirosICMS {
    private Namespace n = ConstantsNotaFiscalTerceiros.NAMESPACE_XML_NFE_X1;
    private static final TLogger logger = TLogger.get(AuxImportaNotaTerceirosICMS.class);
    private DaoMotivoDesoneracaoIcmsImpl daoMotivoDesoneracao = (DaoMotivoDesoneracaoIcmsImpl)ConfApplicationContext.getBean(DaoMotivoDesoneracaoIcmsImpl.class);

    private Element getIcms(Element icms) {
        String[] compICMS;
        for (String cp : compICMS = new String[]{"00", "10", "20", "30", "40", "51", "60", "70", "90"}) {
            Element icmsInt = icms.getChild("ICMS" + cp, this.n);
            if (icmsInt == null) continue;
            return icmsInt;
        }
        return null;
    }

    public void valoresImpostosICMS(Element icms, ItemNotaTerceiros vo, Short importarStRet, Short modoCalculoIcmsSt, Short buscarValorInformadoNota) {
        if (icms == null) {
            return;
        }
        Element icmsInt = this.getIcms(icms);
        if (icmsInt == null) {
            return;
        }
        if (icmsInt.getChildText("vBC", this.n) != null) {
            vo.getItemNotaLivroFiscal().setVrBcCalculoIcms(Double.valueOf(icmsInt.getChildText("vBC", this.n)));
        }
        if (icmsInt.getChildText("pICMS", this.n) != null) {
            vo.getItemNotaLivroFiscal().setAliquotaIcms(Double.valueOf(icmsInt.getChildText("pICMS", this.n)));
        }
        if (buscarValorInformadoNota == 1) {
            if (icmsInt.getChildText("pRedBC", this.n) != null) {
                vo.getItemNotaLivroFiscal().setPercReducaoBCIcms(Double.valueOf(icmsInt.getChildText("pRedBC", this.n)));
            } else {
                vo.getItemNotaLivroFiscal().setPercReducaoBCIcms(Double.valueOf(0.0));
            }
        } else if (ToolMethods.isEquals((Object)vo.getModeloFiscal().getModeloFiscalIcms().getTipoPercReducaoBaseCalcIcms(), (Object)2)) {
            vo.getItemNotaLivroFiscal().setPercReducaoBCIcms(vo.getModeloFiscal().getModeloFiscalIcms().getReducaoBaseCalcIcms());
        } else {
            vo.getItemNotaLivroFiscal().setPercReducaoBCIcms(vo.getProduto().getReducaoBaseCalcIcms());
        }
        if (icmsInt.getChildText("vICMS", this.n) != null) {
            vo.getItemNotaLivroFiscal().setVrIcms(Double.valueOf(icmsInt.getChildText("vICMS", this.n)));
        }
        if (icmsInt.getChildText("vICMSDeson", this.n) != null) {
            vo.getItemNotaLivroFiscal().setVrIcmsDesonerado(Double.valueOf(icmsInt.getChildText("vICMSDeson", this.n)));
        }
        if (icmsInt.getChildText("motDesICMS", this.n) != null) {
            String codigo = icmsInt.getChildText("motDesICMS", this.n);
            vo.getItemNotaLivroFiscal().setMotivoDesoneracaoIcms(this.getMotivoDesoneracaoIcms(codigo));
        }
        if (icmsInt.getChildText("vFCPST", this.n) != null) {
            vo.getItemNotaLivroFiscal().setValorFCPSt(Double.valueOf(icmsInt.getChildText("vFCPST", this.n)));
        }
        if (icmsInt.getChildText("pFCPST", this.n) != null) {
            vo.getItemNotaLivroFiscal().setAliquotaFCPSt(Double.valueOf(icmsInt.getChildText("pFCPST", this.n)));
        }
        if (icmsInt.getChildText("vBCFCPST", this.n) != null) {
            vo.getItemNotaLivroFiscal().setValorBCFCPSt(Double.valueOf(icmsInt.getChildText("vBCFCPST", this.n)));
        }
        this.processaValoresAcordoModeloFiscal(vo);
        this.setIcmsST(icmsInt, modoCalculoIcmsSt, vo, importarStRet);
    }

    private void setIcmsST(Element icmsInt, Short modoCalculoIcmsSt, ItemNotaTerceiros vo, Short importarStRet) {
        if (modoCalculoIcmsSt.equals((short)0)) {
            if (icmsInt.getChildText("vBCST", this.n) != null) {
                vo.getItemNotaLivroFiscal().setVrBcCalculoIcmsSt(Double.valueOf(icmsInt.getChildText("vBCST", this.n)));
            }
            if (icmsInt.getChildText("pICMSST", this.n) != null) {
                vo.getItemNotaLivroFiscal().setAliquotaIcmsST(Double.valueOf(icmsInt.getChildText("pICMSST", this.n)));
            }
            if (icmsInt.getChildText("vICMSST", this.n) != null) {
                vo.getItemNotaLivroFiscal().setVrIcmsSt(Double.valueOf(icmsInt.getChildText("vICMSST", this.n)));
            }
            if (importarStRet != null && importarStRet == 1 && icmsInt.getChildText("vICMSSTRet", this.n) != null) {
                vo.getItemNotaLivroFiscal().setVrIcmsSt(Double.valueOf(icmsInt.getChildText("vICMSSTRet", this.n)));
            }
            if (icmsInt.getChildText("pMVAST", this.n) != null) {
                vo.getItemNotaLivroFiscal().setDescontoPadraoIcmsST(Double.valueOf(icmsInt.getChildText("pMVAST", this.n)));
            }
            if (importarStRet != null && importarStRet == 1 && icmsInt.getChildText("vBCSTRet", this.n) != null) {
                vo.getItemNotaLivroFiscal().setVrBcCalculoIcmsSt(Double.valueOf(icmsInt.getChildText("vBCSTRet", this.n)));
            }
        } else {
            if (icmsInt.getChildText("vBCST", this.n) != null) {
                vo.getItemNotaLivroFiscal().setVrBCCustoICMSST(Double.valueOf(icmsInt.getChildText("vBCST", this.n)));
            }
            if (icmsInt.getChildText("vICMSST", this.n) != null) {
                vo.getItemNotaLivroFiscal().setVrCustoICMSST(Double.valueOf(icmsInt.getChildText("vICMSST", this.n)));
            }
            if (importarStRet != null && importarStRet == 1 && icmsInt.getChildText("vICMSSTRet", this.n) != null) {
                vo.getItemNotaLivroFiscal().setVrCustoICMSST(Double.valueOf(icmsInt.getChildText("vICMSSTRet", this.n)));
            }
            if (importarStRet != null && importarStRet == 1 && icmsInt.getChildText("vBCSTRet", this.n) != null) {
                vo.getItemNotaLivroFiscal().setVrBCCustoICMSST(Double.valueOf(icmsInt.getChildText("vBCSTRet", this.n)));
            }
            vo.getItemNotaLivroFiscal().setVrBcCalculoIcmsSt(Double.valueOf(0.0));
            vo.getItemNotaLivroFiscal().setAliquotaIcmsST(Double.valueOf(0.0));
            vo.getItemNotaLivroFiscal().setVrIcmsSt(Double.valueOf(0.0));
            vo.getItemNotaLivroFiscal().setDescontoPadraoIcmsST(Double.valueOf(0.0));
            vo.getItemNotaLivroFiscal().setValorStCustoCompTotNota(Short.valueOf((short)1));
        }
    }

    private void processaValoresAcordoModeloFiscal(ItemNotaTerceiros vo) {
        ItemNotaLivroFiscal item = vo.getItemNotaLivroFiscal();
        if (vo.getModeloFiscal().getModeloFiscalIcms().getRecuperarTributosIcms() == 1) {
            if (this.incidenciaIsenta(vo.getModeloFiscal().getModeloFiscalIcms().getIncidenciaIcms())) {
                item.setVrIcmsIsento(item.getVrBcCalculoIcms());
            } else if (item.getVrIcms() > 0.0) {
                item.setVrIcmsTributado(item.getVrBcCalculoIcms());
            } else {
                item.setVrIcmsOutros(item.getVrBcCalculoIcms());
            }
        } else {
            item.setVrIcmsSemAprov(item.getVrIcms());
            item.setVrIcmsOutros(item.getVrBcCalculoIcms());
            item.setVrIcms(Double.valueOf(0.0));
        }
        if (this.incidenciaReducao(vo.getModeloFiscal().getModeloFiscalIcms().getIncidenciaIcms()) && vo.getItemNotaLivroFiscal().getPercReducaoBCIcms() > 0.0) {
            Double percRed = vo.getItemNotaLivroFiscal().getPercReducaoBCIcms();
            Double bcICMS = vo.getItemNotaLivroFiscal().getVrBcCalculoIcms();
            Double diferenca = 100.0 - percRed;
            Double vrReduz = ToolFormatter.arrredondarNumero((Double)(percRed * bcICMS / diferenca), (int)2);
            Double total = ToolFormatter.arrredondarNumero((Double)(bcICMS + vrReduz), (int)2);
            if (total > vo.getVrProduto() + vo.getVrServico()) {
                Double dif = ToolFormatter.arrredondarNumero((Double)(total - (vo.getVrProduto() + vo.getVrServico())), (int)2);
                vrReduz = vrReduz - dif;
            } else if (total < vo.getVrProduto() + vo.getVrServico()) {
                Double dif = ToolFormatter.arrredondarNumero((Double)(vo.getVrProduto() + vo.getVrServico() - total), (int)2);
                vrReduz = vrReduz + dif;
            }
            vo.getItemNotaLivroFiscal().setVrBcCalculoIcms(Double.valueOf(bcICMS + vrReduz));
            vo.getItemNotaLivroFiscal().setVrNaoTribICMS(vrReduz);
            vo.getItemNotaLivroFiscal().setVrIcmsIsento(vrReduz);
            if (vo.getModeloFiscal().getModeloFiscalIcms().getIcmsDispensadoDesconto() != null && (vo.getModeloFiscal().getModeloFiscalIcms().getIcmsDispensadoDesconto().equals((short)1) || vo.getModeloFiscal().getModeloFiscalIcms().getIcmsDispensadoDesconto().equals((short)2))) {
                vo.getItemNotaLivroFiscal().setVrIcmsIsento(Double.valueOf(vrReduz - vo.getItemNotaLivroFiscal().getVrIcmsDesonerado()));
            }
        }
    }

    private boolean incidenciaIsenta(IncidenciaIcms incidenciaIcms) {
        return this.isIncidenciaIsenta(incidenciaIcms.getCodigo());
    }

    private boolean incidenciaReducao(IncidenciaIcms incidenciaIcms) {
        String codigo = incidenciaIcms.getCodigo();
        if (codigo.trim().length() == 3) {
            codigo = codigo.substring(1);
        }
        return this.isIncidenciaReducao(codigo);
    }

    private MotivoDesoneracaoIcms getMotivoDesoneracaoIcms(String codigo) {
        return this.daoMotivoDesoneracao.findByCodigo(codigo);
    }

    private boolean isIncidenciaIsenta(String codigo) {
        if (codigo.equalsIgnoreCase("41")) {
            return true;
        }
        if (codigo.equalsIgnoreCase("40")) {
            return true;
        }
        return codigo.equalsIgnoreCase("30");
    }

    private boolean isIncidenciaReducao(String codigo) {
        if (codigo.equalsIgnoreCase("20")) {
            return true;
        }
        return codigo.equalsIgnoreCase("70");
    }
}

