/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.calculoimpostos.impostosxml;

import com.touchcomp.basementor.constants.ConstantsNotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.ItemNotaLivroFiscal;
import com.touchcomp.basementor.model.vo.ItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.UnidadeFatFornecedor;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class AuxImportaNotaTerceirosIPI {
    private Namespace n = ConstantsNotaFiscalTerceiros.NAMESPACE_XML_NFE_X1;

    private Element getIpi(Element ipi) {
        String[] compIPI;
        for (String cp : compIPI = new String[]{"Trib", "INT"}) {
            Element ipiInt = ipi.getChild("IPI" + cp, this.n);
            if (ipiInt == null) continue;
            return ipiInt;
        }
        return null;
    }

    public void valoresImpostosIPI(Element ipi, ItemNotaTerceiros vo, UnidadeFatFornecedor unid) {
        if (ipi != null) {
            Element ipiInt = this.getIpi(ipi);
            if (ipiInt == null) {
                return;
            }
            if (ipiInt.getChildText("pIPI", this.n) != null) {
                vo.getItemNotaLivroFiscal().setAliquotaIpi(Double.valueOf(ipiInt.getChildText("pIPI", this.n)));
            }
            if (ipiInt.getChildText("vIPI", this.n) != null) {
                vo.getItemNotaLivroFiscal().setVrIpiIndustria(Double.valueOf(ipiInt.getChildText("vIPI", this.n)));
            }
        } else {
            vo.getItemNotaLivroFiscal().setVrIpiTributado(vo.getItemNotaLivroFiscal().getVrBcCalculoIcms());
        }
        this.setarValoresAcordoModeloFiscal(ipi, vo, unid);
    }

    private void setarValoresAcordoModeloFiscal(Element ipi, ItemNotaTerceiros vo, UnidadeFatFornecedor unid) {
        boolean recTributos;
        ItemNotaLivroFiscal item = vo.getItemNotaLivroFiscal();
        boolean fornIndustria = unid.getFornecedor().getTipo() == 1;
        boolean fornComercio = unid.getFornecedor().getTipo() == 0;
        boolean bl = recTributos = vo.getModeloFiscal().getModeloFiscalIpi().getRecuperarTributosIPI() != null && vo.getModeloFiscal().getModeloFiscalIpi().getRecuperarTributosIPI() == 1;
        if (recTributos && fornIndustria) {
            item.setVrIpiIndustria(item.getVrIpiIndustria());
            item.setVrIpiTributado(item.getVrIpiTributado());
        } else if (recTributos && fornComercio) {
            item.setVrIpiTributado(item.getVrIpiTributado());
            item.setVrIpiComercio(item.getVrIpiIndustria());
            item.setVrIpiIndustria(Double.valueOf(0.0));
        } else if (!recTributos && fornIndustria) {
            item.setVrIpiOutros(item.getVrIpiTributado());
            item.setVrIpiObservacao(item.getVrIpiIndustria());
            item.setVrIpiIndustria(Double.valueOf(0.0));
            item.setVrIpiTributado(Double.valueOf(0.0));
        } else if (!recTributos && fornComercio) {
            item.setVrIpiOutros(item.getVrIpiTributado());
            item.setVrIpiObservacao(item.getVrIpiIndustria());
            item.setVrIpiIndustria(Double.valueOf(0.0));
            item.setVrIpiTributado(Double.valueOf(0.0));
        }
    }
}

