/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.calculoimpostos.impostosxml;

import com.touchcomp.basementor.constants.ConstantsNotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.IncidenciaIcms;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ModalidadeIcms;
import com.touchcomp.basementorservice.dao.impl.DaoIncidenciaIcmsImpl;
import com.touchcomp.basementorservice.dao.impl.DaoModalidadeIcmsImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class AuxImportarNotaPropriaICMS {
    private Namespace n = ConstantsNotaFiscalTerceiros.NAMESPACE_XML_NFE_X1;
    private DaoIncidenciaIcmsImpl daoIncidenciaIcms = (DaoIncidenciaIcmsImpl)ConfApplicationContext.getBean(DaoIncidenciaIcmsImpl.class);
    private DaoModalidadeIcmsImpl daoModalidadeIcms = (DaoModalidadeIcmsImpl)ConfApplicationContext.getBean(DaoModalidadeIcmsImpl.class);

    private Element getIcms(Element icms) {
        String[] compICMS;
        for (String cp : compICMS = new String[]{"00", "10", "20", "30", "40", "51", "60", "70", "90"}) {
            Element icmsInt = icms.getChild("ICMS" + cp, this.n);
            if (icmsInt == null) continue;
            return icmsInt;
        }
        return null;
    }

    public void valoresImpostosICMS(Element icms, ItemNotaFiscalPropria vo) {
        ModalidadeIcms modalidadeIcms;
        String modBC;
        if (icms == null) {
            return;
        }
        Element icmsInt = this.getIcms(icms);
        if (icmsInt == null) {
            return;
        }
        Double bcIcms = 0.0;
        Double aliqIcms = 0.0;
        Double percRedBC = 0.0;
        Double vrIcms = 0.0;
        if (icmsInt.getChildText("orig", this.n) != null && icmsInt.getChildText("CST", this.n) != null) {
            String codigo;
            IncidenciaIcms incidenciaIcms;
            String origem = icmsInt.getChildText("orig", this.n);
            String cst = icmsInt.getChildText("CST", this.n);
            if (origem.trim().length() > 0 && cst.trim().length() > 0 && (incidenciaIcms = this.getIncidenciaIcmsPorCodigo(codigo = origem + cst)) != null) {
                vo.setIncidenciaIcms(incidenciaIcms);
            }
        }
        if (icmsInt.getChildText("modBC", this.n) != null && (modBC = icmsInt.getChildText("modBC", this.n)).trim().length() > 0 && (modalidadeIcms = this.getModalidadeIcmsPorCodigo(modBC)) != null) {
            vo.setModalidadeIcms(modalidadeIcms);
        }
        if (icmsInt.getChildText("vBC", this.n) != null) {
            bcIcms = Double.valueOf(icmsInt.getChildText("vBC", this.n));
        }
        if (icmsInt.getChildText("pICMS", this.n) != null) {
            aliqIcms = Double.valueOf(icmsInt.getChildText("pICMS", this.n));
        }
        if (icmsInt.getChildText("pRedBC", this.n) != null) {
            percRedBC = Double.valueOf(icmsInt.getChildText("pRedBC", this.n));
        }
        if (icmsInt.getChildText("vICMS", this.n) != null) {
            vrIcms = Double.valueOf(icmsInt.getChildText("vICMS", this.n));
        }
        if (icmsInt.getName().equals("ICMS00") || icmsInt.getText().equals("ICMS10")) {
            vo.getItemNotaLivroFiscal().setVrIcms(vrIcms);
            vo.getItemNotaLivroFiscal().setAliquotaIcms(aliqIcms);
            vo.getItemNotaLivroFiscal().setVrIcmsTributado(bcIcms);
            vo.getItemNotaLivroFiscal().setVrBcCalculoIcms(bcIcms);
        } else if (icmsInt.getName().equals("ICMS30") || icmsInt.getName().equals("ICMS40") || icmsInt.getName().equals("ICMS41")) {
            vo.getItemNotaLivroFiscal().setAliquotaIcms(aliqIcms);
            vo.getItemNotaLivroFiscal().setVrIcmsIsento(bcIcms);
            vo.getItemNotaLivroFiscal().setVrBcCalculoIcms(bcIcms);
        } else if (icmsInt.getName().equals("ICMS50") || icmsInt.getName().equals("ICMS51") || icmsInt.getName().equals("ICMS60")) {
            vo.getItemNotaLivroFiscal().setAliquotaIcms(aliqIcms);
            vo.getItemNotaLivroFiscal().setVrIcmsOutros(bcIcms);
            vo.getItemNotaLivroFiscal().setVrBcCalculoIcms(bcIcms);
        } else if (icmsInt.getName().equals("ICMS20") || icmsInt.getName().equals("ICMS70") || icmsInt.getName().equals("ICMS90")) {
            double vrReduz = 0.0;
            if (bcIcms > 0.0 && percRedBC > 0.0) {
                vrReduz = bcIcms * (percRedBC / 100.0);
            }
            vo.getItemNotaLivroFiscal().setVrIcmsTributado(Double.valueOf(bcIcms - vrReduz));
            vo.getItemNotaLivroFiscal().setVrBcCalculoIcms(bcIcms);
            vo.getItemNotaLivroFiscal().setAliquotaIcms(aliqIcms);
            vo.getItemNotaLivroFiscal().setVrIcms(vrIcms);
            vo.getItemNotaLivroFiscal().setVrIcmsIsento(Double.valueOf(vrReduz));
        }
        this.setIcmsST(icmsInt, vo);
    }

    private void setIcmsST(Element icmsInt, ItemNotaFiscalPropria vo) {
        if (icmsInt.getChildText("vBCST", this.n) != null) {
            vo.getItemNotaLivroFiscal().setVrBcCalculoIcmsSt(Double.valueOf(icmsInt.getChildText("vBCST", this.n)));
        }
        if (icmsInt.getChildText("pICMSST", this.n) != null) {
            vo.getItemNotaLivroFiscal().setAliquotaIcmsST(Double.valueOf(icmsInt.getChildText("pICMSST", this.n)));
        }
        if (icmsInt.getChildText("vICMSST", this.n) != null) {
            vo.getItemNotaLivroFiscal().setVrIcmsSt(Double.valueOf(icmsInt.getChildText("vICMSST", this.n)));
        }
        if (icmsInt.getChildText("vICMSSTRet", this.n) != null) {
            vo.getItemNotaLivroFiscal().setVrIcmsSt(Double.valueOf(icmsInt.getChildText("vICMSSTRet", this.n)));
        }
        if (icmsInt.getChildText("pMVAST", this.n) != null) {
            vo.getItemNotaLivroFiscal().setDescontoPadraoIcmsST(Double.valueOf(icmsInt.getChildText("pMVAST", this.n)));
        }
        if (icmsInt.getChildText("vBCSTRet", this.n) != null) {
            vo.getItemNotaLivroFiscal().setVrBcCalculoIcmsSt(Double.valueOf(icmsInt.getChildText("vBCSTRet", this.n)));
        }
    }

    private IncidenciaIcms getIncidenciaIcmsPorCodigo(String codigo) {
        return this.daoIncidenciaIcms.findByCodigo(codigo);
    }

    private ModalidadeIcms getModalidadeIcmsPorCodigo(String codigo) {
        return this.daoModalidadeIcms.findByCodigo(codigo);
    }
}

