/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.calculoimpostos.impostosxml;

import com.touchcomp.basementor.constants.ConstantsNotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.IncidenciaIcms;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementorservice.dao.impl.DaoIncidenciaIcmsImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class AuxImportarNotaPropriaICMSSN {
    private Namespace n = ConstantsNotaFiscalTerceiros.NAMESPACE_XML_NFE_X1;
    private DaoIncidenciaIcmsImpl daoIncidenciaIcms = (DaoIncidenciaIcmsImpl)ConfApplicationContext.getBean(DaoIncidenciaIcmsImpl.class);

    private Element getIcms(Element icms) {
        String[] compICMS;
        for (String cp : compICMS = new String[]{"101", "102", "201", "202", "203", "400"}) {
            Element icmsInt = icms.getChild("ICMSSN" + cp, this.n);
            if (icmsInt == null) continue;
            return icmsInt;
        }
        return null;
    }

    public void valoresImpostosICMSSN(Element icms, ItemNotaFiscalPropria vo) throws Exception {
        if (icms == null) {
            return;
        }
        Element icmsInt = this.getIcms(icms);
        if (icmsInt == null) {
            return;
        }
        if (icmsInt.getChildText("orig", this.n) != null && icmsInt.getChildText("CSOSN", this.n) != null) {
            String codigo;
            IncidenciaIcms incidenciaIcms;
            String origem = icmsInt.getChildText("orig", this.n);
            String cst = icmsInt.getChildText("CSOSN", this.n);
            if (origem.trim().length() > 0 && cst.trim().length() > 0 && (incidenciaIcms = this.getIncidenciaIcmsPorCodigo(codigo = origem + cst)) != null) {
                vo.setIncidenciaIcms(incidenciaIcms);
            }
        }
        Double bcIcms = 0.0;
        Double aliqIcms = 0.0;
        Double percRedBC = 0.0;
        Double vrIcms = 0.0;
        if (icmsInt.getChildText("vBC", this.n) != null) {
            bcIcms = Double.valueOf(icmsInt.getChildText("vBC", this.n));
        }
        if (icmsInt.getChildText("pICMS", this.n) != null) {
            aliqIcms = Double.valueOf(icmsInt.getChildText("pICMS", this.n));
        }
        if (icmsInt.getChildText("pRedBC", this.n) != null) {
            percRedBC = Double.valueOf(icmsInt.getChildText("pRedBC", this.n));
        }
        if (icmsInt.getChildText("vICMS", this.n) != null) {
            vrIcms = Double.valueOf(icmsInt.getChildText("vICMS", this.n));
        }
        if (icmsInt.getName().equals("ICMSSN101") || icmsInt.getName().equals("ICMSSN900")) {
            vo.getItemNotaLivroFiscal().setValorICMSSimples(vrIcms);
            vo.getItemNotaLivroFiscal().setAliquotaICMSSimples(aliqIcms);
            vo.getItemNotaLivroFiscal().setAliquotaIcms(Double.valueOf(0.0));
            vo.getItemNotaLivroFiscal().setVrIcmsOutros(bcIcms);
            vo.getItemNotaLivroFiscal().setVrBcCalculoIcms(bcIcms);
        } else if (icmsInt.getName().equals("ICMSSN102") || icmsInt.getName().equals("ICMSSN103") || icmsInt.getName().equals("ICMSSN500")) {
            vo.getItemNotaLivroFiscal().setValorICMSSimples(Double.valueOf(0.0));
            vo.getItemNotaLivroFiscal().setAliquotaICMSSimples(Double.valueOf(0.0));
            vo.getItemNotaLivroFiscal().setAliquotaIcms(Double.valueOf(0.0));
            vo.getItemNotaLivroFiscal().setVrIcmsOutros(bcIcms);
            vo.getItemNotaLivroFiscal().setVrBcCalculoIcms(bcIcms);
        } else if (icmsInt.getName().equals("ICMSSN201") || icmsInt.getName().equals("ICMSSN202") || icmsInt.getName().equals("ICMSSN203")) {
            vo.getItemNotaLivroFiscal().setVrIcmsOutros(bcIcms);
            vo.getItemNotaLivroFiscal().setVrBcCalculoIcms(bcIcms);
            vo.getItemNotaLivroFiscal().setAliquotaIcms(Double.valueOf(0.0));
            vo.getItemNotaLivroFiscal().setAliquotaIcms(Double.valueOf(0.0));
            this.setIcmsST(icmsInt, vo);
        } else if (icmsInt.getName().equals("ICMSSN300") || icmsInt.getName().equals("ICMSSN400")) {
            vo.getItemNotaLivroFiscal().setVrIcmsIsento(bcIcms);
            vo.getItemNotaLivroFiscal().setVrBcCalculoIcms(bcIcms);
            vo.getItemNotaLivroFiscal().setAliquotaIcms(Double.valueOf(0.0));
            vo.getItemNotaLivroFiscal().setAliquotaIcms(Double.valueOf(0.0));
        }
    }

    private void setIcmsST(Element icmsInt, ItemNotaFiscalPropria vo) {
        if (icmsInt.getChildText("vBCST", this.n) != null) {
            vo.getItemNotaLivroFiscal().setVrBcCalculoIcmsSt(Double.valueOf(icmsInt.getChildText("vBCST", this.n)));
        }
        if (icmsInt.getChildText("pICMSST", this.n) != null) {
            vo.getItemNotaLivroFiscal().setAliquotaIcmsST(Double.valueOf(icmsInt.getChildText("pICMSST", this.n)));
        }
        if (icmsInt.getChildText("vICMSST", this.n) != null) {
            vo.getItemNotaLivroFiscal().setVrIcmsSt(Double.valueOf(icmsInt.getChildText("vICMSST", this.n)));
        }
        if (icmsInt.getChildText("vICMSSTRet", this.n) != null) {
            vo.getItemNotaLivroFiscal().setVrIcmsSt(Double.valueOf(icmsInt.getChildText("vICMSSTRet", this.n)));
        }
        if (icmsInt.getChildText("pMVAST", this.n) != null) {
            vo.getItemNotaLivroFiscal().setDescontoPadraoIcmsST(Double.valueOf(icmsInt.getChildText("pMVAST", this.n)));
        }
        if (icmsInt.getChildText("vBCSTRet", this.n) != null) {
            vo.getItemNotaLivroFiscal().setVrBcCalculoIcmsSt(Double.valueOf(icmsInt.getChildText("vBCSTRet", this.n)));
        }
    }

    private IncidenciaIcms getIncidenciaIcmsPorCodigo(String codigo) {
        return this.daoIncidenciaIcms.findByCodigo(codigo);
    }
}

