/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.calculoimpostos.impostosxml;

import com.touchcomp.basementor.constants.ConstantsNotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.IncidenciaPisCofins;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementorservice.dao.impl.DaoIncidenciaPisCofinsImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class AuxImportarNotaPropriaPis {
    private Namespace n = ConstantsNotaFiscalTerceiros.NAMESPACE_XML_NFE_X1;
    private DaoIncidenciaPisCofinsImpl daoIncidenciaPisCofins = (DaoIncidenciaPisCofinsImpl)ConfApplicationContext.getBean(DaoIncidenciaPisCofinsImpl.class);

    private Element getPis(Element pis) {
        String[] compPIS;
        for (String cp : compPIS = new String[]{"Aliq", "Qtde", "NT", "Outr"}) {
            Element pisInt = pis.getChild("PIS" + cp, this.n);
            if (pisInt == null) continue;
            return pisInt;
        }
        return null;
    }

    public void valoresImpostosPIS(Element pis, ItemNotaFiscalPropria vo) throws Exception {
        IncidenciaPisCofins incidenciaPisCofins;
        String cst;
        if (pis == null) {
            return;
        }
        Element pisInt = this.getPis(pis);
        if (pisInt == null) {
            return;
        }
        if (pisInt.getChildText("CST", this.n) != null && (cst = pisInt.getChildText("CST", this.n)).trim().length() > 0 && (incidenciaPisCofins = this.getIncidenciaPisCofinsPorCodigo(cst)) != null) {
            vo.setIncidenciaPisCofins(incidenciaPisCofins);
        }
        if (pisInt.getChildText("vPIS", this.n) != null) {
            String vlrPis = pisInt.getChildText("vPIS", this.n);
            if (vlrPis != null) {
                vo.getItemNotaLivroFiscal().setVrPis(Double.valueOf(vlrPis));
            }
        } else {
            vo.getItemNotaLivroFiscal().setVrPis(Double.valueOf(0.0));
        }
        String aliqPis = pisInt.getChildText("pPIS", this.n);
        if (aliqPis == null) {
            aliqPis = pisInt.getChildText("vAliqProd", this.n);
        }
        if (aliqPis != null) {
            vo.getItemNotaLivroFiscal().setAliquotaPis(Double.valueOf(aliqPis));
        } else {
            vo.getItemNotaLivroFiscal().setAliquotaPis(Double.valueOf(0.0));
        }
    }

    private IncidenciaPisCofins getIncidenciaPisCofinsPorCodigo(String cst) {
        return this.daoIncidenciaPisCofins.findByCodigo(cst);
    }
}

