/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.calculoinssempresa;

import com.touchcomp.basementor.constants.ConstantsESocial;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.colaborador.EnumConstTipoColaborador;
import com.touchcomp.basementor.model.vo.AberturaPeriodo;
import com.touchcomp.basementor.model.vo.CalculoInssAberturaPeriodo;
import com.touchcomp.basementor.model.vo.CalculoInssEmpresa;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.ItemMovimentoFolha;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import com.touchcomp.basementor.model.vo.TipoCalculo;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.service.impl.aberturaperiodo.ServiceAberturaPeriodoImpl;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompCalculoInssEmpresa {
    @Autowired
    private ServiceAberturaPeriodoImpl serviceAberturaPeriodo;

    public CalculoInssEmpresa buscarAberturaPeriodo(Date periodo, TipoCalculo tipoCalculo, Empresa empresa, EmpresaRh empresaRh) {
        CalculoInssEmpresa calculoInssEmpresa = new CalculoInssEmpresa();
        this.criarCalculoInssAberturaPeriodo(calculoInssEmpresa, this.serviceAberturaPeriodo.findAberturaPeriodoByCalculoInss(periodo, tipoCalculo, empresa));
        this.calcularSalarioFamilia(calculoInssEmpresa);
        this.calcularSalarioMaternidade(calculoInssEmpresa);
        this.calcularSalarioMaternidadeDecimoTerceiro(calculoInssEmpresa, empresaRh);
        this.calcularAtestados(calculoInssEmpresa);
        this.calcularImpostos(calculoInssEmpresa, empresaRh);
        return calculoInssEmpresa;
    }

    private void criarCalculoInssAberturaPeriodo(CalculoInssEmpresa calculoInssEmpresa, List<AberturaPeriodo> listAberturaPeriodo) {
        if (!ToolMethods.isWithData(listAberturaPeriodo)) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0817.001"));
        }
        for (AberturaPeriodo aberturaPeriodo : listAberturaPeriodo) {
            boolean b = calculoInssEmpresa.getAberturasPeriodo().stream().anyMatch(c -> c.getAberturaPeriodo().equals((Object)aberturaPeriodo));
            if (b) continue;
            CalculoInssAberturaPeriodo calculoInssAberturaPeriodo = new CalculoInssAberturaPeriodo();
            calculoInssAberturaPeriodo.setAberturaPeriodo(aberturaPeriodo);
            calculoInssEmpresa.getAberturasPeriodo().add(calculoInssAberturaPeriodo);
        }
    }

    private void calcularSalarioFamilia(CalculoInssEmpresa calculoInssEmpresa) {
        Double valorSalarioFamilia = 0.0;
        for (CalculoInssAberturaPeriodo calculoInssAberturaPeriodo : calculoInssEmpresa.getAberturasPeriodo()) {
            for (MovimentoFolha movimentoFolha : calculoInssAberturaPeriodo.getAberturaPeriodo().getMovimentoFolha()) {
                for (ItemMovimentoFolha itemMovimentoFolha : movimentoFolha.getItensMovimentoFolha()) {
                    if (!ToolMethods.isEquals((Object)itemMovimentoFolha.getEventoColaborador().getTipoCalculoEvento().getEsocRubricasFolhaPagamento().getCodigo(), (Object)ConstantsESocial.CODIGO_SALARIO_FAMILIA) && !ToolMethods.isEquals((Object)itemMovimentoFolha.getEventoColaborador().getTipoCalculoEvento().getEsocRubricasFolhaPagamento().getCodigo(), (Object)ConstantsESocial.CODIGO_SALARIO_FAMILIA_COMPLEMENTO)) continue;
                    valorSalarioFamilia = valorSalarioFamilia + itemMovimentoFolha.getValor();
                }
            }
        }
        calculoInssEmpresa.setVlrSalarioFamilia(ToolFormatter.arrredondarNumero((Double)valorSalarioFamilia, (int)2));
    }

    private void calcularSalarioMaternidade(CalculoInssEmpresa calculoInssEmpresa) {
        Double valorSalarioMaternidade = 0.0;
        for (CalculoInssAberturaPeriodo calculoInssAberturaPeriodo : calculoInssEmpresa.getAberturasPeriodo()) {
            for (MovimentoFolha movimentoFolha : calculoInssAberturaPeriodo.getAberturaPeriodo().getMovimentoFolha()) {
                for (ItemMovimentoFolha itemMovimentoFolha : movimentoFolha.getItensMovimentoFolha()) {
                    if (!ToolMethods.isEquals((Object)itemMovimentoFolha.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaPrevidencia().getCodigo(), (Object)"21")) continue;
                    valorSalarioMaternidade = valorSalarioMaternidade + itemMovimentoFolha.getValor();
                }
            }
        }
        calculoInssEmpresa.setSalarioMaternidade(ToolFormatter.arrredondarNumero((Double)valorSalarioMaternidade, (int)2));
    }

    private void calcularSalarioMaternidadeDecimoTerceiro(CalculoInssEmpresa calculoInssEmpresa, EmpresaRh empresaRh) {
        Double valorSalarioMaternidadeDecimoTerceiro = 0.0;
        for (CalculoInssAberturaPeriodo calculoInssAberturaPeriodo : calculoInssEmpresa.getAberturasPeriodo()) {
            for (MovimentoFolha movimentoFolha : calculoInssAberturaPeriodo.getAberturaPeriodo().getMovimentoFolha()) {
                for (ItemMovimentoFolha itemMovimentoFolha : movimentoFolha.getItensMovimentoFolha()) {
                    if (!ToolMethods.isEquals((Object)itemMovimentoFolha.getEventoColaborador().getTipoCalculoEvento(), (Object)empresaRh.getMaternidadeDecPagoPrevidencia())) continue;
                    valorSalarioMaternidadeDecimoTerceiro = valorSalarioMaternidadeDecimoTerceiro + itemMovimentoFolha.getValor();
                }
            }
        }
        calculoInssEmpresa.setSalarioMaternindadeDec(ToolFormatter.arrredondarNumero((Double)valorSalarioMaternidadeDecimoTerceiro, (int)2));
    }

    private void calcularAtestados(CalculoInssEmpresa calculoInssEmpresa) {
        Double valorAtestados = 0.0;
        for (CalculoInssAberturaPeriodo calculoInssAberturaPeriodo : calculoInssEmpresa.getAberturasPeriodo()) {
            for (MovimentoFolha movimentoFolha : calculoInssAberturaPeriodo.getAberturaPeriodo().getMovimentoFolha()) {
                for (ItemMovimentoFolha itemMovimentoFolha : movimentoFolha.getItensMovimentoFolha()) {
                    if (!ToolMethods.isEquals((Object)itemMovimentoFolha.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaPrevidencia().getCodigo(), (Object)"15")) continue;
                    valorAtestados = valorAtestados + itemMovimentoFolha.getValor();
                }
            }
        }
        calculoInssEmpresa.setSalarioMaternidade(ToolFormatter.arrredondarNumero((Double)valorAtestados, (int)2));
    }

    private void calcularImpostos(CalculoInssEmpresa calculoInssEmpresa, EmpresaRh empresaRh) {
        for (CalculoInssAberturaPeriodo calculoInssAberturaPeriodo : calculoInssEmpresa.getAberturasPeriodo()) {
            for (MovimentoFolha movimentoFolha : calculoInssAberturaPeriodo.getAberturaPeriodo().getMovimentoFolha()) {
                if (ToolMethods.isEquals((Object)movimentoFolha.getColaborador().getTipoColaborador().getIdentificador(), (Object)EnumConstTipoColaborador.MENOR_APRENDIZ.getValue()) || ToolMethods.isEquals((Object)movimentoFolha.getColaborador().getTipoColaborador().getIdentificador(), (Object)EnumConstTipoColaborador.EMPREGADO.getValue()) || ToolMethods.isEquals((Object)movimentoFolha.getColaborador().getTipoColaborador().getIdentificador(), (Object)EnumConstTipoColaborador.DOMESTICO.getValue())) {
                    calculoInssEmpresa.setBaseCalculoInssFunc(ToolFormatter.arrredondarNumero((Double)(calculoInssEmpresa.getBaseCalculoInssFunc() + (movimentoFolha.getBcInssSalario() + movimentoFolha.getBcInssFerias() + movimentoFolha.getBcInss13Sal())), (int)2));
                    calculoInssEmpresa.setValorTotalInssFunc(ToolFormatter.arrredondarNumero((Double)(calculoInssEmpresa.getValorTotalInssFunc() + movimentoFolha.getVrInssSalario() + movimentoFolha.getVrInssFerias() + movimentoFolha.getVrInss13Sal()), (int)2));
                    calculoInssEmpresa.setSomaValoresIncidInss(ToolFormatter.arrredondarNumero((Double)(calculoInssEmpresa.getSomaValoresIncidInss() + movimentoFolha.getBaseEmpresaColaborador()), (int)2));
                } else if (ToolMethods.isEquals((Object)movimentoFolha.getColaborador().getTipoColaborador().getIdentificador(), (Object)EnumConstTipoColaborador.SOCIO_DIRETOR.getValue()) || ToolMethods.isEquals((Object)movimentoFolha.getColaborador().getTipoColaborador().getIdentificador(), (Object)EnumConstTipoColaborador.AUTONOMO.getValue())) {
                    calculoInssEmpresa.setBaseCalcInssContribuinteIndividual(ToolFormatter.arrredondarNumero((Double)(calculoInssEmpresa.getBaseCalcInssContribuinteIndividual() + (movimentoFolha.getBcInssSalario() + movimentoFolha.getBcInssFerias() + movimentoFolha.getBcInss13Sal())), (int)2));
                    calculoInssEmpresa.setVlrContribuinteIndividual(ToolFormatter.arrredondarNumero((Double)(calculoInssEmpresa.getVlrContribuinteIndividual() + movimentoFolha.getVrInssSalario() + movimentoFolha.getVrInss13Sal()), (int)2));
                    calculoInssEmpresa.setBaseCalcAutonomo(ToolFormatter.arrredondarNumero((Double)(calculoInssEmpresa.getBaseCalcAutonomo() + movimentoFolha.getBaseEmpresaColaborador()), (int)2));
                } else if (ToolMethods.isEquals((Object)movimentoFolha.getColaborador().getTipoColaborador().getIdentificador(), (Object)EnumConstTipoColaborador.AUTONOMO_FRETE.getValue())) {
                    calculoInssEmpresa.setBaseCalcAutonomoFrete(ToolFormatter.arrredondarNumero((Double)(calculoInssEmpresa.getBaseCalcAutonomoFrete() + (movimentoFolha.getBcInssSalario() + movimentoFolha.getBcInssFerias() + movimentoFolha.getBcInss13Sal())), (int)2));
                    calculoInssEmpresa.setVlrTotalAutonomoFrete(ToolFormatter.arrredondarNumero((Double)(calculoInssEmpresa.getVlrTotalAutonomoFrete() + movimentoFolha.getVrInssSalario() + movimentoFolha.getVrInss13Sal()), (int)2));
                    calculoInssEmpresa.setBaseAutonomoFreteEmpresa(ToolFormatter.arrredondarNumero((Double)(calculoInssEmpresa.getBaseAutonomoFreteEmpresa() + movimentoFolha.getBaseEmpresaColaborador()), (int)2));
                }
                if (ToolMethods.isEquals((Object)movimentoFolha.getCategoriaSefip().getTipoAposentadoria().getAno(), (Object)25)) {
                    calculoInssEmpresa.setBaseAposentadoriaEspecial(ToolFormatter.arrredondarNumero((Double)(calculoInssEmpresa.getBaseAposentadoriaEspecial() + (movimentoFolha.getBcInssSalario() + movimentoFolha.getBcInssFerias() + movimentoFolha.getBcInss13Sal())), (int)2));
                }
                if (ToolMethods.isEquals((Object)movimentoFolha.getCategoriaSefip().getTipoAposentadoria().getAno(), (Object)20)) {
                    calculoInssEmpresa.setBaseAposentadoriaEspecial20(ToolFormatter.arrredondarNumero((Double)(calculoInssEmpresa.getBaseAposentadoriaEspecial20() + (movimentoFolha.getBcInssSalario() + movimentoFolha.getBcInssFerias() + movimentoFolha.getBcInss13Sal())), (int)2));
                }
                if (!ToolMethods.isEquals((Object)movimentoFolha.getCategoriaSefip().getTipoAposentadoria().getAno(), (Object)15)) continue;
                calculoInssEmpresa.setBaseAposentadoriaEspecial15(ToolFormatter.arrredondarNumero((Double)(calculoInssEmpresa.getBaseAposentadoriaEspecial15() + (movimentoFolha.getBcInssSalario() + movimentoFolha.getBcInssFerias() + movimentoFolha.getBcInss13Sal())), (int)2));
            }
        }
        calculoInssEmpresa.setPercEmpresa(empresaRh.getPercEmpresa());
        calculoInssEmpresa.setPercAutonomo(empresaRh.getPercEmpresa());
        calculoInssEmpresa.setPercAutonomoFrete(empresaRh.getPercFrete());
        calculoInssEmpresa.setPercTerceiros(empresaRh.getPercTerceiros());
        calculoInssEmpresa.setPercRat(empresaRh.getPercRat());
        calculoInssEmpresa.setPercSestSenac(empresaRh.getPercSENAT());
        calculoInssEmpresa.setPercAposentadoriaEspecial(empresaRh.getPercAposentadoriaEspecial25Anos());
        calculoInssEmpresa.setPercAposentadoriaEspecial15(empresaRh.getPercAposentadoriaEspecial15anos());
        calculoInssEmpresa.setPercAposentadoriaEspecial20(empresaRh.getPercAposentadoriaEspecial20anos());
        calculoInssEmpresa.setPercDesoneracao(Double.valueOf(0.0));
        calculoInssEmpresa.setAliqFreteEmpresa(empresaRh.getPercEmpresa());
        if (ToolMethods.isEquals((Object)empresaRh.getPossuiDesoneracao(), (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            calculoInssEmpresa.setPercDesoneracao(Double.valueOf(100.0));
        }
        calculoInssEmpresa.setValorAposentadoriaEspecial(ToolFormatter.arrredondarNumero((Double)(calculoInssEmpresa.getBaseAposentadoriaEspecial() * (calculoInssEmpresa.getPercAposentadoriaEspecial() / 100.0)), (int)2));
        calculoInssEmpresa.setValorAposentadoriaEspecial20(ToolFormatter.arrredondarNumero((Double)(calculoInssEmpresa.getBaseAposentadoriaEspecial20() * (calculoInssEmpresa.getPercAposentadoriaEspecial20() / 100.0)), (int)2));
        calculoInssEmpresa.setValorAposentadoriaEspecial15(ToolFormatter.arrredondarNumero((Double)(calculoInssEmpresa.getBaseAposentadoriaEspecial15() * (calculoInssEmpresa.getPercAposentadoriaEspecial15() / 100.0)), (int)2));
        calculoInssEmpresa.setValorTotalInssEmpresa(ToolFormatter.arrredondarNumero((Double)(calculoInssEmpresa.getSomaValoresIncidInss() * (calculoInssEmpresa.getPercEmpresa() / 100.0)), (int)2));
        calculoInssEmpresa.setValorTotalRat(ToolFormatter.arrredondarNumero((Double)(calculoInssEmpresa.getSomaValoresIncidInss() * (calculoInssEmpresa.getPercRat() / 100.0) * empresaRh.getIndiceFAP()), (int)2));
        calculoInssEmpresa.setBaseRat(ToolFormatter.arrredondarNumero((Double)calculoInssEmpresa.getBaseCalculoInssFunc(), (int)2));
        calculoInssEmpresa.setVlrTotalAutonomo(ToolFormatter.arrredondarNumero((Double)(calculoInssEmpresa.getBaseCalcAutonomo() * (calculoInssEmpresa.getPercEmpresa() / 100.0)), (int)2));
        calculoInssEmpresa.setBaseTerceiros(ToolFormatter.arrredondarNumero((Double)calculoInssEmpresa.getBaseCalculoInssFunc(), (int)2));
        calculoInssEmpresa.setVlrTerceiros(ToolFormatter.arrredondarNumero((Double)(calculoInssEmpresa.getBaseTerceiros() * (calculoInssEmpresa.getPercTerceiros() / 100.0)), (int)2));
        calculoInssEmpresa.setGps(Double.valueOf(ToolFormatter.arrredondarNumero((Double)(calculoInssEmpresa.getVlrTotalAutonomo() + calculoInssEmpresa.getValorTotalInssEmpresa() + calculoInssEmpresa.getValorTotalInssFunc() + calculoInssEmpresa.getVlrContribuinteIndividual() + calculoInssEmpresa.getValorTotalRat() + calculoInssEmpresa.getVlrTerceiros() + calculoInssEmpresa.getServiceCooperativa() + calculoInssEmpresa.getVlrTotalSescSenac() + calculoInssEmpresa.getVlrTotalAutonomoFrete() + calculoInssEmpresa.getVlrAutonomoFreteEmpresa() + calculoInssEmpresa.getValorAposentadoriaEspecial20() + calculoInssEmpresa.getValorAposentadoriaEspecial15() + calculoInssEmpresa.getValorAposentadoriaEspecial()), (int)2) - ToolFormatter.arrredondarNumero((Double)(calculoInssEmpresa.getVlrSalarioFamilia() + calculoInssEmpresa.getSalarioMaternidade() + calculoInssEmpresa.getSalarioMaternindadeDec() + calculoInssEmpresa.getValorRetencaoObra() + calculoInssEmpresa.getValorOutrasDesoneracoes()), (int)2)));
    }
}

