/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.calculovalores;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstContrEstadoIcms;
import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstTipoAliquotaFCP;
import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstTipoAliquotaIcms;
import com.touchcomp.basementor.constants.enums.modelofiscalicms.EnumConstModFiscalDifalST;
import com.touchcomp.basementor.constants.enums.piscofins.EnumConstTipoAliquotaPisCofins;
import com.touchcomp.basementor.constants.enums.uf.EnumConstUF;
import com.touchcomp.basementor.model.vo.AliquotaSt;
import com.touchcomp.basementor.model.vo.CategoriaSt;
import com.touchcomp.basementor.model.vo.DadosFiscaisUF;
import com.touchcomp.basementor.model.vo.DadosFiscaisUFNcmFCP;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ModeloFiscal;
import com.touchcomp.basementor.model.vo.ModeloFiscalICMSSTItem;
import com.touchcomp.basementor.model.vo.ModeloFiscalIcms;
import com.touchcomp.basementor.model.vo.ModeloFiscalIpi;
import com.touchcomp.basementor.model.vo.ModeloFiscalPisCofins;
import com.touchcomp.basementor.model.vo.Ncm;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementor.model.vo.UnidadeFederativaOrigDest;
import com.touchcomp.basementorexceptions.exceptions.impl.impostoicms.EnumExcepImpostoIcms;
import com.touchcomp.basementorexceptions.exceptions.impl.impostoicms.ExceptionImpostoIcms;
import com.touchcomp.basementorrules.impostos.icms.model.IcmsParams;
import com.touchcomp.basementorservice.helpers.impl.modelofiscal.HelperModeloFiscal;
import com.touchcomp.basementorservice.service.impl.aliquotast.ServiceAliquotaStImpl;
import com.touchcomp.basementorservice.service.impl.dadosfiscaisuf.ServiceDadosFiscaisUFImpl;
import com.touchcomp.basementorservice.service.impl.modelofiscalicmsstitem.ServiceModeloFiscalICMSSTItemImpl;
import com.touchcomp.basementorservice.service.impl.unidadefederativaorigdest.ServiceUnidadeFederativaOrigDestImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public abstract class BaseCalculoValores {
    public static double getAliquotaIpi(Produto produto, ModeloFiscalIpi modIpi) {
        HelperModeloFiscal helperModeloFiscal = (HelperModeloFiscal)ConfApplicationContext.getBean(HelperModeloFiscal.class);
        return helperModeloFiscal.getAliquotaIpi(produto, modIpi);
    }

    protected Double getAliquotaIcmsOrigDest(UnidadeFederativa ufOrigem, UnidadeFederativa ufDestino) {
        if (ufDestino.equals((Object)ufOrigem)) {
            return 0.0;
        }
        ServiceUnidadeFederativaOrigDestImpl service = (ServiceUnidadeFederativaOrigDestImpl)ConfApplicationContext.getBean(ServiceUnidadeFederativaOrigDestImpl.class);
        UnidadeFederativaOrigDest found = service.get(ufOrigem, ufDestino);
        return found != null ? found.getAliquotaICMS() : 0.0;
    }

    protected EnumConstTipoAliquotaIcms getTipoAliquotaICMS(ModeloFiscalIcms mod, Produto produto, UnidadeFederativa uf, Empresa empresa) {
        if (mod.getTipoAliquotaIcms() == 2) {
            return EnumConstTipoAliquotaIcms.ALIQ_ICMS_INFORMADA;
        }
        if (empresa.getPessoa().getEndereco().getCidade().getUf().equals((Object)uf)) {
            return EnumConstTipoAliquotaIcms.ALIQ_ICMS_PRODUTO;
        }
        return EnumConstTipoAliquotaIcms.ALIQ_ICMS_INTERESTADUAL;
    }

    protected Double getPercRedBCICMS(ModeloFiscalIcms mod, Produto produto) {
        Double percRed = ToolMethods.isEquals((Object)mod.getTipoPercReducaoBaseCalcIcms(), (Object)2) ? mod.getReducaoBaseCalcIcms() : produto.getReducaoBaseCalcIcms();
        return percRed != null ? percRed : 0.0;
    }

    protected DadosFiscaisUF getDadosFiscaisUf(UnidadeFederativa ufDest, Empresa empresa) {
        ServiceDadosFiscaisUFImpl service = (ServiceDadosFiscaisUFImpl)ConfApplicationContext.getBean(ServiceDadosFiscaisUFImpl.class);
        if (service != null) {
            return service.get(ufDest, empresa);
        }
        return null;
    }

    protected String getCodigoNcm(Produto produto) {
        if (!TMethods.isNull((Object)produto).booleanValue() && !TMethods.isNull((Object)produto.getNcm()).booleanValue()) {
            return produto.getNcm().getCodigo();
        }
        return null;
    }

    protected List<IcmsParams.AliquotasEstaduaisProduto> getAliquotasUF(Produto produto) {
        LinkedList<IcmsParams.AliquotasEstaduaisProduto> ret = new LinkedList<IcmsParams.AliquotasEstaduaisProduto>();
        produto.getAliquotasUF().forEach(i -> {
            IcmsParams.AliquotasEstaduaisProduto al = new IcmsParams.AliquotasEstaduaisProduto(EnumConstUF.get((Object)i.getUf().getSigla()), i.getAliquotaIcms());
            ret.add(al);
        });
        return ret;
    }

    protected Double getAliquotaFCPNCM(Produto produto, DadosFiscaisUF dadosFiscaisUF) {
        for (DadosFiscaisUFNcmFCP d : dadosFiscaisUF.getNcmsFCP()) {
            if (!d.getNcm().equals((Object)produto.getNcm())) continue;
            return d.getAliquotaFCP();
        }
        return 0.0;
    }

    protected List<IcmsParams.AliquotasEstaduaisNcm> getAliquotasEstaduaisNcm(Ncm ncm) {
        LinkedList<IcmsParams.AliquotasEstaduaisNcm> ret = new LinkedList<IcmsParams.AliquotasEstaduaisNcm>();
        if (!TMethods.isNull((Object)ncm).booleanValue() && TMethods.isWithData((Collection)ncm.getAliquotasUF())) {
            ncm.getAliquotasUF().forEach(i -> {
                IcmsParams.AliquotasEstaduaisNcm al = new IcmsParams.AliquotasEstaduaisNcm(EnumConstUF.get((Object)i.getUf().getSigla()), ncm.getCodigo(), i.getAliquotaIcms());
                ret.add(al);
            });
        }
        return ret;
    }

    protected Double getPercReducaoIcmsST(Produto produto, ModeloFiscalIcms mod) {
        if (mod.getReducaoBaseCalcIcmsST() != null && mod.getReducaoBaseCalcIcmsST() > 0.0) {
            return mod.getReducaoBaseCalcIcmsST();
        }
        return 0.0;
    }

    protected AliquotaSt procurarAliquotaSt(Produto produto, ModeloFiscalIcms mod, UnidadeFederativa ufDestinoCliente) throws ExceptionImpostoIcms {
        CategoriaSt cat = this.getCategoriaST(produto, mod);
        ServiceAliquotaStImpl serviceAliquotaSt = (ServiceAliquotaStImpl)ConfApplicationContext.getBean(ServiceAliquotaStImpl.class);
        AliquotaSt al = serviceAliquotaSt.get(cat, ufDestinoCliente);
        if (al == null) {
            throw new ExceptionImpostoIcms(EnumExcepImpostoIcms.ALIQUOTA_ST_NAO_ENCONTRADA, new Object[]{ufDestinoCliente, cat});
        }
        return al;
    }

    protected ModeloFiscalICMSSTItem getModeloFiscalItem(Produto produto, ModeloFiscalIcms mod, UnidadeFederativa ufDestino, Empresa empresa, EnumConstantsMentorSimNao usarCategoriaST, EnumConstContrEstadoIcms contribuinteEstado, EnumConstantsMentorSimNao consumidorFinal) throws ExceptionImpostoIcms {
        Integer codigo;
        ServiceModeloFiscalICMSSTItemImpl serviceAliquotaSt = (ServiceModeloFiscalICMSSTItemImpl)ConfApplicationContext.getBean(ServiceModeloFiscalICMSSTItemImpl.class);
        ModeloFiscalICMSSTItem found = serviceAliquotaSt.get(produto.getNcm(), ufDestino, empresa, empresa.getEmpresaDados().getCnae(), mod.getIncidenciaIcms(), contribuinteEstado, usarCategoriaST, this.getCategoriaST(produto, mod), consumidorFinal);
        if (found == null && (codigo = Integer.valueOf(mod.getIncidenciaIcms().getCodigo())) != 90 && codigo != 190 && codigo != 290 && codigo != 900) {
            throw new ExceptionImpostoIcms(EnumExcepImpostoIcms.MODELO_FISCAL_ST_NAO_ENCONTRADO, new Object[]{this.getCategoriaST(produto, mod), produto.getNcm(), empresa.getEmpresaDados().getCnae(), ufDestino, mod.getIncidenciaIcms(), consumidorFinal == EnumConstantsMentorSimNao.SIM ? "Sim" : "Nao"});
        }
        return found;
    }

    protected CategoriaSt getCategoriaST(Produto produto, ModeloFiscalIcms mod) throws ExceptionImpostoIcms {
        CategoriaSt cat = null;
        cat = ToolMethods.isEquals((Object)mod.getTipoTributacaoIcmsSt(), (Object)EnumConstModFiscalDifalST.TIPO_TRIB_ICMSST_CAT_INFORMADA.getValue()) ? mod.getCategoriaST() : produto.getCategoriaSutr();
        if (cat == null) {
            throw new ExceptionImpostoIcms(EnumExcepImpostoIcms.CATEGORIA_ST_NAO_INFORMADA, new Object[]{produto});
        }
        return cat;
    }

    public static double getAliquotaPis(Produto produto, ModeloFiscalPisCofins modPis) {
        Double aliquotaPis = 0.0;
        if (modPis == null || produto == null) {
            return aliquotaPis;
        }
        aliquotaPis = ToolMethods.isEquals((Object)modPis.getTipoAliquotaPisCofins(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue()) ? modPis.getAliquotaPis() : (ToolMethods.isEquals((Object)modPis.getTipoAliquotaPisCofins(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_PRODUTO.getValue()) ? produto.getAliquotaPis() : Double.valueOf(0.0));
        return aliquotaPis != null ? aliquotaPis : 0.0;
    }

    public static double getAliquotaPisST(Produto produto, ModeloFiscalPisCofins modPis) {
        Double aliquotaPisST = 0.0;
        if (modPis == null || produto == null) {
            return aliquotaPisST;
        }
        aliquotaPisST = ToolMethods.isEquals((Object)modPis.getTipoAliquotaPisCofinsSt(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue()) ? modPis.getAliquotaPisSt() : (ToolMethods.isEquals((Object)modPis.getTipoAliquotaPisCofinsSt(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_PRODUTO.getValue()) ? produto.getAliquotaPisSt() : Double.valueOf(0.0));
        return aliquotaPisST != null ? aliquotaPisST : 0.0;
    }

    public static double getAliquotaCofins(Produto produto, ModeloFiscalPisCofins modPis) {
        Double aliquotaCofins = 0.0;
        if (modPis == null || produto == null) {
            return aliquotaCofins;
        }
        aliquotaCofins = ToolMethods.isEquals((Object)modPis.getTipoAliquotaPisCofins(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue()) ? modPis.getAliquotaCofins() : (ToolMethods.isEquals((Object)modPis.getTipoAliquotaPisCofins(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_PRODUTO.getValue()) ? produto.getAliquotaCofins() : Double.valueOf(0.0));
        return aliquotaCofins != null ? aliquotaCofins : 0.0;
    }

    public static double getAliquotaCofinsST(Produto produto, ModeloFiscalPisCofins modPis) {
        Double aliquotaCofinsST = 0.0;
        if (modPis == null || produto == null) {
            return aliquotaCofinsST;
        }
        aliquotaCofinsST = ToolMethods.isEquals((Object)modPis.getTipoAliquotaPisCofinsSt(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue()) ? modPis.getAliquotaCofinsSt() : (ToolMethods.isEquals((Object)modPis.getTipoAliquotaPisCofinsSt(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_PRODUTO.getValue()) ? produto.getAliquotaCofinsSt() : Double.valueOf(0.0));
        return aliquotaCofinsST != null ? aliquotaCofinsST : 0.0;
    }

    public Double getAliquotaFCP(DadosFiscaisUF dadosFiscaisUf, Empresa empresa, Produto produto) {
        EnumConstTipoAliquotaFCP tipoFCP = this.getTipoFCP(empresa, produto);
        if (TMethods.isEquals((Object)tipoFCP, (Object)EnumConstTipoAliquotaFCP.CALCULAR_FCP_NCM)) {
            return this.getAliquotaFCPNCM(produto, dadosFiscaisUf);
        }
        if (dadosFiscaisUf != null && dadosFiscaisUf.getAliquotaFCP() != null) {
            return dadosFiscaisUf.getAliquotaFCP();
        }
        return 0.0;
    }

    public Double getAliquotaFCP(Empresa empresa, Produto produto) {
        DadosFiscaisUF dadosFiscaisUf = this.getDadosFiscaisUf(empresa.getPessoa().getEndereco().getCidade().getUf(), empresa);
        return this.getAliquotaFCP(dadosFiscaisUf, empresa, produto);
    }

    public EnumConstTipoAliquotaFCP getTipoFCP(Empresa empresa, Produto produto) {
        DadosFiscaisUF dadosFiscaisUf = this.getDadosFiscaisUf(empresa.getPessoa().getEndereco().getCidade().getUf(), empresa);
        EnumConstTipoAliquotaFCP tipoFCP = EnumConstTipoAliquotaFCP.NAO_CALCULAR_FCP;
        if (dadosFiscaisUf != null) {
            tipoFCP = EnumConstTipoAliquotaFCP.get((Object)dadosFiscaisUf.getCalcularFCP());
        }
        return tipoFCP;
    }

    protected Double getAliquotaPisSt(Produto produto, ModeloFiscal modeloFiscal) {
        if (TMethods.isAffirmative((Number)modeloFiscal.getModeloFiscalPisCofins().getCalcularPisSt())) {
            if (TMethods.isEquals((Object)modeloFiscal.getModeloFiscalPisCofins().getTipoAliquotaPisCofinsSt(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue())) {
                return modeloFiscal.getModeloFiscalPisCofins().getAliquotaPisSt();
            }
            return produto.getAliquotaPisSt();
        }
        return 0.0;
    }

    protected Double getAliquotaCofinsSt(Produto produto, ModeloFiscal modeloFiscal) {
        if (TMethods.isAffirmative((Number)modeloFiscal.getModeloFiscalPisCofins().getCalcularCofinsSt())) {
            if (TMethods.isEquals((Object)modeloFiscal.getModeloFiscalPisCofins().getTipoAliquotaPisCofinsSt(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue())) {
                return modeloFiscal.getModeloFiscalPisCofins().getAliquotaCofinsSt();
            }
            return produto.getAliquotaCofinsSt();
        }
        return 0.0;
    }
}

