/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.calculovalores.cotacaovendas;

import com.touchcomp.basementor.model.impl.ValoresPrecoItemPedido;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemCotacaoVendas;
import com.touchcomp.basementor.model.vo.Moeda;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementor.model.vo.TipoFrete;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.avaliadorexpressoes.ExceptionAvaliadorExpressoes;
import com.touchcomp.basementorexceptions.exceptions.impl.calculos.ExceptionCalcPrecosProduto;
import com.touchcomp.basementorservice.service.impl.tabelaprecos.ServiceCalcTabelaPrecosImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompCalcValoresItemCotacao {
    @Autowired
    ServiceCalcTabelaPrecosImpl serviceCalcTabelaPrecos;

    public ItemCotacaoVendas cotacaoItem(ItemCotacaoVendas item, OpcoesFaturamento opcoesFaturamento, CondicoesPagamento condicaoPagamento, String parcelas, Moeda moeda, Date dataEmissao, TipoFrete tipoFrete, UnidadeFatCliente unidade, Representante rep, Produto produto, NaturezaOperacao naturezaOperacao, String codAux, Empresa empresa, Usuario usuario) throws ExceptionAvaliadorExpressoes, ExceptionCalcPrecosProduto {
        ValoresPrecoItemPedido val = this.getValoresItem(opcoesFaturamento, condicaoPagamento, parcelas, moeda, dataEmissao, tipoFrete, unidade, rep, produto, naturezaOperacao, codAux, empresa, usuario);
        item.setValorMaximo(val.getValorMaximo());
        item.setValorSugerido(val.getValorSugerido());
        item.setValorMinimo(val.getValorMinimo());
        item.setFormTabDinCalcComissao(val.getComissao().getAvaliadorExpFormulasCalComissao());
        item.setFormTabDinCalcPreco(val.getAvaliadorExpFormulasCalPreco());
        if (TMethods.isAffirmative((Number)opcoesFaturamento.getAlterarValorUnitarioItemPedidoPorCondPagamento())) {
            item.setValorUnitario(val.getValorSugerido());
            item.setPercComissao(val.getComissao().getPercComissao());
        }
        return item;
    }

    public ValoresPrecoItemPedido getValoresItem(OpcoesFaturamento opcoesFaturamento, CondicoesPagamento condicaoPagamento, String parcelas, Moeda moeda, Date dataEmissao, TipoFrete tipoFrete, UnidadeFatCliente unidade, Representante rep, Produto produto, NaturezaOperacao naturezaOperacao, String codAux, Empresa empresa, Usuario usuario) throws ExceptionAvaliadorExpressoes, ExceptionCalcPrecosProduto {
        ValoresPrecoItemPedido val = this.serviceCalcTabelaPrecos.calcularValores(opcoesFaturamento, unidade, rep, produto, dataEmissao, moeda, condicaoPagamento, parcelas, tipoFrete, empresa, naturezaOperacao, usuario, codAux);
        return val;
    }
}

