/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.calculovalores.pedido;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorEntSaida;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.cfop.EnumConstCfop;
import com.touchcomp.basementor.constants.enums.impostos.cide.EnumConstTipoCalcCide;
import com.touchcomp.basementor.constants.enums.impostos.contsocial.EnumConstTipoCalcContSocial;
import com.touchcomp.basementor.constants.enums.impostos.funrural.EnumConstTipoCalcFunrural;
import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstContrEstadoIcms;
import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstMotivoDesoneracaoIcms;
import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstNFeIncidenciaIcms;
import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstTipoAliquotaFCP;
import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstTipoCalcIcmsST;
import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstTipoCalculoDiferencaAliquota;
import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstTipoIcmsDispensado;
import com.touchcomp.basementor.constants.enums.impostos.inss.EnumConstTipoCalcInss;
import com.touchcomp.basementor.constants.enums.impostos.ipi.EnumConstNFeIncidenciaIpi;
import com.touchcomp.basementor.constants.enums.impostos.ir.EnumConstTipoCalcIr;
import com.touchcomp.basementor.constants.enums.impostos.iss.EnumConstTipoCalcIss;
import com.touchcomp.basementor.constants.enums.impostos.lei10833.EnumConstTipoCalcLei10833;
import com.touchcomp.basementor.constants.enums.impostos.outros.EnumConstTipoCalcOutros;
import com.touchcomp.basementor.constants.enums.impostos.piscofins.EnumConstNFeIncidenciaCofins;
import com.touchcomp.basementor.constants.enums.impostos.piscofins.EnumConstTipoCalcPisCofins;
import com.touchcomp.basementor.constants.enums.impostos.sestsenat.EnumConstTipoCalcSestSenat;
import com.touchcomp.basementor.constants.enums.modalidadeicms.EnumConstModIcms;
import com.touchcomp.basementor.constants.enums.modalidadeicmsst.EnumConstModIcmsST;
import com.touchcomp.basementor.constants.enums.modelofiscal.EnumConstTipoPercDiferimento;
import com.touchcomp.basementor.constants.enums.modelofiscalicms.EnumConstModFiscalDifal;
import com.touchcomp.basementor.constants.enums.modelofiscalicms.EnumConstModFiscalDifalST;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeVersao;
import com.touchcomp.basementor.constants.enums.number.EnumConstTipoArredondamento;
import com.touchcomp.basementor.constants.enums.piscofins.EnumConstTipoAliquotaPisCofins;
import com.touchcomp.basementor.constants.enums.regimetributario.EnumConstRegimeTributario;
import com.touchcomp.basementor.constants.enums.uf.EnumConstUF;
import com.touchcomp.basementor.model.vo.AliquotaSt;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.DadosFiscaisUF;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.ItemPedido;
import com.touchcomp.basementor.model.vo.ItemPedidoFiscal;
import com.touchcomp.basementor.model.vo.ModeloFiscal;
import com.touchcomp.basementor.model.vo.ModeloFiscalICMSSTItem;
import com.touchcomp.basementor.model.vo.ModeloFiscalIcms;
import com.touchcomp.basementor.model.vo.ModeloFiscalIpi;
import com.touchcomp.basementor.model.vo.ModeloFiscalPisCofins;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.Pedido;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementorexceptions.exceptions.impl.impostoicms.ExceptionImpostoIcms;
import com.touchcomp.basementorexceptions.exceptions.impl.impostoipi.ExceptionImpostoIPI;
import com.touchcomp.basementorexceptions.exceptions.impl.impostopiscofins.ExceptionImpostoPisCofins;
import com.touchcomp.basementorrules.impostos.cide.CompImpostoCide;
import com.touchcomp.basementorrules.impostos.cide.model.CideCalculado;
import com.touchcomp.basementorrules.impostos.cide.model.CideParams;
import com.touchcomp.basementorrules.impostos.contsocial.CompImpostoContSocial;
import com.touchcomp.basementorrules.impostos.contsocial.model.ContSocialCalculado;
import com.touchcomp.basementorrules.impostos.contsocial.model.ContSocialParams;
import com.touchcomp.basementorrules.impostos.funrural.CompImpostoFunrural;
import com.touchcomp.basementorrules.impostos.funrural.model.FunruralCalculado;
import com.touchcomp.basementorrules.impostos.funrural.model.FunruralParams;
import com.touchcomp.basementorrules.impostos.icms.CompImpostoIcms;
import com.touchcomp.basementorrules.impostos.icms.model.IcmsCalculado;
import com.touchcomp.basementorrules.impostos.icms.model.IcmsParams;
import com.touchcomp.basementorrules.impostos.inss.CompImpostoInss;
import com.touchcomp.basementorrules.impostos.inss.model.InssCalculado;
import com.touchcomp.basementorrules.impostos.inss.model.InssParams;
import com.touchcomp.basementorrules.impostos.ipi.CompImpostoIPI;
import com.touchcomp.basementorrules.impostos.ipi.model.IPICalculado;
import com.touchcomp.basementorrules.impostos.ipi.model.IPIParams;
import com.touchcomp.basementorrules.impostos.ir.CompImpostoIr;
import com.touchcomp.basementorrules.impostos.ir.model.IrCalculado;
import com.touchcomp.basementorrules.impostos.ir.model.IrParams;
import com.touchcomp.basementorrules.impostos.iss.CompImpostoIss;
import com.touchcomp.basementorrules.impostos.iss.model.IssCalculado;
import com.touchcomp.basementorrules.impostos.iss.model.IssParams;
import com.touchcomp.basementorrules.impostos.lei10833.CompImpostoLei10833;
import com.touchcomp.basementorrules.impostos.lei10833.model.Lei10833Calculado;
import com.touchcomp.basementorrules.impostos.lei10833.model.Lei10833Params;
import com.touchcomp.basementorrules.impostos.outros.CompImpostoOutros;
import com.touchcomp.basementorrules.impostos.outros.model.OutrosCalculado;
import com.touchcomp.basementorrules.impostos.outros.model.OutrosParams;
import com.touchcomp.basementorrules.impostos.piscofins.CompImpostoPisCofins;
import com.touchcomp.basementorrules.impostos.piscofins.model.PisCofinsCalculado;
import com.touchcomp.basementorrules.impostos.piscofins.model.PisCofinsParams;
import com.touchcomp.basementorrules.impostos.sestsenat.CompImpostoSestSenat;
import com.touchcomp.basementorrules.impostos.sestsenat.model.SestSenatCalculado;
import com.touchcomp.basementorrules.impostos.sestsenat.model.SestSenatParams;
import com.touchcomp.basementorservice.components.calculovalores.BaseCalculoValores;
import com.touchcomp.basementortools.tools.methods.ToolMethods;

public class CompCalcVlrImpostosPedido
extends BaseCalculoValores {
    public void calcular(Pedido ped, OpcoesContabeis opcoesContabeis, OpcoesFaturamento opFat, EmpresaContabilidade empCont) throws ExceptionImpostoPisCofins, ExceptionImpostoIPI, ExceptionImpostoIcms {
        for (ItemPedido item : ped.getItemPedido()) {
            if (item.getModeloFiscal() == null) continue;
            this.atualizaDadosFiscaisItemPedido(item);
            ItemPedidoFiscal fiscal = item.getItemPedidoFiscal();
            this.calcularCide(ped, item, fiscal);
            this.calcularContSocial(ped, item, fiscal);
            this.calcularFunrural(ped, item, fiscal);
            this.calcularInss(ped, item, fiscal);
            this.calcularIr(ped, item, fiscal);
            this.calcularIss(ped, item, fiscal);
            this.calcularLei10833(ped, item, fiscal);
            this.calcularOutros(ped, item, fiscal);
            this.calcularSestSenat(ped, item, fiscal);
            IPICalculado ipiCalc = this.calcularIpi(ped, item, fiscal);
            this.calcularIcms(ped, item, fiscal, ipiCalc, opcoesContabeis, opFat, empCont);
            this.calcularPisCofins(ped, item, fiscal);
        }
    }

    private void atualizaDadosFiscaisItemPedido(ItemPedido itemPedido) {
        ModeloFiscal modeloFiscal = itemPedido.getModeloFiscal();
        ItemPedidoFiscal it = itemPedido.getItemPedidoFiscal();
        if (it == null) {
            it = new ItemPedidoFiscal();
        }
        itemPedido.setItemPedidoFiscal(it);
        it.setItemPedido(itemPedido);
        if (ToolMethods.isNull((Object)it.getIncidenciaIcms()).booleanValue()) {
            it.setIncidenciaIcms(modeloFiscal.getModeloFiscalIcms().getIncidenciaIcms());
        }
        if (ToolMethods.isNull((Object)it.getModalidadeIcms()).booleanValue()) {
            it.setModalidadeIcms(modeloFiscal.getModeloFiscalIcms().getModalidadeIcms());
        }
        if (ToolMethods.isNull((Object)it.getModalidadeIcmsSt()).booleanValue()) {
            it.setModalidadeIcmsSt(modeloFiscal.getModeloFiscalIcms().getModalidadeIcmsSt());
        }
        if (ToolMethods.isNull((Object)it.getIncidenciaIpi()).booleanValue()) {
            it.setIncidenciaIpi(modeloFiscal.getModeloFiscalIpi().getIncidenciaIpi());
        }
        if (ToolMethods.isNull((Object)it.getIncidenciaPisCofins()).booleanValue()) {
            it.setIncidenciaPisCofins(modeloFiscal.getModeloFiscalPisCofins().getIncidenciaPisCofins());
        }
    }

    private void calcularIcms(Pedido ped, ItemPedido item, ItemPedidoFiscal fiscal, IPICalculado ipiCalc, OpcoesContabeis opcoesContabeis, OpcoesFaturamento opFat, EmpresaContabilidade empCont) throws ExceptionImpostoIcms {
        ModeloFiscalIcms mod = item.getModeloFiscal().getModeloFiscalIcms();
        Cliente cli = ped.getUnidadeFatCliente().getCliente();
        UnidadeFederativa ufDestinoCliente = ped.getUnidadeFatCliente().getPessoa().getEndereco().getCidade().getUf();
        UnidadeFederativa ufOrigem = ped.getEmpresa().getPessoa().getEndereco().getCidade().getUf();
        Produto produto = item.getProduto();
        DadosFiscaisUF dadosFiscaisUf = this.getDadosFiscaisUf(ufDestinoCliente, ped.getEmpresa());
        EnumConstTipoAliquotaFCP tipoFCP = EnumConstTipoAliquotaFCP.NAO_CALCULAR_FCP;
        Double aliquotaFCP = 0.0;
        if (dadosFiscaisUf != null) {
            tipoFCP = EnumConstTipoAliquotaFCP.get((Object)dadosFiscaisUf.getCalcularFCP());
            aliquotaFCP = tipoFCP == EnumConstTipoAliquotaFCP.CALCULAR_FCP_NCM ? this.getAliquotaFCPNCM(produto, dadosFiscaisUf) : dadosFiscaisUf.getAliquotaFCP();
        }
        IcmsParams.ParamsCalcIcms paramsCalcIcms = new IcmsParams.ParamsCalcIcms(this.getTipoAliquotaICMS(mod, item.getProduto(), ufDestinoCliente, ped.getEmpresa()), EnumConstTipoIcmsDispensado.get((Object)mod.getIcmsDispensadoDesconto()), tipoFCP, EnumConstTipoCalculoDiferencaAliquota.NAO_CALCULAR, EnumConstantsMentorSimNao.get((Object)mod.getIncluiDesconto()), EnumConstantsMentorSimNao.get((Object)mod.getIncluiFrete()), EnumConstantsMentorSimNao.get((Object)mod.getIncluiSeguro()), EnumConstantsMentorSimNao.get((Object)mod.getIncluiDespAcess()), EnumConstantsMentorSimNao.get((Object)mod.getRecuperarTributosIcms()), EnumConstantsMentorSimNao.NAO, EnumConstantsMentorSimNao.get((Object)mod.getCalcularIcmsSimples()), EnumConstantsMentorSimNao.get((Object)mod.getIncluiDespAcessCalcRed()), mod.getAliquotaIcms(), this.getPercRedBCICMS(mod, produto), mod.getIndiceCalcImportacao(), produto.getAliquotaIcms(), ped.getEmpresa().getEmpresaDados().getAliquotaICMSSimples(), this.getAliquotaIcmsOrigDest(ufOrigem, ufDestinoCliente), aliquotaFCP, Double.valueOf(dadosFiscaisUf != null ? dadosFiscaisUf.getAliquotaFCP() : 0.0), item.getProduto().getValorTabICMS(), this.getPercDiferimento(produto, mod), EnumConstModIcms.get((Object)mod.getModalidadeIcms().getCodigo()), EnumConstantsMentorSimNao.get((Object)empCont.getEmbutirIpiIcmsOutros()), EnumConstModFiscalDifal.get((Object)mod.getTipoCalculoDifal()), mod.getMotivoDesoneracaoIcms() != null ? EnumConstMotivoDesoneracaoIcms.get((Object)mod.getMotivoDesoneracaoIcms().getCodigo()) : null, this.getAliquotasEstaduaisNcm(produto.getNcm()), this.getAliquotasUF(produto));
        Double indiceAlteracaoST = 0.0;
        Double aliquotaIcmsST = 0.0;
        Double descontoPadraoST = 0.0;
        EnumConstTipoCalcIcmsST tipoCalcST = EnumConstTipoCalcIcmsST.NAO_CALCULAR;
        EnumConstModIcmsST modST = EnumConstModIcmsST.MARGEM_VLR_AGREG;
        if (ToolMethods.isAffirmative((Number)mod.getIncidenciaIcms().getIcmsSt())) {
            ModeloFiscalICMSSTItem modItemST;
            tipoCalcST = EnumConstTipoCalcIcmsST.get((Object)mod.getTipoTributacaoIcmsSt());
            EnumConstModIcmsST enumConstModIcmsST = modST = mod.getModalidadeIcmsSt() != null ? EnumConstModIcmsST.get((Object)mod.getModalidadeIcmsSt().getCodigo()) : null;
            if (tipoCalcST == EnumConstTipoCalcIcmsST.CALCULAR_CATEGORIA) {
                AliquotaSt found = this.procurarAliquotaSt(produto, mod, ufDestinoCliente);
                indiceAlteracaoST = found.getIndiceAlteracao();
                aliquotaIcmsST = found.getAliquotaIcms();
                descontoPadraoST = found.getDescontoPadrao();
            } else if (tipoCalcST == EnumConstTipoCalcIcmsST.CALCULAR_MODELO_ICMSST && (modItemST = this.getModeloFiscalItem(produto, mod, ufDestinoCliente, opcoesContabeis.getEmpresa(), EnumConstantsMentorSimNao.get((Object)opFat.getUsarCategoriaST()), EnumConstContrEstadoIcms.get((Object)cli.getPessoa().getComplemento().getContribuinteEstado()), EnumConstantsMentorSimNao.get((Object)ped.getTipoConsumidor()))) != null) {
                indiceAlteracaoST = modItemST.getIndiceAlteracao();
                aliquotaIcmsST = modItemST.getAliquotaIcms();
                descontoPadraoST = modItemST.getDescontoPadrao();
            }
        }
        IcmsParams.ParamsCalcST paramsCalcSt = new IcmsParams.ParamsCalcST(modST, tipoCalcST, EnumConstantsMentorSimNao.get((Object)mod.getIncluiDescontoST()), EnumConstantsMentorSimNao.get((Object)mod.getIncluiFreteST()), EnumConstantsMentorSimNao.get((Object)mod.getIncluiSeguroST()), EnumConstantsMentorSimNao.get((Object)mod.getIncluiDespAcessST()), EnumConstantsMentorSimNao.get((Object)mod.getIncluiIPIST()), EnumConstantsMentorSimNao.get((Object)mod.getCalcularIcmsPresumidoST()), EnumConstModFiscalDifalST.get((Object)mod.getTipoTributacaoIcmsSt()), indiceAlteracaoST, aliquotaIcmsST, descontoPadraoST, this.getPercReducaoIcmsST(produto, mod), produto.getValorTabICMSST(), Double.valueOf(0.0), Double.valueOf(0.0));
        IcmsParams params = new IcmsParams(EnumConstNFeIncidenciaIcms.valueOfCodigo((String)mod.getIncidenciaIcms().getCodigo().substring(1)), ipiCalc, item.getValorFrete(), item.getValorSeguro(), item.getValorDespesaAcessoria(), item.getValorDesconto(), item.getValorTotalBruto(), fiscal.getVrICMSDispensado(), fiscal.getVrIcmsSemAprov(), EnumConstCfop.CFOP_INTERNO, this.getArredondamentoPadrao(), EnumConstNFeVersao.VERSAO_4_00, cli.getFaturamento().getPercentualPisSufr(), cli.getFaturamento().getPercentualCofinsSufr(), cli.getFaturamento().getPercentualIcmsSufr(), cli.getFaturamento().getPercentualIpiSufr(), item.getQuantidadeTotal(), EnumConstantsMentorSimNao.SIM, EnumConstantsMentorSimNao.NAO, EnumConstantsMentorSimNao.NAO, EnumConstantsMentorSimNao.get((Object)mod.getIncluiDespAcess()), EnumConstantsMentorSimNao.get((Object)mod.getIncluiFrete()), EnumConstantsMentorSimNao.get((Object)mod.getIncluiSeguro()), EnumConstContrEstadoIcms.NAO_CONTRIBUINTE, EnumConstantsMentorEntSaida.SAIDA, EnumConstantsMentorSimNao.NAO, EnumConstantsMentorSimNao.NAO, item.getProduto().getNcm().getCodigo(), item.getProduto().getNome(), item.getProduto().getIdentificador(), EnumConstRegimeTributario.valueOfCodigo((short)ped.getEmpresa().getEmpresaDados().getRegimeTributario().getCodigo().shortValue()), EnumConstUF.get((Object)ped.getEmpresa().getPessoa().getEndereco().getCidade().getUf().getSigla()), EnumConstUF.get((Object)ufDestinoCliente.getSigla()), paramsCalcSt, paramsCalcIcms, ped.getDataEmissao(), this.calcularIcmsDesoneradoSuframa(ped.getUnidadeFatCliente().getCliente().getPessoa(), item.getProduto(), mod), ped.getUnidadeFatCliente().getCliente().getFaturamento().getPercentualIcmsSufr());
        IcmsCalculado calc = CompImpostoIcms.calcularIcms((IcmsParams)params);
        fiscal.setAliquotaIcms(calc.getAliquotaIcms());
        fiscal.setVrBcCalculoIcmsSt(calc.getBaseCalculoIcmsST());
        fiscal.setVrBcCalculoIcms(calc.getBaseCalculoIcms());
        fiscal.setVrIcmsSt(calc.getValorIcmsST());
        fiscal.setVrIcms(calc.getValorIcms());
        fiscal.setAliquotaICMSSimples(calc.getAliquotaIcmsSimples());
        fiscal.setValorICMSSimples(calc.getValorIcmsSimples());
        fiscal.setVrIcmsIsento(calc.getValorIcmsIsento());
        fiscal.setVrIcmsOutros(calc.getValorIcmsOutros());
        fiscal.setVrIcmsTributado(calc.getValorIcmsTributado());
        fiscal.setVrIcmsSemAprov(calc.getValorIcmsSemAprov());
        fiscal.setVrICMSDispensado(calc.getValorIcmsDispensado());
        fiscal.setDescontoPadraoIcmsST(calc.getValorDescontoPadraoST());
        fiscal.setIndiceAlteracaoIcmsST(calc.getIndiceAlteracaoST());
        fiscal.setAliquotaIcmsST(calc.getAliquotaIcmsST());
        fiscal.setValorFCP(calc.getValorFCP());
        fiscal.setValorFCPSt(calc.getValorFCPST());
        fiscal.setValorFCPStRetido(calc.getValorFCPSTRetidos());
        fiscal.setValorBCFCP(calc.getBaseCalculoFCP());
        fiscal.setValorBCFCPSt(calc.getBaseCalculoFCPST());
        fiscal.setValorBCFCPStRetido(calc.getBaseCalculoFCPSTRetido());
        fiscal.setAliquotaFCP(calc.getAliquotaFCP());
        fiscal.setAliquotaFCPSt(calc.getAliquotaFCPST());
        fiscal.setAliquotaFCPStRetido(calc.getAliquotaFCPSTRetido());
    }

    private Double getPercDiferimento(Produto produto, ModeloFiscalIcms modeloFiscalIcms) {
        if (ToolMethods.isEquals((Object)modeloFiscalIcms.getTipoPercDiferimento(), (Object)EnumConstTipoPercDiferimento.TIPO_PERC_DIFERIMENTO_MODELO.getValue())) {
            return modeloFiscalIcms.getPercentualDiferimento();
        }
        return produto.getPercentualDiferimento();
    }

    private EnumConstantsMentorSimNao calcularIcmsDesoneradoSuframa(Pessoa pessoa, Produto produto, ModeloFiscalIcms modeloFiscalIcms) {
        if (ToolMethods.isAffirmative((Number)pessoa.getComplemento().getHabilitarSuframa()) && modeloFiscalIcms.getMotivoDesoneracaoIcms() != null && ToolMethods.isEquals((Object)modeloFiscalIcms.getMotivoDesoneracaoIcms().getCodigo(), (Object)EnumConstMotivoDesoneracaoIcms.SUFRAMA.getValue()) && !ToolMethods.isAffirmative((Number)produto.getNaoAplicaSuframa())) {
            return EnumConstantsMentorSimNao.SIM;
        }
        return EnumConstantsMentorSimNao.NAO;
    }

    private PisCofinsCalculado calcularPisCofins(Pedido ped, ItemPedido item, ItemPedidoFiscal fiscal) throws ExceptionImpostoPisCofins {
        ModeloFiscalPisCofins mod = item.getModeloFiscal().getModeloFiscalPisCofins();
        Double aliquotaPis = 0.0;
        Double aliquotaPisSt = 0.0;
        Double aliquotaCofins = 0.0;
        Double aliquotaCofinsSt = 0.0;
        aliquotaPis = mod.getCalcularPisNormal().equals((short)1) ? (ToolMethods.isEquals((Object)mod.getTipoAliquotaPisCofins(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue()) ? mod.getAliquotaPis() : item.getProduto().getAliquotaPis()) : Double.valueOf(0.0);
        if (mod.getCalcularPisSt().equals((short)1)) {
            aliquotaPisSt = ToolMethods.isEquals((Object)mod.getTipoAliquotaPisCofinsSt(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue()) ? mod.getAliquotaPisSt() : item.getProduto().getAliquotaPisSt();
        } else {
            aliquotaPis = 0.0;
        }
        aliquotaCofins = mod.getCalcularCofinsNormal().equals((short)1) ? (ToolMethods.isEquals((Object)mod.getTipoAliquotaPisCofins(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue()) ? mod.getAliquotaCofins() : item.getProduto().getAliquotaCofins()) : Double.valueOf(0.0);
        aliquotaCofinsSt = mod.getCalcularCofinsSt().equals((short)1) ? (ToolMethods.isEquals((Object)mod.getTipoAliquotaPisCofinsSt(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue()) ? mod.getAliquotaCofinsSt() : item.getProduto().getAliquotaCofinsSt()) : Double.valueOf(0.0);
        PisCofinsParams params = new PisCofinsParams(EnumConstNFeIncidenciaCofins.valueOfCodigo((String)mod.getIncidenciaPisCofins().getCodigo()), aliquotaPis, aliquotaCofins, EnumConstantsMentorEntSaida.SAIDA, EnumConstTipoCalcPisCofins.get((Object)mod.getCalcularPisNormal()), EnumConstTipoCalcPisCofins.get((Object)mod.getCalcularCofinsNormal()), EnumConstTipoCalcPisCofins.get((Object)mod.getCalcularPisSt()), EnumConstTipoCalcPisCofins.get((Object)mod.getCalcularCofinsSt()), item.getValorTotal(), item.getValorDesconto(), item.getValorDespesaAcessoria(), item.getValorFrete(), item.getValorSeguro(), item.getQuantidadeTotal(), EnumConstantsMentorSimNao.get((Object)mod.getIncluiDesconto()), EnumConstantsMentorSimNao.get((Object)mod.getIncluirIcmsDesonerado()), EnumConstantsMentorSimNao.get((Object)mod.getIncluiDespAcess()), EnumConstantsMentorSimNao.get((Object)mod.getIncluiFrete()), EnumConstantsMentorSimNao.get((Object)mod.getIncluiSeguro()), EnumConstantsMentorSimNao.get((Object)mod.getIncluiDesconto()), EnumConstantsMentorSimNao.get((Object)mod.getIncluiDespAcess()), EnumConstantsMentorSimNao.get((Object)mod.getIncluiFrete()), EnumConstantsMentorSimNao.get((Object)mod.getIncluiSeguro()), EnumConstantsMentorSimNao.get((Object)mod.getAbaterValorIcms()), EnumConstantsMentorSimNao.get((Object)mod.getIncluirIcmsDesonerado()), EnumConstantsMentorSimNao.get((Object)mod.getIncluirIcmsSemAproveitamento()), EnumConstantsMentorSimNao.get((Object)mod.getIncluirIpiObservacao()), EnumConstantsMentorSimNao.get((Object)mod.getAbaterValorIcms()), EnumConstantsMentorSimNao.get((Object)mod.getIncluirIcmsSemAproveitamento()), EnumConstantsMentorSimNao.get((Object)mod.getIncluirIpiObservacao()), EnumConstantsMentorSimNao.get((Object)item.getProduto().getPisCofinsTributadoQuantidade()), aliquotaPisSt, aliquotaCofinsSt, item.getItemPedidoFiscal().getVrIcms(), item.getItemPedidoFiscal().getVrICMSDispensado(), item.getItemPedidoFiscal().getVrIcmsSemAprov(), item.getItemPedidoFiscal().getVrIpiObservacao(), Double.valueOf(0.0), Double.valueOf(0.0), mod.getValorMinimoPis(), mod.getValorMinimoCofins());
        PisCofinsCalculado calc = CompImpostoPisCofins.calcularPisCofins((PisCofinsParams)params);
        fiscal.setAliquotaPis(calc.getAliquotaPis());
        fiscal.setVrBCPis(calc.getValorBCPis());
        fiscal.setVrPis(calc.getValorPis());
        fiscal.setVrPisSt(calc.getValorPisST());
        fiscal.setAliquotaCofins(calc.getAliquotaCofins());
        fiscal.setVrBCCofins(calc.getValorBCCofins());
        fiscal.setVrCofins(calc.getValorCofins());
        fiscal.setVrCofinsSt(calc.getValorCofinsST());
        return calc;
    }

    private IPICalculado calcularIpi(Pedido ped, ItemPedido item, ItemPedidoFiscal fiscal) throws ExceptionImpostoIPI {
        ModeloFiscalIpi modIpi = item.getModeloFiscal().getModeloFiscalIpi();
        Double aliquotaIPI = CompCalcVlrImpostosPedido.getAliquotaIpi(item.getProduto(), modIpi);
        IPIParams params = new IPIParams(EnumConstNFeIncidenciaIpi.valueOfCodigo((String)item.getModeloFiscal().getModeloFiscalIpi().getIncidenciaIpi().getCodigo()), null, null, aliquotaIPI, item.getQuantidadeTotal(), EnumConstantsMentorSimNao.get((Object)item.getProduto().getIpiTributadoQuantidade()), EnumConstantsMentorEntSaida.SAIDA, item.getValorTotal(), item.getValorDesconto(), item.getValorDespesaAcessoria(), item.getValorFrete(), item.getValorSeguro(), EnumConstantsMentorSimNao.get((Object)modIpi.getIncluiDesconto()), EnumConstantsMentorSimNao.get((Object)modIpi.getIncluiDespAcess()), EnumConstantsMentorSimNao.get((Object)modIpi.getIncluiFrete()), EnumConstantsMentorSimNao.get((Object)modIpi.getIncluiSeguro()), EnumConstantsMentorSimNao.get((Object)modIpi.getIpiCompoeBcIcms()));
        IPICalculado calc = CompImpostoIPI.calcularIpi((IPIParams)params);
        fiscal.setAliquotaIpi(calc.getAliquotaIpi());
        fiscal.setVrIpiComercio(calc.getValorIpiComercio());
        fiscal.setVrIpiIndustria(calc.getValorIpiIndustria());
        fiscal.setVrIpiIsento(calc.getValorIpiIsento());
        fiscal.setVrIpiObservacao(calc.getValorIpiObservacao());
        fiscal.setVrIpiOutros(calc.getValorIpiOutros());
        fiscal.setVrIpiTributado(calc.getValorIpiTributado());
        return calc;
    }

    private void calcularSestSenat(Pedido ped, ItemPedido item, ItemPedidoFiscal fiscal) {
        SestSenatParams params = new SestSenatParams(item.getProduto().getPercSestSenat(), item.getProduto().getPercRedSestSenat(), fiscal.getValorSestSenat(), Double.valueOf(0.0), item.getValorFrete(), item.getValorSeguro(), item.getValorDespesaAcessoria(), item.getValorDesconto(), item.getValorTotal(), this.getArredondamentoPadrao(), EnumConstTipoCalcSestSenat.get((Object)item.getModeloFiscal().getTipoSestSenat()));
        SestSenatCalculado calc = CompImpostoSestSenat.calcularSestSenat((SestSenatParams)params);
        fiscal.setValorSestSenat(calc.getValorSestSenat());
        fiscal.setAliquotaSestSenat(calc.getAliquotaSestSenat());
    }

    private void calcularOutros(Pedido ped, ItemPedido item, ItemPedidoFiscal fiscal) {
        OutrosParams params = new OutrosParams(item.getProduto().getAliquotaOutros(), item.getProduto().getPercRedOutros(), fiscal.getVrOutros(), Double.valueOf(0.0), item.getValorFrete(), item.getValorSeguro(), item.getValorDespesaAcessoria(), item.getValorDesconto(), item.getValorTotal(), this.getArredondamentoPadrao(), EnumConstTipoCalcOutros.get((Object)item.getModeloFiscal().getTipoOutros()));
        OutrosCalculado calc = CompImpostoOutros.calcularOutros((OutrosParams)params);
        fiscal.setVrOutros(calc.getValorOutros());
        fiscal.setAliquotaOutros(calc.getAliquotaOutros());
    }

    private void calcularLei10833(Pedido ped, ItemPedido item, ItemPedidoFiscal fiscal) {
        Lei10833Params params = new Lei10833Params(item.getProduto().getAliquotaLei10833(), item.getProduto().getPercRedLei10833(), fiscal.getVrLei10833(), Double.valueOf(0.0), item.getValorFrete(), item.getValorSeguro(), item.getValorDespesaAcessoria(), item.getValorDesconto(), item.getValorTotal(), this.getArredondamentoPadrao(), EnumConstTipoCalcLei10833.get((Object)item.getModeloFiscal().getTipoLei10833()));
        Lei10833Calculado calc = CompImpostoLei10833.calcularLei10833((Lei10833Params)params);
        fiscal.setVrLei10833(calc.getValorLei10833());
        fiscal.setAliquotaLei10833(calc.getAliquotaLei10833());
    }

    private void calcularIss(Pedido ped, ItemPedido item, ItemPedidoFiscal fiscal) {
        IssParams params = new IssParams(item.getProduto().getAliquotaIss(), Double.valueOf(0.0), fiscal.getVrIss(), Double.valueOf(0.0), item.getValorFrete(), item.getValorSeguro(), item.getValorDespesaAcessoria(), item.getValorDesconto(), item.getValorTotal(), this.getArredondamentoPadrao(), EnumConstTipoCalcIss.get((Object)item.getModeloFiscal().getIssRetido()));
        IssCalculado calc = CompImpostoIss.calcularIss((IssParams)params);
        fiscal.setVrIss(calc.getValorIss());
        fiscal.setAliquotaIss(calc.getAliquotaIss());
    }

    private void calcularIr(Pedido ped, ItemPedido item, ItemPedidoFiscal fiscal) {
        IrParams params = new IrParams(item.getProduto().getAliquotaIrrf(), item.getProduto().getPercRedIrrf(), fiscal.getVrIrrf(), Double.valueOf(0.0), item.getValorFrete(), item.getValorSeguro(), item.getValorDespesaAcessoria(), item.getValorDesconto(), item.getValorTotal(), this.getArredondamentoPadrao(), EnumConstTipoCalcIr.get((Object)item.getModeloFiscal().getTipoIRRF()));
        IrCalculado calc = CompImpostoIr.calcularIr((IrParams)params);
        fiscal.setVrIrrf(calc.getValorIr());
        fiscal.setAliquotaIrrf(calc.getAliquotaIr());
    }

    private void calcularInss(Pedido ped, ItemPedido item, ItemPedidoFiscal fiscal) {
        InssParams params = new InssParams(item.getProduto().getAliquotaInss(), item.getProduto().getPercRedBCINSS(), fiscal.getVrInss(), Double.valueOf(0.0), Double.valueOf(0.0), item.getValorFrete(), item.getValorSeguro(), item.getValorDespesaAcessoria(), item.getValorDesconto(), item.getValorTotal(), this.getArredondamentoPadrao(), EnumConstTipoCalcInss.get((Object)item.getModeloFiscal().getTipoContSoc()));
        InssCalculado calc = CompImpostoInss.calcularInss((InssParams)params);
        fiscal.setVrInss(calc.getValorInss());
        fiscal.setAliquotaInss(calc.getAliquotaInss());
    }

    private void calcularFunrural(Pedido ped, ItemPedido item, ItemPedidoFiscal fiscal) {
        FunruralParams params = new FunruralParams(item.getProduto().getAliquotaFunrural(), item.getProduto().getPercRedFunrural(), fiscal.getVrFunrural(), Double.valueOf(0.0), item.getValorFrete(), item.getValorSeguro(), item.getValorDespesaAcessoria(), item.getValorDesconto(), item.getValorTotal(), this.getArredondamentoPadrao(), EnumConstTipoCalcFunrural.get((Object)item.getModeloFiscal().getTipoContSoc()));
        FunruralCalculado calc = CompImpostoFunrural.calcularFunrural((FunruralParams)params);
        fiscal.setVrContSoc(calc.getValorFunrural());
        fiscal.setAliquotaContSoc(calc.getAliquotaFunrural());
    }

    private void calcularContSocial(Pedido ped, ItemPedido item, ItemPedidoFiscal fiscal) {
        ContSocialParams params = new ContSocialParams(item.getProduto().getAliquotaContSoc(), item.getProduto().getPercRedContSoc(), fiscal.getVrContSoc(), Double.valueOf(0.0), item.getValorFrete(), item.getValorSeguro(), item.getValorDespesaAcessoria(), item.getValorDesconto(), item.getValorTotal(), this.getArredondamentoPadrao(), EnumConstTipoCalcContSocial.get((Object)item.getModeloFiscal().getTipoContSoc()));
        ContSocialCalculado calc = CompImpostoContSocial.calcularContSocial((ContSocialParams)params);
        fiscal.setVrContSoc(calc.getValorContSocial());
        fiscal.setAliquotaContSoc(calc.getAliquotaContSocial());
    }

    private void calcularCide(Pedido ped, ItemPedido item, ItemPedidoFiscal fiscal) {
        CideParams params = new CideParams(item.getProduto().getAliquotaCide(), Double.valueOf(0.0), item.getItemPedidoFiscal().getValorCIDE(), Double.valueOf(0.0), item.getValorFrete(), item.getValorSeguro(), item.getValorDespesaAcessoria(), item.getValorDesconto(), item.getValorTotalBruto(), item.getQuantidadeTotal(), this.getArredondamentoPadrao(), EnumConstTipoCalcCide.get((Object)item.getModeloFiscal().getTipoCalculoCide()));
        CideCalculado calc = CompImpostoCide.calcularCide((CideParams)params);
        fiscal.setValorCIDE(calc.getValorCide());
        fiscal.setAliquotaCIDE(calc.getAliquotaCide());
        fiscal.setQuantidadeBCCIDE(calc.getBaseCalculoCide());
    }

    private EnumConstTipoArredondamento getArredondamentoPadrao() {
        return EnumConstTipoArredondamento.ROUND_HALF_EVEN;
    }
}

