/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.calculovalores.pedido;

import com.touchcomp.basementor.model.deprecated.PreFaturamentoPedItem;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.GradeItemPedido;
import com.touchcomp.basementor.model.vo.ItemPedido;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.Pedido;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementorexceptions.exceptions.impl.impostoicms.ExceptionImpostoIcms;
import com.touchcomp.basementorexceptions.exceptions.impl.impostoipi.ExceptionImpostoIPI;
import com.touchcomp.basementorexceptions.exceptions.impl.impostopiscofins.ExceptionImpostoPisCofins;
import com.touchcomp.basementorservice.components.calculovalores.pedido.CompCalcVlrImpostosPedido;
import com.touchcomp.basementorservice.helpers.impl.condicoespagamento.HelperCondicoesPagamento;
import com.touchcomp.basementorservice.service.impl.empresacontabilidade.ServiceEmpresaContabilidadeImpl;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.number.ToolNumber;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class CompCalcVlrPedido {
    public void calculoValoresPedido(List<ItemPedido> itens, Representante rep, NaturezaOperacao nat, Empresa emp, Date dataEmissao, UnidadeFatCliente unid, OpcoesFaturamento opcoesFaturamento) {
        for (ItemPedido it : itens) {
            this.putQuantidadeTotal(it);
            this.putValorDescTrib(it);
            this.putValorTotalBruto(it);
            this.putBancoCredito(it);
            this.putValorTotal(it, opcoesFaturamento);
            this.putPeso(it);
            this.putLancVendasItens(it, dataEmissao, nat, unid);
        }
    }

    private void putValorDescTrib(ItemPedido it) {
        if (it.getValorUnitario() != null && it.getPercDescTrib() != null) {
            it.setValorUnitarioDescTrib(Double.valueOf(it.getValorUnitario() - it.getValorUnitario() * (it.getPercDescTrib() / 100.0)));
        }
    }

    private void putQuantidadeTotal(ItemPedido it) {
        double qtd = 0.0;
        for (GradeItemPedido g : it.getGradeItemPedido()) {
            qtd += g.getQuantidade().doubleValue();
        }
        it.setQuantidadeTotal(Double.valueOf(qtd));
    }

    private void putValorTotalBruto(ItemPedido item) {
        item.setValorTotalBruto(Double.valueOf(item.getValorUnitario() * item.getQuantidadeTotal()));
        item.setValorTotalBrutoDescTrib(Double.valueOf(item.getValorUnitarioDescTrib() * item.getQuantidadeTotal()));
    }

    private void putBancoCredito(ItemPedido it) {
        double valorBC = it.getValorTotalBruto();
        it.setValorBancoCredito(Double.valueOf(valorBC -= it.getQuantidadeTotal() * it.getValorMinimo()));
    }

    private void putValorTotal(ItemPedido item, OpcoesFaturamento op) {
        Double valorTotal = item.getValorTotalBruto() - item.getValorDesconto() + item.getValorFrete() + item.getValorSeguro() + item.getValorDespesaAcessoria();
        item.setValorTotal(valorTotal);
        Double valorTotalDescTrib = item.getValorTotalBrutoDescTrib() - item.getValorDesconto() + item.getValorFrete() + item.getValorSeguro() + item.getValorDespesaAcessoria();
        item.setValorTotalDescTrib(valorTotalDescTrib);
    }

    private void putPeso(ItemPedido it) {
    }

    public void ratearValoresAcessorios(List<ItemPedido> itens, double valorDesc, double percDesc, short tipoDesc, double valorDesp, double percDesp, short tipoDesp, double valorFrete, double percFrete, short tipoFrete, double valorSeg, double percSeg, short tipoSeg, OpcoesFaturamento op) {
        CompCalcVlrPedido.ratearDesconto(itens, valorDesc, percDesc, tipoDesc, op);
        CompCalcVlrPedido.ratearDespAcess(itens, valorDesp, percDesp, tipoDesp, op);
        CompCalcVlrPedido.ratearFrete(itens, valorFrete, percFrete, tipoFrete, op);
        CompCalcVlrPedido.ratearSeguro(itens, valorSeg, percSeg, tipoSeg, op);
    }

    private static void ratearDesconto(List<ItemPedido> itens, double valorDesc, double percDesc, short tipoDesc, OpcoesFaturamento op) {
        double valorTotal = 0.0;
        if (tipoDesc == 0) {
            valorDesc = 0.0;
        }
        for (ItemPedido it : itens) {
            if (it.getDescontoItem() == 1) continue;
            valorTotal += it.getQuantidadeTotal() * it.getValorUnitario();
        }
        if (valorTotal <= 0.0 && valorDesc > 0.0) {
            return;
        }
        ItemPedido lastItem = null;
        double valorDescTotal = 0.0;
        for (ItemPedido item : itens) {
            double vlrProduto = item.getValorUnitario() * item.getQuantidadeTotal();
            double valorDescCalc = 0.0;
            double percDescCalc = 0.0;
            if (item.getDescontoItem() != 1) {
                if (tipoDesc == 0) {
                    valorDescCalc = CompCalcVlrPedido.arrredondarNumero(percDesc / 100.0 * vlrProduto, 2);
                    percDescCalc = percDesc;
                } else {
                    percDescCalc = valorDesc > 0.0 && valorTotal > 0.0 ? CompCalcVlrPedido.arrredondarNumero(valorDesc / valorTotal * 100.0, 4) : 0.0;
                    valorDescCalc = CompCalcVlrPedido.arrredondarNumero(vlrProduto * percDescCalc / 100.0, 2);
                }
                valorDescTotal += valorDescCalc;
                lastItem = item;
                item.setPercDesconto(ToolNumber.asZeroIfNull((Double)percDescCalc));
                item.setValorDesconto(ToolNumber.asZeroIfNull((Double)valorDescCalc));
                continue;
            }
            if (item.getTipoDesconto() == 0) {
                if (!(item.getPercDesconto() > 0.0)) continue;
                item.setValorDesconto(Double.valueOf(CompCalcVlrPedido.arrredondarNumero(item.getPercDesconto() / 100.0 * vlrProduto, 2)));
                continue;
            }
            item.setValorDesconto(Double.valueOf(CompCalcVlrPedido.arrredondarNumero(item.getValorDesconto(), 2)));
            if (!(item.getValorDesconto() > 0.0) || !(vlrProduto > 0.0)) continue;
            item.setPercDesconto(Double.valueOf(CompCalcVlrPedido.arrredondarNumero(item.getValorDesconto() * 100.0 / vlrProduto, 4)));
        }
        if (lastItem != null && valorDesc > 0.0) {
            Double vrDesconto = lastItem.getValorDesconto() + (valorDesc - valorDescTotal);
            lastItem.setValorDesconto(vrDesconto);
            if (lastItem.getValorDesconto() < 0.0) {
                lastItem.setValorDesconto(Double.valueOf(0.0));
                lastItem.setPercDesconto(Double.valueOf(0.0));
                vrDesconto = Math.abs(vrDesconto);
                for (ItemPedido item : itens) {
                    if (item.getValorDesconto() >= vrDesconto) {
                        item.setValorDesconto(Double.valueOf(item.getValorDesconto() - vrDesconto));
                        break;
                    }
                    item.setValorDesconto(Double.valueOf(0.0));
                    vrDesconto = vrDesconto - item.getValorDesconto();
                }
            }
        }
    }

    private static void ratearFrete(List<ItemPedido> itens, double valorFrete, double percFrete, short tipoFrete, OpcoesFaturamento op) {
        double valorTotal = 0.0;
        if (tipoFrete == 0) {
            valorFrete = 0.0;
        }
        for (ItemPedido it : itens) {
            if (it.getFreteItem() == 1) continue;
            valorTotal += it.getQuantidadeTotal() * it.getValorUnitario();
        }
        ItemPedido lastItem = null;
        double valorFreteTotal = 0.0;
        for (ItemPedido item : itens) {
            double vlrProduto = item.getValorUnitario() * item.getQuantidadeTotal();
            double valorFreteCalc = 0.0;
            double percFreteCalc = 0.0;
            if (item.getFreteItem() != 1) {
                if (tipoFrete == 0) {
                    valorFreteCalc = CompCalcVlrPedido.arrredondarNumero(percFrete / 100.0 * vlrProduto, 2);
                    percFreteCalc = percFrete;
                } else {
                    percFreteCalc = valorFrete > 0.0 && valorTotal > 0.0 ? CompCalcVlrPedido.arrredondarNumero(valorFrete / valorTotal * 100.0, 4) : 0.0;
                    valorFreteCalc = CompCalcVlrPedido.arrredondarNumero(vlrProduto * percFreteCalc / 100.0, 2);
                }
                valorFreteTotal += valorFreteCalc;
                lastItem = item;
                item.setPercFrete(Double.valueOf(percFreteCalc));
                item.setValorFrete(Double.valueOf(valorFreteCalc));
                continue;
            }
            if (item.getTipoFrete() == 0) {
                if (!(item.getPercFrete() > 0.0)) continue;
                item.setValorFrete(Double.valueOf(CompCalcVlrPedido.arrredondarNumero(item.getPercFrete() / 100.0 * vlrProduto, 2)));
                continue;
            }
            item.setValorFrete(Double.valueOf(CompCalcVlrPedido.arrredondarNumero(item.getValorFrete(), 2)));
            if (!(item.getValorFrete() > 0.0) || !(vlrProduto > 0.0)) continue;
            item.setPercFrete(Double.valueOf(CompCalcVlrPedido.arrredondarNumero(item.getValorFrete() * 100.0 / vlrProduto, 4)));
        }
        if (lastItem != null && valorFrete > 0.0) {
            Double vrFrete = lastItem.getValorFrete() + (valorFrete - valorFreteTotal);
            lastItem.setValorFrete(vrFrete);
            if (lastItem.getValorFrete() < 0.0) {
                lastItem.setValorFrete(Double.valueOf(0.0));
                lastItem.setPercFrete(Double.valueOf(0.0));
                vrFrete = Math.abs(vrFrete);
                for (ItemPedido item : itens) {
                    if (item.getValorFrete() >= vrFrete) {
                        item.setValorFrete(Double.valueOf(item.getValorFrete() - vrFrete));
                        break;
                    }
                    item.setValorFrete(Double.valueOf(0.0));
                    vrFrete = vrFrete - item.getValorFrete();
                }
            }
        }
    }

    private static void ratearDespAcess(List<ItemPedido> itens, double valorDesp, double percDesp, short tipoDesp, OpcoesFaturamento op) {
        double valorTotal = 0.0;
        if (tipoDesp == 0) {
            valorDesp = 0.0;
        }
        for (ItemPedido it : itens) {
            if (it.getDespAcessItem() == 1) continue;
            valorTotal += it.getQuantidadeTotal() * it.getValorUnitario();
        }
        ItemPedido lastItem = null;
        double valorDespTotal = 0.0;
        for (ItemPedido item : itens) {
            double vlrProduto = item.getValorUnitario() * item.getQuantidadeTotal();
            double valorDespCalc = 0.0;
            double percDespCalc = 0.0;
            if (item.getDespAcessItem() != 1) {
                if (tipoDesp == 0) {
                    valorDespCalc = CompCalcVlrPedido.arrredondarNumero(percDesp / 100.0 * vlrProduto, 2);
                    percDespCalc = percDesp;
                } else {
                    percDespCalc = valorDesp > 0.0 && valorTotal > 0.0 ? CompCalcVlrPedido.arrredondarNumero(valorDesp / valorTotal * 100.0, 4) : 0.0;
                    valorDespCalc = CompCalcVlrPedido.arrredondarNumero(vlrProduto * percDespCalc / 100.0, 2);
                }
                valorDespTotal += valorDespCalc;
                lastItem = item;
                item.setPercDespesaAcessoria(Double.valueOf(percDespCalc));
                item.setValorDespesaAcessoria(Double.valueOf(valorDespCalc));
                continue;
            }
            if (item.getTipoDespAcessoria() == 0) {
                if (!(item.getPercDespesaAcessoria() > 0.0)) continue;
                item.setValorDespesaAcessoria(Double.valueOf(CompCalcVlrPedido.arrredondarNumero(item.getPercDespesaAcessoria() / 100.0 * vlrProduto, 2)));
                continue;
            }
            item.setValorDespesaAcessoria(Double.valueOf(CompCalcVlrPedido.arrredondarNumero(item.getValorDespesaAcessoria(), 2)));
            if (!(item.getValorDespesaAcessoria() > 0.0) || !(vlrProduto > 0.0)) continue;
            item.setPercDespesaAcessoria(Double.valueOf(CompCalcVlrPedido.arrredondarNumero(item.getValorDespesaAcessoria() * 100.0 / vlrProduto, 4)));
        }
        if (lastItem != null && valorDesp > 0.0) {
            Double vrDesp = lastItem.getValorDespesaAcessoria() + (valorDesp - valorDespTotal);
            lastItem.setValorDespesaAcessoria(vrDesp);
            if (lastItem.getValorDespesaAcessoria() < 0.0) {
                lastItem.setValorDespesaAcessoria(Double.valueOf(0.0));
                lastItem.setPercDespesaAcessoria(Double.valueOf(0.0));
                vrDesp = Math.abs(vrDesp);
                for (ItemPedido item : itens) {
                    if (item.getValorDespesaAcessoria() >= vrDesp) {
                        item.setValorDespesaAcessoria(Double.valueOf(item.getValorDespesaAcessoria() - vrDesp));
                        break;
                    }
                    item.setValorDespesaAcessoria(Double.valueOf(0.0));
                    vrDesp = vrDesp - item.getValorDespesaAcessoria();
                }
            }
        }
    }

    private static void ratearSeguro(List<ItemPedido> itens, double valorSeguro, double percSeguro, short tipoSeguro, OpcoesFaturamento op) {
        double valorTotal = 0.0;
        if (tipoSeguro == 0) {
            valorSeguro = 0.0;
        }
        for (ItemPedido it : itens) {
            valorTotal += it.getQuantidadeTotal() * it.getValorUnitario();
        }
        ItemPedido lastItem = null;
        double valorSeguroTotal = 0.0;
        for (ItemPedido item : itens) {
            double vlrProduto = item.getValorUnitario() * item.getQuantidadeTotal();
            double valorSeguroCalc = 0.0;
            double percSeguroCalc = 0.0;
            if (item.getSeguroItem() != 1) {
                if (tipoSeguro == 0) {
                    valorSeguroCalc = CompCalcVlrPedido.arrredondarNumero(percSeguro / 100.0 * vlrProduto, 2);
                    percSeguroCalc = percSeguro;
                } else {
                    percSeguroCalc = valorSeguro > 0.0 && valorTotal > 0.0 ? CompCalcVlrPedido.arrredondarNumero(valorSeguro / valorTotal * 100.0, 4) : 0.0;
                    valorSeguroCalc = CompCalcVlrPedido.arrredondarNumero(vlrProduto * percSeguroCalc / 100.0, 2);
                }
                valorSeguroTotal += valorSeguroCalc;
                lastItem = item;
                item.setPercSeguro(Double.valueOf(percSeguroCalc));
                item.setValorSeguro(Double.valueOf(valorSeguroCalc));
                continue;
            }
            if (item.getTipoSeguro() == 0) {
                if (!(item.getPercSeguro() > 0.0)) continue;
                item.setValorSeguro(Double.valueOf(CompCalcVlrPedido.arrredondarNumero(item.getPercSeguro() / 100.0 * vlrProduto, 2)));
                continue;
            }
            item.setValorSeguro(Double.valueOf(CompCalcVlrPedido.arrredondarNumero(item.getValorSeguro(), 2)));
            if (!(item.getValorSeguro() > 0.0) || !(vlrProduto > 0.0)) continue;
            item.setPercSeguro(Double.valueOf(CompCalcVlrPedido.arrredondarNumero(item.getValorSeguro() * 100.0 / vlrProduto, 4)));
        }
        if (lastItem != null && valorSeguro > 0.0) {
            Double vrSeguro = lastItem.getValorSeguro() + (valorSeguro - valorSeguroTotal);
            lastItem.setValorSeguro(vrSeguro);
            if (lastItem.getValorSeguro() < 0.0) {
                lastItem.setValorSeguro(Double.valueOf(0.0));
                lastItem.setPercSeguro(Double.valueOf(0.0));
                vrSeguro = Math.abs(vrSeguro);
                for (ItemPedido item : itens) {
                    if (item.getValorSeguro() >= vrSeguro) {
                        item.setValorSeguro(Double.valueOf(item.getValorSeguro() - vrSeguro));
                        break;
                    }
                    item.setValorSeguro(Double.valueOf(0.0));
                    vrSeguro = vrSeguro - item.getValorSeguro();
                }
            }
        }
    }

    private static double arrredondarNumero(double numero, int casasDecimais) {
        return ToolFormatter.arrredondarNumero((Double)numero, (int)casasDecimais);
    }

    public void calcularTotalizadores(Pedido ped) {
        List its = ped.getItemPedido();
        Double valorTotalBruto = 0.0;
        Double valorTotal = 0.0;
        Double valorTotalBrutoDescTrib = 0.0;
        Double valorTotalDescTrib = 0.0;
        Double valorTotalComImpostos = 0.0;
        Double valorDesconto = 0.0;
        Double valorDescontoInf = 0.0;
        Double valorBrutoDescontoInf = 0.0;
        Double valorDesp = 0.0;
        Double valorDespInf = 0.0;
        Double valorBrutoDespInf = 0.0;
        Double valorSeguro = 0.0;
        Double valorSeguroInf = 0.0;
        Double valorBrutoSeguroInf = 0.0;
        Double valorFrete = 0.0;
        Double valorFreteInf = 0.0;
        Double valorBrutoFreteInf = 0.0;
        Double pesoTotal = 0.0;
        Double volumeTotal = 0.0;
        Double valorComissaoTotal = 0.0;
        Double qtdeTotal = 0.0;
        Double vlrTotalCusto = 0.0;
        Integer nrItens = 0;
        for (ItemPedido it : its) {
            valorTotalBruto = valorTotalBruto + it.getValorTotalBruto();
            valorTotal = valorTotal + it.getValorTotal();
            valorTotalBrutoDescTrib = valorTotalBrutoDescTrib + it.getValorTotalBrutoDescTrib();
            valorTotalDescTrib = valorTotalDescTrib + it.getValorTotalDescTrib();
            valorTotalComImpostos = valorTotalComImpostos + it.getValorTotalComImpostos();
            valorDesconto = valorDesconto + it.getValorDesconto();
            valorDesp = valorDesp + it.getValorDespesaAcessoria();
            valorSeguro = valorSeguro + it.getValorSeguro();
            valorFrete = valorFrete + it.getValorFrete();
            valorComissaoTotal = valorComissaoTotal + it.getPercComissao() / 100.0 * it.getValorTotal();
            if (it.getDescontoItem() == null || it.getDescontoItem() == 0) {
                valorDescontoInf = valorDescontoInf + it.getValorDesconto();
                valorBrutoDescontoInf = valorBrutoDescontoInf + it.getValorTotalBruto();
            }
            if (it.getFreteItem() == null || it.getFreteItem() == 0) {
                valorFreteInf = valorFreteInf + it.getValorFrete();
                valorBrutoFreteInf = valorBrutoFreteInf + it.getValorTotalBruto();
            }
            if (it.getSeguroItem() == null || it.getSeguroItem() == 0) {
                valorSeguroInf = valorSeguroInf + it.getValorSeguro();
                valorBrutoSeguroInf = valorBrutoSeguroInf + it.getValorTotalBruto();
            }
            if (it.getDespAcessItem() == null || it.getDespAcessItem() == 0) {
                valorDespInf = valorDespInf + it.getValorDespesaAcessoria();
                valorBrutoDespInf = valorBrutoDespInf + it.getValorTotalBruto();
            }
            if (it.getProduto() != null && it.getTipoCondicao() != null && it.getTipoCondicao() == 0) {
                pesoTotal = pesoTotal + (it.getProduto().getPesoUnitario() + it.getProduto().getPesoEmbalagem()) * it.getQuantidadeTotal();
            }
            if (it.getProduto() != null && it.getTipoCondicao() != null && it.getTipoCondicao() == 0 && it.getProduto().getVolume() != null) {
                volumeTotal = volumeTotal + it.getProduto().getVolume() * it.getQuantidadeTotal();
            }
            Integer n = nrItens;
            nrItens = nrItens + 1;
            if (it.getValorCusto() == null) {
                it.setValorCusto(Double.valueOf(0.0));
            }
            vlrTotalCusto = vlrTotalCusto + it.getQuantidadeTotal() * it.getValorCusto();
            qtdeTotal = qtdeTotal + it.getQuantidadeTotal();
        }
        ped.setQtdeTotalItens(qtdeTotal);
        ped.setVlrTotalCusto(vlrTotalCusto);
        ped.setNrTotalItens(nrItens);
        ped.setValorTotalBruto(valorTotalBruto);
        ped.setValorTotal(valorTotal);
        ped.setValorTotalBrutoDescTrib(valorTotalBrutoDescTrib);
        ped.setValorTotalDescTrib(valorTotalDescTrib);
        ped.setValorTotalComImpostos(valorTotalComImpostos);
        ped.setPesoTotal(pesoTotal);
        ped.setVolumeTotal(volumeTotal);
        ped.setTotalComissao(valorComissaoTotal);
        ped.setPercComissao(Double.valueOf(valorComissaoTotal / (valorTotal > 0.0 ? valorTotal : 1.0) * 100.0));
        this.getTotalizadorDesconto(ped, valorDesconto, valorDescontoInf, valorTotalBruto, valorBrutoDescontoInf);
        this.getTotalizadorFrete(ped, valorFrete, valorFreteInf, valorTotalBruto, valorBrutoFreteInf);
        this.getTotalizadorSeguro(ped, valorSeguro, valorSeguroInf, valorTotalBruto, valorBrutoSeguroInf);
        this.getTotalizadorDespAcessoria(ped, valorDesp, valorDespInf, valorTotalBruto, valorBrutoDespInf);
    }

    private void getTotalizadorDesconto(Pedido ped, Double valorDesconto, Double valorDescontoInf, Double valorTotalBruto, Double valorTotalBrutoInf) {
        if (ped.getTipoDespAcessInf() == 0) {
            ped.setValorDescontoInf(valorDescontoInf);
        } else if (valorDescontoInf > 0.0 && valorTotalBrutoInf > 0.0) {
            ped.setPercDescontoInf(Double.valueOf(valorDescontoInf / valorTotalBrutoInf * 100.0));
        }
        ped.setValorDesconto(valorDesconto);
        if (valorTotalBruto > 0.0) {
            ped.setPercDesconto(Double.valueOf(valorDesconto / valorTotalBruto * 100.0));
        } else {
            ped.setPercDesconto(Double.valueOf(0.0));
        }
    }

    private void getTotalizadorFrete(Pedido ped, Double valorFrete, Double valorFreteInf, Double valorTotalBruto, Double valorTotalBrutoInf) {
        if (ped.getTipoFreteInf() == 0) {
            ped.setValorFreteInf(valorFreteInf);
        } else if (valorFreteInf > 0.0 && valorTotalBrutoInf > 0.0) {
            ped.setPercFreteInf(Double.valueOf(valorFreteInf / valorTotalBrutoInf * 100.0));
        }
        ped.setValorFrete(valorFrete);
        if (valorTotalBruto > 0.0) {
            ped.setPercFrete(Double.valueOf(valorFrete / valorTotalBruto * 100.0));
        } else {
            ped.setPercFrete(Double.valueOf(0.0));
        }
    }

    private void getTotalizadorSeguro(Pedido ped, Double valorSeguro, Double valorSeguroInf, Double valorTotalBruto, Double valorTotalBrutoInf) {
        if (ped.getTipoSeguroInf() == 0) {
            ped.setValorSeguroInf(valorSeguroInf);
        } else if (valorSeguroInf > 0.0 && valorTotalBrutoInf > 0.0) {
            ped.setPercSeguroInf(Double.valueOf(valorSeguroInf / valorTotalBrutoInf * 100.0));
        }
        ped.setValorSeguro(valorSeguro);
        if (valorTotalBruto > 0.0) {
            ped.setPercSeguro(Double.valueOf(valorSeguro / valorTotalBruto * 100.0));
        } else {
            ped.setPercSeguro(Double.valueOf(0.0));
        }
    }

    private void getTotalizadorDespAcessoria(Pedido ped, Double valorDesp, Double valorDespInf, Double valorTotalBruto, Double valorTotalBrutoInf) {
        if (ped.getTipoDespAcessInf() == 0) {
            ped.setValorDespAcessoriaInf(valorDespInf);
        } else if (valorDespInf > 0.0 && valorTotalBrutoInf > 0.0) {
            ped.setPercDespAcessoriaInf(Double.valueOf(valorDespInf / valorTotalBrutoInf * 100.0));
        }
        ped.setValorDespAcessoria(valorDesp);
        if (valorTotalBruto > 0.0) {
            ped.setPercDespAcessoria(Double.valueOf(valorDesp / valorTotalBruto * 100.0));
        } else {
            ped.setPercDespAcessoria(Double.valueOf(0.0));
        }
    }

    public static void calcularValoresPedido(Pedido ped, OpcoesFaturamento opcoes, OpcoesContabeis opcoesContabeis) throws ExceptionImpostoPisCofins, ExceptionImpostoIPI, ExceptionImpostoIcms {
        int ret = ((HelperCondicoesPagamento)Context.get(HelperCondicoesPagamento.class)).calcularNrDiasMedios(ped.getCondicoesPagamento(), ped.getCondPagMut());
        EmpresaContabilidade empCont = ((ServiceEmpresaContabilidadeImpl)Context.get(ServiceEmpresaContabilidadeImpl.class)).findByEmpresa(ped.getEmpresa());
        ped.setDiasMediosCondPag(Short.valueOf((short)ret));
        new CompCalcVlrPedido().ratearValoresAcessorios(ped.getItemPedido(), ped.getValorDescontoInf(), ped.getPercDescontoInf(), ped.getTipoDesconto(), ped.getValorDespAcessoriaInf(), ped.getPercDespAcessoriaInf(), ped.getTipoDespAcessInf(), ped.getValorFreteInf(), ped.getPercFreteInf(), ped.getTipoFreteInf(), ped.getValorSeguroInf(), ped.getPercSeguroInf(), ped.getTipoSeguroInf(), opcoes);
        new CompCalcVlrPedido().calculoValoresPedido(ped.getItemPedido(), ped.getRepresentante(), ped.getNaturezaOperacao(), ped.getEmpresa(), ped.getDataEmissao(), ped.getUnidadeFatCliente(), opcoes);
        if (opcoes.getCalcularImpPrevPedido() != null && opcoes.getCalcularImpPrevPedido() == 1) {
            new CompCalcVlrImpostosPedido().calcular(ped, opcoesContabeis, opcoes, empCont);
        }
        new CompCalcVlrPedido().calcularTotalizadores(ped);
    }

    public HashMap<String, Double> getValorTotalItemPedido(List<ItemPedido> itens, double percDescFinance) {
        HashMap<String, Double> h = new HashMap<String, Double>();
        Double valor = 0.0;
        Double valorIcmsSt = 0.0;
        Double valorParaBCComissaoTitulo = 0.0;
        for (ItemPedido i : itens) {
            if (i.getModeloFiscal().getGerarFinanceiro() != 1) continue;
            valor = valor + (i.getValorTotal() - i.getValorTotal() * (percDescFinance / 100.0));
            valorParaBCComissaoTitulo = valorParaBCComissaoTitulo + i.getValorTotal();
        }
        h.put("valorTotal", valor);
        h.put("valorICMSST", valorIcmsSt);
        h.put("valorParaBCComissaoTitulo", valorParaBCComissaoTitulo);
        return h;
    }

    public HashMap<String, Double> getValorTotalItemPedido(List<ItemPedido> itens) {
        HashMap<String, Double> h = new HashMap<String, Double>();
        Double valor = 0.0;
        Double valorIcmsSt = 0.0;
        for (ItemPedido i : itens) {
            if (i.getModeloFiscal() != null && i.getModeloFiscal().getGerarFinanceiro() != 1) continue;
            valor = valor + i.getValorTotal();
        }
        h.put("valorTotal", valor);
        h.put("valorICMSST", valorIcmsSt);
        return h;
    }

    private void putLancVendasItens(ItemPedido it, Date dataEmissao, NaturezaOperacao nat, UnidadeFatCliente unid) {
        if (nat == null || unid == null) {
            return;
        }
        if (nat.getTipoLancCampVendas() == null || nat.getTipoLancCampVendas() == 3) {
            return;
        }
    }

    public HashMap<String, Double> getValorTotalItemPreFaturamento(List<PreFaturamentoPedItem> itens, double percDescFinance) {
        HashMap<String, Double> h = new HashMap<String, Double>();
        Double valor = 0.0;
        Double valorIcmsSt = 0.0;
        Double valorParaBCComissaoTitulo = 0.0;
        for (PreFaturamentoPedItem preItem : itens) {
            if (preItem.getGerarFinanceiro() != 1) continue;
            valor = valor + (preItem.getValorTotal() - preItem.getValorTotal() * (percDescFinance / 100.0));
            valorParaBCComissaoTitulo = valorParaBCComissaoTitulo + preItem.getValorTotal();
        }
        h.put("valorTotal", valor);
        h.put("valorICMSST", valorIcmsSt);
        h.put("valorParaBCComissaoTitulo", valorParaBCComissaoTitulo);
        return h;
    }
}

