/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.calculovalores.rps;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorEntSaida;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.impostos.contsocial.EnumConstTipoCalcContSocial;
import com.touchcomp.basementor.constants.enums.impostos.inss.EnumConstTipoCalcInss;
import com.touchcomp.basementor.constants.enums.impostos.ir.EnumConstTipoCalcIr;
import com.touchcomp.basementor.constants.enums.impostos.iss.EnumConstTipoCalcIss;
import com.touchcomp.basementor.constants.enums.impostos.outros.EnumConstTipoCalcOutros;
import com.touchcomp.basementor.constants.enums.impostos.piscofins.EnumConstNFeIncidenciaCofins;
import com.touchcomp.basementor.constants.enums.impostos.piscofins.EnumConstTipoCalcPisCofins;
import com.touchcomp.basementor.constants.enums.modelorps.EnumConstTipoISSModeloRPS;
import com.touchcomp.basementor.constants.enums.modelorps.EnumConstTipoOutrosModeloRPS;
import com.touchcomp.basementor.constants.enums.number.EnumConstTipoArredondamento;
import com.touchcomp.basementor.model.vo.GrupoServicoRPS;
import com.touchcomp.basementor.model.vo.ItemServicoRPSRPS;
import com.touchcomp.basementor.model.vo.Rps;
import com.touchcomp.basementorexceptions.exceptions.impl.impostopiscofins.ExceptionImpostoPisCofins;
import com.touchcomp.basementorrules.impostos.contsocial.CompImpostoContSocial;
import com.touchcomp.basementorrules.impostos.contsocial.model.ContSocialCalculado;
import com.touchcomp.basementorrules.impostos.contsocial.model.ContSocialParams;
import com.touchcomp.basementorrules.impostos.inss.CompImpostoInss;
import com.touchcomp.basementorrules.impostos.inss.model.InssCalculado;
import com.touchcomp.basementorrules.impostos.inss.model.InssParams;
import com.touchcomp.basementorrules.impostos.ir.CompImpostoIr;
import com.touchcomp.basementorrules.impostos.ir.model.IrCalculado;
import com.touchcomp.basementorrules.impostos.ir.model.IrParams;
import com.touchcomp.basementorrules.impostos.iss.CompImpostoIss;
import com.touchcomp.basementorrules.impostos.iss.model.IssCalculado;
import com.touchcomp.basementorrules.impostos.iss.model.IssParams;
import com.touchcomp.basementorrules.impostos.outros.CompImpostoOutros;
import com.touchcomp.basementorrules.impostos.outros.model.OutrosCalculado;
import com.touchcomp.basementorrules.impostos.outros.model.OutrosParams;
import com.touchcomp.basementorrules.impostos.piscofins.CompImpostoPisCofins;
import com.touchcomp.basementorrules.impostos.piscofins.model.PisCofinsCalculado;
import com.touchcomp.basementorrules.impostos.piscofins.model.PisCofinsParams;
import com.touchcomp.basementorservice.BaseMethods;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.text.DecimalFormat;
import org.springframework.stereotype.Component;

@Component
public class CompCalcularValoresFiscaisRps
extends BaseMethods {
    public void calcular(Rps rps) throws ExceptionImpostoPisCofins {
        if (this.isNull(rps).booleanValue() || this.isNull(rps.getModeloRps()).booleanValue()) {
            return;
        }
        this.calcularBCOutrosValores(rps);
        this.setValorContSocial(rps);
        this.setValorPisCofins(rps);
        this.setValorInss(rps);
        this.setValorIRRF(rps);
        this.setValorIss(rps);
        this.setValorOutros(rps);
        rps.setValorLiquidoNfse(Double.valueOf(rps.getValorServico() - rps.getValorPisST() - rps.getValorCofinsST() - rps.getValorInss() - rps.getValorIr() - rps.getValorContSoc() - rps.getValorOutros() - rps.getValorIssRetido() - rps.getValorDescontoIncondicionado() - rps.getValorDescontoCondicionado()));
        CompCalcularValoresFiscaisRps.setOBSTributos(rps);
    }

    private void calcularBCOutrosValores(Rps rps) {
        Double vlr = 0.0;
        Double bcInss = 0.0;
        Double bcIss = 0.0;
        Double bcPis = 0.0;
        Double bcCofins = 0.0;
        Double bcIr = 0.0;
        Double bcCsll = 0.0;
        Double bcOutros = 0.0;
        if (CompCalcularValoresFiscaisRps.isWithData(rps.getItensRps())) {
            for (ItemServicoRPSRPS it : rps.getItensRps()) {
                vlr = vlr + it.getValor();
                if (this.isAffimative(it.getIncidirCSLL())) {
                    bcCsll = bcCsll + it.getValor();
                }
                if (this.isAffimative(it.getIncidirCofins())) {
                    bcCofins = bcCofins + it.getValor();
                }
                if (this.isAffimative(it.getIncidirIR())) {
                    bcIr = bcIr + it.getValor();
                }
                if (this.isAffimative(it.getIncidirISS())) {
                    bcIss = bcIss + it.getValor();
                }
                if (this.isAffimative(it.getIncidirInss())) {
                    bcInss = bcInss + it.getValor();
                }
                if (this.isAffimative(it.getIncidirPis())) {
                    bcPis = bcPis + it.getValor();
                }
                if (!this.isAffimative(it.getIncidirOutros())) continue;
                bcOutros = bcOutros + it.getValor();
            }
        }
        rps.setValorServico(vlr);
        rps.setValorDescontoIncondicionado(Double.valueOf(rps.getPercDescontoIncondicionado() / 100.0 * rps.getValorServico()));
        Double vrRed = rps.getValorDescontoIncondicionado() + rps.getValorDescontoCondicionado();
        if (this.isAffimative(rps.getModeloRps().getIncidirDescCofins())) {
            rps.setBcCofins(Double.valueOf(bcCofins - vrRed));
        } else {
            rps.setBcCofins(bcCofins);
        }
        if (this.isAffimative(rps.getModeloRps().getIncidirDescCSLL())) {
            rps.setBcCsll(Double.valueOf(bcCsll - vrRed));
        } else {
            rps.setBcCsll(bcCsll);
        }
        if (this.isAffimative(rps.getModeloRps().getIncidirDescIR())) {
            rps.setBcIr(Double.valueOf(bcIr - vrRed));
        } else {
            rps.setBcIr(bcIr);
        }
        if (this.isAffimative(rps.getModeloRps().getIncidirDescISS())) {
            rps.setBcIss(Double.valueOf(bcIss - vrRed));
        } else {
            rps.setBcIss(bcIss);
        }
        if (this.isAffimative(rps.getModeloRps().getIncidirDescInss())) {
            rps.setBcInss(Double.valueOf(bcInss - vrRed));
        } else {
            rps.setBcInss(bcInss);
        }
        if (this.isAffimative(rps.getModeloRps().getIncidirDescOutros())) {
            rps.setBcOutros(Double.valueOf(bcOutros - vrRed));
        } else {
            rps.setBcOutros(bcOutros);
        }
        if (this.isAffimative(rps.getModeloRps().getIncidirDescPis())) {
            rps.setBcPis(Double.valueOf(bcPis - vrRed));
        } else {
            rps.setBcPis(bcPis);
        }
        rps.setValorBaseCalculo(Double.valueOf(vlr - vrRed));
    }

    private void setValorContSocial(Rps rps) {
        if (rps.getModeloRps() != null) {
            ContSocialParams params = new ContSocialParams(rps.getAliquotaContSoc(), rps.getModeloRps().getPercRedCSLL(), rps.getValorContSoc(), rps.getModeloRps().getValorMinimoCSLL(), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(rps.getValorDescontoCondicionado() + rps.getValorDescontoIncondicionado()), rps.getBcCsll(), EnumConstTipoArredondamento.get((Object)rps.getModoArredondamento()), this.getTipoCalcContSocial(rps));
            ContSocialCalculado ret = CompImpostoContSocial.calcularContSocial((ContSocialParams)params);
            rps.setAliquotaContSoc(ret.getAliquotaContSocial());
            rps.setValorContSoc(ret.getValorContSocial());
        }
    }

    private EnumConstTipoCalcContSocial getTipoCalcContSocial(Rps rps) {
        if (this.isEquals(rps.getModeloRps().getTipoContSoc(), (short)1)) {
            return EnumConstTipoCalcContSocial.CALCULAR_NORMAL;
        }
        if (this.isEquals(rps.getModeloRps().getTipoContSoc(), (short)0)) {
            return EnumConstTipoCalcContSocial.NAO_CALCULAR;
        }
        return EnumConstTipoCalcContSocial.HABILITAR;
    }

    private void setValorPisCofins(Rps rps) throws ExceptionImpostoPisCofins {
        PisCofinsParams params = new PisCofinsParams(EnumConstNFeIncidenciaCofins.valueOfCodigo((String)rps.getModeloRps().getIncidenciaPisCofins().getCodigo()), rps.getAliquotaPis(), rps.getAliquotaCofins(), EnumConstantsMentorEntSaida.ENTRADA, this.getCalcularPisCofinsNormal(rps.getModeloRps().getTipoPis()), this.getCalcularPisCofinsNormal(rps.getModeloRps().getTipoCofins()), this.getCalcularPisCofinsSt(rps.getModeloRps().getTipoPis()), this.getCalcularPisCofinsSt(rps.getModeloRps().getTipoCofins()), rps.getBcCofins(), Double.valueOf(rps.getValorDescontoCondicionado() + rps.getValorDescontoIncondicionado()), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), EnumConstantsMentorSimNao.NAO, EnumConstantsMentorSimNao.NAO, EnumConstantsMentorSimNao.NAO, EnumConstantsMentorSimNao.NAO, EnumConstantsMentorSimNao.NAO, EnumConstantsMentorSimNao.NAO, EnumConstantsMentorSimNao.NAO, EnumConstantsMentorSimNao.NAO, EnumConstantsMentorSimNao.NAO, EnumConstantsMentorSimNao.NAO, EnumConstantsMentorSimNao.NAO, EnumConstantsMentorSimNao.NAO, EnumConstantsMentorSimNao.NAO, EnumConstantsMentorSimNao.NAO, EnumConstantsMentorSimNao.NAO, EnumConstantsMentorSimNao.NAO, EnumConstantsMentorSimNao.NAO, rps.getAliquotaPis(), rps.getAliquotaCofins(), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), rps.getModeloRps().getValorMinimoPis(), rps.getModeloRps().getValorMinimoCofins());
        PisCofinsCalculado ret = CompImpostoPisCofins.calcularPisCofins((PisCofinsParams)params);
        rps.setAliquotaPis(Double.valueOf(ret.getAliquotaPis() + ret.getAliquotaPisST()));
        rps.setAliquotaCofins(Double.valueOf(ret.getAliquotaCofins() + ret.getAliquotaCofinsST()));
        rps.setValorPis(ret.getValorPis());
        rps.setValorPisST(ret.getValorPisST());
        rps.setValorCofinsST(ret.getValorCofinsST());
        rps.setValorCofins(ret.getValorCofins());
    }

    private void setValorInss(Rps rps) {
        InssParams param = new InssParams(rps.getAliquotaInss(), rps.getModeloRps().getPercRedInss(), rps.getValorInss(), Double.valueOf(0.0), rps.getModeloRps().getValorMinimoInss(), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(rps.getValorDescontoCondicionado() + rps.getValorDescontoIncondicionado()), rps.getBcInss(), EnumConstTipoArredondamento.get((Object)rps.getModoArredondamento()), this.getTipoCalcInss(rps));
        InssCalculado ret = CompImpostoInss.calcularInss((InssParams)param);
        rps.setAliquotaInss(ret.getAliquotaInss());
        rps.setBcInss(ret.getBaseCalculoInss());
        rps.setValorInss(Double.valueOf(ret.getValorInss() + ret.getValorInssNaoRetido()));
    }

    private EnumConstTipoCalcInss getTipoCalcInss(Rps rps) {
        if (this.isEquals(rps.getModeloRps().getTipoINSS(), (short)1)) {
            return EnumConstTipoCalcInss.CALCULAR_INSS_RETIDO;
        }
        if (this.isEquals(rps.getModeloRps().getTipoINSS(), (short)0)) {
            return EnumConstTipoCalcInss.NAO_CALCULAR;
        }
        if (this.isEquals(rps.getModeloRps().getTipoINSS(), (short)3)) {
            return EnumConstTipoCalcInss.CALCULAR_INSS_NAO_RETIDO;
        }
        return EnumConstTipoCalcInss.CALCULAR_INSS_HABILITAR;
    }

    private void setValorIRRF(Rps rps) {
        IrParams params = new IrParams(rps.getAliquotaIr(), Double.valueOf(0.0), rps.getValorIr(), rps.getModeloRps().getValorMinimoIR(), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(rps.getValorDescontoCondicionado() + rps.getValorDescontoIncondicionado()), rps.getBcIr(), EnumConstTipoArredondamento.get((Object)rps.getModoArredondamento()), this.getTipoCalcIrrf(rps));
        IrCalculado ret = CompImpostoIr.calcularIr((IrParams)params);
        rps.setAliquotaIr(ret.getAliquotaIr());
        rps.setValorIr(ret.getValorIr());
    }

    private EnumConstTipoCalcIr getTipoCalcIrrf(Rps rps) {
        if (this.isEquals(rps.getModeloRps().getTipoIRRF(), (short)1)) {
            return EnumConstTipoCalcIr.CALCULAR_NORMAL;
        }
        if (this.isEquals(rps.getModeloRps().getTipoIRRF(), (short)0)) {
            return EnumConstTipoCalcIr.NAO_CALCULAR;
        }
        return EnumConstTipoCalcIr.HABILITAR;
    }

    private void setValorIss(Rps rps) {
        IssParams params = new IssParams(rps.getAliquotaIss(), rps.getModeloRps().getPercRedIss(), rps.getValorIss(), rps.getModeloRps().getValorMinimoISS(), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(rps.getValorDescontoCondicionado() + rps.getValorDescontoIncondicionado()), rps.getBcIss(), EnumConstTipoArredondamento.get((Object)rps.getModoArredondamento()), this.getTipoCalcIss(rps));
        IssCalculado ret = CompImpostoIss.calcularIss((IssParams)params);
        rps.setAliquotaIss(ret.getAliquotaIss());
        rps.setBcIss(ret.getBaseCalculoIss());
        if (TMethods.isNotNull((Object)ret.getValorDeducoes()).booleanValue()) {
            rps.setValorDeducoes(ret.getValorDeducoes());
        }
        if (TMethods.isEquals((Object)rps.getTipoIss(), (Object)EnumConstTipoCalcIss.CALCULAR_RETIDO.getShortValue())) {
            rps.setValorIssRetido(ret.getValorIss());
            rps.setValorIss(Double.valueOf(0.0));
        } else {
            rps.setValorIss(ret.getValorIss());
            rps.setValorIssRetido(Double.valueOf(0.0));
        }
    }

    private EnumConstTipoCalcIss getTipoCalcIss(Rps rps) {
        if (this.isEquals(rps.getModeloRps().getTipoIss(), EnumConstTipoISSModeloRPS.TIPO_ISS_RETIDO.getValue())) {
            return EnumConstTipoCalcIss.CALCULAR_RETIDO;
        }
        if (this.isEquals(rps.getModeloRps().getTipoIss(), EnumConstTipoISSModeloRPS.TIPO_ISS_NORMAL.getValue())) {
            return EnumConstTipoCalcIss.CALCULAR_NORMAL;
        }
        if (this.isEquals(rps.getModeloRps().getTipoIss(), EnumConstTipoISSModeloRPS.TIPO_ISS_NAO_CALCULAR.getValue())) {
            return EnumConstTipoCalcIss.NAO_CALCULAR;
        }
        return EnumConstTipoCalcIss.EXIBIR_ALIQ_NAO_CALC;
    }

    private void setValorOutros(Rps rps) {
        OutrosParams params = new OutrosParams(rps.getAliquotaOutros(), Double.valueOf(0.0), rps.getValorOutros(), rps.getModeloRps().getValorMinimoOutros(), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(rps.getValorDescontoCondicionado() + rps.getValorDescontoIncondicionado()), rps.getBcOutros(), EnumConstTipoArredondamento.get((Object)rps.getModoArredondamento()), this.getTipoCalcOutros(rps));
        OutrosCalculado ret = CompImpostoOutros.calcularOutros((OutrosParams)params);
        rps.setAliquotaOutros(ret.getAliquotaOutros());
        rps.setValorOutros(ret.getValorOutros());
    }

    private EnumConstTipoCalcOutros getTipoCalcOutros(Rps rps) {
        if (this.isEquals(rps.getModeloRps().getTipoIss(), EnumConstTipoOutrosModeloRPS.TIPO_OUTROS_CALCULAR.getValue())) {
            return EnumConstTipoCalcOutros.CALCULAR_NORMAL;
        }
        if (this.isEquals(rps.getModeloRps().getTipoIss(), EnumConstTipoOutrosModeloRPS.TIPO_OUTROS_NAO_CALCULAR.getValue())) {
            return EnumConstTipoCalcOutros.NAO_CALCULAR;
        }
        return EnumConstTipoCalcOutros.HABILITAR;
    }

    private static void setOBSTributos(Rps rps) {
        Double valorTotal = rps.getValorServico();
        GrupoServicoRPS grupoServRPS = rps.getServicoRPS().getGrupoServicoRPS();
        DecimalFormat df = new DecimalFormat("#,###0.00");
        Double valorPagoFederal = valorTotal / 100.0 * grupoServRPS.getTaxaFederal();
        Double valorPagoMunicipal = valorTotal / 100.0 * grupoServRPS.getTaxaMunicipal();
        String msg = "Tributacao aproximada R$: " + df.format(valorPagoFederal) + " Federal (" + grupoServRPS.getTaxaFederal() + " %) e " + df.format(valorPagoMunicipal) + " Municipal (" + grupoServRPS.getTaxaMunicipal() + " %) - Fonte: IBPT";
        rps.setDescricaoTributosRps(msg);
        rps.setDescricaoTributosRps(msg);
        rps.setValorTributacaoFederal(valorPagoFederal);
        rps.setValorTributacaoMunicipal(valorPagoMunicipal);
        rps.setTaxaTributacaoFederal(grupoServRPS.getTaxaFederal());
        rps.setTaxaTributacaoMunicipal(grupoServRPS.getTaxaMunicipal());
        rps.setCodigoTributacaoServ(grupoServRPS.getCodigoTributos());
    }

    private EnumConstTipoCalcPisCofins getCalcularPisCofinsNormal(Short tipoPis) {
        if (TMethods.isEquals((Object)tipoPis, (Object)EnumConstTipoCalcPisCofins.NAO_CALCULAR.getShortValue())) {
            return EnumConstTipoCalcPisCofins.CALCULAR;
        }
        return EnumConstTipoCalcPisCofins.NAO_CALCULAR;
    }

    private EnumConstTipoCalcPisCofins getCalcularPisCofinsSt(Short tipoPis) {
        if (TMethods.isEquals((Object)tipoPis, (Object)EnumConstTipoCalcPisCofins.CALCULAR.getShortValue())) {
            return EnumConstTipoCalcPisCofins.CALCULAR;
        }
        return EnumConstTipoCalcPisCofins.NAO_CALCULAR;
    }
}

