/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.calculovalores.venda;

import com.touchcomp.basementor.constants.enums.modelodocfiscal.EnumConstModDocFiscal;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeIndicadorPresConsumidor;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ModeloFiscal;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.ParamTribCbsIbsClass;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementor.model.vo.TabelaPrecoPromocoesProd;
import com.touchcomp.basementor.model.vo.TabelaPrecoPromocoesProdQtd;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.impl.impostoicms.ExceptionImpostoIcms;
import com.touchcomp.basementorexceptions.exceptions.impl.impostoipi.ExceptionImpostoIPI;
import com.touchcomp.basementorexceptions.exceptions.impl.impostopiscofins.ExceptionImpostoPisCofins;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorservice.components.calculovalores.venda.CompCalcVlrImpostosVenda;
import com.touchcomp.basementorservice.components.calculovalores.venda.model.BaseGradeItemVenda;
import com.touchcomp.basementorservice.components.calculovalores.venda.model.BaseItemVenda;
import com.touchcomp.basementorservice.components.calculovalores.venda.model.BaseVenda;
import com.touchcomp.basementorservice.helpers.impl.condicoespagamento.HelperCondicoesPagamento;
import com.touchcomp.basementorservice.helpers.impl.modelofiscal.HelperModeloFiscal;
import com.touchcomp.basementorservice.helpers.impl.unidadefatcliente.HelperUnidadeFatCliente;
import com.touchcomp.basementorservice.service.impl.paramtribcbsibs.ServiceParamTribCbsIbsImpl;
import com.touchcomp.basementorservice.service.impl.tabelaprecopromocoes.ServiceTabelaPrecoPromocoesImpl;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompCalcValoresVenda {
    @Autowired
    private HelperCondicoesPagamento helperCondicoesPagamento;
    @Autowired
    private HelperModeloFiscal helperModeloFiscal;
    @Autowired
    private HelperUnidadeFatCliente helperUnidadeFatCliente;
    @Autowired
    private ServiceTabelaPrecoPromocoesImpl serviceTabelaPrecoPromocao;
    @Autowired
    private CompCalcVlrImpostosVenda compCalcVlrImpostos;

    public void reprocessarVenda(BaseVenda ped, OpcoesFaturamento opcoes, OpcoesContabeis opcoesContabeis) throws ExceptionBase, ExceptionImpostoPisCofins, ExceptionImpostoIPI, ExceptionImpostoIcms {
        this.setModeloFiscal(ped.itensVenda(), ped.empresa(), ped.unidadeFatCliente(), ped.naturezaOperacao(), false);
        this.calcularValoresPedido(ped, opcoes, opcoesContabeis);
    }

    public void setModeloFiscal(List<BaseItemVenda> itemPedido, Empresa empresa, UnidadeFatCliente unidadeFatCliente, NaturezaOperacao naturezaOp, boolean throwExNotFound) throws ExceptionBase {
        for (BaseItemVenda itemP : itemPedido) {
            try {
                itemP.setModeloFiscal(this.findModeloFiscal(itemP, empresa, unidadeFatCliente, naturezaOp));
                itemP.setParamTribCbsIbsClass(this.getParamTribCbsIbs(itemP, empresa, unidadeFatCliente, naturezaOp));
            }
            catch (ExceptionBase ex) {
                if (!throwExNotFound) continue;
                throw ex;
            }
        }
    }

    private ModeloFiscal findModeloFiscal(BaseItemVenda itemP, Empresa empresa, UnidadeFatCliente unidadeFatCliente, NaturezaOperacao naturezaOp) throws ExceptionObjNotFound {
        return this.helperModeloFiscal.getFirst(itemP.produto(), unidadeFatCliente, naturezaOp, empresa);
    }

    public void calcularValoresPedido(BaseVenda ped, OpcoesFaturamento opcoes, OpcoesContabeis opcoesContabeis) throws ExceptionImpostoPisCofins, ExceptionImpostoIPI, ExceptionImpostoIcms {
        int ret = this.helperCondicoesPagamento.calcularNrDiasMedios(ped.condicoesPagamento(), ped.condPagMut());
        ped.setDiasMediosCondPag((short)ret);
        this.ratearValoresAcessorios(ped.itensVenda(), ped.valorDescontoInf(), ped.percDescontoInf(), ped.tipoDesconto(), ped.valorDespAcessoriaInf(), ped.percDespAcessoriaInf(), ped.tipoDespAcessInf(), ped.valorFreteInf(), ped.percFreteInf(), ped.tipoFreteInf(), ped.valorSeguroInf(), ped.percSeguroInf(), ped.tipoSeguroInf(), opcoes);
        this.calculoValoresPedido(ped.itensVenda(), ped.representante(), ped.naturezaOperacao(), ped.empresa(), ped.dataEmissao(), ped.unidadeFatCliente(), opcoes);
        if (opcoes.getCalcularImpPrevPedido() != null && opcoes.getCalcularImpPrevPedido() == 1) {
            this.compCalcVlrImpostos.calcular(ped, opcoesContabeis, opcoes);
        }
        this.calcularTotalizadores(ped);
    }

    public void calculoValoresPedido(List<BaseItemVenda> itens, Representante rep, NaturezaOperacao nat, Empresa emp, Date dataEmissao, UnidadeFatCliente unid, OpcoesFaturamento opcoesFaturamento) {
        for (BaseItemVenda it : itens) {
            this.putQuantidadeTotal(it);
            this.putValorDescontoPromocional(it, emp, dataEmissao);
            this.calcularTotalizadoresAcessoriosItem(it);
            this.putValorDescTrib(it);
            this.putValorTotalBruto(it);
            this.putBancoCredito(it);
            this.putValorTotal(it);
            this.putPeso(it);
        }
    }

    public void calcularTotalizadoresAcessoriosItem(BaseItemVenda item) {
        this.calcularTotalDesconto(item);
        this.calcularTotalFrete(item);
        this.calcularTotalSeguro(item);
        this.calcularTotalDespAcessoria(item);
    }

    private void calcularTotalDesconto(BaseItemVenda item) {
        Double valorTotalBruto = this.getValorTotalBruto(item);
        Double valorTotalDesconto = ToolFormatter.arrredondarNumero((Double)(item.valorDescontoItemInf() + item.valorDescontoRateado()), (int)2);
        if (item.valorDescontoPromocional() != null) {
            valorTotalDesconto = valorTotalDesconto + item.valorDescontoPromocional();
        }
        Double percDesconto = 0.0;
        if (valorTotalDesconto > 0.0 && valorTotalBruto > 0.0) {
            percDesconto = ToolFormatter.arrredondarNumero((Double)(valorTotalDesconto * 100.0 / valorTotalBruto), (int)4);
        }
        item.setValorDesconto(valorTotalDesconto);
        item.setPercDesconto(percDesconto);
    }

    private void calcularTotalFrete(BaseItemVenda item) {
        Double valorTotalBruto = this.getValorTotalBruto(item);
        Double valorTotalFrete = ToolFormatter.arrredondarNumero((Double)(item.valorFreteItemInf() + item.valorFreteRateado()), (int)2);
        Double percFrete = 0.0;
        if (valorTotalFrete > 0.0 && valorTotalBruto > 0.0) {
            percFrete = ToolFormatter.arrredondarNumero((Double)(valorTotalFrete * 100.0 / valorTotalBruto), (int)4);
        }
        item.setValorFrete(valorTotalFrete);
        item.setPercFrete(percFrete);
    }

    private void calcularTotalDespAcessoria(BaseItemVenda item) {
        Double valorTotalBruto = this.getValorTotalBruto(item);
        Double valorTotalDesp = ToolFormatter.arrredondarNumero((Double)(item.valorDespAcessItemInf() + item.valorDespAcessRateado()), (int)2);
        Double percDesp = 0.0;
        if (valorTotalDesp > 0.0 && valorTotalBruto > 0.0) {
            percDesp = ToolFormatter.arrredondarNumero((Double)(valorTotalDesp * 100.0 / valorTotalBruto), (int)4);
        }
        item.setValorDespesaAcessoria(valorTotalDesp);
        item.setPercDespesaAcessoria(percDesp);
    }

    private void calcularTotalSeguro(BaseItemVenda item) {
        Double valorTotalBruto = this.getValorTotalBruto(item);
        Double valorTotalSeguro = ToolFormatter.arrredondarNumero((Double)(item.valorSeguroItemInf() + item.valorSeguroRateado()), (int)2);
        Double percSeguro = 0.0;
        if (valorTotalSeguro > 0.0 && valorTotalBruto > 0.0) {
            percSeguro = ToolFormatter.arrredondarNumero((Double)(valorTotalSeguro * 100.0 / valorTotalBruto), (int)4);
        }
        item.setValorSeguro(valorTotalSeguro);
        item.setPercSeguro(percSeguro);
    }

    private void putValorDescontoPromocional(BaseItemVenda item, Empresa empresa, Date dataEmissao) {
        TabelaPrecoPromocoesProd promocaoItem = this.serviceTabelaPrecoPromocao.getTabelaPrecosPromo(item.produto(), dataEmissao, empresa);
        item.setTabPrecoPromocoesProd(promocaoItem);
        if (TMethods.isNotNull((Object)promocaoItem).booleanValue() && item.valorUnitario() * item.quantidadeTotal() > promocaoItem.getValorVenda() * item.quantidadeTotal()) {
            item.setValorDescontoPromocional(ToolFormatter.arrredondarNumero((Double)((item.valorUnitario() - promocaoItem.getValorVenda()) * item.quantidadeTotal()), (int)2));
            item.setPercDescontoPromocional(ToolFormatter.arrredondarNumero((Double)(item.valorDescontoPromocional() * (100.0 / (item.valorUnitario() * item.quantidadeTotal()))), (int)4));
            item.setValorReferenciaDescontoPromocional(item.valorUnitario() - promocaoItem.getValorVenda());
            if (TMethods.isWithData((Collection)promocaoItem.getTabelaPrecoPromocoesProdQtd())) {
                for (TabelaPrecoPromocoesProdQtd tabQtde : promocaoItem.getTabelaPrecoPromocoesProdQtd()) {
                    if (!(item.quantidadeTotal() >= tabQtde.getQuantidadeInicial()) || !(item.quantidadeTotal() <= tabQtde.getQuantidadeFinal())) continue;
                    item.setValorDescontoPromocional(ToolFormatter.arrredondarNumero((Double)((item.valorUnitario() - tabQtde.getValor()) * item.quantidadeTotal()), (int)2));
                    item.setPercDescontoPromocional(ToolFormatter.arrredondarNumero((Double)(item.valorDescontoPromocional() * (100.0 / (item.valorUnitario() * item.quantidadeTotal()))), (int)4));
                    return;
                }
            }
        }
    }

    private void putValorDescTrib(BaseItemVenda it) {
        if (it.valorUnitario() != null && it.percDescTrib() != null) {
            it.setValorUnitarioDescTrib(it.valorUnitario() - it.valorUnitario() * (it.percDescTrib() / 100.0));
        }
    }

    private void putQuantidadeTotal(BaseItemVenda it) {
        double qtd = 0.0;
        for (BaseGradeItemVenda g : it.grades()) {
            qtd += g.quantidade().doubleValue();
        }
        it.setQuantidadeTotal(qtd);
    }

    private void putValorTotalBruto(BaseItemVenda item) {
        item.setValorTotalBruto(item.valorUnitario() * item.quantidadeTotal());
        item.setValorTotalBrutoDescTrib(item.valorUnitarioDescTrib() * item.quantidadeTotal());
    }

    private void putBancoCredito(BaseItemVenda it) {
        double valorBC = it.valorTotalBruto();
        it.setValorBancoCredito(valorBC -= it.quantidadeTotal() * it.valorMinimo());
    }

    private void putValorTotal(BaseItemVenda item) {
        Double valorTotal = item.valorTotalBruto() - item.valorDesconto() + item.valorFrete() + item.valorSeguro() + item.valorDespesaAcessoria();
        item.setValorTotal(valorTotal);
        Double valorTotalDescTrib = item.valorTotalBrutoDescTrib() - item.valorDesconto() + item.valorFrete() + item.valorSeguro() + item.valorDespesaAcessoria();
        item.setValorTotalDescTrib(valorTotalDescTrib);
        item.setValorTotalComImpostos(valorTotalDescTrib);
    }

    private Double getValorTotalBruto(BaseItemVenda item) {
        return ToolFormatter.arrredondarNumero((Double)(item.valorUnitario() * item.quantidadeTotal()), (int)2);
    }

    private void putPeso(BaseItemVenda it) {
    }

    public void ratearValoresAcessorios(List<BaseItemVenda> itens, double valorDesc, double percDesc, short tipoDesc, double valorDesp, double percDesp, short tipoDesp, double valorFrete, double percFrete, short tipoFrete, double valorSeg, double percSeg, short tipoSeg, OpcoesFaturamento op) {
        this.ratearDesconto(itens, valorDesc, percDesc, tipoDesc, op);
        CompCalcValoresVenda.ratearDespAcess(itens, valorDesp, percDesp, tipoDesp, op);
        CompCalcValoresVenda.ratearFrete(itens, valorFrete, percFrete, tipoFrete, op);
        CompCalcValoresVenda.ratearSeguro(itens, valorSeg, percSeg, tipoSeg, op);
    }

    private void ratearDesconto(List<BaseItemVenda> itens, double valorDesc, double percDesc, short tipoDesc, OpcoesFaturamento op) {
        double valorTotal = 0.0;
        if (tipoDesc == 0) {
            valorDesc = 0.0;
        }
        for (BaseItemVenda it : itens) {
            if (it.descontoItem() == 1) continue;
            valorTotal += it.quantidadeTotal() * it.valorUnitario();
        }
        if (valorTotal <= 0.0 && valorDesc > 0.0) {
            return;
        }
        BaseItemVenda lastItem = null;
        double valorDescTotal = 0.0;
        for (BaseItemVenda item : itens) {
            double vlrProduto = item.valorUnitario() * item.quantidadeTotal();
            double valorDescCalc = 0.0;
            double percDescCalc = 0.0;
            if (item.descontoItem() != 1) {
                if (tipoDesc == 0) {
                    valorDescCalc = ToolFormatter.arrredondarNumero((Double)(percDesc / 100.0 * vlrProduto), (int)2);
                    percDescCalc = percDesc;
                } else {
                    percDescCalc = valorDesc > 0.0 && valorTotal > 0.0 ? ToolFormatter.arrredondarNumero((Double)(valorDesc / valorTotal * 100.0), (int)4) : 0.0;
                    valorDescCalc = ToolFormatter.arrredondarNumero((Double)(vlrProduto * percDescCalc / 100.0), (int)2);
                }
                valorDescTotal += valorDescCalc;
                lastItem = item;
                item.setPercDesconto(percDescCalc);
                item.setValorDesconto(valorDescCalc);
                continue;
            }
            if (item.tipoDesconto() == 0) {
                if (!(item.percDesconto() > 0.0)) continue;
                item.setValorDesconto(ToolFormatter.arrredondarNumero((Double)(item.percDesconto() / 100.0 * vlrProduto), (int)2));
                continue;
            }
            item.setValorDesconto(ToolFormatter.arrredondarNumero((Double)item.valorDesconto(), (int)2));
            if (!(item.valorDesconto() > 0.0) || !(vlrProduto > 0.0)) continue;
            item.setPercDesconto(ToolFormatter.arrredondarNumero((Double)(item.valorDesconto() * 100.0 / vlrProduto), (int)4));
        }
        if (lastItem != null && valorDesc > 0.0) {
            Double vrDesconto = lastItem.valorDesconto() + (valorDesc - valorDescTotal);
            lastItem.setValorDesconto(vrDesconto);
            if (lastItem.valorDesconto() < 0.0) {
                lastItem.setValorDesconto(0.0);
                lastItem.setPercDesconto(0.0);
                vrDesconto = Math.abs(vrDesconto);
                for (BaseItemVenda item : itens) {
                    if (item.valorDesconto() >= vrDesconto) {
                        item.setValorDesconto(item.valorDesconto() - vrDesconto);
                        break;
                    }
                    item.setValorDesconto(0.0);
                    vrDesconto = vrDesconto - item.valorDesconto();
                }
            }
        }
    }

    private static void ratearFrete(List<BaseItemVenda> itens, double valorFrete, double percFrete, short tipoFrete, OpcoesFaturamento op) {
        double valorTotal = 0.0;
        if (tipoFrete == 0) {
            valorFrete = 0.0;
        }
        for (BaseItemVenda it : itens) {
            if (it.freteItem() == 1) continue;
            valorTotal += it.quantidadeTotal() * it.valorUnitario();
        }
        BaseItemVenda lastItem = null;
        double valorFreteTotal = 0.0;
        for (BaseItemVenda item : itens) {
            double vlrProduto = item.valorUnitario() * item.quantidadeTotal();
            double valorFreteCalc = 0.0;
            double percFreteCalc = 0.0;
            if (item.freteItem() != 1) {
                if (tipoFrete == 0) {
                    valorFreteCalc = ToolFormatter.arrredondarNumero((Double)(percFrete / 100.0 * vlrProduto), (int)2);
                    percFreteCalc = percFrete;
                } else {
                    percFreteCalc = valorFrete > 0.0 && valorTotal > 0.0 ? ToolFormatter.arrredondarNumero((Double)(valorFrete / valorTotal * 100.0), (int)4) : 0.0;
                    valorFreteCalc = ToolFormatter.arrredondarNumero((Double)(vlrProduto * percFreteCalc / 100.0), (int)2);
                }
                valorFreteTotal += valorFreteCalc;
                lastItem = item;
                item.setPercFrete(percFreteCalc);
                item.setValorFrete(valorFreteCalc);
                continue;
            }
            if (item.tipoFrete() == 0) {
                if (!(item.percFrete() > 0.0)) continue;
                item.setValorFrete(ToolFormatter.arrredondarNumero((Double)(item.percFrete() / 100.0 * vlrProduto), (int)2));
                continue;
            }
            item.setValorFrete(ToolFormatter.arrredondarNumero((Double)item.valorFrete(), (int)2));
            if (!(item.valorFrete() > 0.0) || !(vlrProduto > 0.0)) continue;
            item.setPercFrete(ToolFormatter.arrredondarNumero((Double)(item.valorFrete() * 100.0 / vlrProduto), (int)4));
        }
        if (lastItem != null && valorFrete > 0.0) {
            Double vrFrete = lastItem.valorFrete() + (valorFrete - valorFreteTotal);
            lastItem.setValorFrete(vrFrete);
            if (lastItem.valorFrete() < 0.0) {
                lastItem.setValorFrete(0.0);
                lastItem.setPercFrete(0.0);
                vrFrete = Math.abs(vrFrete);
                for (BaseItemVenda item : itens) {
                    if (item.valorFrete() >= vrFrete) {
                        item.setValorFrete(item.valorFrete() - vrFrete);
                        break;
                    }
                    item.setValorFrete(0.0);
                    vrFrete = vrFrete - item.valorFrete();
                }
            }
        }
    }

    private static void ratearDespAcess(List<BaseItemVenda> itens, double valorDesp, double percDesp, short tipoDesp, OpcoesFaturamento op) {
        double valorTotal = 0.0;
        if (tipoDesp == 0) {
            valorDesp = 0.0;
        }
        for (BaseItemVenda it : itens) {
            if (it.despAcessItem() == 1) continue;
            valorTotal += it.quantidadeTotal() * it.valorUnitario();
        }
        BaseItemVenda lastItem = null;
        double valorDespTotal = 0.0;
        for (BaseItemVenda item : itens) {
            double vlrProduto = item.valorUnitario() * item.quantidadeTotal();
            double valorDespCalc = 0.0;
            double percDespCalc = 0.0;
            if (item.despAcessItem() != 1) {
                if (tipoDesp == 0) {
                    valorDespCalc = ToolFormatter.arrredondarNumero((Double)(percDesp / 100.0 * vlrProduto), (int)2);
                    percDespCalc = percDesp;
                } else {
                    percDespCalc = valorDesp > 0.0 && valorTotal > 0.0 ? ToolFormatter.arrredondarNumero((Double)(valorDesp / valorTotal * 100.0), (int)4) : 0.0;
                    valorDespCalc = ToolFormatter.arrredondarNumero((Double)(vlrProduto * percDespCalc / 100.0), (int)2);
                }
                valorDespTotal += valorDespCalc;
                lastItem = item;
                item.setPercDespesaAcessoria(percDespCalc);
                item.setValorDespesaAcessoria(valorDespCalc);
                continue;
            }
            if (item.tipoDespAcessoria() == 0) {
                if (!(item.percDespesaAcessoria() > 0.0)) continue;
                item.setValorDespesaAcessoria(ToolFormatter.arrredondarNumero((Double)(item.percDespesaAcessoria() / 100.0 * vlrProduto), (int)2));
                continue;
            }
            item.setValorDespesaAcessoria(ToolFormatter.arrredondarNumero((Double)item.valorDespesaAcessoria(), (int)2));
            if (!(item.valorDespesaAcessoria() > 0.0) || !(vlrProduto > 0.0)) continue;
            item.setPercDespesaAcessoria(ToolFormatter.arrredondarNumero((Double)(item.valorDespesaAcessoria() * 100.0 / vlrProduto), (int)4));
        }
        if (lastItem != null && valorDesp > 0.0) {
            Double vrDesp = lastItem.valorDespesaAcessoria() + (valorDesp - valorDespTotal);
            lastItem.setValorDespesaAcessoria(vrDesp);
            if (lastItem.valorDespesaAcessoria() < 0.0) {
                lastItem.setValorDespesaAcessoria(0.0);
                lastItem.setPercDespesaAcessoria(0.0);
                vrDesp = Math.abs(vrDesp);
                for (BaseItemVenda item : itens) {
                    if (item.valorDespesaAcessoria() >= vrDesp) {
                        item.setValorDespesaAcessoria(item.valorDespesaAcessoria() - vrDesp);
                        break;
                    }
                    item.setValorDespesaAcessoria(0.0);
                    vrDesp = vrDesp - item.valorDespesaAcessoria();
                }
            }
        }
    }

    private static void ratearSeguro(List<BaseItemVenda> itens, double valorSeguro, double percSeguro, short tipoSeguro, OpcoesFaturamento op) {
        double valorTotal = 0.0;
        if (tipoSeguro == 0) {
            valorSeguro = 0.0;
        }
        for (BaseItemVenda it : itens) {
            valorTotal += it.quantidadeTotal() * it.valorUnitario();
        }
        BaseItemVenda lastItem = null;
        double valorSeguroTotal = 0.0;
        for (BaseItemVenda item : itens) {
            double vlrProduto = item.valorUnitario() * item.quantidadeTotal();
            double valorSeguroCalc = 0.0;
            double percSeguroCalc = 0.0;
            if (item.seguroItem() != 1) {
                if (tipoSeguro == 0) {
                    valorSeguroCalc = ToolFormatter.arrredondarNumero((Double)(percSeguro / 100.0 * vlrProduto), (int)2);
                    percSeguroCalc = percSeguro;
                } else {
                    percSeguroCalc = valorSeguro > 0.0 && valorTotal > 0.0 ? ToolFormatter.arrredondarNumero((Double)(valorSeguro / valorTotal * 100.0), (int)4) : 0.0;
                    valorSeguroCalc = ToolFormatter.arrredondarNumero((Double)(vlrProduto * percSeguroCalc / 100.0), (int)2);
                }
                valorSeguroTotal += valorSeguroCalc;
                lastItem = item;
                item.setPercSeguro(percSeguroCalc);
                item.setValorSeguro(valorSeguroCalc);
                continue;
            }
            if (item.tipoSeguro() == 0) {
                if (!(item.percSeguro() > 0.0)) continue;
                item.setValorSeguro(ToolFormatter.arrredondarNumero((Double)(item.percSeguro() / 100.0 * vlrProduto), (int)2));
                continue;
            }
            item.setValorSeguro(ToolFormatter.arrredondarNumero((Double)item.valorSeguro(), (int)2));
            if (!(item.valorSeguro() > 0.0) || !(vlrProduto > 0.0)) continue;
            item.setPercSeguro(ToolFormatter.arrredondarNumero((Double)(item.valorSeguro() * 100.0 / vlrProduto), (int)4));
        }
        if (lastItem != null && valorSeguro > 0.0) {
            Double vrSeguro = lastItem.valorSeguro() + (valorSeguro - valorSeguroTotal);
            lastItem.setValorSeguro(vrSeguro);
            if (lastItem.valorSeguro() < 0.0) {
                lastItem.setValorSeguro(0.0);
                lastItem.setPercSeguro(0.0);
                vrSeguro = Math.abs(vrSeguro);
                for (BaseItemVenda item : itens) {
                    if (item.valorSeguro() >= vrSeguro) {
                        item.setValorSeguro(item.valorSeguro() - vrSeguro);
                        break;
                    }
                    item.setValorSeguro(0.0);
                    vrSeguro = vrSeguro - item.valorSeguro();
                }
            }
        }
    }

    public void calcularTotalizadores(BaseVenda ped) {
        List<BaseItemVenda> its = ped.itensVenda();
        Double valorTotalBruto = 0.0;
        Double valorTotal = 0.0;
        Double valorTotalBrutoDescTrib = 0.0;
        Double valorTotalDescTrib = 0.0;
        Double valorTotalComImpostos = 0.0;
        Double valorDesconto = 0.0;
        Double valorDescontoInf = 0.0;
        Double valorBrutoDescontoInf = 0.0;
        Double valorDesp = 0.0;
        Double valorDespInf = 0.0;
        Double valorBrutoDespInf = 0.0;
        Double valorSeguro = 0.0;
        Double valorSeguroInf = 0.0;
        Double valorBrutoSeguroInf = 0.0;
        Double valorFrete = 0.0;
        Double valorFreteInf = 0.0;
        Double valorBrutoFreteInf = 0.0;
        Double pesoTotal = 0.0;
        Double volumeTotal = 0.0;
        Double valorComissaoTotal = 0.0;
        Double qtdeTotal = 0.0;
        Double vlrTotalCusto = 0.0;
        Integer nrItens = 0;
        for (BaseItemVenda it : its) {
            valorTotalBruto = valorTotalBruto + it.valorTotalBruto();
            valorTotal = valorTotal + it.valorTotal();
            valorTotalBrutoDescTrib = valorTotalBrutoDescTrib + it.valorTotalBrutoDescTrib();
            valorTotalDescTrib = valorTotalDescTrib + it.valorTotalDescTrib();
            valorTotalComImpostos = valorTotalComImpostos + it.valorTotalComImpostos();
            valorDesconto = valorDesconto + it.valorDesconto();
            valorDesp = valorDesp + it.valorDespesaAcessoria();
            valorSeguro = valorSeguro + it.valorSeguro();
            valorFrete = valorFrete + it.valorFrete();
            valorComissaoTotal = valorComissaoTotal + it.percComissao() / 100.0 * it.valorTotal();
            if (it.descontoItem() == null || it.descontoItem() == 0) {
                valorDescontoInf = valorDescontoInf + it.valorDesconto();
                valorBrutoDescontoInf = valorBrutoDescontoInf + it.valorTotalBruto();
            }
            if (it.freteItem() == null || it.freteItem() == 0) {
                valorFreteInf = valorFreteInf + it.valorFrete();
                valorBrutoFreteInf = valorBrutoFreteInf + it.valorTotalBruto();
            }
            if (it.seguroItem() == null || it.seguroItem() == 0) {
                valorSeguroInf = valorSeguroInf + it.valorSeguro();
                valorBrutoSeguroInf = valorBrutoSeguroInf + it.valorTotalBruto();
            }
            if (it.despAcessItem() == null || it.despAcessItem() == 0) {
                valorDespInf = valorDespInf + it.valorDespesaAcessoria();
                valorBrutoDespInf = valorBrutoDespInf + it.valorTotalBruto();
            }
            if (it.produto() != null && it.tipoCondicao() != null && it.tipoCondicao() == 0) {
                pesoTotal = pesoTotal + (it.produto().getPesoUnitario() + it.produto().getPesoEmbalagem()) * it.quantidadeTotal();
            }
            if (it.produto() != null && it.tipoCondicao() != null && it.tipoCondicao() == 0 && it.produto().getVolume() != null) {
                volumeTotal = volumeTotal + it.produto().getVolume() * it.quantidadeTotal();
            }
            Integer n = nrItens;
            nrItens = nrItens + 1;
            if (it.valorCusto() == null) {
                it.setValorCusto(0.0);
            }
            vlrTotalCusto = vlrTotalCusto + it.quantidadeTotal() * it.valorCusto();
            qtdeTotal = qtdeTotal + it.quantidadeTotal();
        }
        ped.setQtdeTotalItens(qtdeTotal);
        ped.setVlrTotalCusto(vlrTotalCusto);
        ped.setNrTotalItens(nrItens);
        ped.setValorTotalBruto(valorTotalBruto);
        ped.setValorTotal(valorTotal);
        ped.setValorTotalBrutoDescTrib(valorTotalBrutoDescTrib);
        ped.setValorTotalDescTrib(valorTotalDescTrib);
        ped.setValorTotalComImpostos(valorTotalComImpostos);
        ped.setPesoTotal(pesoTotal);
        ped.setVolumeTotal(volumeTotal);
        ped.setTotalComissao(valorComissaoTotal);
        ped.setPercComissao(valorComissaoTotal / (valorTotal > 0.0 ? valorTotal : 1.0) * 100.0);
        this.getTotalizadorDesconto(ped, valorDesconto, valorDescontoInf, valorTotalBruto, valorBrutoDescontoInf);
        this.getTotalizadorFrete(ped, valorFrete, valorFreteInf, valorTotalBruto, valorBrutoFreteInf);
        this.getTotalizadorSeguro(ped, valorSeguro, valorSeguroInf, valorTotalBruto, valorBrutoSeguroInf);
        this.getTotalizadorDespAcessoria(ped, valorDesp, valorDespInf, valorTotalBruto, valorBrutoDespInf);
    }

    private void getTotalizadorDesconto(BaseVenda ped, Double valorDesconto, Double valorDescontoInf, Double valorTotalBruto, Double valorTotalBrutoInf) {
        if (ped.tipoDespAcessInf() == 0) {
            ped.setValorDescontoInf(valorDescontoInf);
        } else if (valorDescontoInf > 0.0 && valorTotalBrutoInf > 0.0) {
            ped.setPercDescontoInf(valorDescontoInf / valorTotalBrutoInf * 100.0);
        }
        ped.setValorDesconto(valorDesconto);
        if (valorTotalBruto > 0.0) {
            ped.setPercDesconto(valorDesconto / valorTotalBruto * 100.0);
        } else {
            ped.setPercDesconto(0.0);
        }
    }

    private void getTotalizadorFrete(BaseVenda ped, Double valorFrete, Double valorFreteInf, Double valorTotalBruto, Double valorTotalBrutoInf) {
        if (ped.tipoFreteInf() == 0) {
            ped.setValorFreteInf(valorFreteInf);
        } else if (valorFreteInf > 0.0 && valorTotalBrutoInf > 0.0) {
            ped.setPercFreteInf(valorFreteInf / valorTotalBrutoInf * 100.0);
        }
        ped.setValorFrete(valorFrete);
        if (valorTotalBruto > 0.0) {
            ped.setPercFrete(valorFrete / valorTotalBruto * 100.0);
        } else {
            ped.setPercFrete(0.0);
        }
    }

    private void getTotalizadorSeguro(BaseVenda ped, Double valorSeguro, Double valorSeguroInf, Double valorTotalBruto, Double valorTotalBrutoInf) {
        if (ped.tipoSeguroInf() == 0) {
            ped.setValorSeguroInf(valorSeguroInf);
        } else if (valorSeguroInf > 0.0 && valorTotalBrutoInf > 0.0) {
            ped.setPercSeguroInf(valorSeguroInf / valorTotalBrutoInf * 100.0);
        }
        ped.setValorSeguro(valorSeguro);
        if (valorTotalBruto > 0.0) {
            ped.setPercSeguro(valorSeguro / valorTotalBruto * 100.0);
        } else {
            ped.setPercSeguro(0.0);
        }
    }

    private void getTotalizadorDespAcessoria(BaseVenda ped, Double valorDesp, Double valorDespInf, Double valorTotalBruto, Double valorTotalBrutoInf) {
        if (ped.tipoDespAcessInf() == 0) {
            ped.setValorDespAcessoriaInf(valorDespInf);
        } else if (valorDespInf > 0.0 && valorTotalBrutoInf > 0.0) {
            ped.setPercDespAcessoriaInf(valorDespInf / valorTotalBrutoInf * 100.0);
        }
        ped.setValorDespAcessoria(valorDesp);
        if (valorTotalBruto > 0.0) {
            ped.setPercDespAcessoria(valorDesp / valorTotalBruto * 100.0);
        } else {
            ped.setPercDespAcessoria(0.0);
        }
    }

    private ParamTribCbsIbsClass getParamTribCbsIbs(BaseItemVenda item, Empresa empresa, UnidadeFatCliente unid, NaturezaOperacao natureza) throws ExceptionInvalidData {
        return ((ServiceParamTribCbsIbsImpl)Context.get(ServiceParamTribCbsIbsImpl.class)).getParametrizacaoNFe(new Date(), empresa, unid, item.produto(), EnumConstModDocFiscal.get((Object)natureza.getModeloDocFiscal().getCodigo()), item.modeloFiscal(), EnumConstNFeIndicadorPresConsumidor.OPERACAO_NAO_PRESENCIAL_OUTROS);
    }
}

