/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.classcompiler;

import com.touchcomp.basementorexceptions.exceptions.impl.decoder.ExceptionDecodeHexString64;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.invalidstate.ExceptionInvalidState;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementortools.tools.base64.ToolBase64;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementortools.tools.system.ToolSystem;
import java.io.File;
import org.springframework.stereotype.Component;

@Component
public class CompClassCompiler {
    private String DEFAULT_NAME_COMPILER = "basementormodulescompiler.jar";
    private String DEFAULT_DIR_COMPILED_CLASS = "compiled-classes";
    private String DEFAULT_DIR_COMPILERS = "compilers";

    public String compileClassBase64(String className, Long javaVersion, String base64) throws ExceptionInvalidData, ExceptionInvalidState, ExceptionDecodeHexString64, ExceptionIO {
        File javaCompilerModuleDir = this.getBaseModuleCompiler(javaVersion);
        File javaHomeDir = new File(javaCompilerModuleDir.getAbsolutePath() + File.separator + "java");
        File javaCompilerModule = new File(javaCompilerModuleDir.getAbsolutePath() + File.separator + this.DEFAULT_NAME_COMPILER);
        if (!javaCompilerModule.exists()) {
            throw new ExceptionInvalidData("E.GEN.000055", new Object[]{javaCompilerModule.getAbsolutePath()});
        }
        if (!javaHomeDir.exists()) {
            throw new ExceptionInvalidData("E.GEN.000056", new Object[]{javaCompilerModule.getAbsolutePath()});
        }
        base64 = ToolBase64.decodeBase64String((String)base64);
        File outputDir = new File(javaCompilerModuleDir.getAbsolutePath() + File.separator + this.DEFAULT_DIR_COMPILED_CLASS);
        outputDir.mkdirs();
        File tempJavaSource = new File(outputDir.getAbsolutePath() + File.separator + className + ".java");
        File tempJavaClass = new File(outputDir.getAbsolutePath() + File.separator + className + ".class");
        ToolFile.writeStringInFile((File)tempJavaSource, (String)base64);
        ToolSystem.execCommandTerminal((File)outputDir, (String[])new String[]{"../java/bin/java -jar ../basementormodulescompiler.jar " + className});
        base64 = ToolBase64.encodeBase64((byte[])ToolFile.getBytesFromFile((File)tempJavaClass));
        return base64;
    }

    public File getBaseModuleCompiler(Long javaVersion) throws ExceptionInvalidData {
        String baseDir = ToolSystem.isWindows() ? "c:\\touchcomp\\web\\" : (ToolSystem.isMac() ? "/Library/touchcomp/web/" : "/opt/touchcomp/web/");
        File baseFileDir = new File(baseDir + File.separator + this.DEFAULT_DIR_COMPILERS);
        baseFileDir.mkdirs();
        if (!baseFileDir.exists()) {
            throw new ExceptionInvalidData("E.GEN.000055", new Object[]{baseFileDir.getAbsolutePath()});
        }
        File[] dir = baseFileDir.listFiles();
        File javaTarget = null;
        for (File subDir : dir) {
            String onlyNumbers = ToolString.onlyNumbers((String)subDir.getName());
            if (!TMethods.isStrWithData((String)onlyNumbers) || !TMethods.isEqualsNumber((Number)Long.valueOf(onlyNumbers), (Number)javaVersion)) continue;
            javaTarget = subDir;
            break;
        }
        if (javaTarget == null) {
            throw new ExceptionInvalidData("E.GEN.000057", new Object[]{baseFileDir.getAbsolutePath()});
        }
        return javaTarget;
    }
}

