/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.codigobarras;

import com.touchcomp.basementor.constants.enums.codigobarras.EnumConstCodigoBarras;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementorvalidator.others.barcode.ValidateBarcode;
import java.util.Arrays;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class CompCodigoBarras {
    private final int MAX_CASAS_DEC = 13;

    public String createCodigoBarras(EnumConstCodigoBarras tipo, Object valor) {
        String sufix = valor != null ? valor.toString() : "0";
        String prefix = tipo.getCodigo();
        return ToolString.completaZeros((String)prefix, (int)2, (boolean)true) + ToolString.completaZeros((String)sufix, (int)13, (boolean)true);
    }

    public String findCodigoBarras(EnumConstCodigoBarras tipo, Object valor) {
        String sufix;
        String string = sufix = valor != null ? valor.toString() : "0";
        if (EnumConstCodigoBarras.getCodigosBarrasDinamicos().contains(tipo)) {
            sufix = sufix.substring(2);
        }
        return ToolString.completaZeros((String)sufix, (int)13, (boolean)true);
    }

    public EnumConstCodigoBarras identificaTipoCodBarras(String codigo, List<EnumConstCodigoBarras> types) {
        if (!ToolMethods.isStrWithData((String)codigo)) {
            return EnumConstCodigoBarras.CODIGO_BARRAS_INVALIDO;
        }
        if (!ToolString.stringIsANumberInteger((String)codigo).booleanValue()) {
            return EnumConstCodigoBarras.CODIGO_BARRAS_INVALIDO;
        }
        if (codigo.length() == 15) {
            for (EnumConstCodigoBarras enumConstCodigoBarras : EnumConstCodigoBarras.getCodigosBarrasDinamicos()) {
                if (!codigo.startsWith(enumConstCodigoBarras.getCodigo())) continue;
                return enumConstCodigoBarras;
            }
        }
        if (types.contains(EnumConstCodigoBarras.CODIGO_BARRAS_EAN) && codigo.length() >= 8 && ValidateBarcode.valEan13((String)codigo)) {
            return EnumConstCodigoBarras.CODIGO_BARRAS_EAN;
        }
        return EnumConstCodigoBarras.CODIGO_BARRAS_ID_ENTIDADE;
    }

    public EnumConstCodigoBarras identificaTipoCodBarras(String codBarras, EnumConstCodigoBarras[] types) {
        return this.identificaTipoCodBarras(codBarras, Arrays.asList(types));
    }

    public EnumConstCodigoBarras identificaTipoCodBarras(String codBarras) {
        return this.identificaTipoCodBarras(codBarras, Arrays.asList(EnumConstCodigoBarras.values()));
    }
}

