/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.colaborador;

import com.touchcomp.basementor.constants.enums.atualizacaosalarial.EnumConstTipoAtualizacao;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.ColaboradorSalario;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.TipoColaborador;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.BaseMethods;
import com.touchcomp.basementorservice.service.impl.colaborador.ServiceColaboradorImpl;
import com.touchcomp.basementorservice.service.impl.colaboradorsalario.ServiceColaboradorSalarioImpl;
import com.touchcomp.basementorservice.service.impl.tipocolaborador.ServiceTipoColaboradorImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.touchvomodel.vo.atualizacaosalarial.web.DTOAtualizacaoSalarial;
import com.touchcomp.touchvomodel.vo.atualizacaosalarial.web.TempDadosAtualizacao;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompAtualizacaoSalarialColaborador
extends BaseMethods {
    @Autowired
    private ServiceColaboradorSalarioImpl serviceColaboradorSalario;
    @Autowired
    private ServiceTipoColaboradorImpl serviceTipoColaborador;
    @Autowired
    private ServiceColaboradorImpl serviceColaborador;

    public List<ColaboradorSalario> calculaAtualizacaoSalarial(TempDadosAtualizacao dadosAtualizacao, Empresa empresa) {
        Date periodo = new Date(dadosAtualizacao.getPeriodo());
        List<ColaboradorSalario> cs = new ArrayList<ColaboradorSalario>();
        if (dadosAtualizacao.getColaboradores() != null) {
            aux = this.serviceColaborador.buildToEntity(dadosAtualizacao.getColaboradores());
            cs = this.serviceColaboradorSalario.getColaboradoresColaboradores((List<Colaborador>)aux, empresa, periodo);
        } else if (dadosAtualizacao.getTipoColaboradores() != null && !dadosAtualizacao.getTipoColaboradores().isEmpty()) {
            aux = this.serviceTipoColaborador.buildToEntity(dadosAtualizacao.getTipoColaboradores());
            cs = this.serviceColaboradorSalario.getColaboradores((List<TipoColaborador>)aux, empresa, periodo);
        }
        if (cs == null || cs.isEmpty()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0463.001"));
        }
        List at = this.possuiFaixas(cs, dadosAtualizacao.getItemAtualizacaoSalarial(), periodo);
        List returned = new ArrayList();
        returned = dadosAtualizacao.getPercentualValor().equals(EnumConstTipoAtualizacao.INFORMAR_VALOR.getValue()) ? this.criarColaboradoresSalario(at, periodo, dadosAtualizacao.getItemAtualizacaoSalarial(), EnumConstTipoAtualizacao.INFORMAR_VALOR) : this.criarColaboradoresSalario(at, periodo, dadosAtualizacao.getItemAtualizacaoSalarial(), EnumConstTipoAtualizacao.INFORMAR_PERCENTUAL);
        return returned;
    }

    Boolean validaInformadoSalarioLimite(List<DTOAtualizacaoSalarial.DTOItemAtualizacaoSalarial> itens) {
        for (DTOAtualizacaoSalarial.DTOItemAtualizacaoSalarial i : itens) {
            if (i.getSalarioMensalAte() != null) continue;
            return false;
        }
        return true;
    }

    List possuiFaixas(List<ColaboradorSalario> colaboradoresSalario, List<DTOAtualizacaoSalarial.DTOItemAtualizacaoSalarial> itens, Date periodo) {
        ArrayList<ColaboradorSalario> ret = new ArrayList<ColaboradorSalario>();
        if (!this.validaInformadoSalarioLimite(itens).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0463.002"));
        }
        if (itens != null & !itens.isEmpty()) {
            block0: for (ColaboradorSalario x : colaboradoresSalario) {
                if (!this.isAffimative(x.getColaborador().getAtivo())) continue;
                for (DTOAtualizacaoSalarial.DTOItemAtualizacaoSalarial y : itens) {
                    if (y.getDataParametro() == null && y.getSalarioMensalAte() != null) {
                        if (!(this.getValorSalario(x.getColaborador(), periodo) <= y.getSalarioMensalAte())) continue;
                        ret.add(x);
                        continue block0;
                    }
                    if (y.getDataParametro() == null || y.getSalarioMensalAte() != null || !this.isEquals(ToolDate.dataSemHora((Date)y.getDataParametro()), ToolDate.dataSemHora((Date)x.getColaborador().getDataAdmissao()))) continue;
                    ret.add(x);
                    continue block0;
                }
            }
        } else {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0463.003"));
        }
        return ret;
    }

    Double getValorSalario(Colaborador colaborador, Date periodo) {
        String cod = colaborador.getTipoSalario().getCodigo();
        Integer codigo = Integer.valueOf(cod);
        Double valor = 0.0;
        switch (codigo) {
            case 1: 
            case 2: 
            case 3: {
                valor = this.serviceColaboradorSalario.findVrSalarioMaiorColaboradorSalarioNoPeriodo(colaborador, periodo);
                return valor;
            }
            case 4: {
                valor = this.serviceColaboradorSalario.findVrSalarioMaiorColaboradorSalarioNoPeriodo(colaborador, periodo);
                valor = valor * colaborador.getDiasJornada();
                return valor;
            }
            case 5: {
                valor = this.serviceColaboradorSalario.findVrSalarioMaiorColaboradorSalarioNoPeriodo(colaborador, periodo);
                valor = valor * colaborador.getDiasJornada() * colaborador.getHorasTrabDia();
                valor = ToolFormatter.arrredondarNumero((Double)valor, (int)2);
                return valor;
            }
            case 6: 
            case 7: {
                return valor;
            }
        }
        return valor;
    }

    List criarColaboradoresSalario(List<ColaboradorSalario> salarios, Date periodo, List<DTOAtualizacaoSalarial.DTOItemAtualizacaoSalarial> itens, EnumConstTipoAtualizacao tipo) {
        ArrayList<ColaboradorSalario> listaAtualizada = new ArrayList<ColaboradorSalario>();
        for (ColaboradorSalario cSal : salarios) {
            ColaboradorSalario novoCSal = new ColaboradorSalario();
            novoCSal.setColaborador(cSal.getColaborador());
            novoCSal.setDataCadastro(ToolDate.getCurrentDate());
            novoCSal.setPeriodo(this.converterPeriodoDate(periodo, cSal.getPeriodo()));
            novoCSal.setValorSalarioAnterior(cSal.getValorSalario());
            if (tipo == EnumConstTipoAtualizacao.INFORMAR_VALOR) {
                novoCSal.setValorSalario(this.calcularNovoSalarioPorValor(cSal, novoCSal, itens, periodo));
            } else {
                novoCSal.setValorSalario(this.calcularNovoSalario(cSal, itens, periodo));
            }
            novoCSal.getColaborador().setValorSalario(novoCSal.getValorSalario());
            novoCSal.setFuncao(cSal.getFuncao());
            if (!(novoCSal.getValorSalario() > novoCSal.getValorSalarioAnterior())) continue;
            listaAtualizada.add(novoCSal);
        }
        if (listaAtualizada.isEmpty()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0463.004"));
        }
        return listaAtualizada;
    }

    Date converterPeriodoDate(Date periodo, Date periodoEncontrado) {
        if (periodo.equals(periodoEncontrado) || periodo.before(periodoEncontrado)) {
            return ToolDate.nextDays((Date)periodoEncontrado, (int)1);
        }
        return periodo;
    }

    Double calcularNovoSalario(ColaboradorSalario vo, List<DTOAtualizacaoSalarial.DTOItemAtualizacaoSalarial> itens, Date periodo) {
        Double salarioAnterior = vo.getValorSalario();
        Double salarioAtual = 0.0;
        DTOAtualizacaoSalarial.DTOItemAtualizacaoSalarial item = this.pegarItemPorColaboradorSalario(vo, itens, periodo);
        if (item.getPercentualAumento() == null) {
            item.setPercentualAumento(Double.valueOf(0.0));
        }
        if (item.getValorParcela() == null) {
            item.setValorParcela(Double.valueOf(0.0));
        }
        salarioAtual = ToolFormatter.arrredondarNumero((Double)(salarioAnterior + salarioAnterior * item.getPercentualAumento() / 100.0 + item.getValorParcela()), (int)2);
        return salarioAtual;
    }

    DTOAtualizacaoSalarial.DTOItemAtualizacaoSalarial pegarItemPorColaboradorSalario(ColaboradorSalario cs, List<DTOAtualizacaoSalarial.DTOItemAtualizacaoSalarial> itens, Date periodo) {
        for (DTOAtualizacaoSalarial.DTOItemAtualizacaoSalarial item : itens) {
            if (!(item.getSalarioMensalAte() >= this.getValorSalario(cs.getColaborador(), periodo))) continue;
            return item;
        }
        return null;
    }

    Double calcularNovoSalarioPorValor(ColaboradorSalario vo, ColaboradorSalario novoSal, List<DTOAtualizacaoSalarial.DTOItemAtualizacaoSalarial> itens, Date periodo) {
        Double salarioAtual = 0.0;
        DTOAtualizacaoSalarial.DTOItemAtualizacaoSalarial item = this.pegarItemPorColaboradorSalario(vo, itens, periodo);
        if (item.getPercentualAumento() == null) {
            item.setPercentualAumento(Double.valueOf(0.0));
        }
        if (item.getValorParcela() == null) {
            item.setValorParcela(Double.valueOf(0.0));
        }
        if (vo.getColaborador().getTipoSalario().getCodigo().equals("5")) {
            salarioAtual = ToolFormatter.arrredondarNumero((Double)(item.getPercentualAumento() / vo.getColaborador().getDiasJornada() / vo.getColaborador().getHorasTrabDia()), (int)2);
            novoSal.setPercAumento(item.getPercentualAumento());
        } else {
            salarioAtual = item.getPercentualAumento();
        }
        return salarioAtual;
    }
}

