/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.coleta;

import com.touchcomp.basementor.model.vo.Coleta;
import com.touchcomp.basementor.model.vo.ColetaDadosAtivo;
import com.touchcomp.basementor.model.vo.ConsumoAtivo;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Equipamento;
import com.touchcomp.basementor.model.vo.FechamOrdemServicoColeta;
import com.touchcomp.basementor.model.vo.FechamentoOrdemServico;
import com.touchcomp.basementor.model.vo.RelacaoEquipamento;
import com.touchcomp.basementor.model.vo.TipoPontoControle;
import com.touchcomp.basementor.model.vo.TipoPontoControleAtivo;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementortools.tools.date.TDate;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class CompColeta {
    public Coleta getColeta(FechamentoOrdemServico fechamento, FechamOrdemServicoColeta f) {
        Coleta c = this.getColeta(fechamento.getOrdemServico().getEquipamento(), f.getTipoPontoControle(), fechamento.getEmpresa());
        c.setDataHoraColeta(f.getDataHoraColeta());
        c.setValorColeta(f.getValorColeta());
        f.setColeta(c);
        return c;
    }

    public Coleta getColeta(Equipamento ativoPrincipal, TipoPontoControle tipoPontoControle, Empresa empresa) {
        return this.getColeta(null, ativoPrincipal, tipoPontoControle, empresa);
    }

    public Coleta getColeta(Coleta coleta, Equipamento ativoPrincipal, TipoPontoControle tipoPontoControle, Empresa empresa) {
        Coleta newColeta = coleta;
        if (newColeta == null) {
            newColeta = new Coleta();
        }
        newColeta.setIdentificador(null);
        newColeta.setDataCadastro(new Date());
        newColeta.setTipoPontoControle(tipoPontoControle);
        newColeta.setColetaAnterior(null);
        newColeta.setValorAcumulado(Integer.valueOf(0));
        newColeta.setNumeroColeta(Long.valueOf(1L));
        newColeta.setAtivo(ativoPrincipal);
        newColeta.setDescricao("Coleta ativo: " + ativoPrincipal.getIdentificador() + "-" + ativoPrincipal.getNome());
        newColeta.setDataHoraColeta(ToolDate.toTimestamp((Date)new Date()));
        newColeta.setEmpresa(empresa);
        newColeta.setValorColeta(Integer.valueOf(0));
        return newColeta;
    }

    public Coleta getNovaColetaColetaPai(Coleta coletaPai, Equipamento ativo, TipoPontoControle tipoPontoControle, Empresa empresa) {
        Coleta newColeta = this.getColeta(ativo, tipoPontoControle, empresa);
        if (coletaPai != null) {
            newColeta.setDataHoraColeta(coletaPai.getDataHoraColeta());
            newColeta.setEmpresa(coletaPai.getEmpresa());
            newColeta.setValorColeta(coletaPai.getValorColeta());
        }
        return newColeta;
    }

    public Coleta getColeta(ConsumoAtivo vo, Empresa empresa) {
        Coleta c = this.getColeta(vo.getEquipamento(), vo.getTipoPontoControleColeta(), empresa);
        c.setDataHoraColeta(vo.getDataHoraColeta());
        c.setValorColeta(vo.getValorColeta());
        return c;
    }

    public Coleta getColeta(Coleta coleta, ColetaDadosAtivo col, TipoPontoControle tipoPontoControle) {
        if (col == null) {
            return null;
        }
        Coleta c = this.getColeta(coleta, col.getEquipamento(), tipoPontoControle, col.getEmpresa());
        c.setDataHoraColeta(TDate.toTimestamp((Date)col.getDataHoraUltColeta()));
        c.setValorColeta(Integer.valueOf(col.getValorColetado().intValue()));
        return c;
    }

    public List<Coleta> checkExclusaoAtivoColeta(Equipamento ativo, List<Coleta> coletas) {
        List coletasAtivo = coletas.stream().filter(c -> c.getAtivo().equals((Object)ativo)).collect(Collectors.toList());
        ArrayList<Coleta> grupo = new ArrayList<Coleta>();
        if (!coletasAtivo.isEmpty()) {
            Coleta vo = (Coleta)coletasAtivo.get(0);
            if (vo.getAtivo().getAtivos() == null || vo.getAtivo().getAtivos().isEmpty()) {
                grupo.add(vo);
            } else {
                for (Coleta c2 : coletas) {
                    if (!vo.getAtivo().getAtivos().contains(c2.getAtivo()) || grupo.contains(c2)) continue;
                    grupo.add(c2);
                }
                grupo.add(vo);
            }
        }
        return grupo;
    }

    public List<Coleta> gerarColetas(Equipamento eq, Empresa empresa) throws ExceptionValidacaoDados {
        ArrayList<Coleta> coletas = new ArrayList<Coleta>();
        TipoPontoControle tipoPontoControle = null;
        TipoPontoControleAtivo tipoPontoControleAtivo = null;
        if (eq.getTipoPontoControleAtivo() != null && eq.getTipoPontoControleAtivo().size() > 1) {
            coletas.add(this.getColeta(eq, null, empresa));
        } else if (eq.getTipoPontoControleAtivo() != null && !eq.getTipoPontoControleAtivo().isEmpty()) {
            tipoPontoControleAtivo = (TipoPontoControleAtivo)eq.getTipoPontoControleAtivo().get(0);
            if (!ToolMethods.isAffirmative((Number)tipoPontoControleAtivo.getAtivo())) {
                throw new ExceptionValidacaoDados("E.ERP.1131.003", new Object[0]);
            }
            tipoPontoControle = tipoPontoControleAtivo.getTipoPontoControle();
            coletas.add(this.getColeta(eq, tipoPontoControle, empresa));
        }
        if (eq.getAtivos() != null && !eq.getAtivos().isEmpty()) {
            for (RelacaoEquipamento ativo : eq.getAtivos()) {
                if (ativo.getEquipamentoFilho() == null || !ativo.getEquipamentoFilho().getTipoPontoControleAtivo().contains(tipoPontoControleAtivo)) continue;
                coletas.add(this.getColeta(ativo.getEquipamentoFilho(), tipoPontoControle, empresa));
            }
        }
        return coletas;
    }
}

