/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.comunicadoproducao;

import com.touchcomp.basementor.constants.enums.tipoproducao.EnumConstTipoProducao;
import com.touchcomp.basementor.model.vo.CelulaProdutiva;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.ComunicadoProducao;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FaseProdutiva;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeItemComunicadoProducao;
import com.touchcomp.basementor.model.vo.ItemComProdOutrosCustos;
import com.touchcomp.basementor.model.vo.ItemComunicadoProducao;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.TipoProducao;
import com.touchcomp.basementorservice.components.comunicadoproducao.model.TempOSLinhaProducao;
import com.touchcomp.basementorservice.components.comunicadoproducao.model.TempOSLinhaResultado;
import com.touchcomp.basementorservice.helpers.impl.comunicadoproducao.HelperComunicadoProducao;
import com.touchcomp.basementorservice.helpers.impl.comunicadoproducao.HelperItemComunicadoProducao;
import com.touchcomp.basementorservice.service.impl.celulaprodutiva.ServiceCelulaProdutivaImpl;
import com.touchcomp.basementorservice.service.impl.lotefabricacao.ServiceLoteFabricacaoImpl;
import com.touchcomp.basementorservice.service.impl.tipoproducao.ServiceTipoProducaoImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.Date;
import java.util.List;
import java.util.Optional;

class AuxComunicadoProdOSLinha {
    final ServiceTipoProducaoImpl serviceTipoProducaoImpl;
    final HelperItemComunicadoProducao helperItemComunicadoProducao;
    final HelperComunicadoProducao helperComunicadoProducao;
    final ServiceCelulaProdutivaImpl serviceCelulaProdutivaImpl;
    final ServiceLoteFabricacaoImpl serviceLoteFabricacaoImpl;

    public AuxComunicadoProdOSLinha(ServiceTipoProducaoImpl serviceTipoProducaoImpl, HelperItemComunicadoProducao helperItemComunicadoProducao, HelperComunicadoProducao helperComunicadoProducao, ServiceCelulaProdutivaImpl serviceCelulaProdutivaImpl, ServiceLoteFabricacaoImpl serviceLoteFabricacaoImpl) {
        this.serviceTipoProducaoImpl = serviceTipoProducaoImpl;
        this.helperItemComunicadoProducao = helperItemComunicadoProducao;
        this.helperComunicadoProducao = helperComunicadoProducao;
        this.serviceCelulaProdutivaImpl = serviceCelulaProdutivaImpl;
        this.serviceLoteFabricacaoImpl = serviceLoteFabricacaoImpl;
    }

    public void getComunicadoProducaoLinhaProducao(TempOSLinhaResultado temp, FaseProdutiva faseProdutiva, Date data, boolean createNewItens, Empresa empresa) {
        ComunicadoProducao comunicadoProducao = temp.getComProducaoGerado();
        if (comunicadoProducao == null) {
            comunicadoProducao = new ComunicadoProducao();
        }
        comunicadoProducao.setTipoProducaoSped(temp.getSubOS().getOrdemServicoProdLinhaProd().getTipoProducaoSped());
        comunicadoProducao.setDataCadastro(new Date());
        comunicadoProducao.setDataEntradaSaida(data);
        comunicadoProducao.setDataFinal(data);
        comunicadoProducao.setEmpresa(empresa);
        comunicadoProducao.setQuantidadeProd(temp.getQuantidadeTotalReal());
        comunicadoProducao.setQuantidadeRef(temp.getQuantidadeTotalRef());
        this.criarItemComunicadoProducao(comunicadoProducao, createNewItens, faseProdutiva, temp, empresa);
        this.helperComunicadoProducao.beforeSave(comunicadoProducao);
        temp.setComProducaoGerado(comunicadoProducao);
    }

    private ItemComunicadoProducao getItemComunicadoProducao(TipoProducao tipoProducao, List<ItemComunicadoProducao> itens, GradeCor p) {
        for (ItemComunicadoProducao itemComunicado : itens) {
            if (itemComunicado.getTipoProducao() == null || !TMethods.isEqualsNumber((Number)itemComunicado.getTipoProducao().getTipo(), (Number)tipoProducao.getTipo())) continue;
            for (GradeItemComunicadoProducao g : itemComunicado.getGradeItemComunicadoProducao()) {
                if (!g.getGradeCor().getIdentificador().equals(p.getIdentificador())) continue;
                return itemComunicado;
            }
        }
        return null;
    }

    private void criarItemComunicadoProducao(ComunicadoProducao comunicadoProducao, boolean createNewItens, FaseProdutiva fase, TempOSLinhaResultado tempOSResultado, Empresa empresa) {
        for (TempOSLinhaProducao tempItemProducao : tempOSResultado.getProducao()) {
            this.criarItemComunicadoProducao(tempItemProducao.getTipoProducao(), comunicadoProducao, tempItemProducao.getGradeCor(), createNewItens, fase, tempOSResultado, tempItemProducao, empresa);
        }
    }

    private void criarItemComunicadoProducao(TipoProducao tipoProducao, ComunicadoProducao c, GradeCor gradeCor, boolean createNewItens, FaseProdutiva fase, TempOSLinhaResultado tempOSResultado, TempOSLinhaProducao item, Empresa empresa) {
        List itens = c.getItemComunicadoProducao();
        ItemComunicadoProducao itemComunicado = this.getItemComunicadoProducao(tipoProducao, itens, gradeCor);
        if (itemComunicado == null || createNewItens) {
            itemComunicado = new ItemComunicadoProducao();
            c.getItemComunicadoProducao().add(itemComunicado);
        }
        CelulaProdutiva cel = fase.getCelulaProdutiva();
        CentroEstoque centro = item.getCentroEstoque();
        if (centro == null) {
            centro = this.serviceCelulaProdutivaImpl.getCentroEstoqueComProd(cel, tempOSResultado.getSubOS().getOrdemServicoProdLinhaProd().getEmpresa());
        }
        itemComunicado.setGradeFormulaProduto(item.getGradeFormulaProduto());
        itemComunicado.setProduto(item.getGradeCor().getProdutoGrade().getProduto());
        itemComunicado.setComunicadoProducao(c);
        itemComunicado.setCentroEstoque(centro);
        itemComunicado.setCentroCusto(tempOSResultado.getSubOS().getCentroCusto());
        if (itemComunicado.getCentroCusto() == null) {
            itemComunicado.setCentroCusto(cel.getCentroCusto());
        }
        itemComunicado.setTiposDefeitos(item.getTiposDefeitos());
        itemComunicado.setValorAdCusto(Double.valueOf(0.0));
        itemComunicado.setTipoProducao(tipoProducao);
        if (itemComunicado.getTipoProducao() == null) {
            itemComunicado.setTipoProducao(this.serviceTipoProducaoImpl.getFirstTipoProducao(EnumConstTipoProducao.PRODUCAO));
        }
        itemComunicado.setUnidadeMedida(itemComunicado.getProduto().getUnidadeMedida());
        this.setOutrosCustos(itemComunicado, tempOSResultado);
        List grades = itemComunicado.getGradeItemComunicadoProducao();
        GradeItemComunicadoProducao gi = this.getGradeItemComunicado(item.getGradeCor(), item.getLoteFabricacao(), grades);
        gi.setLoteFabricacao(item.getLoteFabricacao());
        if (gi.getLoteFabricacao() == null && TMethods.isAffirmative((Number)itemComunicado.getProduto().getLoteUnico())) {
            gi.setLoteFabricacao(this.serviceLoteFabricacaoImpl.findLoteUnico(itemComunicado.getProduto()));
        }
        gi.setGradeCor(item.getGradeCor());
        gi.setQuantidade(Double.valueOf(item.getQuantidadeReal()));
        gi.setQuantidadeReferencia(Double.valueOf(item.getQuantidadeReferencia()));
        gi.setValorUnitario(Double.valueOf(0.0));
        gi.setItemComunicadoProducao(itemComunicado);
        gi.setCentroEstoque(itemComunicado.getCentroEstoque());
        gi.setEmpresa(empresa);
        itemComunicado.setGradeItemComunicadoProducao(grades);
        gi.setItemComunicadoProducao(itemComunicado);
        itemComunicado.setGradeItemComunicadoProducao(grades);
        this.helperItemComunicadoProducao.calcularTotais(itemComunicado);
        itemComunicado.setFichasTecnicas(item.getEspecificacoes());
        item.setItemComunicadoGerado(itemComunicado);
    }

    private GradeItemComunicadoProducao getGradeItemComunicado(GradeCor gradeCor, LoteFabricacao lote, List<GradeItemComunicadoProducao> grades) {
        Optional<GradeItemComunicadoProducao> found = grades.stream().filter(i -> TMethods.isEquals((Object)i.getGradeCor(), (Object)gradeCor) && TMethods.isEquals((Object)i.getLoteFabricacao(), (Object)lote)).findFirst();
        if (found.isPresent()) {
            return found.get();
        }
        GradeItemComunicadoProducao gi = new GradeItemComunicadoProducao();
        grades.add(gi);
        return gi;
    }

    private void setOutrosCustos(ItemComunicadoProducao i, TempOSLinhaResultado temp) {
        if (temp.getSubOS().getOrdemServicoProdLinhaProd().getGradeItemNotaTerceiros() != null) {
            ItemComProdOutrosCustos aux = new ItemComProdOutrosCustos();
            aux.setGradeItemNFTerceirosOrigem(temp.getSubOS().getOrdemServicoProdLinhaProd().getGradeItemNotaTerceiros());
            aux.setItemComunicadoProducao(i);
            aux.setDataReferencia(aux.getGradeItemNFTerceirosOrigem().getDataEntradaSaida());
            aux.setQuantidade(aux.getGradeItemNFTerceirosOrigem().getQuantidade());
            aux.setValor(Double.valueOf(aux.getGradeItemNFTerceirosOrigem().getValorCusto() * aux.getGradeItemNFTerceirosOrigem().getQuantidade()));
            i.getItensOutrosCustos().add(aux);
        }
    }
}

