/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.comunicadoproducao;

import com.touchcomp.basementor.constants.enums.opcoespcp.EnumConstOpcoesPCPOP;
import com.touchcomp.basementor.constants.enums.tipoproducao.EnumConstTipoProducao;
import com.touchcomp.basementor.constants.enums.tipoproducaosped.EnumConstTipoProducaoSped;
import com.touchcomp.basementor.interfaces.EnumOpDinamicasInterface;
import com.touchcomp.basementor.model.interfaces.InterfaceStaticObjects;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.ComunicadoProducao;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FaseProdutiva;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeItemComunicadoProducao;
import com.touchcomp.basementor.model.vo.GradeItemRequisicao;
import com.touchcomp.basementor.model.vo.ItemComunicadoProducao;
import com.touchcomp.basementor.model.vo.ItemRequisicao;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.OpcoesPCP;
import com.touchcomp.basementor.model.vo.Requisicao;
import com.touchcomp.basementor.model.vo.SubdivisaoOSProdLinhaProd;
import com.touchcomp.basementor.model.vo.TipoProducao;
import com.touchcomp.basementor.model.vo.TipoProducaoSped;
import com.touchcomp.basementor.model.vo.TiposDefeitos;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorrules.opcoesdinamicas.CompOpcoes;
import com.touchcomp.basementorservice.components.comunicadoproducao.AuxComunicadoProdOSLinha;
import com.touchcomp.basementorservice.components.comunicadoproducao.model.TempOSLinhaProducao;
import com.touchcomp.basementorservice.components.comunicadoproducao.model.TempOSLinhaResultado;
import com.touchcomp.basementorservice.components.requisicao.auxcomp.AuxGradesQtd;
import com.touchcomp.basementorservice.components.requisicao.auxcomp.CacheSaldoProduto;
import com.touchcomp.basementorservice.components.requisicao.impl.comunicadoproducao.CompRequisicaoComunicadoProducao;
import com.touchcomp.basementorservice.helpers.impl.comunicadoproducao.HelperComunicadoProducao;
import com.touchcomp.basementorservice.helpers.impl.comunicadoproducao.HelperItemComunicadoProducao;
import com.touchcomp.basementorservice.helpers.impl.opcoes.opcoespcp.HelperOpcoesPCP;
import com.touchcomp.basementorservice.service.impl.celulaprodutiva.ServiceCelulaProdutivaImpl;
import com.touchcomp.basementorservice.service.impl.lotefabricacao.ServiceLoteFabricacaoImpl;
import com.touchcomp.basementorservice.service.impl.tipoproducao.ServiceTipoProducaoImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class CompComunicadoProducao {
    final ServiceTipoProducaoImpl serviceTipoProducaoImpl;
    final HelperItemComunicadoProducao helperItemComunicadoProducao;
    final HelperComunicadoProducao helperComunicadoProducao;
    final ServiceCelulaProdutivaImpl serviceCelulaProdutivaImpl;
    final CompRequisicaoComunicadoProducao compRequisicao;
    final ServiceLoteFabricacaoImpl serviceLoteFabricacaoImpl;
    final InterfaceStaticObjects sharedObjects;

    public CompComunicadoProducao(ServiceTipoProducaoImpl serviceTipoProducaoImpl, HelperItemComunicadoProducao helperItemComunicadoProducao, HelperComunicadoProducao helperComunicadoProducao, ServiceCelulaProdutivaImpl serviceCelulaProdutivaImpl, CompRequisicaoComunicadoProducao compRequisicao, ServiceLoteFabricacaoImpl serviceLoteFabricacaoImpl, InterfaceStaticObjects sharedObjects) {
        this.serviceTipoProducaoImpl = serviceTipoProducaoImpl;
        this.helperItemComunicadoProducao = helperItemComunicadoProducao;
        this.helperComunicadoProducao = helperComunicadoProducao;
        this.serviceCelulaProdutivaImpl = serviceCelulaProdutivaImpl;
        this.compRequisicao = compRequisicao;
        this.sharedObjects = sharedObjects;
        this.serviceLoteFabricacaoImpl = serviceLoteFabricacaoImpl;
    }

    public void gerarComunicadoProducaoLinhaProducao(TempOSLinhaResultado tempApontamentoOS, FaseProdutiva faseProdutiva, Date data, boolean createNewItens, Empresa empresa) throws ExceptionBase {
        this.gerarComunicadoProducaoLinhaProducao(tempApontamentoOS, faseProdutiva, data, createNewItens, empresa, new CacheSaldoProduto(), new AuxGradesQtd());
    }

    public TempOSLinhaResultado gerarComunicadoProducaoLinhaProducao(SubdivisaoOSProdLinhaProd subOS, GradeCor gradeCor, Double quantidade, FaseProdutiva faseProdutiva, TipoProducao tipoProducao, TiposDefeitos tipoDefeito, CentroEstoque centroEstoque, LoteFabricacao loteFabricacao, Date data, boolean createNewItens, Empresa empresa) throws ExceptionBase {
        TempOSLinhaResultado temp = new TempOSLinhaResultado();
        temp.setSubOS(subOS);
        TempOSLinhaProducao tempOS = new TempOSLinhaProducao();
        tempOS.setGradeCor(gradeCor);
        tempOS.setQuantidadeReal(quantidade);
        tempOS.setGradeFormulaProduto(subOS.getGradeFormulaProduto());
        tempOS.setQuantidadeReferencia(quantidade);
        tempOS.setTipoProducao(tipoProducao);
        tempOS.setCentroEstoque(centroEstoque);
        tempOS.setLoteFabricacao(loteFabricacao);
        tempOS.setTiposDefeitos(tipoDefeito);
        temp.getProducao().add(tempOS);
        this.gerarComunicadoProducaoLinhaProducao(temp, faseProdutiva, data, createNewItens, empresa, new CacheSaldoProduto(), new AuxGradesQtd());
        return temp;
    }

    public void gerarComunicadoProducaoLinhaProducao(TempOSLinhaResultado temp, FaseProdutiva faseProdutiva, Date data, boolean createNewItens, Empresa empresa, CacheSaldoProduto cacheSaldo, AuxGradesQtd auxGrades) throws ExceptionBase {
        OpcoesPCP opcoesPcp = this.sharedObjects.getOpcoesPCP(empresa);
        new AuxComunicadoProdOSLinha(this.serviceTipoProducaoImpl, this.helperItemComunicadoProducao, this.helperComunicadoProducao, this.serviceCelulaProdutivaImpl, this.serviceLoteFabricacaoImpl).getComunicadoProducaoLinhaProducao(temp, faseProdutiva, data, createNewItens, empresa);
        if (TMethods.isAffirmative((Number)opcoesPcp.getNaoGerarReqAutEvt())) {
            return;
        }
        String aux = "(" + temp.getSubOS().getGradeCor().getProdutoGrade().getProduto().getIdentificador() + ")";
        if (opcoesPcp.getExcecaoGerarReqAuto() != null && opcoesPcp.getExcecaoGerarReqAuto().contains(aux)) {
            return;
        }
        this.gerarRequisicaoLinhaProd(temp, data, faseProdutiva, auxGrades, cacheSaldo, opcoesPcp, empresa);
        this.replicarLoteRequisicaoNoComunicado(temp.getComProducaoGerado(), opcoesPcp);
    }

    private void replicarLoteRequisicaoNoComunicado(ComunicadoProducao c, OpcoesPCP opcoesPCP) {
        if (TMethods.isNegative((Number)opcoesPCP.getReplicarLoteReqEvento())) {
            return;
        }
        for (ItemComunicadoProducao i : c.getItemComunicadoProducao()) {
            for (GradeItemComunicadoProducao gi : i.getGradeItemComunicadoProducao()) {
                Boolean achou = false;
                for (Requisicao r : i.getRequisicoes()) {
                    if (achou.booleanValue()) continue;
                    for (ItemRequisicao ir : r.getItensRequisicao()) {
                        if (!ir.getProduto().equals((Object)i.getProduto()) || achou.booleanValue()) continue;
                        for (GradeItemRequisicao gir : ir.getGradeItemRequisicao()) {
                            if (gir.getLoteFabricacao() == null) continue;
                            gi.setLoteFabricacao(gir.getLoteFabricacao());
                            achou = true;
                        }
                    }
                }
            }
        }
    }

    public void gerarRequisicaoLinhaProd(TempOSLinhaResultado temp, Date data, FaseProdutiva fase, AuxGradesQtd aux, CacheSaldoProduto cache, OpcoesPCP opcoesPCP, Empresa empresa) {
        TipoProducaoSped tp = temp.getSubOS().getOrdemServicoProdLinhaProd().getTipoProducaoSped();
        Short preencherApenasProdPrincipal = (Short)CompOpcoes.getOption(((HelperOpcoesPCP)ConfApplicationContext.getBean(HelperOpcoesPCP.class)).build(opcoesPCP).getItens(), (EnumOpDinamicasInterface)EnumConstOpcoesPCPOP.PERMITIR_APONT_PROD_CONJ_PROD_PRINCIPAL, Short.class);
        if (EnumConstTipoProducaoSped.get((Object)tp.getCodigo()).isDesmancheOuProdConjunt()) {
            List<Object> itensReq = new ArrayList();
            itensReq = !TMethods.isAffirmative((Number)preencherApenasProdPrincipal) ? this.compRequisicao.getItemReqLinhaProd(temp.getSubOS().getQuantidadePrevista(), temp.getSubOS().getQuantidadeRefPrevProd(), temp.getSubOS().getGradeFormulaProduto(), data, temp.getSubOS().getOrdemServicoProdLinhaProd(), fase, temp.getSubOS(), opcoesPCP, null, cache) : this.compRequisicao.getItemReqLinhaProd(temp.getQuantidadeTotalReal(), temp.getQuantidadeTotalRef(), temp.getSubOS().getGradeFormulaProduto(), data, temp.getSubOS().getOrdemServicoProdLinhaProd(), fase, temp.getSubOS(), opcoesPCP, null, cache);
            Requisicao r = this.compRequisicao.novaRequisicao(temp.getComProducaoGerado().getRequisicao(), null, data, itensReq, empresa);
            temp.getComProducaoGerado().setRequisicao(r);
        } else {
            for (TempOSLinhaProducao item : temp.getProducao()) {
                Requisicao r;
                if (item.getTipoProducao() == null || item.getGradeFormulaProduto() == null || item.getTipoProducao().getTipo().shortValue() != EnumConstTipoProducao.PRODUCAO.getValue() && item.getTipoProducao().getTipo().shortValue() != EnumConstTipoProducao.REFUGO.getValue() || ToolMethods.isNull((Object)(r = ((CompRequisicaoComunicadoProducao)Context.get(CompRequisicaoComunicadoProducao.class)).gerarRequisicaoItemComProducao(item.getItemComunicadoGerado(), item.getGradeFormulaProduto(), data, temp.getSubOS().getOrdemServicoProdLinhaProd(), fase, temp.getSubOS(), opcoesPCP, aux, cache))).booleanValue()) continue;
                r.setItemComunicadoProducao(item.getItemComunicadoGerado());
                item.getItemComunicadoGerado().getRequisicoes().add(r);
            }
        }
    }
}

