/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.conferencianfterceiros;

import com.touchcomp.basementor.constants.enums.confnfterceiros.EnumConstConfereciaNFTerceiros;
import com.touchcomp.basementor.constants.enums.confnfterceiros.EnumConstTipoConfNFTercItens;
import com.touchcomp.basementor.constants.enums.relacionamentopessoa.EnumConstTipoConfNFProduto;
import com.touchcomp.basementor.model.vo.ConfNFTercResAvaItens;
import com.touchcomp.basementor.model.vo.GradeItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.InfPagamentoNfTerceiros;
import com.touchcomp.basementor.model.vo.ItemLiberacaoNFTerceirosQualidade;
import com.touchcomp.basementor.model.vo.ItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.LivroFiscal;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class CompConferenciaNFTerceiros {
    public static void avaliarNFParaConferencia(NotaFiscalTerceiros vo, OpcoesCompraSuprimentos op) {
        if (CompConferenciaNFTerceiros.bloquearNFParaConferencia(vo, op)) {
            if (op.getUtilizarSomenteLibSel() == null || op.getUtilizarSomenteLibSel().equals((short)0)) {
                for (InfPagamentoNfTerceiros inf : vo.getInfPagamentoNfTerceiros()) {
                    for (Titulo t : inf.getTitulos()) {
                        t.setProvisao(Short.valueOf((short)0));
                    }
                }
                for (ItemNotaTerceiros i : vo.getItemNotaTerceiros()) {
                    for (GradeItemNotaTerceiros gr : i.getGrade()) {
                        gr.setMovimentacaoFisica(Short.valueOf((short)0));
                    }
                }
                for (LivroFiscal lv : vo.getLivrosFiscais()) {
                    lv.setCancelado(Short.valueOf((short)1));
                }
                vo.setIntegracaoNotaTerceiros(null);
            } else {
                if (op.getUtilizarSomenteLibSel().equals((short)1) && op.getLiberacaoFinanceiro() != null && op.getLiberacaoFinanceiro().equals((short)1)) {
                    for (InfPagamentoNfTerceiros inf : vo.getInfPagamentoNfTerceiros()) {
                        for (Titulo t : inf.getTitulos()) {
                            t.setProvisao(Short.valueOf((short)0));
                        }
                    }
                }
                if (op.getUtilizarSomenteLibSel().equals((short)1) && op.getLiberacaoEstoque() != null && op.getLiberacaoEstoque().equals((short)1)) {
                    for (ItemNotaTerceiros i : vo.getItemNotaTerceiros()) {
                        for (GradeItemNotaTerceiros gr : i.getGrade()) {
                            gr.setMovimentacaoFisica(Short.valueOf((short)0));
                        }
                    }
                }
                if (op.getUtilizarSomenteLibSel().equals((short)1) && op.getLiberacaoFiscal() != null && op.getLiberacaoFiscal().equals((short)1)) {
                    for (LivroFiscal lv : vo.getLivrosFiscais()) {
                        lv.setCancelado(Short.valueOf((short)1));
                    }
                    vo.setIntegracaoNotaTerceiros(null);
                }
            }
        }
    }

    public static boolean bloquearNFParaConferencia(NotaFiscalTerceiros vo, OpcoesCompraSuprimentos op) {
        if (op == null || vo == null) {
            return false;
        }
        if (op.getConferirNFTerceiros() == null || op.getConferirNFTerceiros() == EnumConstConfereciaNFTerceiros.NAO_CONFERIR.value) {
            return false;
        }
        if (vo.getLiberacaoNFTerceiros() != null && (vo.getLiberacaoNFTerceiros().getLiberacaoEstoque() != null && vo.getLiberacaoNFTerceiros().getLiberacaoEstoque().getConferida().equals((short)1) || vo.getLiberacaoNFTerceiros().getLiberacaoFinanceira() != null && vo.getLiberacaoNFTerceiros().getLiberacaoFinanceira().getConferida().equals((short)1) || vo.getLiberacaoNFTerceiros().getLiberacaoFiscal() != null && vo.getLiberacaoNFTerceiros().getLiberacaoFiscal().getConferida().equals((short)1) || vo.getLiberacaoNFTerceiros().getLiberacaoQualidade() != null && vo.getLiberacaoNFTerceiros().getLiberacaoQualidade().getConferida().equals((short)1))) {
            return true;
        }
        if (op.getTipoConfNFTerceirosItens() == EnumConstTipoConfNFTercItens.CONFERIR_TODOS_ITENS.value) {
            return true;
        }
        for (ItemNotaTerceiros it : vo.getItemNotaTerceiros()) {
            if (it.getProduto().getTipoConfNFTerceirosProduto() == null || it.getProduto().getTipoConfNFTerceirosProduto().getTipo() != EnumConstTipoConfNFProduto.CONFERIR.value) continue;
            return true;
        }
        return false;
    }

    public static StringBuilder validaProdutoSemTipoConferenciaInNFT(NotaFiscalTerceiros notaTerceiros, OpcoesCompraSuprimentos opcoesCompra) {
        if (ToolMethods.isEquals((Object)opcoesCompra, null) || ToolMethods.isEquals((Object)opcoesCompra.getConferirNFTerceiros(), null) || ToolMethods.isEquals((Object)opcoesCompra.getConferirNFTerceiros(), (Object)EnumConstConfereciaNFTerceiros.NAO_CONFERIR.value)) {
            return new StringBuilder();
        }
        if (!ToolMethods.isEquals((Object)opcoesCompra.getTipoConfNFTerceirosItens(), (Object)EnumConstTipoConfNFTercItens.CONF_CADASTRO_PROD.value)) {
            return new StringBuilder();
        }
        StringBuilder error = new StringBuilder();
        notaTerceiros.getItemNotaTerceiros().forEach(i -> {
            if (ToolMethods.isEquals((Object)i.getProduto().getTipoConfNFTerceirosProduto(), null)) {
                error.append("O produto ").append(i.getProduto().toString().toUpperCase()).append(" n\u00e3o possui Tipo de Confer\u00eancia.\n");
            }
        });
        return error;
    }

    public static List<ConfNFTercResAvaItens> calcularResumoAvaItens(List<ItemLiberacaoNFTerceirosQualidade> itensLiberacao) {
        return CompConferenciaNFTerceiros.calcularResAva(itensLiberacao);
    }

    private static List<ConfNFTercResAvaItens> calcularResAva(List<ItemLiberacaoNFTerceirosQualidade> itensConf) {
        LinkedList<ConfNFTercResAvaItens> ret = new LinkedList<ConfNFTercResAvaItens>();
        itensConf.forEach(item -> item.getInfAdicionalItemConfNFTerc().getItemInfAdicionalItemConfNFe().forEach(inf -> {
            if (inf.getItensModeloFichaTecnica() != null && inf.getValor() != null && inf.getValor().length() > 0 && (inf.getItensModeloFichaTecnica().getItemCompoeAnalise() == null || inf.getItensModeloFichaTecnica().getItemCompoeAnalise() == 1) && (inf.getItensModeloFichaTecnica().getTipoItemFichaTecnica().getCodigo().equals((short)4) || inf.getItensModeloFichaTecnica().getTipoItemFichaTecnica().getCodigo().equals((short)3)) || inf.getItensModeloFichaTecnica().getTipoItemFichaTecnica().getCodigo().equals((short)5) || inf.getItensModeloFichaTecnica().getTipoItemFichaTecnica().getCodigo().equals((short)6)) {
                ConfNFTercResAvaItens current;
                Optional<ConfNFTercResAvaItens> found = ret.stream().filter(i -> i.getIteModeloFichaTecnica().equals((Object)inf.getItensModeloFichaTecnica())).findFirst();
                if (found.isPresent()) {
                    current = found.get();
                    current.setNrInteracoes(Integer.valueOf(current.getNrInteracoes() + 1));
                } else {
                    current = new ConfNFTercResAvaItens();
                    current.setIteModeloFichaTecnica(inf.getItensModeloFichaTecnica());
                    current.setNrInteracoes(Integer.valueOf(1));
                    ret.add(current);
                }
                current.setPontuacaoAlcancada(Double.valueOf(current.getPontuacaoPossivel() + Double.valueOf(inf.getValor())));
                current.setPontuacaoPossivel(Double.valueOf(current.getPontuacaoPossivel() + inf.getItensModeloFichaTecnica().getValorMaximo()));
                if (current.getPontuacaoPossivel() > 0.0) {
                    current.setEficiencia(Double.valueOf(current.getPontuacaoAlcancada() / current.getPontuacaoPossivel() * 100.0));
                }
            }
        }));
        ret.forEach(item -> item.setPontuacaoMedia(Double.valueOf(item.getPontuacaoAlcancada() / (double)item.getNrInteracoes().intValue())));
        return ret;
    }
}

