/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.consumo;

import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstDisponibilidade;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstTipoPropTerc;
import com.touchcomp.basementor.constants.enums.opcoesmanutencaoativos.EnumConstTipoMovimentoConsumo;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoCarregQtdeVlr;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoSaldo;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoSaldoQtde;
import com.touchcomp.basementor.model.vo.ConsumoAtivo;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FechamentoOrdemServico;
import com.touchcomp.basementor.model.vo.GradeItemConsumoAtivo;
import com.touchcomp.basementor.model.vo.ItemConsumoAtivo;
import com.touchcomp.basementor.model.vo.OpcoesManutencEquip;
import com.touchcomp.basementor.model.vo.Procedimento;
import com.touchcomp.basementor.model.vo.ProdutoPrevManutencao;
import com.touchcomp.basementor.model.vo.Requisicao;
import com.touchcomp.basementor.model.vo.ServicoProcedimento;
import com.touchcomp.basementorexceptions.exceptions.impl.parametrizacaoctbrequisicao.ExceptionParamCtbRequisicao;
import com.touchcomp.basementorservice.helpers.impl.requisicao.HelperRequisicao;
import com.touchcomp.basementorservice.service.impl.saldoestoque.ServiceSaldoEstoqueImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import java.util.Optional;

public class AuxConsumoAtivoFechamentoOS {
    private final HelperRequisicao helperRequisicao;
    private final ServiceSaldoEstoqueImpl serviceSaldoEstoqueImpl;

    public AuxConsumoAtivoFechamentoOS(HelperRequisicao helperRequisicao, ServiceSaldoEstoqueImpl serviceSaldoEstoqueImpl) {
        this.helperRequisicao = helperRequisicao;
        this.serviceSaldoEstoqueImpl = serviceSaldoEstoqueImpl;
    }

    ConsumoAtivo criarAtualizarConsumoAtivo(FechamentoOrdemServico fechamento, OpcoesManutencEquip opcoesManutencEquip) throws ExceptionParamCtbRequisicao {
        ConsumoAtivo cons = this.getConsumoAtivo(fechamento);
        for (ServicoProcedimento servProc : fechamento.getServicoProcedimentos()) {
            for (Procedimento proc : servProc.getProcedimento()) {
                for (ProdutoPrevManutencao prod : proc.getProdutosPrevisaoManutencao()) {
                    this.convertItemConsumo(prod, cons, fechamento.getEmpresa(), opcoesManutencEquip);
                }
            }
        }
        if (!cons.getItemConsumoAtivo().isEmpty()) {
            fechamento.setConsumoAtivo(cons);
            Requisicao r = this.helperRequisicao.gerarRequisicaoConsumoAtivo(cons);
            cons.setRequisicao(r);
        } else {
            fechamento.setConsumoAtivo(null);
        }
        return cons;
    }

    public ConsumoAtivo getConsumoAtivo(FechamentoOrdemServico fechamento) {
        ConsumoAtivo cons = fechamento.getConsumoAtivo();
        if (cons == null) {
            cons = new ConsumoAtivo();
            cons.setDataCadastro(new Date());
        } else {
            cons.getItemConsumoAtivo().clear();
        }
        cons.setDataConsumo(fechamento.getDataFechamento());
        cons.setDataMovimentacao(fechamento.getDataFechamento());
        cons.setOrdemServico(fechamento.getOrdemServico());
        cons.setEquipamento(fechamento.getOrdemServico().getEquipamento());
        cons.setSolicitante(fechamento.getOrdemServico().getResponsavel());
        cons.setEmpresa(fechamento.getEmpresa());
        cons.setObservacao(fechamento.getObservacao());
        return cons;
    }

    public void convertItemConsumo(ProdutoPrevManutencao prod, ConsumoAtivo cons, Empresa empresa, OpcoesManutencEquip opcoesManutencEquip) {
        Optional<ItemConsumoAtivo> found = cons.getItemConsumoAtivo().stream().filter(i -> {
            if (!TMethods.isEquals((Object)i.getProduto(), (Object)prod.getGradeCor().getProdutoGrade().getProduto())) {
                return false;
            }
            if (!TMethods.isEquals((Object)prod.getTipoMovProdutoCons(), (Object)i.getMovInterno())) {
                return false;
            }
            return TMethods.isEquals((Object)prod.getCentroEstoque(), (Object)i.getCentroEstoque());
        }).findFirst();
        ItemConsumoAtivo item = found.isPresent() ? found.get() : new ItemConsumoAtivo();
        item.setCentroCusto(cons.getOrdemServico().getCentroCusto());
        item.setCentroEstoque(prod.getCentroEstoque());
        if (ToolMethods.isEquals((Object)item.getCentroEstoque(), null)) {
            item.setCentroEstoque(opcoesManutencEquip.getCentroEstoque());
        }
        item.setConsumoAtivo(cons);
        item.setNaturezaRequisicao(prod.getNaturezaRequisicao());
        item.setProduto(prod.getGradeCor().getProdutoGrade().getProduto());
        item.setMovInterno(prod.getTipoMovProdutoCons());
        item.setGerarPagamentoAgregado(prod.getGerarPagamentoAgregado());
        if (prod.getTipoMovProdutoCons() == null || ToolMethods.isEquals((Object)prod.getTipoMovProdutoCons(), (Object)EnumConstTipoMovimentoConsumo.CONSUMO_EXTERNO.getValue())) {
            item.setValorUnitario(prod.getValorUnitario());
        } else {
            Double valorMedio = this.serviceSaldoEstoqueImpl.findPrecoMedioIdProduto(item.getProduto(), empresa, cons.getDataMovimentacao(), EnumConstSaldoEstTipoSaldo.TIPO_SALDO_PRODUTO, EnumConstSaldoEstTipoSaldoQtde.TIPO_SALDO_QTQ_TUDO, EnumConstSaldoEstTipoCarregQtdeVlr.TIPO_SALDO_QTQ_VLR_SOMENTE_VALOR, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_TODOS, EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO, null);
            item.setValorUnitario(valorMedio);
        }
        item.setValorTotal(Double.valueOf(item.getValorUnitario() * prod.getQtdReal()));
        item.setValorDesconto(Double.valueOf(0.0));
        item.setQuantidadeTotal(prod.getQtdReal());
        cons.getItemConsumoAtivo().add(item);
        GradeItemConsumoAtivo gi = new GradeItemConsumoAtivo();
        gi.setDataCadastro(cons.getDataCadastro());
        gi.setEmpresa(cons.getEmpresa());
        gi.setGradeCor(prod.getGradeCor());
        gi.setItemConsumoAtivo(item);
        gi.setLoteFabricacao(prod.getLoteFabricacao());
        gi.setQuantidade(prod.getQtdReal());
        item.getGradeItemConsumoAtivo().add(gi);
    }
}

